# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SSISPropertyOverride(Model):
    """SSIS property override.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. SSIS package property override value. Type: string
     (or Expression with resultType string).
    :type value: object
    :param is_sensitive: Whether SSIS package property override value is
     sensitive data. Value will be encrypted in SSISDB if it is true
    :type is_sensitive: bool
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'object'},
        'is_sensitive': {'key': 'isSensitive', 'type': 'bool'},
    }

    def __init__(self, *, value, is_sensitive: bool=None, **kwargs) -> None:
        super(SSISPropertyOverride, self).__init__(**kwargs)
        self.value = value
        self.is_sensitive = is_sensitive
