#include "pgrp_dat.h"

     /**** TETRAGONAL space groups ****/
int  lat_C4_sgrp[NC4_sgrp]={
     TETRAGONAL_P, /*  1  */
     TETRAGONAL_P, /*  2  */
     TETRAGONAL_P, /*  3  */
     TETRAGONAL_P, /*  4  */
     TETRAGONAL_I, /*  5  */
     TETRAGONAL_I  /*  6  */
};
int  lat_S4_sgrp[NS4_sgrp]={
     TETRAGONAL_P, /*  1  */
     TETRAGONAL_I  /*  2  */
};
int  lat_C4h_sgrp[NC4h_sgrp]={
     TETRAGONAL_P, /*  1  */
     TETRAGONAL_P, /*  2  */
     TETRAGONAL_P, /*  3  */
     TETRAGONAL_P, /*  4  */
     TETRAGONAL_I, /*  5  */
     TETRAGONAL_I  /*  6  */
};
int  lat_D4_sgrp[ND4_sgrp]={
     TETRAGONAL_P, /*  1  */
     TETRAGONAL_P, /*  2  */
     TETRAGONAL_P, /*  3  */
     TETRAGONAL_P, /*  4  */
     TETRAGONAL_P, /*  5  */
     TETRAGONAL_P, /*  6  */
     TETRAGONAL_P, /*  7  */
     TETRAGONAL_P, /*  8  */
     TETRAGONAL_I, /*  9  */
     TETRAGONAL_I  /*  10  */
};
int  lat_C4v_sgrp[NC4v_sgrp]={
     TETRAGONAL_P, /*  1  */
     TETRAGONAL_P, /*  2  */
     TETRAGONAL_P, /*  3  */
     TETRAGONAL_P, /*  4  */
     TETRAGONAL_P, /*  5  */
     TETRAGONAL_P, /*  6  */
     TETRAGONAL_P, /*  7  */
     TETRAGONAL_P, /*  8  */
     TETRAGONAL_I, /*  9  */
     TETRAGONAL_I, /*  10  */
     TETRAGONAL_I, /*  11  */
     TETRAGONAL_I  /*  12  */
};
int  lat_D2d_sgrp[ND2d_sgrp]={
     TETRAGONAL_P, /*  D1  2d  */
     TETRAGONAL_P, /*  D2  2d  */
     TETRAGONAL_P, /*  D3  2d  */
     TETRAGONAL_P, /*  D4  2d  */
     TETRAGONAL_I, /*  D11 2d  */
     TETRAGONAL_I  /*  D12 2d  */
};
int  lat_D2d2_sgrp[ND2d2_sgrp]={
     TETRAGONAL_P, /*  D5  2d  */
     TETRAGONAL_P, /*  D6  2d  */
     TETRAGONAL_P, /*  D7  2d  */
     TETRAGONAL_P, /*  D8  2d  */
     TETRAGONAL_I, /*  D9  2d  */
     TETRAGONAL_I  /*  D10 2d  */
};
int  lat_D4h_sgrp[ND4h_sgrp]={
     TETRAGONAL_P, /*  1  */
     TETRAGONAL_P, /*  2  */
     TETRAGONAL_P, /*  3  */
     TETRAGONAL_P, /*  4  */
     TETRAGONAL_P, /*  5  */
     TETRAGONAL_P, /*  6  */
     TETRAGONAL_P, /*  7  */
     TETRAGONAL_P, /*  8  */
     TETRAGONAL_P, /*  9  */
     TETRAGONAL_P, /*  10  */
     TETRAGONAL_P, /*  11  */
     TETRAGONAL_P, /*  12  */
     TETRAGONAL_P, /*  13  */
     TETRAGONAL_P, /*  14  */
     TETRAGONAL_P, /*  15  */
     TETRAGONAL_P, /*  16  */
     TETRAGONAL_I, /*  17  */
     TETRAGONAL_I, /*  18  */
     TETRAGONAL_I, /*  19  */
     TETRAGONAL_I  /*  20  */
};

char  *comnt_C4_sgrp[NC4_sgrp]={
  "76 (P 41)",
  "77 (P 42)",
  "78 (P 43)",
  "79 (I 4)",
  "80 (I 41)"
};
char  *comnt_S4_sgrp[NS4_sgrp]={
  "81 (P -4)",
  "82 (I -4)"
};
char  *comnt_C4h_sgrp[NC4h_sgrp]={
  "83 (P 4/m)",
  "84 (P 42/m)",
  "85 (P 4/n) [origin choice 2]",
  "86 (P 42/n) [origin choice 2]",
  "87 (I 4/m)",
  "88 (I 41/a) [origin choice 2]"
};
char  *comnt_D4_sgrp[ND4_sgrp]={
  "89 (P 4 2 2)",
  "90 (P 4 21 2)",
  "91 (P 41 2 2)",
  "92 (P 41 21 2)",
  "93 (P 42 2 2)",
  "94 (P 42 21 2)",
  "95 (P 43 2 2)",
  "96 (P 43 21 2)",
  "97 (I 4 2 2)",
  "98 (I 41 2 2)"
};
char  *comnt_C4v_sgrp[NC4v_sgrp]={
  "99 (P 4 m m)",
  "100 (P 4 b m)",
  "101 (P 42 c m)",
  "102 (P 42 n m)",
  "103 (P 4 c c)",
  "104 (P 4 n c)",
  "105 (P 42 m c)",
  "106 (P 42 b c)",
  "107 (I 4 m m)",
  "108 (I 4 c m)",
  "109 (I 41 m d)",
  "110 (I 41 c d)"
};
char  *comnt_D2d_sgrp[ND2d_sgrp]={
  "111 (P -4 2 m) ",
  "112 (P -4 2 c) ",
  "113 (P -4 21 m) ",
  "114 (P -4 21 c) ",
  "121 (I -4 2 m) ",
  "122 (I -4 2 d) "
};
char  *comnt_D2d2_sgrp[ND2d2_sgrp]={
  "115 (P -4 m 2) ",
  "116 (P -4 c 2) ",
  "117 (P -4 b 2) ",
  "118 (P -4 n 2) ",
  "119 (I -4 m 2) ",
  "120 (I -4 c 2) "
};
char  *comnt_D4h_sgrp[ND4h_sgrp]={
  "123 (P 4/m m m) ",
  "124 (P 4/m c c) ",
  "125 (P 4/n b m) [origin choice 2]",
  "126 (P 4/n n c) [origin choice 2]",
  "127 (P 4/m b m)",
  "128 (P 4/m n c)",
  "129 (P 4/n m m) [origin choice 2]",
  "130 (P 4/n c c) [origin choice 2]",
  "131 (P 42/m m c)",
  "132 (P 42/m c m)",
  "133 (P 42/n b c) [origin choice 2]",
  "134 (P 42/n n m) [origin choice 2]",
  "135 (P 42/m b c)",
  "136 (P 42/m n m)",
  "137 (P 42/n m c) [origin choice 2]",
  "138 (P 42/n c m) [origin choice 2]",
  "139 (I 4/m m m)",
  "140 (I 4/m c m)",
  "141 (I 41/a m d) [origin choice 2]",
  "142 (I 41/a c d) [origin choice 2]"
};
     
     /*** Partial translations for all tetragonal space groups ***/
double rC4_sgrp[NC4_sgrp][4*3]={
  { /*  1  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000  /*    4  */
  },
  { /*  2  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.5000, /*    2  */
     0.0000,  0.0000,  0.2500, /*    3  */
     0.0000,  0.0000,  0.7500  /*    4  */
  },
  { /*  3  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.0000,  0.5000  /*    4  */
  },
  { /*  4  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.5000, /*    2  */
     0.0000,  0.0000,  0.7500, /*    3  */
     0.0000,  0.0000,  0.2500  /*    4  */
  },
  { /*  5  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000  /*    4  */
  },
  { /*  6  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.5000, /*    2  */
     0.0000,  0.5000,  0.2500, /*    3  */
     0.5000,  0.0000,  0.7500  /*    4  */
  }
};
double rS4_sgrp[NS4_sgrp][4*3]={
  { /*  1  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000  /*    4  */
  },
  { /*  2  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000  /*    4  */
  }
};
double rC4h_sgrp[NC4h_sgrp][8*3]={
  { /*  1  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  },
  { /*  2  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.0000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.0000,  0.5000  /*    8  */
  },
  { /*  3  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.0000, /*    2  */
     0.5000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.5000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.5000,  0.0000  /*    8  */
  },
  { /*  4  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.0000, /*    2  */
     0.0000,  0.5000,  0.5000, /*    3  */
     0.5000,  0.0000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.0000,  0.5000,  0.5000, /*    7  */
     0.5000,  0.0000,  0.5000  /*    8  */
  },
  { /*  5  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  },
  {  /*  6  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.0000,  0.5000, /*    2  */
     0.7500,  0.2500,  0.2500, /*    3  */
     0.7500,  0.7500,  0.7500, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.0000,  0.5000, /*    6  */
     0.2500,  0.7500,  0.7500, /*    7  */
     0.2500,  0.2500,  0.2500  /*    8  */
  }
};
double rD4_sgrp[ND4_sgrp][8*3]={
  { /*  1  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  },
  { /*  2  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.5000,  0.5000,  0.0000, /*    3  */
     0.5000,  0.5000,  0.0000, /*    4  */
     0.5000,  0.5000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  },
  { /*  3  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.5000, /*    2  */
     0.0000,  0.0000,  0.2500, /*    3  */
     0.0000,  0.0000,  0.7500, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.7500, /*    7  */
     0.0000,  0.0000,  0.2500  /*    8  */
  },
  { /*  4  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.5000, /*    2  */
     0.5000,  0.5000,  0.2500, /*    3  */
     0.5000,  0.5000,  0.7500, /*    4  */
     0.5000,  0.5000,  0.2500, /*    5  */
     0.5000,  0.5000,  0.7500, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.5000  /*    8  */
  },
  { /*  5  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.0000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.0000,  0.5000  /*    8  */
  },
  { /*  6  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.5000,  0.5000,  0.5000, /*    3  */
     0.5000,  0.5000,  0.5000, /*    4  */
     0.5000,  0.5000,  0.5000, /*    5  */
     0.5000,  0.5000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  },
  { /*  7  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.5000, /*    2  */
     0.0000,  0.0000,  0.7500, /*    3  */
     0.0000,  0.0000,  0.2500, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.2500, /*    7  */
     0.0000,  0.0000,  0.7500  /*    8  */
  },
  { /*  8  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.5000, /*    2  */
     0.5000,  0.5000,  0.7500, /*    3  */
     0.5000,  0.5000,  0.2500, /*    4  */
     0.5000,  0.5000,  0.7500, /*    5  */
     0.5000,  0.5000,  0.2500, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.5000  /*    8  */
  },
  { /*  9  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  },
  { /*  10  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.5000, /*    2  */
     0.0000,  0.5000,  0.2500, /*    3  */
     0.5000,  0.0000,  0.7500, /*    4  */
     0.5000,  0.0000,  0.7500, /*    5  */
     0.0000,  0.5000,  0.2500, /*    6  */
     0.5000,  0.5000,  0.5000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  }
};
double rC4v_sgrp[NC4v_sgrp][8*3]={
  { /*  1  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  },
  { /*  2  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.5000,  0.5000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.5000,  0.0000, /*    7  */
     0.5000,  0.5000,  0.0000  /*    8  */
  },
  { /*  3  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.0000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  },
  { /*  4  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.5000,  0.5000,  0.5000, /*    3  */
     0.5000,  0.5000,  0.5000, /*    4  */
     0.5000,  0.5000,  0.5000, /*    5  */
     0.5000,  0.5000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  },
  { /*  5  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.0000,  0.5000  /*    8  */
  },
  { /*  6  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.5000,  0.5000,  0.5000, /*    5  */
     0.5000,  0.5000,  0.5000, /*    6  */
     0.5000,  0.5000,  0.5000, /*    7  */
     0.5000,  0.5000,  0.5000  /*    8  */
  },
  { /*  7  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.0000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.0000,  0.5000  /*    8  */
  },
  { /*  8  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.0000,  0.5000, /*    4  */
     0.5000,  0.5000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.5000,  0.5000, /*    7  */
     0.5000,  0.5000,  0.5000  /*    8  */
  },
  { /*  9  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  },
  {  /*  10  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.0000,  0.5000  /*    8  */
  },
  { /*  11  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.5000, /*    2  */
     0.0000,  0.5000,  0.2500, /*    3  */
     0.5000,  0.0000,  0.7500, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.5000, /*    6  */
     0.0000,  0.5000,  0.2500, /*    7  */
     0.5000,  0.0000,  0.7500  /*    8  */
  },
  { /*  12  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.5000, /*    2  */
     0.0000,  0.5000,  0.2500, /*    3  */
     0.5000,  0.0000,  0.7500, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.0000,  0.5000,  0.7500, /*    7  */
     0.5000,  0.0000,  0.2500  /*    8  */
  }
};
double rD2d_sgrp[ND2d_sgrp][8*3]={
  { /*  D1 2d  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  },
  { /*  D2 2d  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.0000,  0.5000  /*    8  */
  },
  {   /*  D3 2d  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.5000,  0.5000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.5000,  0.0000, /*    7  */
     0.5000,  0.5000,  0.0000  /*    8  */
  },
  { /*  D4 2d  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.5000,  0.5000,  0.5000, /*    5  */
     0.5000,  0.5000,  0.5000, /*    6  */
     0.5000,  0.5000,  0.5000, /*    7  */
     0.5000,  0.5000,  0.5000  /*    8  */
  },
  { /*  D11 2d  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  },
  { /*  D12 2d  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.5000,  0.0000,  0.7500, /*    5  */
     0.5000,  0.0000,  0.7500, /*    6  */
     0.5000,  0.0000,  0.7500, /*    7  */
     0.5000,  0.0000,  0.7500  /*    8  */
  }
};
double rD2d2_sgrp[ND2d2_sgrp][8*3]={
  { /*  D5 2d  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  },
  { /*  D6 2d  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.0000,  0.5000  /*    8  */
  },
  {   /*  D7 2d  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.5000,  0.5000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.5000,  0.0000, /*    7  */
     0.5000,  0.5000,  0.0000  /*    8  */
  },
  {  /*  D8 2d  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.5000,  0.5000,  0.5000, /*    5  */
     0.5000,  0.5000,  0.5000, /*    6  */
     0.5000,  0.5000,  0.5000, /*    7  */
     0.5000,  0.5000,  0.5000  /*    8  */
  },
  { /*  D9 2d  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000  /*    8  */
  },
  { /*  D10 2d  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.0000,  0.5000  /*    8  */
  }
};
double rD4h_sgrp[ND4h_sgrp][16*3]={
  {  /*  1  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000  /*    16  */
  },
  {  /*  2  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.0000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.5000, /*    13  */
     0.0000,  0.0000,  0.5000, /*    14  */
     0.0000,  0.0000,  0.5000, /*    15  */
     0.0000,  0.0000,  0.5000  /*    16  */
  },
  {  /*  3  */
     0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.0000, /*    2  */
     0.5000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.5000,  0.0000, /*    4  */
     0.5000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.5000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.5000,  0.5000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.5000,  0.5000,  0.0000, /*    10  */
     0.5000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.5000,  0.0000, /*    12  */
     0.5000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.5000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.5000,  0.5000,  0.0000  /*    16  */
  },
   /*  4  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.0000, /*    2  */
     0.5000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.5000,  0.0000, /*    4  */
     0.5000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.5000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.5000, /*    7  */
     0.5000,  0.5000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.5000,  0.5000,  0.0000, /*    10  */
     0.5000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.5000,  0.0000, /*    12  */
     0.5000,  0.0000,  0.5000, /*    13  */
     0.0000,  0.5000,  0.5000, /*    14  */
     0.0000,  0.0000,  0.5000, /*    15  */
     0.5000,  0.5000,  0.5000  /*    16  */
  },
   /*  5  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.5000,  0.5000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.5000,  0.0000, /*    7  */
     0.5000,  0.5000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.5000,  0.5000,  0.0000, /*    13  */
     0.5000,  0.5000,  0.0000, /*    14  */
     0.5000,  0.5000,  0.0000, /*    15  */
     0.5000,  0.5000,  0.0000  /*    16  */
  },
   /*  6  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.5000,  0.5000,  0.5000, /*    5  */
     0.5000,  0.5000,  0.5000, /*    6  */
     0.5000,  0.5000,  0.5000, /*    7  */
     0.5000,  0.5000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.5000,  0.5000,  0.5000, /*    13  */
     0.5000,  0.5000,  0.5000, /*    14  */
     0.5000,  0.5000,  0.5000, /*    15  */
     0.5000,  0.5000,  0.5000  /*    16  */
  },
   /*  7  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.0000, /*    2  */
     0.5000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.5000,  0.0000, /*    4  */
     0.0000,  0.5000,  0.0000, /*    5  */
     0.5000,  0.0000,  0.0000, /*    6  */
     0.5000,  0.5000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.5000,  0.5000,  0.0000, /*    10  */
     0.5000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.5000,  0.0000, /*    12  */
     0.0000,  0.5000,  0.0000, /*    13  */
     0.5000,  0.0000,  0.0000, /*    14  */
     0.5000,  0.5000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000  /*    16  */
  },
   /*  8  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.0000, /*    2  */
     0.5000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.5000,  0.0000, /*    4  */
     0.0000,  0.5000,  0.5000, /*    5  */
     0.5000,  0.0000,  0.5000, /*    6  */
     0.5000,  0.5000,  0.5000, /*    7  */
     0.0000,  0.0000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.5000,  0.5000,  0.0000, /*    10  */
     0.5000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.5000,  0.0000, /*    12  */
     0.0000,  0.5000,  0.5000, /*    13  */
     0.5000,  0.0000,  0.5000, /*    14  */
     0.5000,  0.5000,  0.5000, /*    15  */
     0.0000,  0.0000,  0.5000  /*    16  */
  },
   /*  9  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.0000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.0000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.5000, /*    11  */
     0.0000,  0.0000,  0.5000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.5000, /*    15  */
     0.0000,  0.0000,  0.5000  /*    16  */
  },
   /*  10  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.0000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.5000, /*    11  */
     0.0000,  0.0000,  0.5000, /*    12  */
     0.0000,  0.0000,  0.5000, /*    13  */
     0.0000,  0.0000,  0.5000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000  /*    16  */
  },
   /*  11  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.0000, /*    2  */
     0.5000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.5000,  0.5000, /*    4  */
     0.5000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.5000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.5000, /*    7  */
     0.5000,  0.5000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.5000,  0.5000,  0.0000, /*    10  */
     0.5000,  0.0000,  0.5000, /*    11  */
     0.0000,  0.5000,  0.5000, /*    12  */
     0.5000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.5000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.5000, /*    15  */
     0.5000,  0.5000,  0.5000  /*    16  */
  },
   /*  12  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.0000, /*    2  */
     0.5000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.5000,  0.5000, /*    4  */
     0.5000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.5000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.5000,  0.5000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.5000,  0.5000,  0.0000, /*    10  */
     0.5000,  0.0000,  0.5000, /*    11  */
     0.0000,  0.5000,  0.5000, /*    12  */
     0.5000,  0.0000,  0.5000, /*    13  */
     0.0000,  0.5000,  0.5000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.5000,  0.5000,  0.0000  /*    16  */
  },
   /*  13  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.0000,  0.5000, /*    4  */
     0.5000,  0.5000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.5000,  0.5000, /*    7  */
     0.5000,  0.5000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.5000, /*    11  */
     0.0000,  0.0000,  0.5000, /*    12  */
     0.5000,  0.5000,  0.0000, /*    13  */
     0.5000,  0.5000,  0.0000, /*    14  */
     0.5000,  0.5000,  0.5000, /*    15  */
     0.5000,  0.5000,  0.5000  /*    16  */
  },
  /*  14  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.5000,  0.5000,  0.5000, /*    3  */
     0.5000,  0.5000,  0.5000, /*    4  */
     0.5000,  0.5000,  0.5000, /*    5  */
     0.5000,  0.5000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.5000,  0.5000,  0.5000, /*    11  */
     0.5000,  0.5000,  0.5000, /*    12  */
     0.5000,  0.5000,  0.5000, /*    13  */
     0.5000,  0.5000,  0.5000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000  /*    16  */
  },
  /*  15  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.0000, /*    2  */
     0.5000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.5000,  0.5000, /*    4  */
     0.0000,  0.5000,  0.0000, /*    5  */
     0.5000,  0.0000,  0.0000, /*    6  */
     0.5000,  0.5000,  0.5000, /*    7  */
     0.0000,  0.0000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.5000,  0.5000,  0.0000, /*    10  */
     0.5000,  0.0000,  0.5000, /*    11  */
     0.0000,  0.5000,  0.5000, /*    12  */
     0.0000,  0.5000,  0.0000, /*    13  */
     0.5000,  0.0000,  0.0000, /*    14  */
     0.5000,  0.5000,  0.5000, /*    15  */
     0.0000,  0.0000,  0.5000  /*    16  */
  },
   /*  16  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.0000, /*    2  */
     0.5000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.5000,  0.5000, /*    4  */
     0.0000,  0.5000,  0.5000, /*    5  */
     0.5000,  0.0000,  0.5000, /*    6  */
     0.5000,  0.5000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.5000,  0.5000,  0.0000, /*    10  */
     0.5000,  0.0000,  0.5000, /*    11  */
     0.0000,  0.5000,  0.5000, /*    12  */
     0.0000,  0.5000,  0.5000, /*    13  */
     0.5000,  0.0000,  0.5000, /*    14  */
     0.5000,  0.5000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000  /*    16  */
  },
   /*  17  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000  /*    16  */
  },
   /*  18  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.0000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.5000, /*    13  */
     0.0000,  0.0000,  0.5000, /*    14  */
     0.0000,  0.0000,  0.5000, /*    15  */
     0.0000,  0.0000,  0.5000  /*    16  */
  },
   /*  19  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.0000,  0.5000, /*    2  */
     0.2500,  0.7500,  0.2500, /*    3  */
     0.2500,  0.2500,  0.7500, /*    4  */
     0.5000,  0.0000,  0.5000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.2500,  0.7500,  0.2500, /*    7  */
     0.2500,  0.2500,  0.7500, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.5000,  0.0000,  0.5000, /*    10  */
     0.7500,  0.2500,  0.7500, /*    11  */
     0.7500,  0.7500,  0.2500, /*    12  */
     0.5000,  0.0000,  0.5000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.7500,  0.2500,  0.7500, /*    15  */
     0.7500,  0.7500,  0.2500  /*    16  */
  },
   /*  20  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.0000,  0.5000, /*    2  */
     0.2500,  0.7500,  0.2500, /*    3  */
     0.2500,  0.2500,  0.7500, /*    4  */
     0.5000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.5000, /*    6  */
     0.2500,  0.7500,  0.7500, /*    7  */
     0.2500,  0.2500,  0.2500, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.5000,  0.0000,  0.5000, /*    10  */
     0.7500,  0.2500,  0.7500, /*    11  */
     0.7500,  0.7500,  0.2500, /*    12  */
     0.5000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.5000, /*    14  */
     0.7500,  0.2500,  0.2500, /*    15  */
     0.7500,  0.7500,  0.7500  /*    16  */
  }
};
   
