#include "pgrp_dat.h"

     /**** CUBIC space groups ****/
int  lat_T_sgrp[NT_sgrp]={
     CUBIC_P, /*  1  */
     CUBIC_F, /*  2  */
     CUBIC_I, /*  3  */
     CUBIC_P, /*  4  */
     CUBIC_I  /*  5  */
};
int  lat_Th_sgrp[NTh_sgrp]={
     CUBIC_P, /*  1  */
     CUBIC_P, /*  2  */
     CUBIC_F, /*  3  */
     CUBIC_F, /*  4  */
     CUBIC_I, /*  5  */
     CUBIC_P, /*  6  */
     CUBIC_I  /*  7  */
};
int  lat_O_sgrp[NO_sgrp]={
     CUBIC_P, /*  1  */
     CUBIC_P, /*  2  */
     CUBIC_F, /*  3  */
     CUBIC_F, /*  4  */
     CUBIC_I, /*  5  */
     CUBIC_P, /*  6  */
     CUBIC_P, /*  7  */
     CUBIC_I  /*  8  */
};
int  lat_Td_sgrp[NTd_sgrp]={
     CUBIC_P, /*  1  */
     CUBIC_F, /*  2  */
     CUBIC_I, /*  3  */
     CUBIC_P, /*  4  */
     CUBIC_F, /*  5  */
     CUBIC_I  /*  6  */
};
int  lat_Oh_sgrp[NOh_sgrp]={
     CUBIC_P, /*  1  */
     CUBIC_P, /*  2  */
     CUBIC_P, /*  3  */
     CUBIC_P, /*  4  */
     CUBIC_F, /*  5  */
     CUBIC_F, /*  6  */
     CUBIC_F, /*  7  */
     CUBIC_F, /*  8  */
     CUBIC_I, /*  9  */
     CUBIC_I  /*  10  */
};

char  *comnt_T_sgrp[NT_sgrp]={
  "195 (P 2 3)",
  "196 (F 2 3)",
  "197 (I 2 3)",
  "198 (P 21 3)",
  "199 (I 21 3)"
};
char  *comnt_Th_sgrp[NTh_sgrp]={
  "200 (P m -3)",
  "201 (P n -3) [origin choice 2]",
  "202 (F m -3)",
  "203 (F d -3) [origin choice 2]",
  "204 (I m -3)",
  "205 (P a -3)",
  "206 (I a -3)"
};
char  *comnt_O_sgrp[NO_sgrp]={
  "207 (P 4 3 2)",
  "208 (P 42 3 2)",
  "209 (F 4 3 2)",
  "210 (F 41 3 2)",
  "211 (I 4 3 2)",
  "212 (P 43 3 2)",
  "213 (P 41 3 2)",
  "214 (I 41 3 2)"
};
char  *comnt_Td_sgrp[NTd_sgrp]={
  "215 (P -4 3 m)",
  "216 (F -4 3 m)",
  "217 (I -4 3 m)",
  "218 (P -4 3 n)",
  "219 (F -4 3 c)",
  "220 (I -4 3 d)"
};
char  *comnt_Oh_sgrp[NOh_sgrp]={
  "221 (P m -3 m)",
  "222 (P n -3 n) [origin choice 2]",
  "223 (P m -3 n)",
  "224 (P n -3 m) [origin choice 2]",
  "225 (F m -3 m)",
  "226 (F m -3 c)",
  "227 (F d -3 m) [origin choice 2]",
  "228 (F d -3 c) [origin choice 2]",
  "229 (I m -3 m)",
  "230 (I a -3 d)"
};
     
     /*** Partial translations for all cubic space groups ***/
double rT_sgrp[NT_sgrp][12*3]={
   /*  1  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000  /*    12  */
  },
   /*  2  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000  /*    12  */
  },
   /*  3  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000  /*    12  */
  },
   /*  4  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.0000,  0.5000, /*    2  */
     0.0000,  0.5000,  0.5000, /*    3  */
     0.5000,  0.5000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.5000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.5000,  0.5000, /*    10  */
     0.5000,  0.5000,  0.0000, /*    11  */
     0.5000,  0.0000,  0.5000  /*    12  */
  },
   /*  5  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.0000,  0.5000, /*    2  */
     0.0000,  0.5000,  0.5000, /*    3  */
     0.5000,  0.5000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.5000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.5000,  0.5000, /*    10  */
     0.5000,  0.5000,  0.0000, /*    11  */
     0.5000,  0.0000,  0.5000  /*    12  */
  }
};
   
double rTh_sgrp[NTh_sgrp][24*3]={
   /*  1  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.0000,  0.0000,  0.0000, /*    18  */
     0.0000,  0.0000,  0.0000, /*    19  */
     0.0000,  0.0000,  0.0000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.0000,  0.0000,  0.0000, /*    22  */
     0.0000,  0.0000,  0.0000, /*    23  */
     0.0000,  0.0000,  0.0000  /*    24  */
  },
   /*  2  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.0000, /*    2  */
     0.5000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.5000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.5000,  0.5000, /*    6  */
     0.5000,  0.5000,  0.0000, /*    7  */
     0.5000,  0.0000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.5000,  0.0000,  0.5000, /*    10  */
     0.0000,  0.5000,  0.5000, /*    11  */
     0.5000,  0.5000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.5000,  0.5000,  0.0000, /*    14  */
     0.5000,  0.0000,  0.5000, /*    15  */
     0.0000,  0.5000,  0.5000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.0000,  0.5000,  0.5000, /*    18  */
     0.5000,  0.5000,  0.0000, /*    19  */
     0.5000,  0.0000,  0.5000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.5000,  0.0000,  0.5000, /*    22  */
     0.0000,  0.5000,  0.5000, /*    23  */
     0.5000,  0.5000,  0.0000  /*    24  */
  },
   /*  3  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.0000,  0.0000,  0.0000, /*    18  */
     0.0000,  0.0000,  0.0000, /*    19  */
     0.0000,  0.0000,  0.0000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.0000,  0.0000,  0.0000, /*    22  */
     0.0000,  0.0000,  0.0000, /*    23  */
     0.0000,  0.0000,  0.0000  /*    24  */
  },
   /*  4  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.2500,  0.2500,  0.0000, /*    2  */
     0.2500,  0.0000,  0.2500, /*    3  */
     0.0000,  0.2500,  0.2500, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.2500,  0.2500, /*    6  */
     0.2500,  0.2500,  0.0000, /*    7  */
     0.2500,  0.0000,  0.2500, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.2500,  0.0000,  0.2500, /*    10  */
     0.0000,  0.2500,  0.2500, /*    11  */
     0.2500,  0.2500,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.7500,  0.7500,  0.0000, /*    14  */
     0.7500,  0.0000,  0.7500, /*    15  */
     0.0000,  0.7500,  0.7500, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.0000,  0.7500,  0.7500, /*    18  */
     0.7500,  0.7500,  0.0000, /*    19  */
     0.7500,  0.0000,  0.7500, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.7500,  0.0000,  0.7500, /*    22  */
     0.0000,  0.7500,  0.7500, /*    23  */
     0.7500,  0.7500,  0.0000  /*    24  */
  },
   /*  5  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.0000,  0.0000,  0.0000, /*    18  */
     0.0000,  0.0000,  0.0000, /*    19  */
     0.0000,  0.0000,  0.0000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.0000,  0.0000,  0.0000, /*    22  */
     0.0000,  0.0000,  0.0000, /*    23  */
     0.0000,  0.0000,  0.0000  /*    24  */
  },
   /*  6  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.0000,  0.5000, /*    2  */
     0.0000,  0.5000,  0.5000, /*    3  */
     0.5000,  0.5000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.5000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.5000,  0.5000, /*    10  */
     0.5000,  0.5000,  0.0000, /*    11  */
     0.5000,  0.0000,  0.5000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.5000,  0.0000,  0.5000, /*    14  */
     0.0000,  0.5000,  0.5000, /*    15  */
     0.5000,  0.5000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.5000,  0.5000,  0.0000, /*    18  */
     0.5000,  0.0000,  0.5000, /*    19  */
     0.0000,  0.5000,  0.5000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.0000,  0.5000,  0.5000, /*    22  */
     0.5000,  0.5000,  0.0000, /*    23  */
     0.5000,  0.0000,  0.5000  /*    24  */
  },
   /*  7  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.0000,  0.5000, /*    2  */
     0.0000,  0.5000,  0.5000, /*    3  */
     0.5000,  0.5000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.5000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.5000,  0.5000, /*    10  */
     0.5000,  0.5000,  0.0000, /*    11  */
     0.5000,  0.0000,  0.5000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.5000,  0.0000,  0.5000, /*    14  */
     0.0000,  0.5000,  0.5000, /*    15  */
     0.5000,  0.5000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.5000,  0.5000,  0.0000, /*    18  */
     0.5000,  0.0000,  0.5000, /*    19  */
     0.0000,  0.5000,  0.5000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.0000,  0.5000,  0.5000, /*    22  */
     0.5000,  0.5000,  0.0000, /*    23  */
     0.5000,  0.0000,  0.5000  /*    24  */
  }
};

double rO_sgrp[NO_sgrp][24*3]={
   /*  1  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.0000,  0.0000,  0.0000, /*    18  */
     0.0000,  0.0000,  0.0000, /*    19  */
     0.0000,  0.0000,  0.0000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.0000,  0.0000,  0.0000, /*    22  */
     0.0000,  0.0000,  0.0000, /*    23  */
     0.0000,  0.0000,  0.0000  /*    24  */
  },
   /*  2  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.5000,  0.5000,  0.5000, /*    13  */
     0.5000,  0.5000,  0.5000, /*    14  */
     0.5000,  0.5000,  0.5000, /*    15  */
     0.5000,  0.5000,  0.5000, /*    16  */
     0.5000,  0.5000,  0.5000, /*    17  */
     0.5000,  0.5000,  0.5000, /*    18  */
     0.5000,  0.5000,  0.5000, /*    19  */
     0.5000,  0.5000,  0.5000, /*    20  */
     0.5000,  0.5000,  0.5000, /*    21  */
     0.5000,  0.5000,  0.5000, /*    22  */
     0.5000,  0.5000,  0.5000, /*    23  */
     0.5000,  0.5000,  0.5000  /*    24  */
  },
   /*  3  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.0000,  0.0000,  0.0000, /*    18  */
     0.0000,  0.0000,  0.0000, /*    19  */
     0.0000,  0.0000,  0.0000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.0000,  0.0000,  0.0000, /*    22  */
     0.0000,  0.0000,  0.0000, /*    23  */
     0.0000,  0.0000,  0.0000  /*    24  */
  },
   /*  4  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.5000,  0.5000, /*    2  */
     0.5000,  0.5000,  0.0000, /*    3  */
     0.5000,  0.0000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.0000,  0.5000, /*    6  */
     0.0000,  0.5000,  0.5000, /*    7  */
     0.5000,  0.5000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.5000,  0.5000,  0.0000, /*    10  */
     0.5000,  0.0000,  0.5000, /*    11  */
     0.0000,  0.5000,  0.5000, /*    12  */
     0.7500,  0.2500,  0.7500, /*    13  */
     0.2500,  0.2500,  0.2500, /*    14  */
     0.2500,  0.7500,  0.7500, /*    15  */
     0.7500,  0.7500,  0.2500, /*    16  */
     0.7500,  0.2500,  0.7500, /*    17  */
     0.7500,  0.7500,  0.2500, /*    18  */
     0.2500,  0.2500,  0.2500, /*    19  */
     0.2500,  0.7500,  0.7500, /*    20  */
     0.7500,  0.2500,  0.7500, /*    21  */
     0.2500,  0.7500,  0.7500, /*    22  */
     0.7500,  0.7500,  0.2500, /*    23  */
     0.2500,  0.2500,  0.2500  /*    24  */
  },
   /*  5  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.0000,  0.0000,  0.0000, /*    18  */
     0.0000,  0.0000,  0.0000, /*    19  */
     0.0000,  0.0000,  0.0000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.0000,  0.0000,  0.0000, /*    22  */
     0.0000,  0.0000,  0.0000, /*    23  */
     0.0000,  0.0000,  0.0000  /*    24  */
  },
   /*  6  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.0000,  0.5000, /*    2  */
     0.0000,  0.5000,  0.5000, /*    3  */
     0.5000,  0.5000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.5000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.5000,  0.5000, /*    10  */
     0.5000,  0.5000,  0.0000, /*    11  */
     0.5000,  0.0000,  0.5000, /*    12  */
     0.2500,  0.7500,  0.7500, /*    13  */
     0.2500,  0.2500,  0.2500, /*    14  */
     0.7500,  0.7500,  0.2500, /*    15  */
     0.7500,  0.2500,  0.7500, /*    16  */
     0.2500,  0.7500,  0.7500, /*    17  */
     0.7500,  0.2500,  0.7500, /*    18  */
     0.2500,  0.2500,  0.2500, /*    19  */
     0.7500,  0.7500,  0.2500, /*    20  */
     0.2500,  0.7500,  0.7500, /*    21  */
     0.7500,  0.7500,  0.2500, /*    22  */
     0.7500,  0.2500,  0.7500, /*    23  */
     0.2500,  0.2500,  0.2500  /*    24  */
  },
   /*  7  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.0000,  0.5000, /*    2  */
     0.0000,  0.5000,  0.5000, /*    3  */
     0.5000,  0.5000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.5000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.5000,  0.5000, /*    10  */
     0.5000,  0.5000,  0.0000, /*    11  */
     0.5000,  0.0000,  0.5000, /*    12  */
     0.7500,  0.2500,  0.2500, /*    13  */
     0.7500,  0.7500,  0.7500, /*    14  */
     0.2500,  0.2500,  0.7500, /*    15  */
     0.2500,  0.7500,  0.2500, /*    16  */
     0.7500,  0.2500,  0.2500, /*    17  */
     0.2500,  0.7500,  0.2500, /*    18  */
     0.7500,  0.7500,  0.7500, /*    19  */
     0.2500,  0.2500,  0.7500, /*    20  */
     0.7500,  0.2500,  0.2500, /*    21  */
     0.2500,  0.2500,  0.7500, /*    22  */
     0.2500,  0.7500,  0.2500, /*    23  */
     0.7500,  0.7500,  0.7500, /*    24  */
  },
   /*  8  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.0000,  0.5000, /*    2  */
     0.0000,  0.5000,  0.5000, /*    3  */
     0.5000,  0.5000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.5000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.5000,  0.5000, /*    10  */
     0.5000,  0.5000,  0.0000, /*    11  */
     0.5000,  0.0000,  0.5000, /*    12  */
     0.7500,  0.2500,  0.2500, /*    13  */
     0.7500,  0.7500,  0.7500, /*    14  */
     0.2500,  0.2500,  0.7500, /*    15  */
     0.2500,  0.7500,  0.2500, /*    16  */
     0.7500,  0.2500,  0.2500, /*    17  */
     0.2500,  0.7500,  0.2500, /*    18  */
     0.7500,  0.7500,  0.7500, /*    19  */
     0.2500,  0.2500,  0.7500, /*    20  */
     0.7500,  0.2500,  0.2500, /*    21  */
     0.2500,  0.2500,  0.7500, /*    22  */
     0.2500,  0.7500,  0.2500, /*    23  */
     0.7500,  0.7500,  0.7500  /*    24  */
  }
};

double rTd_sgrp[NTd_sgrp][24*3]={
   /*  1  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.0000,  0.0000,  0.0000, /*    18  */
     0.0000,  0.0000,  0.0000, /*    19  */
     0.0000,  0.0000,  0.0000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.0000,  0.0000,  0.0000, /*    22  */
     0.0000,  0.0000,  0.0000, /*    23  */
     0.0000,  0.0000,  0.0000  /*    24  */
  },
   /*  2  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.0000,  0.0000,  0.0000, /*    18  */
     0.0000,  0.0000,  0.0000, /*    19  */
     0.0000,  0.0000,  0.0000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.0000,  0.0000,  0.0000, /*    22  */
     0.0000,  0.0000,  0.0000, /*    23  */
     0.0000,  0.0000,  0.0000  /*    24  */
  },
   /*  3  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.0000,  0.0000,  0.0000, /*    18  */
     0.0000,  0.0000,  0.0000, /*    19  */
     0.0000,  0.0000,  0.0000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.0000,  0.0000,  0.0000, /*    22  */
     0.0000,  0.0000,  0.0000, /*    23  */
     0.0000,  0.0000,  0.0000  /*    24  */
  },
   /*  4  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.5000,  0.5000,  0.5000, /*    13  */
     0.5000,  0.5000,  0.5000, /*    14  */
     0.5000,  0.5000,  0.5000, /*    15  */
     0.5000,  0.5000,  0.5000, /*    16  */
     0.5000,  0.5000,  0.5000, /*    17  */
     0.5000,  0.5000,  0.5000, /*    18  */
     0.5000,  0.5000,  0.5000, /*    19  */
     0.5000,  0.5000,  0.5000, /*    20  */
     0.5000,  0.5000,  0.5000, /*    21  */
     0.5000,  0.5000,  0.5000, /*    22  */
     0.5000,  0.5000,  0.5000, /*    23  */
     0.5000,  0.5000,  0.5000  /*    24  */
  },
   /*  5  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.5000,  0.5000,  0.5000, /*    13  */
     0.5000,  0.5000,  0.5000, /*    14  */
     0.5000,  0.5000,  0.5000, /*    15  */
     0.5000,  0.5000,  0.5000, /*    16  */
     0.5000,  0.5000,  0.5000, /*    17  */
     0.5000,  0.5000,  0.5000, /*    18  */
     0.5000,  0.5000,  0.5000, /*    19  */
     0.5000,  0.5000,  0.5000, /*    20  */
     0.5000,  0.5000,  0.5000, /*    21  */
     0.5000,  0.5000,  0.5000, /*    22  */
     0.5000,  0.5000,  0.5000, /*    23  */
     0.5000,  0.5000,  0.5000  /*    24  */
  },
   /*  6  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.0000,  0.5000, /*    2  */
     0.0000,  0.5000,  0.5000, /*    3  */
     0.5000,  0.5000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.5000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.5000,  0.5000, /*    10  */
     0.5000,  0.5000,  0.0000, /*    11  */
     0.5000,  0.0000,  0.5000, /*    12  */
     0.2500,  0.2500,  0.2500, /*    13  */
     0.2500,  0.7500,  0.7500, /*    14  */
     0.7500,  0.2500,  0.7500, /*    15  */
     0.7500,  0.7500,  0.2500, /*    16  */
     0.2500,  0.2500,  0.2500, /*    17  */
     0.7500,  0.7500,  0.2500, /*    18  */
     0.2500,  0.7500,  0.7500, /*    19  */
     0.7500,  0.2500,  0.7500, /*    20  */
     0.2500,  0.2500,  0.2500, /*    21  */
     0.7500,  0.2500,  0.7500, /*    22  */
     0.7500,  0.7500,  0.2500, /*    23  */
     0.2500,  0.7500,  0.7500  /*    24  */
  }
};
     
double rOh_sgrp[NOh_sgrp][48*3]={
   /*  1  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.0000,  0.0000,  0.0000, /*    18  */
     0.0000,  0.0000,  0.0000, /*    19  */
     0.0000,  0.0000,  0.0000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.0000,  0.0000,  0.0000, /*    22  */
     0.0000,  0.0000,  0.0000, /*    23  */
     0.0000,  0.0000,  0.0000, /*    24  */
     0.0000,  0.0000,  0.0000, /*    25  */
     0.0000,  0.0000,  0.0000, /*    26  */
     0.0000,  0.0000,  0.0000, /*    27  */
     0.0000,  0.0000,  0.0000, /*    28  */
     0.0000,  0.0000,  0.0000, /*    29  */
     0.0000,  0.0000,  0.0000, /*    30  */
     0.0000,  0.0000,  0.0000, /*    31  */
     0.0000,  0.0000,  0.0000, /*    32  */
     0.0000,  0.0000,  0.0000, /*    33  */
     0.0000,  0.0000,  0.0000, /*    34  */
     0.0000,  0.0000,  0.0000, /*    35  */
     0.0000,  0.0000,  0.0000, /*    36  */
     0.0000,  0.0000,  0.0000, /*    37  */
     0.0000,  0.0000,  0.0000, /*    38  */
     0.0000,  0.0000,  0.0000, /*    39  */
     0.0000,  0.0000,  0.0000, /*    40  */
     0.0000,  0.0000,  0.0000, /*    41  */
     0.0000,  0.0000,  0.0000, /*    42  */
     0.0000,  0.0000,  0.0000, /*    43  */
     0.0000,  0.0000,  0.0000, /*    44  */
     0.0000,  0.0000,  0.0000, /*    45  */
     0.0000,  0.0000,  0.0000, /*    46  */
     0.0000,  0.0000,  0.0000, /*    47  */
     0.0000,  0.0000,  0.0000, /*    48  */
  },
   /*  2 (2)  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.0000, /*    2  */
     0.5000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.5000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.5000,  0.5000, /*    6  */
     0.5000,  0.5000,  0.0000, /*    7  */
     0.5000,  0.0000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.5000,  0.0000,  0.5000, /*    10  */
     0.0000,  0.5000,  0.5000, /*    11  */
     0.5000,  0.5000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.5000, /*    13  */
     0.5000,  0.5000,  0.5000, /*    14  */
     0.0000,  0.5000,  0.0000, /*    15  */
     0.5000,  0.0000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.5000, /*    17  */
     0.5000,  0.0000,  0.0000, /*    18  */
     0.5000,  0.5000,  0.5000, /*    19  */
     0.0000,  0.5000,  0.0000, /*    20  */
     0.0000,  0.0000,  0.5000, /*    21  */
     0.0000,  0.5000,  0.0000, /*    22  */
     0.5000,  0.0000,  0.0000, /*    23  */
     0.5000,  0.5000,  0.5000, /*    24  */
     0.0000,  0.0000,  0.0000, /*    25  */
     0.5000,  0.5000,  0.0000, /*    26  */
     0.5000,  0.0000,  0.5000, /*    27  */
     0.0000,  0.5000,  0.5000, /*    28  */
     0.0000,  0.0000,  0.0000, /*    29  */
     0.0000,  0.5000,  0.5000, /*    30  */
     0.5000,  0.5000,  0.0000, /*    31  */
     0.5000,  0.0000,  0.5000, /*    32  */
     0.0000,  0.0000,  0.0000, /*    33  */
     0.5000,  0.0000,  0.5000, /*    34  */
     0.0000,  0.5000,  0.5000, /*    35  */
     0.5000,  0.5000,  0.0000, /*    36  */
     0.0000,  0.0000,  0.5000, /*    37  */
     0.5000,  0.5000,  0.5000, /*    38  */
     0.0000,  0.5000,  0.0000, /*    39  */
     0.5000,  0.0000,  0.0000, /*    40  */
     0.0000,  0.0000,  0.5000, /*    41  */
     0.5000,  0.0000,  0.0000, /*    42  */
     0.5000,  0.5000,  0.5000, /*    43  */
     0.0000,  0.5000,  0.0000, /*    44  */
     0.0000,  0.0000,  0.5000, /*    45  */
     0.0000,  0.5000,  0.0000, /*    46  */
     0.5000,  0.0000,  0.0000, /*    47  */
     0.5000,  0.5000,  0.5000  /*    48  */
   },
  /*  3  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.5000,  0.5000,  0.5000, /*    13  */
     0.5000,  0.5000,  0.5000, /*    14  */
     0.5000,  0.5000,  0.5000, /*    15  */
     0.5000,  0.5000,  0.5000, /*    16  */
     0.5000,  0.5000,  0.5000, /*    17  */
     0.5000,  0.5000,  0.5000, /*    18  */
     0.5000,  0.5000,  0.5000, /*    19  */
     0.5000,  0.5000,  0.5000, /*    20  */
     0.5000,  0.5000,  0.5000, /*    21  */
     0.5000,  0.5000,  0.5000, /*    22  */
     0.5000,  0.5000,  0.5000, /*    23  */
     0.5000,  0.5000,  0.5000, /*    24  */
     0.0000,  0.0000,  0.0000, /*    25  */
     0.0000,  0.0000,  0.0000, /*    26  */
     0.0000,  0.0000,  0.0000, /*    27  */
     0.0000,  0.0000,  0.0000, /*    28  */
     0.0000,  0.0000,  0.0000, /*    29  */
     0.0000,  0.0000,  0.0000, /*    30  */
     0.0000,  0.0000,  0.0000, /*    31  */
     0.0000,  0.0000,  0.0000, /*    32  */
     0.0000,  0.0000,  0.0000, /*    33  */
     0.0000,  0.0000,  0.0000, /*    34  */
     0.0000,  0.0000,  0.0000, /*    35  */
     0.0000,  0.0000,  0.0000, /*    36  */
     0.5000,  0.5000,  0.5000, /*    37  */
     0.5000,  0.5000,  0.5000, /*    38  */
     0.5000,  0.5000,  0.5000, /*    39  */
     0.5000,  0.5000,  0.5000, /*    40  */
     0.5000,  0.5000,  0.5000, /*    41  */
     0.5000,  0.5000,  0.5000, /*    42  */
     0.5000,  0.5000,  0.5000, /*    43  */
     0.5000,  0.5000,  0.5000, /*    44  */
     0.5000,  0.5000,  0.5000, /*    45  */
     0.5000,  0.5000,  0.5000, /*    46  */
     0.5000,  0.5000,  0.5000, /*    47  */
     0.5000,  0.5000,  0.5000  /*    48  */
  },
    /*  4  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.5000,  0.0000, /*    2  */
     0.5000,  0.0000,  0.5000, /*    3  */
     0.0000,  0.5000,  0.5000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.5000,  0.5000, /*    6  */
     0.5000,  0.5000,  0.0000, /*    7  */
     0.5000,  0.0000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.5000,  0.0000,  0.5000, /*    10  */
     0.0000,  0.5000,  0.5000, /*    11  */
     0.5000,  0.5000,  0.0000, /*    12  */
     0.5000,  0.5000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.5000,  0.0000,  0.5000, /*    15  */
     0.0000,  0.5000,  0.5000, /*    16  */
     0.5000,  0.5000,  0.0000, /*    17  */
     0.0000,  0.5000,  0.5000, /*    18  */
     0.0000,  0.0000,  0.0000, /*    19  */
     0.5000,  0.0000,  0.5000, /*    20  */
     0.5000,  0.5000,  0.0000, /*    21  */
     0.5000,  0.0000,  0.5000, /*    22  */
     0.0000,  0.5000,  0.5000, /*    23  */
     0.0000,  0.0000,  0.0000, /*    24  */
     0.0000,  0.0000,  0.0000, /*    25  */
     0.5000,  0.5000,  0.0000, /*    26  */
     0.5000,  0.0000,  0.5000, /*    27  */
     0.0000,  0.5000,  0.5000, /*    28  */
     0.0000,  0.0000,  0.0000, /*    29  */
     0.0000,  0.5000,  0.5000, /*    30  */
     0.5000,  0.5000,  0.0000, /*    31  */
     0.5000,  0.0000,  0.5000, /*    32  */
     0.0000,  0.0000,  0.0000, /*    33  */
     0.5000,  0.0000,  0.5000, /*    34  */
     0.0000,  0.5000,  0.5000, /*    35  */
     0.5000,  0.5000,  0.0000, /*    36  */
     0.5000,  0.5000,  0.0000, /*    37  */
     0.0000,  0.0000,  0.0000, /*    38  */
     0.5000,  0.0000,  0.5000, /*    39  */
     0.0000,  0.5000,  0.5000, /*    40  */
     0.5000,  0.5000,  0.0000, /*    41  */
     0.0000,  0.5000,  0.5000, /*    42  */
     0.0000,  0.0000,  0.0000, /*    43  */
     0.5000,  0.0000,  0.5000, /*    44  */
     0.5000,  0.5000,  0.0000, /*    45  */
     0.5000,  0.0000,  0.5000, /*    46  */
     0.0000,  0.5000,  0.5000, /*    47  */
     0.0000,  0.0000,  0.0000  /*    48  */
  },
   /*  5  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.0000,  0.0000,  0.0000, /*    18  */
     0.0000,  0.0000,  0.0000, /*    19  */
     0.0000,  0.0000,  0.0000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.0000,  0.0000,  0.0000, /*    22  */
     0.0000,  0.0000,  0.0000, /*    23  */
     0.0000,  0.0000,  0.0000, /*    24  */
     0.0000,  0.0000,  0.0000, /*    25  */
     0.0000,  0.0000,  0.0000, /*    26  */
     0.0000,  0.0000,  0.0000, /*    27  */
     0.0000,  0.0000,  0.0000, /*    28  */
     0.0000,  0.0000,  0.0000, /*    29  */
     0.0000,  0.0000,  0.0000, /*    30  */
     0.0000,  0.0000,  0.0000, /*    31  */
     0.0000,  0.0000,  0.0000, /*    32  */
     0.0000,  0.0000,  0.0000, /*    33  */
     0.0000,  0.0000,  0.0000, /*    34  */
     0.0000,  0.0000,  0.0000, /*    35  */
     0.0000,  0.0000,  0.0000, /*    36  */
     0.0000,  0.0000,  0.0000, /*    37  */
     0.0000,  0.0000,  0.0000, /*    38  */
     0.0000,  0.0000,  0.0000, /*    39  */
     0.0000,  0.0000,  0.0000, /*    40  */
     0.0000,  0.0000,  0.0000, /*    41  */
     0.0000,  0.0000,  0.0000, /*    42  */
     0.0000,  0.0000,  0.0000, /*    43  */
     0.0000,  0.0000,  0.0000, /*    44  */
     0.0000,  0.0000,  0.0000, /*    45  */
     0.0000,  0.0000,  0.0000, /*    46  */
     0.0000,  0.0000,  0.0000, /*    47  */
     0.0000,  0.0000,  0.0000, /*    48  */
  },
   /*  6  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.5000,  0.5000,  0.5000, /*    13  */
     0.5000,  0.5000,  0.5000, /*    14  */
     0.5000,  0.5000,  0.5000, /*    15  */
     0.5000,  0.5000,  0.5000, /*    16  */
     0.5000,  0.5000,  0.5000, /*    17  */
     0.5000,  0.5000,  0.5000, /*    18  */
     0.5000,  0.5000,  0.5000, /*    19  */
     0.5000,  0.5000,  0.5000, /*    20  */
     0.5000,  0.5000,  0.5000, /*    21  */
     0.5000,  0.5000,  0.5000, /*    22  */
     0.5000,  0.5000,  0.5000, /*    23  */
     0.5000,  0.5000,  0.5000, /*    24  */
     0.0000,  0.0000,  0.0000, /*    25  */
     0.0000,  0.0000,  0.0000, /*    26  */
     0.0000,  0.0000,  0.0000, /*    27  */
     0.0000,  0.0000,  0.0000, /*    28  */
     0.0000,  0.0000,  0.0000, /*    29  */
     0.0000,  0.0000,  0.0000, /*    30  */
     0.0000,  0.0000,  0.0000, /*    31  */
     0.0000,  0.0000,  0.0000, /*    32  */
     0.0000,  0.0000,  0.0000, /*    33  */
     0.0000,  0.0000,  0.0000, /*    34  */
     0.0000,  0.0000,  0.0000, /*    35  */
     0.0000,  0.0000,  0.0000, /*    36  */
     0.5000,  0.5000,  0.5000, /*    37  */
     0.5000,  0.5000,  0.5000, /*    38  */
     0.5000,  0.5000,  0.5000, /*    39  */
     0.5000,  0.5000,  0.5000, /*    40  */
     0.5000,  0.5000,  0.5000, /*    41  */
     0.5000,  0.5000,  0.5000, /*    42  */
     0.5000,  0.5000,  0.5000, /*    43  */
     0.5000,  0.5000,  0.5000, /*    44  */
     0.5000,  0.5000,  0.5000, /*    45  */
     0.5000,  0.5000,  0.5000, /*    46  */
     0.5000,  0.5000,  0.5000, /*    47  */
     0.5000,  0.5000,  0.5000  /*    48  */
  },
   /*  7  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.7500,  0.2500,  0.5000, /*    2  */
     0.2500,  0.5000,  0.7500, /*    3  */
     0.5000,  0.7500,  0.2500, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.7500,  0.2500, /*    6  */
     0.7500,  0.2500,  0.5000, /*    7  */
     0.2500,  0.5000,  0.7500, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.2500,  0.5000,  0.7500, /*    10  */
     0.5000,  0.7500,  0.2500, /*    11  */
     0.7500,  0.2500,  0.5000, /*    12  */
     0.7500,  0.2500,  0.5000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.2500,  0.5000,  0.7500, /*    15  */
     0.5000,  0.7500,  0.2500, /*    16  */
     0.7500,  0.2500,  0.5000, /*    17  */
     0.5000,  0.7500,  0.2500, /*    18  */
     0.0000,  0.0000,  0.0000, /*    19  */
     0.2500,  0.5000,  0.7500, /*    20  */
     0.7500,  0.2500,  0.5000, /*    21  */
     0.2500,  0.5000,  0.7500, /*    22  */
     0.5000,  0.7500,  0.2500, /*    23  */
     0.0000,  0.0000,  0.0000, /*    24  */
     0.0000,  0.0000,  0.0000, /*    25  */
     0.2500,  0.7500,  0.5000, /*    26  */
     0.7500,  0.5000,  0.2500, /*    27  */
     0.5000,  0.2500,  0.7500, /*    28  */
     0.0000,  0.0000,  0.0000, /*    29  */
     0.5000,  0.2500,  0.7500, /*    30  */
     0.2500,  0.7500,  0.5000, /*    31  */
     0.7500,  0.5000,  0.2500, /*    32  */
     0.0000,  0.0000,  0.0000, /*    33  */
     0.7500,  0.5000,  0.2500, /*    34  */
     0.5000,  0.2500,  0.7500, /*    35  */
     0.2500,  0.7500,  0.5000, /*    36  */
     0.2500,  0.7500,  0.5000, /*    37  */
     0.0000,  0.0000,  0.0000, /*    38  */
     0.7500,  0.5000,  0.2500, /*    39  */
     0.5000,  0.2500,  0.7500, /*    40  */
     0.2500,  0.7500,  0.5000, /*    41  */
     0.5000,  0.2500,  0.7500, /*    42  */
     0.0000,  0.0000,  0.0000, /*    43  */
     0.7500,  0.5000,  0.2500, /*    44  */
     0.2500,  0.7500,  0.5000, /*    45  */
     0.7500,  0.5000,  0.2500, /*    46  */
     0.5000,  0.2500,  0.7500, /*    47  */
     0.0000,  0.0000,  0.0000  /*    48  */
  },
   /*  8  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.2500,  0.7500,  0.5000, /*    2  */
     0.7500,  0.5000,  0.2500, /*    3  */
     0.5000,  0.2500,  0.7500, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.2500,  0.7500, /*    6  */
     0.2500,  0.7500,  0.5000, /*    7  */
     0.7500,  0.5000,  0.2500, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.7500,  0.5000,  0.2500, /*    10  */
     0.5000,  0.2500,  0.7500, /*    11  */
     0.2500,  0.7500,  0.5000, /*    12  */
     0.7500,  0.2500,  0.0000, /*    13  */
     0.5000,  0.5000,  0.5000, /*    14  */
     0.2500,  0.0000,  0.7500, /*    15  */
     0.0000,  0.7500,  0.2500, /*    16  */
     0.7500,  0.2500,  0.0000, /*    17  */
     0.0000,  0.7500,  0.2500, /*    18  */
     0.5000,  0.5000,  0.5000, /*    19  */
     0.2500,  0.0000,  0.7500, /*    20  */
     0.7500,  0.2500,  0.0000, /*    21  */
     0.2500,  0.0000,  0.7500, /*    22  */
     0.0000,  0.7500,  0.2500, /*    23  */
     0.5000,  0.5000,  0.5000, /*    24  */
     0.0000,  0.0000,  0.0000, /*    25  */
     0.7500,  0.2500,  0.5000, /*    26  */
     0.2500,  0.5000,  0.7500, /*    27  */
     0.5000,  0.7500,  0.2500, /*    28  */
     0.0000,  0.0000,  0.0000, /*    29  */
     0.5000,  0.7500,  0.2500, /*    30  */
     0.7500,  0.2500,  0.5000, /*    31  */
     0.2500,  0.5000,  0.7500, /*    32  */
     0.0000,  0.0000,  0.0000, /*    33  */
     0.2500,  0.5000,  0.7500, /*    34  */
     0.5000,  0.7500,  0.2500, /*    35  */
     0.7500,  0.2500,  0.5000, /*    36  */
     0.2500,  0.7500,  0.0000, /*    37  */
     0.5000,  0.5000,  0.5000, /*    38  */
     0.7500,  0.0000,  0.2500, /*    39  */
     0.0000,  0.2500,  0.7500, /*    40  */
     0.2500,  0.7500,  0.0000, /*    41  */
     0.0000,  0.2500,  0.7500, /*    42  */
     0.5000,  0.5000,  0.5000, /*    43  */
     0.7500,  0.0000,  0.2500, /*    44  */
     0.2500,  0.7500,  0.0000, /*    45  */
     0.7500,  0.0000,  0.2500, /*    46  */
     0.0000,  0.2500,  0.7500, /*    47  */
     0.5000,  0.5000,  0.5000  /*    48  */
  },
    /*  9  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.0000,  0.0000,  0.0000, /*    2  */
     0.0000,  0.0000,  0.0000, /*    3  */
     0.0000,  0.0000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.0000,  0.0000,  0.0000, /*    6  */
     0.0000,  0.0000,  0.0000, /*    7  */
     0.0000,  0.0000,  0.0000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.0000,  0.0000, /*    10  */
     0.0000,  0.0000,  0.0000, /*    11  */
     0.0000,  0.0000,  0.0000, /*    12  */
     0.0000,  0.0000,  0.0000, /*    13  */
     0.0000,  0.0000,  0.0000, /*    14  */
     0.0000,  0.0000,  0.0000, /*    15  */
     0.0000,  0.0000,  0.0000, /*    16  */
     0.0000,  0.0000,  0.0000, /*    17  */
     0.0000,  0.0000,  0.0000, /*    18  */
     0.0000,  0.0000,  0.0000, /*    19  */
     0.0000,  0.0000,  0.0000, /*    20  */
     0.0000,  0.0000,  0.0000, /*    21  */
     0.0000,  0.0000,  0.0000, /*    22  */
     0.0000,  0.0000,  0.0000, /*    23  */
     0.0000,  0.0000,  0.0000, /*    24  */
     0.0000,  0.0000,  0.0000, /*    25  */
     0.0000,  0.0000,  0.0000, /*    26  */
     0.0000,  0.0000,  0.0000, /*    27  */
     0.0000,  0.0000,  0.0000, /*    28  */
     0.0000,  0.0000,  0.0000, /*    29  */
     0.0000,  0.0000,  0.0000, /*    30  */
     0.0000,  0.0000,  0.0000, /*    31  */
     0.0000,  0.0000,  0.0000, /*    32  */
     0.0000,  0.0000,  0.0000, /*    33  */
     0.0000,  0.0000,  0.0000, /*    34  */
     0.0000,  0.0000,  0.0000, /*    35  */
     0.0000,  0.0000,  0.0000, /*    36  */
     0.0000,  0.0000,  0.0000, /*    37  */
     0.0000,  0.0000,  0.0000, /*    38  */
     0.0000,  0.0000,  0.0000, /*    39  */
     0.0000,  0.0000,  0.0000, /*    40  */
     0.0000,  0.0000,  0.0000, /*    41  */
     0.0000,  0.0000,  0.0000, /*    42  */
     0.0000,  0.0000,  0.0000, /*    43  */
     0.0000,  0.0000,  0.0000, /*    44  */
     0.0000,  0.0000,  0.0000, /*    45  */
     0.0000,  0.0000,  0.0000, /*    46  */
     0.0000,  0.0000,  0.0000, /*    47  */
     0.0000,  0.0000,  0.0000  /*    48  */
  },
   /*  10  */
  {  0.0000,  0.0000,  0.0000, /*    1  */
     0.5000,  0.0000,  0.5000, /*    2  */
     0.0000,  0.5000,  0.5000, /*    3  */
     0.5000,  0.5000,  0.0000, /*    4  */
     0.0000,  0.0000,  0.0000, /*    5  */
     0.5000,  0.5000,  0.0000, /*    6  */
     0.5000,  0.0000,  0.5000, /*    7  */
     0.0000,  0.5000,  0.5000, /*    8  */
     0.0000,  0.0000,  0.0000, /*    9  */
     0.0000,  0.5000,  0.5000, /*    10  */
     0.5000,  0.5000,  0.0000, /*    11  */
     0.5000,  0.0000,  0.5000, /*    12  */
     0.7500,  0.2500,  0.2500, /*    13  */
     0.7500,  0.7500,  0.7500, /*    14  */
     0.2500,  0.2500,  0.7500, /*    15  */
     0.2500,  0.7500,  0.2500, /*    16  */
     0.7500,  0.2500,  0.2500, /*    17  */
     0.2500,  0.7500,  0.2500, /*    18  */
     0.7500,  0.7500,  0.7500, /*    19  */
     0.2500,  0.2500,  0.7500, /*    20  */
     0.7500,  0.2500,  0.2500, /*    21  */
     0.2500,  0.2500,  0.7500, /*    22  */
     0.2500,  0.7500,  0.2500, /*    23  */
     0.7500,  0.7500,  0.7500, /*    24  */
     0.0000,  0.0000,  0.0000, /*    25  */
     0.5000,  0.0000,  0.5000, /*    26  */
     0.0000,  0.5000,  0.5000, /*    27  */
     0.5000,  0.5000,  0.0000, /*    28  */
     0.0000,  0.0000,  0.0000, /*    29  */
     0.5000,  0.5000,  0.0000, /*    30  */
     0.5000,  0.0000,  0.5000, /*    31  */
     0.0000,  0.5000,  0.5000, /*    32  */
     0.0000,  0.0000,  0.0000, /*    33  */
     0.0000,  0.5000,  0.5000, /*    34  */
     0.5000,  0.5000,  0.0000, /*    35  */
     0.5000,  0.0000,  0.5000, /*    36  */
     0.2500,  0.7500,  0.7500, /*    37  */
     0.2500,  0.2500,  0.2500, /*    38  */
     0.7500,  0.7500,  0.2500, /*    39  */
     0.7500,  0.2500,  0.7500, /*    40  */
     0.2500,  0.7500,  0.7500, /*    41  */
     0.7500,  0.2500,  0.7500, /*    42  */
     0.2500,  0.2500,  0.2500, /*    43  */
     0.7500,  0.7500,  0.2500, /*    44  */
     0.2500,  0.7500,  0.7500, /*    45  */
     0.7500,  0.7500,  0.2500, /*    46  */
     0.7500,  0.2500,  0.7500, /*    47  */
     0.2500,  0.2500,  0.2500  /*    48  */
  }
};
     
