/***********************************************************************************
* System Monitor: Plasmoid and data engines to monitor CPU/Memory/Swap Usage.
* Copyright (C) 2008  Matthew Dawson
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef CPU_MONITOR_H
#define CPU_MONITOR_H

#include <plasma/dataengine.h>
#include <QTimer>
#include <sys/types.h>
#include <unistd.h>

class QFile;

class MemMonitor : public Plasma::DataEngine{

    Q_OBJECT

public:
	MemMonitor(QObject* parent, const QVariantList& args);
	~MemMonitor();

protected slots:
        void printUsage();

protected:
	void init();
	bool sourceRequestEvent(const QString &name);
	bool updateSourceEvent(const QString& source);

private:
	QFile *meminfo;
	bool updateRAM();
	bool updateSwap();
	bool parseFile(QStringList fields, QMap<QString, int> &values);

};

K_EXPORT_PLASMA_DATAENGINE(memmonitor, MemMonitor)

#endif
