/*	test_Memory_Chart

CVS ID: test_Memory_Chart.java,v 1.4 2012/04/16 06:23:00 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import PIRL.Viewers.Memory_Chart;

import	javax.swing.JFrame;
import	javax.swing.JPanel;
import	javax.swing.BorderFactory;
import	javax.swing.JButton;
import	javax.swing.JLabel;
import	javax.swing.JTextField;
import	javax.swing.Box;
import	javax.swing.Timer;
import	java.awt.GridBagLayout;
import	java.awt.GridBagConstraints;
import	java.awt.Insets;
import	java.awt.event.ActionListener;
import	java.awt.event.ActionEvent;
import	java.util.Stack;
import	java.util.Random;


public class test_Memory_Chart
{
static private Memory_Chart
	Chart;

static private Memory_Use
	Memory_User;

static private JButton
	Annotation_Button,
	Seconds_Scale_Button,
	Start_Stop_Button;

static private JTextField
	Rate_Field;


private static class Memory_Use
{
private Timer
	Cycle;
private Random
	Randomizer	= new Random ();
private Stack
	Chunks		= new Stack ();
int
	Total_Used	= 0;


public Memory_Use ()
{
Cycle = new Timer (2000, new ActionListener ()
	{public void actionPerformed (ActionEvent event)
	{Use_Memory ();}});
Cycle.start ();
}


private void Use_Memory ()
{
if (Randomizer.nextInt (3) != 0)
	{
	int
		remaining =
			(int)(Chart.Available_Memory ()
				- Chart.Allocated_Memory ()
				+ Chart.Free_Memory ());
	if (remaining > (8 * 1024 * 1024))
		{
		int
			amount = Randomizer.nextInt (remaining);
		try
			{
			Chunks.push (new char[amount]);
			Total_Used += amount;
			System.out.println
				("      Total_Used: " + Total_Used + '\n'
				+"Available_Memory: " + Chart.Available_Memory () + '\n'
				+"Allocated_Memory: " + Chart.Allocated_Memory () + '\n'
				+"     Free_Memory: " + Chart.Free_Memory ());
			return;
			}
		catch (OutOfMemoryError e) {}
		}
	}
if (! Chunks.isEmpty ())
	{
	char[]
		chunk = (char[])Chunks.pop ();
	Chunks.trimToSize ();
	Total_Used -= chunk.length;
	System.out.println
		("      Total_Used: " + Total_Used + '\n'
		+"Available_Memory: " + Chart.Available_Memory () + '\n'
		+"Allocated_Memory: " + Chart.Allocated_Memory () + '\n'
		+"     Free_Memory: " + Chart.Free_Memory ());
	chunk = null;
	System.gc ();
	}
}

}


public static void main
	(
	String[]	arguments
	)
{
System.out.println (Memory_Chart.ID);

JFrame
	frame = new JFrame ("Memory_Chart Test");
frame.setDefaultCloseOperation (JFrame.EXIT_ON_CLOSE);
JPanel
	panel = new JPanel (new GridBagLayout ());
GridBagConstraints
	location = new GridBagConstraints ();

//	Memory chart:
JPanel
	memory_chart = new JPanel (new GridBagLayout ());
memory_chart.setBorder (BorderFactory.createTitledBorder ("Memory Use"));
location.fill = GridBagConstraints.BOTH;
location.weightx =
location.weighty = 1.0;
memory_chart.add (Chart = new Memory_Chart (1), location);
Memory_User = new Memory_Use ();
location.gridwidth = 4;
location.gridheight = 3;
location.insets = new Insets (0, 5, 0, 0);
panel.add (memory_chart, location);

//	Right side buttons:

location.gridx = 4;
location.fill = GridBagConstraints.VERTICAL;
location.weightx = 0.0;
location.gridwidth = GridBagConstraints.REMAINDER;
location.gridheight = 1;
panel.add (Box.createVerticalGlue (), location);

Annotation_Button = new JButton ("Annotation");
Annotation_Button.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event) {Change_Annotation ();}});
location.anchor = GridBagConstraints.SOUTH;
location.fill = GridBagConstraints.HORIZONTAL;
location.weighty = 0.0;
location.insets = new Insets (5, 5, 5, 5);
panel.add (Annotation_Button, location);

Seconds_Scale_Button = new JButton ("Seconds Scale");
Seconds_Scale_Button.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event) {Change_Seconds_Scale ();}});
location.insets = new Insets (0, 5, 5, 5);
panel.add (Seconds_Scale_Button, location);

//	Bottom row:

location.gridx = 0;
location.fill = GridBagConstraints.HORIZONTAL;
location.weightx = 1.0;
location.gridwidth = 1;
panel.add (Box.createHorizontalGlue (), location);

location.gridx = GridBagConstraints.RELATIVE;
location.anchor = GridBagConstraints.EAST;
location.fill = GridBagConstraints.NONE;
location.weightx = 0.0;
location.insets = new Insets (5, 5, 5, 5);
panel.add (new JLabel ("Sampling Rate:"), location);

Rate_Field = new JTextField (String.valueOf (Chart.Rate ()), 3);
Rate_Field.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event) {Change_Rate ();}});
location.insets = new Insets (5, 0, 5, 5);
panel.add (Rate_Field, location);

location.insets = new Insets (5, 0, 5, 5);
panel.add (new JLabel ("seconds"), location);

Start_Stop_Button = new JButton ((Chart.Rate () == 0) ? "Start" : "Stop");
Start_Stop_Button.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event) {Start_Stop ();}});
location.anchor = GridBagConstraints.CENTER;
location.fill = GridBagConstraints.HORIZONTAL;
location.weightx = 1.0;
location.gridwidth = GridBagConstraints.REMAINDER;
location.insets = new Insets (5, 5, 5, 5);
panel.add (Start_Stop_Button, location);

frame.setContentPane (panel);
frame.pack ();
frame.setVisible (true);
}


private static void Change_Annotation ()
{Chart.Annotation (! Chart.Annotation ());}


private static void Change_Seconds_Scale ()
{Chart.Seconds_Scale (! Chart.Seconds_Scale ());}


private static void Change_Rate ()
{
int
	previous_rate = Chart.Rate ();
try {Chart.Rate (Integer.valueOf (Rate_Field.getText ()));}
catch (NumberFormatException exception)
	{Rate_Field.setText (String.valueOf (previous_rate));}
}


private static void Start_Stop ()
{
if (Chart.Rate () == 0)
	{
	Chart.Start ();
	Start_Stop_Button.setText ("Stop");
	}
else
	{
	Chart.Stop ();
	Start_Stop_Button.setText ("Start");
	}
}

}
