/*	Invalid_Map_Syntax

PIRL CVS ID: Invalid_Map_Syntax.java,v 1.5 2012/04/16 06:14:23 castalia Exp

Copyright (C) 2004-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package PIRL.PVL;

/**	The <I>Exeception</I> that is thrown if a PVL_to_DB map parameter
	contains invalid syntax.
<p>
	@author	Bradford Castalia - UA/PIRL
	@version	1.5
	@see	PVL_to_DB
*/
public class Invalid_Map_Syntax
	extends Exception
{
/**	Class name and version identification.
*/
public static final String
	ID = "PIRL.PVL.Invalid_Map_Syntax (1.5 2012/04/16 06:14:23)";

private String
	Reference = null,
	Pathname = null,
	Value = null;

/**	Constructs an Invalid_Map_Syntax exception with the
	specified detail message.
<p>
	The exception's Reference, Pathname and Value will be null.
<p>
	@param	message	The detail message; retrievable by the
		{@link Throwable#getMessage()} method.
*/
public Invalid_Map_Syntax
	(
	String	message
	)
{super (message);}

/**	Constructs an Invalid_Map_Syntax exception with
	the specified detail message and reference.
<p>
	The exception's Pathname and Value will be null.
<p>
	@param	message	The detail message; retrievable by the
		{@link Throwable#getMessage()} method.
	@param	reference The reference String that contains the invalid
		syntax; retrievable by the {@link #Reference()} method.
*/
public Invalid_Map_Syntax
	(
	String	message,
	String	reference
	)
{
super (message);
Reference = reference;
}

/**	Constructs an Invalid_Map_Syntax exception with
	the specified detail message, reference, and map parameter.
<p>
	The {@link #Pathname() Pathname} and {@link #Value() Value}
	Strings of the parameter are saved.
<p>
	@param	message	The detail message; retrievable by the
		{@link Throwable#getMessage()} method.
	@param	reference The reference String that contains the invalid
		syntax; retrievable by the {@link #Reference()} method.
	@param	parameter The map parameter that contains the invalid
		syntax.
*/
public Invalid_Map_Syntax
	(
	String		message,
	String		reference,
	Parameter	parameter
	)
{
super (message);
Reference = reference;
Parameter (parameter);
}

/**	Gets the reference with the invalid syntax.
<p>
	@return	The reference String with the invalid syntax that
		caused the exception.
*/
public String Reference ()
{return Reference;}

/**	Gets the pathname of the map parameter with the invalid syntax.
<p>
	@return	The pathname of the map parameter that contained the
		reference with invalid syntax.
*/
public String Pathname ()
{return Pathname;}

/**	Gets the value of the map parameter with the invalid syntax.
<p>
	@return	The value String of the map parameter that contained the
		reference with invalid syntax.
*/
public String Value ()
{return Value;}

/**	Saves the pathname and value of the parameter.
<p>
	If the parameter is an Aggregate, the value will be null. If
	the parameter Value is an Array, the full reprepresentation of
	the Array will be saved.
<p>
	@param	parameter	The map parameter that contains the invalid
		syntax.
*/
public void Parameter
	(
	Parameter	parameter
	)
{
Pathname = parameter.Path_Name ();
if (parameter.Is_Aggregate ())
	Value = null;
else
	{
	Value
		value = null;
	try {value = parameter.Value ();}
	catch (PVL_Exception exception) {/* Checked for Aggregate above. */}
	if (value.Is_Array ())
		Value = value.Description ();
	else
		{
		try {Value = value.String_Data ();}
		catch (PVL_Exception exception) {/* Checked for Array above. */}
		}
	}
}


}
