# SPDX-FileCopyrightText: 2018 Nextcloud GmbH and Nextcloud contributors
# SPDX-FileCopyrightText: 2011 ownCloud GmbH
# SPDX-License-Identifier: GPL-2.0-or-later

# ------------------------------------
# Version information
# ------------------------------------
set(MIRALL_VERSION_MAJOR 4)
set(MIRALL_VERSION_MINOR 0)
set(MIRALL_VERSION_PATCH 0)
set(MIRALL_VERSION_YEAR  2025)
set(MIRALL_SOVERSION     0)
set(MIRALL_PREVERSION_HUMAN "4.0.0")  # For preversions where PATCH>=50. Use version + alpha, rc1, rc2, etc.
set(NCEXT_BUILD_NUM 47)
set(NCEXT_VERSION 3,0,0,${NCEXT_BUILD_NUM})

# ------------------------------------
# Minimum supported server versions
# According to: https://docs.nextcloud.com/server/latest/admin_manual/release_schedule.html
# ------------------------------------
set(NEXTCLOUD_SERVER_VERSION_MIN_SUPPORTED_MAJOR 18)
set(NEXTCLOUD_SERVER_VERSION_MIN_SUPPORTED_MINOR 0)
set(NEXTCLOUD_SERVER_VERSION_MIN_SUPPORTED_PATCH 0)

set(NEXTCLOUD_SERVER_VERSION_SECURE_FILEDROP_MIN_SUPPORTED_MAJOR 26)
set(NEXTCLOUD_SERVER_VERSION_SECURE_FILEDROP_MIN_SUPPORTED_MINOR 0)
set(NEXTCLOUD_SERVER_VERSION_SECURE_FILEDROP_MIN_SUPPORTED_PATCH 0)

set(NEXTCLOUD_SERVER_VERSION_MOUNT_ROOT_PROPERTY_SUPPORTED_MAJOR 28)
set(NEXTCLOUD_SERVER_VERSION_MOUNT_ROOT_PROPERTY_SUPPORTED_MINOR 0)
set(NEXTCLOUD_SERVER_VERSION_MOUNT_ROOT_PROPERTY_SUPPORTED_PATCH 3)

# ------------------------------------
# Define default suffixes if not set
# ------------------------------------
if(NOT DEFINED MIRALL_VERSION_SUFFIX)
    set(MIRALL_VERSION_SUFFIX "daily")  # e.g. beta1, rc1, etc.
endif()

if(NOT DEFINED MIRALL_VERSION_BUILD)
    set(MIRALL_VERSION_BUILD "0")       # Integer ID generated by the build system
endif()

# ------------------------------------
# Composite version definitions
# ------------------------------------
# Used for libraries: keep at x.y.z
set(MIRALL_VERSION "${MIRALL_VERSION_MAJOR}.${MIRALL_VERSION_MINOR}.${MIRALL_VERSION_PATCH}")

# Full version (includes build number)
set(MIRALL_VERSION_FULL "${MIRALL_VERSION}.${MIRALL_VERSION_BUILD}")

# Base version string (e.g. 3.16.50daily)
set(MIRALL_VERSION_STRING "${MIRALL_VERSION}${MIRALL_VERSION_SUFFIX}")

# Decide human-readable version string
if(MIRALL_VERSION_PATCH VERSION_GREATER_EQUAL 50)
    set(MIRALL_HUMAN_VERSION_STRING "${MIRALL_PREVERSION_HUMAN}")
else()
    set(MIRALL_HUMAN_VERSION_STRING "${MIRALL_VERSION_STRING}")
endif()

# Append build info if available
if(MIRALL_VERSION_BUILD)
    set(MIRALL_VERSION_STRING "${MIRALL_VERSION_STRING} (build ${MIRALL_VERSION_BUILD})")
endif()

# ------------------------------------
# Misc
# ------------------------------------
# Not used anymore. For brander, please maintain craftmaster.ini
set(QT_MAJOR_VERSION 6)
