/***************************** LICENSE START ***********************************

 Copyright 2021ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MVQFEATURECOMMANDTARGET_H
#define MVQFEATURECOMMANDTARGET_H

#include <QPointF>
#include <QString>
#include <QStringList>

class MvQFeatureType;
class MvQFeatureItem;
class MvQFeatureHandler;

// indentifies the recepient of a context menu event or a shortcut
class MvQFeatureCommandTarget
{
public:
    enum SelectionMode {ContextMenuMode, ShortcutMode};
    MvQFeatureCommandTarget(SelectionMode mode, MvQFeatureHandler* handler) : mode_(mode), handler_(handler) {}

    SelectionMode mode() const {return mode_;}
    MvQFeatureItem* targetItem() const {return targetItem_;}
    QPointF scenePos() const {return scenePos_;}
    QString itemMode() const {return itemMode_;}
    QString itemType() const {return itemType_;}
    int nodeIndex() const {return nodeIndex_;}
    bool inSelector() const {return inSelector_;}
    bool isCommmandEnabled(QString cmd) const {return !disabledCommands_.contains(cmd);}

    void eval(const QPointF& scenePos);
    void setTargetItem(MvQFeatureItem*);
    void setTargetNodeItem(MvQFeatureItem* item, int nodeIndex);
    void setInSelector(bool b) {inSelector_ = b;}
    void addDisabledCommands(QStringList lst);

protected:
    SelectionMode mode_{ContextMenuMode};
    QString itemMode_{"-"};
    QString itemType_{"-"};
    int nodeIndex_{-1};
    MvQFeatureItem* targetItem_{nullptr};
    bool inSelector_{false};
    QPointF scenePos_;
    MvQFeatureHandler* handler_{nullptr};
    QStringList disabledCommands_;
};


#endif // MVQFEATURECOMMANDTARGET_H
