/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QRegExp>
#include <QStringList>

#include "MvQHighlighter.h"

using namespace std;

MvQHighlighter::MvQHighlighter(QTextDocument *parent)
     : QSyntaxHighlighter(parent)
 {
 }

 void MvQHighlighter::highlightBlock(const QString &text)
 {
     foreach (HighlightingRule rule, highlightingRules) 
	{
         QRegExp expression(rule.pattern);
         int index = text.indexOf(expression);
         while (index >= 0) 
	{
             int length = expression.matchedLength();
             setFormat(index, length, rule.format);
             index = text.indexOf(expression, index + length);
         }
     }
     setCurrentBlockState(0);

    /* int startIndex = 0;
     if (previousBlockState() != 1)
         startIndex = text.indexOf(commentStartExpression);

     while (startIndex >= 0) 
	{
         int endIndex = text.indexOf(commentEndExpression, startIndex);
         int commentLength;
         if (endIndex == -1) 
	{
             setCurrentBlockState(1);
             commentLength = text.length() - startIndex;
         } 
	else 
	{
             commentLength = endIndex - startIndex
                             + commentEndExpression.matchedLength();
         }
         setFormat(startIndex, commentLength, multiLineCommentFormat);
         startIndex = text.indexOf(commentStartExpression,
                                                 startIndex + commentLength);
     }*/
 }

 MvQOdbSqlHighlighter::MvQOdbSqlHighlighter(QTextDocument *parent,QStringList columns, QStringList functions)
     : MvQHighlighter(parent)
 {
	HighlightingRule rule;

  	//Keywords
     	QTextCharFormat keywordFormat;

	keywordFormat.setForeground(Qt::darkBlue);
     	keywordFormat.setFontWeight(QFont::Bold);
 
    	QStringList keywordPatterns;
      	keywordPatterns << "select" << "from" << "where" << "orderby" << "uniqueby" << "distinct";

	foreach (QString pattern, keywordPatterns)
	{
         	rule.pattern = QRegExp(pattern,Qt::CaseInsensitive);
    		//QString s=pattern + "(?==)";
		//rule.pattern = QRegExp(s,Qt::CaseInsensitive);    		
		rule.format = keywordFormat;
         	highlightingRules.append(rule);
	}

	//Columns
     	setColumns(columns);
 }

void MvQOdbSqlHighlighter::setColumns(QStringList columns)
{
	if(columns.count() == 0)
		return;

	//Here we should remove the previous settings!!!!!!

	HighlightingRule rule;

	rule.id="column";

  	QTextCharFormat columnFormat;

	columnFormat.setForeground(Qt::red);
     	columnFormat.setFontWeight(QFont::Bold);

	foreach (QString pattern, columns)
	{
         	rule.pattern = QRegExp(pattern,Qt::CaseInsensitive);
    		//QString s=pattern + "(?==)";
		//rule.pattern = QRegExp(s,Qt::CaseInsensitive);    		
		rule.format = columnFormat;
         	highlightingRules.append(rule);
	}

}
