/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File StringLine.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef StringLine_H
#define StringLine_H

#include "UITextLine.h"
#include "RequestPanelLine.h"

class StringLine : public XRequestPanelLine<UITextLine_c> {
public:

// -- Contructors

	StringLine(RequestPanel&,const Parameter&);

// -- Destructor

	virtual ~StringLine(); 

private:

// No copy allowed

	StringLine(const StringLine&);
	StringLine& operator=(const StringLine&);

// -- Members
	
	bool changed_;

// -- Overridden methods

	// From XD

	virtual void activateCB(Widget,XtPointer);
	virtual void changedCB(Widget,XtPointer);
	virtual void loosingFocusCB(Widget,XtPointer);
	virtual void loosingPrimaryCB(Widget,XtPointer);

	// From RequestPanelItem

	virtual void refresh(const vector<string>&);
	virtual void apply();
	virtual void set(Request&);

};

#endif
