/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QApplication>
#include "OdbExaminer.h"

#include <iostream>
#include "Metview.h"
#include "MvQService.h"

#include "MvScanFileType.h"
#include "MvQOdbMetaData.h"

using namespace std;
 
// Globals
int          ac;
char       **av;


class Base : public MvQService { 
protected:
	Base(char* a) : MvQService(a) {};
};

class MvOdbExaminer: public Base {	
public:
	MvOdbExaminer(char* a) : Base(a) {};
	void serve(MvRequest&,MvRequest&);
};


void MvOdbExaminer::serve( MvRequest& in, MvRequest& /*out*/)
{
   	cout << "--------------MvOdbExaminer::serve()--------------" << endl;
  	in.print();
 
	string dataPath;

	// Get verb
	string verb = in.getVerb();

	cout << "verb: " << verb << endl;

	if(verb == "ODB_GEO_POINTS" || verb == "ODB_GEO_VECTORS" || 
	   verb == "ODB_XY_POINTS" || verb == "ODB_XY_VECTORS" ||
	   verb == "ODB_XY_BINNING")
	{				      
		//string odbVerb = odbReq.getVerb();
		const char *path=in("ODB_FILENAME");
		if(path)
			dataPath.assign(path);
		

	}
	else
	{
		const char* path=in("PATH");
		if(path)
			dataPath.assign(path);
	}	
	if(dataPath.empty())
  	{
		string err="Error!\n";			
		setError(13,err.c_str());
		err="No ODB file is specified!\n";
		setError(13,err.c_str());
		return;			
  	}		

	//Find out and check odb format  	
  	string odbType = MvOdbType(dataPath.c_str(),true);	

	if(odbType != "ODB_NEW" && odbType != "ODB_OLD")
	{
		marslog(LOG_EROR,"Wrong data type: %s! Only ODB_DB is accepted!",odbType.c_str());
		setError(13);
		return;			
	}
	else if(odbType == "ODB_NEW")
	{
#ifndef METVIEW_ODB_NEW		
		marslog(LOG_EROR,"Cannot handle ODB-2 data! ODB-2 support is disabled!");
		setError(13);
		return;
#endif
	}
	else if(odbType == "ODB_OLD")
	{
#ifndef METVIEW_ODB_OLD		
		marslog(LOG_EROR,"Cannot handle ODB-1 data! ODB-1 support is disabled!");
		setError(13);
		return;
#endif
	}

	//Create the qt application
	QApplication app(ac, av);

	//Initialise resorces from a static library (libMvQtGui)
	Q_INIT_RESOURCE(examiner);
	Q_INIT_RESOURCE(window);
	Q_INIT_RESOURCE(find);

	//Create the oda object and initialize it	
	MvQOdbMetaData *odb=new MvQOdbMetaData(dataPath,odbType);

	//Create the oda examiner and initialize it
	OdbExaminer *browser = new OdbExaminer;
	browser->init(odb);
   	browser->show();

	//Listen to the mars event loop!
	setupSocketNotifier();
	
	// Send reply to MetviewUI (but not to MvExamineManager)
	// To turn icon to green; otherwise, it will stay orange
	if( strcmp( getenv("METVIEW_MODE"), "examine" ) != 0 )
	{
	    MvRequest req;
	    sendReplyFromInteractive(req);
	}

	//Enter the app loop
 	app.exec();	
}		

int main( int argc, char **argv )
{
	ac = argc;
  	av = argv;
	
	MvApplication theApp( argc, argv );

    	MvOdbExaminer odb("ODB_DB");
	MvOdbExaminer odb1("ODB_GEO_POINTS");	
	MvOdbExaminer odb2("ODB_GEO_VECTORS");
	MvOdbExaminer odb3("ODB_XY_POINTS");
	MvOdbExaminer odb4("ODB_XY_VECTORS");
	MvOdbExaminer odb5("ODB_XY_MATRIX");
	
    	theApp.run();	
}
