/*****************************************************************************
 *
 * This file is part of Mapnik (c++ mapping toolkit)
 *
 * Copyright (C) 2016 Artem Pavlenko
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *****************************************************************************/


#include <mapnik/json/geometry_parser.hpp>
#include <mapnik/json/geometry_grammar.hpp>

// boost
#include <boost/spirit/include/qi.hpp>
#include <boost/spirit/include/phoenix_core.hpp>

namespace mapnik { namespace json {

bool from_geojson(std::string const& json, mapnik::geometry::geometry<double> & geom)
{
    using namespace boost::spirit;
    static const geometry_grammar<char const*> g;
    standard::space_type space;
    char const* start = json.c_str();
    char const* end = start + json.length();
    try
    {
        if (!qi::phrase_parse(start, end, g, space, geom))
        {
            throw std::runtime_error("Can't parser GeoJSON Geometry");
        }
    }
    catch (...) { return false; }
    return true;
}

}}
