<?PHP
# Copyright 2006, CRIM, Revolution Linux Inc.
#
# $Id$
#
# Authors : Stephane Bond
#
# This file is part of the MILLE-XTERM project.
#
#       http://www.revolutionlinux.com/mille-xterm/
#       http://www.mille.ca/
#
# This program is covered by the GNU General Public License.
# See the COPYING file in the top-level MILLE-XTERM directory.
#
# -------------------------------------------------------------------------


/**
*
* This script is called by terminals to obtain current security rules
*
* <code>
* ?action=list/ip=192.168.2.221
* </code>
*/

require_once 'util/functions.php';
require_once 'util/Node.php';
require_once 'util/SecurityRulesFinder.php';


# Security : only the expected variable are assigned
# No post
unset($_POST);
# No cookies 
unset($_COOKIES);


# Expected variables
$get["action"]='';
$get["ip"]='';

# Get the allowed variables
foreach ($_GET as $key=>$value) {
    if (isset($get[$key])) {
	    $get[$key]="$value";
    }
}

# Open the current node
$rulesFinder=new SecurityRulesFinder($get["ip"]);

$keys=$rulesFinder->getAuthorizedKeys();
if (!empty($keys)) {
	foreach ($keys as $key) {
		print "key:".$key."\n";
	}
}
$ips=$rulesFinder->getAuthorizedIps();
if (!empty($ips)) {
	foreach ($ips as $ip) {
		print "ip:".$ip."\n";
	}
}


?>
