This directory contains two netlib versions.  The routines have been
grabbed from netlib and other places.  In general the C files are
direct translations of the FORTRAN, so the `*.f` should be edited if
improvements are required or mods are to be made.

The old netlib library has been almost completely removed.  All code
but `triangle.c` and related code belong to the newer `v3p_netlib
library`.

The `v3p_netlib` library contains updated netlib code converted with `f2c`
in a thread-safe manner.  Sources have been modified to use the
`v3p_*.h` headers in this directory.  Types and function names have been
mangled to start with a `v3p_netlib_` prefix.  This distinguishes them
from other netlib libraries and keeps the code grouped and isolated.

------------------------------------------------------------------------------
The `libf2c` directory was created as follows:

1. Downloaded and extracted http://www.netlib.org/f2c/libf2c.zip

2. Converted sources to include our mangled `f2c` header.

    ```bash
    for f in libf2c/*.c; do
        cat $f | sed 's/f2c.h/v3p_f2c.h/' > $f.tmp && mv $f.tmp $f
    done
    ```
3. Added a missing leading segment to some sources.

    ```bash
    for f in libf2c/sig_die.c libf2c/cabs.c; do
        (echo "#include \"v3p_f2c.h\"
    #undef abs
    #undef min
    #undef max
    " && cat $f) > $f.tmp &&
        mv $f.tmp $f
    done
    ```
4. Remove calls to `f_exit` from `libf2c/sig_die.c`

5. Put `v3p_netlib_`-mangling definitions in `v3p_f2c_mangle.h` and
`undef` directives in `v3p_f2c_unmangle.h`.  These change the symbol
and type names using the preprocessor to avoid sweeping changes
of the code.

Updates to the `libf2c` directory for newer upstream versions should be
made by first committing them to a new branch and then merging the
changes to the main tree.

------------------------------------------------------------------------------

The other directories were created as follows:

1. Find needed FORTRAN routines from http://www.netlib.org/liblist.html

2. Use the web interface to download the routines and dependencies.
For example at

    http://www.netlib.org/cgi-bin/netlibfiles.pl?filename=/linpack/dsvdc.f
    
    choose "yes" for including BLAS routines and package as zip or tgz.

3. Extract the sources into the `vxl/v3p/netlib` directory.  They should
automatically create subdirectories like `blas/` and `linpack/` with the
respecitve sources.

4. Commit the original FORTRAN sources.
    ```bash
    $ git commit -m "Adding original FORTRAN code for this function."
    ```

5. Convert the sources to C using `f2c` and replace the `f2c.h` header
inclusion with `v3p_netlib.h`:
    ```bash
    for d in blas linpack temperton eispack laso arpack lapack/complex16 lapack/double lapack/single lapack/util napack minpack opt linalg toms datapac mathews; do
      for f in ${d}/*.f; do
        b=`echo "$f" | sed 's/.f$//'`
        if [ ! -f "${b}.c" ]; then
          echo "Converting ${b}.f to ${b}.c"
          f2c -A -a -C++ -c -ec -E -P -d${d} ${b}.f &&
          cat ${b}.c | sed 's/f2c.h/v3p_netlib.h/' > ${b}.c.tmp &&
          mv ${b}.c.tmp ${b}.c
        fi
      done
    done
    ```
    ```bash
    $ git commit -m "Converted function from FORTRAN to C."
    ```

  Note the use of options to `f2c`:

    -A    = Produce ANSI C.
    -a    = Make local variables automatic instead of static (for threads).
    -C++  = Make code C++ compatible.
    -c    = Include original FORTRAN code in comments.
    -ec   = Place uninitialized COMMON blocks in separate files
    -E    = Declare uninitialized common blocks to be extern.
    -P    = Write ANSI C prototypes to .P files.
    -ddir = Write output files to given directory.

6. Put `v3p_netlib_`-mangling definitions in `v3p_netlib_mangle.h` and
`undef` directives in `v3p_netlib_unmangle.h`.  These change the symbol
and type names using the preprocessor to avoid sweeping changes of the
code.  Use
    ```bash
    $ nm libv3p_netlib.a | grep " [TRD] "
    ```
to identify symbols in the library that have not been
properly mangled.  Note if using shared libraries the command
is
    ```bash
    $ nm libv3p_netlib.so | grep " [TRD] "
    ```
and the shared-library implementation functions `_fini` and `_init` should
be left alone.

7. Convert prototypes in the `*.P` files generated by `f2c` to `*.h` files
with the mangled interface.  Include them all in `v3p_netlib_prototypes.h`.
    ```bash
    echo "/* Include prototype headers. */" > v3p_netlib_prototypes.h
    for f in blas/*.P linpack/*.P temperton/*.P eispack/*.P laso/*.P arpack/*.P lapack/*/*.P napack/*.P minpack/*.P opt/*.P linalg/*.P toms/*.P datapac/*.P mathews/*.P; do
      b=`echo "$f" | sed 's/.P//'`
      if [ ! -f "${b}.h" ] ; then
        echo "Converting prototype $b"
        cat ${b}.P |
        grep -v "^/\\*" |
        sed 's/\([A-Za-z0-9]*\)_(/v3p_netlib_\1_(/' |
        sed 's/(/(\n  /g' |
        sed 's/, /,\n  /g' |
        sed 's/)/\n  )/g' |
        sed 's/const/v3p_netlib_const/g' |
        sed '/ logical1/ {s/logical1/v3p_netlib_logical1/g}' |
        sed '/ real/ {s/real/v3p_netlib_real/g}' |
        sed '/ integer1/ {s/integer1/v3p_netlib_integer1/g}' |
        sed '/ uinteger/ {s/uinteger/v3p_netlib_uinteger/g}' |
        sed '/ integer/ {s/integer/v3p_netlib_integer/g}' |
        sed '/ address/ {s/address/v3p_netlib_address/g}' |
        sed '/ shortint/ {s/shortint/v3p_netlib_shortint/g}' |
        sed '/ doublereal/ {s/doublereal/v3p_netlib_doublereal/g}' |
        sed '/ doublecomplex/ {s/doublecomplex/v3p_netlib_doublecomplex/g}' |
        sed '/ complex/ {s/complex/v3p_netlib_complex/g}' |
        sed '/ shortlogical/ {s/shortlogical/v3p_netlib_shortlogical/g}' |
        sed '/ logical/ {s/logical/v3p_netlib_logical/g}' |
        sed '/ longint/ {s/longint/v3p_netlib_longint/g}' |
        sed '/ ulongint/ {s/ulongint/v3p_netlib_ulongint/g}' |
        sed '/ ftnlen/ {s/ftnlen/v3p_netlib_ftnlen/g}' |
        sed '/ C_f/ {s/C_f/v3p_netlib_C_f/g}' |
        sed '/ E_f/ {s/E_f/v3p_netlib_E_f/g}' |
        sed '/ H_f/ {s/H_f/v3p_netlib_H_f/g}' |
        sed '/ Z_f/ {s/Z_f/v3p_netlib_Z_f/g}' |
        cat > ${b}.h
      fi
      echo "#include \"${b}.h\"" >> v3p_netlib_prototypes.h
    done
    ```
    ```bash
    $ git commit -m "Converted .P file prototypes generated by f2c to v3p_netlib_-mangled protytypes in header files."
    ```
Some of these prototype header files have been manually edited to add
`v3p_netlib_const` to some of the arguments.  This is a hack to allow
const-correct code to call the functions.  The `v3p_netlib_const` macro
is defined to empty when building sources in side the library which
allows the f2c-converted code to compile without manual conversion to
const-correctness.  The macro is defined to "const" when compiling
other sources which enforces const-correctness for code calling the
routines.  Since the interface is `extern "C"` code, the symbol names
are not changed by the presence or absence of `const`.
    ```bash
    $ git commit -m "Manually documented prototype and added v3p_netlib_const to appropriate arguments."
    ```
------------------------------------------------------------------------------

Thread safety can be partially checked in this directory by running
    ```bash
    $ grep "  static" **/*.c |grep -v constant
    ```
Global data declared static seem to be constant, so only local
variables are of concern, which is why the grep expression contains
spaces.  Local statics that have been manually deemed safe (constant)
should be marked with a
    ```cpp
       /* constant */
    ```
comment to avoid being listed in the grep output.  Local statics that
require one-time initialization at run-time should be marked with a
    ```cpp
       /* runtime-initialized constant */
    ```

comment to avoid being listed in the grep output.  The routines
holding them should be given a `v3p_netlib_*_init()` function that is
called from `v3p_netlib_init.c` in the `v3p_netlib_initialize` function.

Functions that call back to user functions have been manually given a
userdata callback argument.  This allows them to be reentrant.
