package internal

import "testing"

func TestPercentage(t *testing.T) {
	// key is barWidth
	testSuite := map[uint][]struct {
		name     string
		total    int64
		current  int64
		expected int64
	}{
		100: {
			{"t,c,e{-1,-1,0}", -1, -1, 0},
			{"t,c,e{0,-1,0}", 0, -1, 0},
			{"t,c,e{0,0,0}", 0, 0, 0},
			{"t,c,e{0,1,0}", 0, 1, 0},
			{"t,c,e{100,0,0}", 100, 0, 0},
			{"t,c,e{100,10,10}", 100, 10, 10},
			{"t,c,e{100,15,15}", 100, 15, 15},
			{"t,c,e{100,50,50}", 100, 50, 50},
			{"t,c,e{100,99,99}", 100, 99, 99},
			{"t,c,e{100,100,100}", 100, 100, 100},
			{"t,c,e{100,101,101}", 100, 101, 100},
			{"t,c,e{120,0,0}", 120, 0, 0},
			{"t,c,e{120,10,8}", 120, 10, 8},
			{"t,c,e{120,15,13}", 120, 15, 13},
			{"t,c,e{120,50,42}", 120, 50, 42},
			{"t,c,e{120,60,50}", 120, 60, 50},
			{"t,c,e{120,99,83}", 120, 99, 83},
			{"t,c,e{120,101,84}", 120, 101, 84},
			{"t,c,e{120,118,98}", 120, 118, 98},
			{"t,c,e{120,119,99}", 120, 119, 99},
			{"t,c,e{120,120,100}", 120, 120, 100},
			{"t,c,e{120,121,101}", 120, 121, 100},
		},
		80: {
			{"t,c,e{-1,-1,0}", -1, -1, 0},
			{"t,c,e{0,-1,0}", 0, -1, 0},
			{"t,c,e{0,0,0}", 0, 0, 0},
			{"t,c,e{0,1,0}", 0, 1, 0},
			{"t,c,e{100,0,0}", 100, 0, 0},
			{"t,c,e{100,10,8}", 100, 10, 8},
			{"t,c,e{100,15,12}", 100, 15, 12},
			{"t,c,e{100,50,40}", 100, 50, 40},
			{"t,c,e{100,99,79}", 100, 99, 79},
			{"t,c,e{100,100,80}", 100, 100, 80},
			{"t,c,e{100,101,81}", 100, 101, 80},
			{"t,c,e{120,0,0}", 120, 0, 0},
			{"t,c,e{120,10,7}", 120, 10, 7},
			{"t,c,e{120,15,10}", 120, 15, 10},
			{"t,c,e{120,50,33}", 120, 50, 33},
			{"t,c,e{120,60,40}", 120, 60, 40},
			{"t,c,e{120,99,66}", 120, 99, 66},
			{"t,c,e{120,101,67}", 120, 101, 67},
			{"t,c,e{120,118,79}", 120, 118, 79},
			{"t,c,e{120,119,79}", 120, 119, 79},
			{"t,c,e{120,120,80}", 120, 120, 80},
			{"t,c,e{120,121,81}", 120, 121, 80},
		},
	}

	for width, cases := range testSuite {
		for _, tc := range cases {
			got := int64(PercentageRound(tc.total, tc.current, width))
			if got != tc.expected {
				t.Errorf("width %d; %s: Expected: %d, got: %d\n", width, tc.name, tc.expected, got)
			}
		}
	}
}
