// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package route53 provides a client for Amazon Route 53.
package route53

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssociateVPCWithHostedZone = "AssociateVPCWithHostedZone"

// AssociateVPCWithHostedZoneRequest generates a "aws/request.Request" representing the
// client's request for the AssociateVPCWithHostedZone operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AssociateVPCWithHostedZone for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AssociateVPCWithHostedZone method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AssociateVPCWithHostedZoneRequest method.
//    req, resp := client.AssociateVPCWithHostedZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) AssociateVPCWithHostedZoneRequest(input *AssociateVPCWithHostedZoneInput) (req *request.Request, output *AssociateVPCWithHostedZoneOutput) {
	op := &request.Operation{
		Name:       opAssociateVPCWithHostedZone,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/associatevpc",
	}

	if input == nil {
		input = &AssociateVPCWithHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AssociateVPCWithHostedZoneOutput{}
	req.Data = output
	return
}

// AssociateVPCWithHostedZone API operation for Amazon Route 53.
//
// Associates an Amazon VPC with a private hosted zone.
//
// The VPC and the hosted zone must already exist, and you must have created
// a private hosted zone. You cannot convert a public hosted zone into a private
// hosted zone.
//
// Send a POST request to the /2013-04-01/hostedzone/hosted zone ID/associatevpc
// resource. The request body must include an XML document with a AssociateVPCWithHostedZoneRequest
// element. The response returns the AssociateVPCWithHostedZoneResponse element.
//
// If you used different accounts to create the hosted zone and to create the
// Amazon VPCs that you want to associate with the hosted zone, we need to update
// account permissions for you. For more information, see Associating Amazon
// VPCs and Private Hosted Zones That You Create with Different AWS Accounts
// (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/hosted-zone-private-associate-vpcs-different-accounts.html)
// in the Amazon Route 53 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation AssociateVPCWithHostedZone for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
//   * InvalidVPCId
//   The hosted zone you are trying to create for your VPC_ID does not belong
//   to you. Amazon Route 53 returns this error when the VPC specified by VPCId
//   does not belong to you.
//
//   * InvalidInput
//   The input is not valid.
//
//   * PublicZoneVPCAssociation
//   The hosted zone specified in HostedZoneId is a public hosted zone.
//
//   * ConflictingDomainExists
//   You specified an Amazon VPC that you're already using for another hosted
//   zone, and the domain that you specified for one of the hosted zones is a
//   subdomain of the domain that you specified for the other hosted zone. For
//   example, you cannot use the same Amazon VPC for the hosted zones for example.com
//   and test.example.com.
//
//   * LimitsExceeded
//   The limits specified for a resource have been exceeded.
//
func (c *Route53) AssociateVPCWithHostedZone(input *AssociateVPCWithHostedZoneInput) (*AssociateVPCWithHostedZoneOutput, error) {
	req, out := c.AssociateVPCWithHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opChangeResourceRecordSets = "ChangeResourceRecordSets"

// ChangeResourceRecordSetsRequest generates a "aws/request.Request" representing the
// client's request for the ChangeResourceRecordSets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ChangeResourceRecordSets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ChangeResourceRecordSets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ChangeResourceRecordSetsRequest method.
//    req, resp := client.ChangeResourceRecordSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ChangeResourceRecordSetsRequest(input *ChangeResourceRecordSetsInput) (req *request.Request, output *ChangeResourceRecordSetsOutput) {
	op := &request.Operation{
		Name:       opChangeResourceRecordSets,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/rrset/",
	}

	if input == nil {
		input = &ChangeResourceRecordSetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ChangeResourceRecordSetsOutput{}
	req.Data = output
	return
}

// ChangeResourceRecordSets API operation for Amazon Route 53.
//
// Create, change, update, or delete authoritative DNS information on all Amazon
// Route 53 servers. Send a POST request to:
//
// /2013-04-01/hostedzone/Amazon Route 53 hosted Zone ID/rrset resource.
//
// The request body must include a document with a ChangeResourceRecordSetsRequest
// element. The request body contains a list of change items, known as a change
// batch. Change batches are considered transactional changes. When using the
// Amazon Route 53 API to change resource record sets, Amazon Route 53 either
// makes all or none of the changes in a change batch request. This ensures
// that Amazon Route 53 never partially implements the intended changes to the
// resource record sets in a hosted zone.
//
// For example, a change batch request that deletes the CNAME record for www.example.com
// and creates an alias resource record set for www.example.com. Amazon Route
// 53 deletes the first resource record set and creates the second resource
// record set in a single operation. If either the DELETE or the CREATE action
// fails, then both changes (plus any other changes in the batch) fail, and
// the original CNAME record continues to exist.
//
// Due to the nature of transactional changes, you cannot delete the same resource
// record set more than once in a single change batch. If you attempt to delete
// the same change batch more than once, Amazon Route 53 returns an InvalidChangeBatch
// error.
//
// To create resource record sets for complex routing configurations, use either
// the traffic flow visual editor in the Amazon Route 53 console or the API
// actions for traffic policies and traffic policy instances. Save the configuration
// as a traffic policy, then associate the traffic policy with one or more domain
// names (such as example.com) or subdomain names (such as www.example.com),
// in the same hosted zone or in multiple hosted zones. You can roll back the
// updates if the new configuration isn't performing as expected. For more information,
// see Using Traffic Flow to Route DNS Traffic (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-flow.html)
// in the Amazon Route 53 Developer Guide.
//
// Use ChangeResourceRecordsSetsRequest to perform the following actions:
//
//    * CREATE: Creates a resource record set that has the specified values.
//
//    * DELETE: Deletes an existing resource record set that has the specified
//    values for Name, Type, Set Identifier (for code latency, weighted, geolocation,
//    and failover resource record sets), and TTL (except alias resource record
//    sets, for which the TTL is determined by the AWS resource you're routing
//    queries to).
//
//    * UPSERT: If a resource record set does not already exist, AWS creates
//    it. If a resource set does exist, Amazon Route 53 updates it with the
//    values in the request. Amazon Route 53 can update an existing resource
//    record set only when all of the following values match: Name, Type, and
//    Set Identifier (for weighted, latency, geolocation, and failover resource
//    record sets).
//
// In response to a ChangeResourceRecordSets request, the DNS data is changed
// on all Amazon Route 53 DNS servers. Initially, the status of a change is
// PENDING, meaning the change has not yet propagated to all the authoritative
// Amazon Route 53 DNS servers. When the change is propagated to all hosts,
// the change returns a status of INSYNC.
//
// After sending a change request, confirm your change has propagated to all
// Amazon Route 53 DNS servers. Changes generally propagate to all Amazon Route
// 53 name servers in a few minutes. In rare circumstances, propagation can
// take up to 30 minutes. For more information, see GetChange.
//
// For information about the limits on a ChangeResourceRecordSets request, see
// Limits (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
// in the Amazon Route 53 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ChangeResourceRecordSets for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
//   * NoSuchHealthCheck
//   No health check exists with the ID that you specified in the DeleteHealthCheck
//   request.
//
//   * InvalidChangeBatch
//   This exception contains a list of messages that might contain one or more
//   error messages. Each error message indicates one error in the change batch.
//
//   * InvalidInput
//   The input is not valid.
//
//   * PriorRequestNotComplete
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Amazon Route 53 returns this error repeatedly
//   for the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
func (c *Route53) ChangeResourceRecordSets(input *ChangeResourceRecordSetsInput) (*ChangeResourceRecordSetsOutput, error) {
	req, out := c.ChangeResourceRecordSetsRequest(input)
	err := req.Send()
	return out, err
}

const opChangeTagsForResource = "ChangeTagsForResource"

// ChangeTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ChangeTagsForResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ChangeTagsForResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ChangeTagsForResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ChangeTagsForResourceRequest method.
//    req, resp := client.ChangeTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ChangeTagsForResourceRequest(input *ChangeTagsForResourceInput) (req *request.Request, output *ChangeTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opChangeTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/tags/{ResourceType}/{ResourceId}",
	}

	if input == nil {
		input = &ChangeTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ChangeTagsForResourceOutput{}
	req.Data = output
	return
}

// ChangeTagsForResource API operation for Amazon Route 53.
//
// Adds, edits, or deletes tags for a health check or a hosted zone.
//
// For information about using tags for cost allocation, see Using Cost Allocation
// Tags (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
// in the AWS Billing and Cost Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ChangeTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
//   * NoSuchHealthCheck
//   No health check exists with the ID that you specified in the DeleteHealthCheck
//   request.
//
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
//   * PriorRequestNotComplete
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Amazon Route 53 returns this error repeatedly
//   for the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
//   * ThrottlingException

//
func (c *Route53) ChangeTagsForResource(input *ChangeTagsForResourceInput) (*ChangeTagsForResourceOutput, error) {
	req, out := c.ChangeTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opCreateHealthCheck = "CreateHealthCheck"

// CreateHealthCheckRequest generates a "aws/request.Request" representing the
// client's request for the CreateHealthCheck operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateHealthCheck for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateHealthCheck method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateHealthCheckRequest method.
//    req, resp := client.CreateHealthCheckRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) CreateHealthCheckRequest(input *CreateHealthCheckInput) (req *request.Request, output *CreateHealthCheckOutput) {
	op := &request.Operation{
		Name:       opCreateHealthCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/healthcheck",
	}

	if input == nil {
		input = &CreateHealthCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateHealthCheckOutput{}
	req.Data = output
	return
}

// CreateHealthCheck API operation for Amazon Route 53.
//
// Creates a new health check.
//
// To create a new health check, send a POST request to the /2013-04-01/healthcheck
// resource. The request body must include an XML document with a CreateHealthCheckRequest
// element. The response returns the CreateHealthCheckResponse element, containing
// the health check ID specified when adding health check to a resource record
// set. For information about adding health checks to resource record sets,
// see ResourceRecordSet$HealthCheckId in ChangeResourceRecordSets.
//
// If you are registering Amazon EC2 instances with an Elastic Load Balancing
// (ELB) load balancer, do not create Amazon Route 53 health checks for the
// Amazon EC2 instances. When you register an Amazon EC2 instance with a load
// balancer, you configure settings for an ELB health check, which performs
// a similar function to an Amazon Route 53 health check.
//
// You can associate health checks with failover resource record sets in a private
// hosted zone. Note the following:
//
//    * Amazon Route 53 health checkers are outside the VPC. To check the health
//    of an endpoint within a VPC by IP address, you must assign a public IP
//    address to the instance in the VPC.
//
//    * You can configure a health checker to check the health of an external
//    resource that the instance relies on, such as a database server.
//
//    * You can create a CloudWatch metric, associate an alarm with the metric,
//    and then create a health check that is based on the state of the alarm.
//    For example, you might create a CloudWatch metric that checks the status
//    of the Amazon EC2 StatusCheckFailed metric, add an alarm to the metric,
//    and then create a health check that is based on the state of the alarm.
//    For information about creating CloudWatch metrics and alarms by using
//    the CloudWatch console, see the Amazon CloudWatch Developer Guide (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/WhatIsCloudWatch.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateHealthCheck for usage and error information.
//
// Returned Error Codes:
//   * TooManyHealthChecks
//   You have reached the maximum number of active health checks for an AWS account.
//   The default limit is 100. To request a higher limit, create a case (http://aws.amazon.com/route53-request)
//   with the AWS Support Center.
//
//   * HealthCheckAlreadyExists
//   The health check you're attempting to create already exists.
//
//   Amazon Route 53 returns this error when a health check has already been created
//   with the specified value for CallerReference.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) CreateHealthCheck(input *CreateHealthCheckInput) (*CreateHealthCheckOutput, error) {
	req, out := c.CreateHealthCheckRequest(input)
	err := req.Send()
	return out, err
}

const opCreateHostedZone = "CreateHostedZone"

// CreateHostedZoneRequest generates a "aws/request.Request" representing the
// client's request for the CreateHostedZone operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateHostedZone for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateHostedZone method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateHostedZoneRequest method.
//    req, resp := client.CreateHostedZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) CreateHostedZoneRequest(input *CreateHostedZoneInput) (req *request.Request, output *CreateHostedZoneOutput) {
	op := &request.Operation{
		Name:       opCreateHostedZone,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone",
	}

	if input == nil {
		input = &CreateHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateHostedZoneOutput{}
	req.Data = output
	return
}

// CreateHostedZone API operation for Amazon Route 53.
//
// Creates a new public hosted zone, used to specify how the Domain Name System
// (DNS) routes traffic on the Internet for a domain, such as example.com, and
// its subdomains.
//
// Public hosted zones cannot be converted to a private hosted zone or vice
// versa. Instead, create a new hosted zone with the same name and create new
// resource record sets.
//
// Send a POST request to the /2013-04-01/hostedzone resource. The request body
// must include an XML document with a CreateHostedZoneRequest element. The
// response returns the CreateHostedZoneResponse element containing metadata
// about the hosted zone.
//
// Fore more information about charges for hosted zones, see Amazon Route 53
// Pricing (http://aws.amazon.com/route53/pricing/).
//
// Note the following:
//
//    * You cannot create a hosted zone for a top-level domain (TLD).
//
//    * Amazon Route 53 automatically creates a default SOA record and four
//    NS records for the zone. For more information about SOA and NS records,
//    see NS and SOA Records that Amazon Route 53 Creates for a Hosted Zone
//    (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html)
//    in the Amazon Route 53 Developer Guide.
//
//    * If your domain is registered with a registrar other than Amazon Route
//    53, you must update the name servers with your registrar to make Amazon
//    Route 53 your DNS service. For more information, see Configuring Amazon
//    Route 53 as your DNS Service (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/creating-migrating.html)
//    in the Amazon Route 53 Developer's Guide.
//
// After creating a zone, its initial status is PENDING. This means that it
// is not yet available on all DNS servers. The status of the zone changes to
// INSYNC when the NS and SOA records are available on all Amazon Route 53 DNS
// servers.
//
// When trying to create a hosted zone using a reusable delegation set, specify
// an optional DelegationSetId, and Amazon Route 53 would assign those 4 NS
// records for the zone, instead of allotting a new one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateHostedZone for usage and error information.
//
// Returned Error Codes:
//   * InvalidDomainName
//   The specified domain name is not valid.
//
//   * HostedZoneAlreadyExists
//   The hosted zone you are trying to create already exists. Amazon Route 53
//   returns this error when a hosted zone has already been created with the specified
//   CallerReference.
//
//   * TooManyHostedZones
//   This hosted zone cannot be created because the hosted zone limit is exceeded.
//   To request a limit increase, go to the Amazon Route 53 Contact Us (http://aws.amazon.com/route53-request/)
//   page.
//
//   * InvalidVPCId
//   The hosted zone you are trying to create for your VPC_ID does not belong
//   to you. Amazon Route 53 returns this error when the VPC specified by VPCId
//   does not belong to you.
//
//   * InvalidInput
//   The input is not valid.
//
//   * DelegationSetNotAvailable
//   You can create a hosted zone that has the same name as an existing hosted
//   zone (example.com is common), but there is a limit to the number of hosted
//   zones that have the same name. If you get this error, Amazon Route 53 has
//   reached that limit. If you own the domain name and Amazon Route 53 generates
//   this error, contact Customer Support.
//
//   * ConflictingDomainExists
//   You specified an Amazon VPC that you're already using for another hosted
//   zone, and the domain that you specified for one of the hosted zones is a
//   subdomain of the domain that you specified for the other hosted zone. For
//   example, you cannot use the same Amazon VPC for the hosted zones for example.com
//   and test.example.com.
//
//   * NoSuchDelegationSet
//   A reusable delegation set with the specified ID does not exist.
//
//   * DelegationSetNotReusable
//   A reusable delegation set with the specified ID does not exist.
//
func (c *Route53) CreateHostedZone(input *CreateHostedZoneInput) (*CreateHostedZoneOutput, error) {
	req, out := c.CreateHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opCreateReusableDelegationSet = "CreateReusableDelegationSet"

// CreateReusableDelegationSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateReusableDelegationSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateReusableDelegationSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateReusableDelegationSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateReusableDelegationSetRequest method.
//    req, resp := client.CreateReusableDelegationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) CreateReusableDelegationSetRequest(input *CreateReusableDelegationSetInput) (req *request.Request, output *CreateReusableDelegationSetOutput) {
	op := &request.Operation{
		Name:       opCreateReusableDelegationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/delegationset",
	}

	if input == nil {
		input = &CreateReusableDelegationSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateReusableDelegationSetOutput{}
	req.Data = output
	return
}

// CreateReusableDelegationSet API operation for Amazon Route 53.
//
// Creates a delegation set (a group of four name servers) that can be reused
// by multiple hosted zones. If a hosted zoned ID is specified, CreateReusableDelegationSet
// marks the delegation set associated with that zone as reusable
//
// Send a POST request to the /2013-04-01/delegationset resource. The request
// body must include an XML document with a CreateReusableDelegationSetRequest
// element.
//
// A reusable delegation set cannot be associated with a private hosted zone/
//
// For more information, including a procedure on how to create and configure
// a reusable delegation set (also known as white label name servers), see Configuring
// White Label Name Servers (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/white-label-name-servers.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateReusableDelegationSet for usage and error information.
//
// Returned Error Codes:
//   * DelegationSetAlreadyCreated
//   A delegation set with the same owner and caller reference combination has
//   already been created.
//
//   * LimitsExceeded
//   The limits specified for a resource have been exceeded.
//
//   * HostedZoneNotFound
//   The specified HostedZone cannot be found.
//
//   * InvalidArgument
//   Parameter name and problem.
//
//   * InvalidInput
//   The input is not valid.
//
//   * DelegationSetNotAvailable
//   You can create a hosted zone that has the same name as an existing hosted
//   zone (example.com is common), but there is a limit to the number of hosted
//   zones that have the same name. If you get this error, Amazon Route 53 has
//   reached that limit. If you own the domain name and Amazon Route 53 generates
//   this error, contact Customer Support.
//
//   * DelegationSetAlreadyReusable
//   The specified delegation set has already been marked as reusable.
//
func (c *Route53) CreateReusableDelegationSet(input *CreateReusableDelegationSetInput) (*CreateReusableDelegationSetOutput, error) {
	req, out := c.CreateReusableDelegationSetRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTrafficPolicy = "CreateTrafficPolicy"

// CreateTrafficPolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTrafficPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTrafficPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTrafficPolicyRequest method.
//    req, resp := client.CreateTrafficPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) CreateTrafficPolicyRequest(input *CreateTrafficPolicyInput) (req *request.Request, output *CreateTrafficPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicy",
	}

	if input == nil {
		input = &CreateTrafficPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTrafficPolicyOutput{}
	req.Data = output
	return
}

// CreateTrafficPolicy API operation for Amazon Route 53.
//
// Creates a traffic policy, which you use to create multiple DNS resource record
// sets for one domain name (such as example.com) or one subdomain name (such
// as www.example.com).
//
// Send a POST request to the /2013-04-01/trafficpolicy resource. The request
// body must include a document with a CreateTrafficPolicyRequest element. The
// response includes the CreateTrafficPolicyResponse element, which contains
// information about the new traffic policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateTrafficPolicy for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
//   * TooManyTrafficPolicies
//   You've created the maximum number of traffic policies that can be created
//   for the current AWS account. You can request an increase to the limit on
//   the Contact Us (http://aws.amazon.com/route53-request/) page.
//
//   * TrafficPolicyAlreadyExists
//   A traffic policy that has the same value for Name already exists.
//
//   * InvalidTrafficPolicyDocument
//   The format of the traffic policy document that you specified in the Document
//   element is invalid.
//
func (c *Route53) CreateTrafficPolicy(input *CreateTrafficPolicyInput) (*CreateTrafficPolicyOutput, error) {
	req, out := c.CreateTrafficPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTrafficPolicyInstance = "CreateTrafficPolicyInstance"

// CreateTrafficPolicyInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficPolicyInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTrafficPolicyInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTrafficPolicyInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTrafficPolicyInstanceRequest method.
//    req, resp := client.CreateTrafficPolicyInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) CreateTrafficPolicyInstanceRequest(input *CreateTrafficPolicyInstanceInput) (req *request.Request, output *CreateTrafficPolicyInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficPolicyInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicyinstance",
	}

	if input == nil {
		input = &CreateTrafficPolicyInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTrafficPolicyInstanceOutput{}
	req.Data = output
	return
}

// CreateTrafficPolicyInstance API operation for Amazon Route 53.
//
// Creates resource record sets in a specified hosted zone based on the settings
// in a specified traffic policy version. In addition, CreateTrafficPolicyInstance
// associates the resource record sets with a specified domain name (such as
// example.com) or subdomain name (such as www.example.com). Amazon Route 53
// responds to DNS queries for the domain or subdomain name by using the resource
// record sets that CreateTrafficPolicyInstance created.
//
// Send a POST request to the /2013-04-01/trafficpolicyinstance resource. The
// request body must include a document with a CreateTrafficPolicyRequest element.
// The response returns the CreateTrafficPolicyInstanceResponse element, which
// contains information about the traffic policy instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateTrafficPolicyInstance for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
//   * InvalidInput
//   The input is not valid.
//
//   * TooManyTrafficPolicyInstances
//   You've created the maximum number of traffic policy instances that can be
//   created for the current AWS account. You can request an increase to the limit
//   on the Contact Us (http://aws.amazon.com/route53-request/) page.
//
//   * NoSuchTrafficPolicy
//   No traffic policy exists with the specified ID.
//
//   * TrafficPolicyInstanceAlreadyExists
//   Traffic policy instance with given Id already exists.
//
func (c *Route53) CreateTrafficPolicyInstance(input *CreateTrafficPolicyInstanceInput) (*CreateTrafficPolicyInstanceOutput, error) {
	req, out := c.CreateTrafficPolicyInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTrafficPolicyVersion = "CreateTrafficPolicyVersion"

// CreateTrafficPolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficPolicyVersion operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTrafficPolicyVersion for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTrafficPolicyVersion method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTrafficPolicyVersionRequest method.
//    req, resp := client.CreateTrafficPolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) CreateTrafficPolicyVersionRequest(input *CreateTrafficPolicyVersionInput) (req *request.Request, output *CreateTrafficPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficPolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicy/{Id}",
	}

	if input == nil {
		input = &CreateTrafficPolicyVersionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTrafficPolicyVersionOutput{}
	req.Data = output
	return
}

// CreateTrafficPolicyVersion API operation for Amazon Route 53.
//
// Creates a new version of an existing traffic policy. When you create a new
// version of a traffic policy, you specify the ID of the traffic policy that
// you want to update and a JSON-formatted document that describes the new version.
// You use traffic policies to create multiple DNS resource record sets for
// one domain name (such as example.com) or one subdomain name (such as www.example.com).
// You can create a maximum of 1000 versions of a traffic policy. If you reach
// the limit and need to create another version, you'll need to start a new
// traffic policy.
//
// Send a POST request to the /2013-04-01/trafficpolicy/ resource. The request
// body includes a document with a CreateTrafficPolicyVersionRequest element.
// The response returns the CreateTrafficPolicyVersionResponse element, which
// contains information about the new version of the traffic policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation CreateTrafficPolicyVersion for usage and error information.
//
// Returned Error Codes:
//   * NoSuchTrafficPolicy
//   No traffic policy exists with the specified ID.
//
//   * InvalidInput
//   The input is not valid.
//
//   * ConcurrentModification
//   Another user submitted a request to update the object at the same time that
//   you did. Retry the request.
//
//   * InvalidTrafficPolicyDocument
//   The format of the traffic policy document that you specified in the Document
//   element is invalid.
//
func (c *Route53) CreateTrafficPolicyVersion(input *CreateTrafficPolicyVersionInput) (*CreateTrafficPolicyVersionOutput, error) {
	req, out := c.CreateTrafficPolicyVersionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteHealthCheck = "DeleteHealthCheck"

// DeleteHealthCheckRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHealthCheck operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteHealthCheck for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteHealthCheck method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteHealthCheckRequest method.
//    req, resp := client.DeleteHealthCheckRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) DeleteHealthCheckRequest(input *DeleteHealthCheckInput) (req *request.Request, output *DeleteHealthCheckOutput) {
	op := &request.Operation{
		Name:       opDeleteHealthCheck,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}",
	}

	if input == nil {
		input = &DeleteHealthCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteHealthCheckOutput{}
	req.Data = output
	return
}

// DeleteHealthCheck API operation for Amazon Route 53.
//
// Deletes a health check. Send a DELETE request to the /2013-04-01/healthcheck/health
// check ID resource.
//
// Amazon Route 53 does not prevent you from deleting a health check even if
// the health check is associated with one or more resource record sets. If
// you delete a health check and you don't update the associated resource record
// sets, the future status of the health check cannot be predicted and may change.
// This will affect the routing of DNS queries for your DNS failover configuration.
// For more information, see Replacing and Deleting Health Checks (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html#health-checks-deleting.html)
// in the Amazon Route 53 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DeleteHealthCheck for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHealthCheck
//   No health check exists with the ID that you specified in the DeleteHealthCheck
//   request.
//
//   * HealthCheckInUse
//   The health check ID for this health check is referenced in the HealthCheckId
//   element in one of the resource record sets in one of the hosted zones that
//   are owned by the current AWS account.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) DeleteHealthCheck(input *DeleteHealthCheckInput) (*DeleteHealthCheckOutput, error) {
	req, out := c.DeleteHealthCheckRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteHostedZone = "DeleteHostedZone"

// DeleteHostedZoneRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHostedZone operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteHostedZone for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteHostedZone method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteHostedZoneRequest method.
//    req, resp := client.DeleteHostedZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) DeleteHostedZoneRequest(input *DeleteHostedZoneInput) (req *request.Request, output *DeleteHostedZoneOutput) {
	op := &request.Operation{
		Name:       opDeleteHostedZone,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}",
	}

	if input == nil {
		input = &DeleteHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteHostedZoneOutput{}
	req.Data = output
	return
}

// DeleteHostedZone API operation for Amazon Route 53.
//
// Deletes a hosted zone. Send a DELETE request to the /Amazon Route 53 API
// version/hostedzone/hosted zone ID resource.
//
// Delete a hosted zone only if there are no resource record sets other than
// the default SOA record and NS resource record sets. If the hosted zone contains
// other resource record sets, delete them before deleting the hosted zone.
// If you try to delete a hosted zone that contains other resource record sets,
// Amazon Route 53 denies your request with a HostedZoneNotEmpty error. For
// information about deleting records from your hosted zone, see ChangeResourceRecordSets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DeleteHostedZone for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
//   * HostedZoneNotEmpty
//   The hosted zone contains resource records that are not SOA or NS records.
//
//   * PriorRequestNotComplete
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Amazon Route 53 returns this error repeatedly
//   for the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
//   * InvalidInput
//   The input is not valid.
//
//   * InvalidDomainName
//   The specified domain name is not valid.
//
func (c *Route53) DeleteHostedZone(input *DeleteHostedZoneInput) (*DeleteHostedZoneOutput, error) {
	req, out := c.DeleteHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteReusableDelegationSet = "DeleteReusableDelegationSet"

// DeleteReusableDelegationSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReusableDelegationSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteReusableDelegationSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteReusableDelegationSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteReusableDelegationSetRequest method.
//    req, resp := client.DeleteReusableDelegationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) DeleteReusableDelegationSetRequest(input *DeleteReusableDelegationSetInput) (req *request.Request, output *DeleteReusableDelegationSetOutput) {
	op := &request.Operation{
		Name:       opDeleteReusableDelegationSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/delegationset/{Id}",
	}

	if input == nil {
		input = &DeleteReusableDelegationSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteReusableDelegationSetOutput{}
	req.Data = output
	return
}

// DeleteReusableDelegationSet API operation for Amazon Route 53.
//
// Deletes a reusable delegation set. Send a DELETE request to the /2013-04-01/delegationset/delegation
// set ID resource.
//
// You can delete a reusable delegation set only if there are no associated
// hosted zones.
//
// To verify that the reusable delegation set is not associated with any hosted
// zones, run the GetReusableDelegationSet action and specify the ID of the
// reusable delegation set that you want to delete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DeleteReusableDelegationSet for usage and error information.
//
// Returned Error Codes:
//   * NoSuchDelegationSet
//   A reusable delegation set with the specified ID does not exist.
//
//   * DelegationSetInUse
//   The specified delegation contains associated hosted zones which must be deleted
//   before the reusable delegation set can be deleted.
//
//   * DelegationSetNotReusable
//   A reusable delegation set with the specified ID does not exist.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) DeleteReusableDelegationSet(input *DeleteReusableDelegationSetInput) (*DeleteReusableDelegationSetOutput, error) {
	req, out := c.DeleteReusableDelegationSetRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTrafficPolicy = "DeleteTrafficPolicy"

// DeleteTrafficPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrafficPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTrafficPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTrafficPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTrafficPolicyRequest method.
//    req, resp := client.DeleteTrafficPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) DeleteTrafficPolicyRequest(input *DeleteTrafficPolicyInput) (req *request.Request, output *DeleteTrafficPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/trafficpolicy/{Id}/{Version}",
	}

	if input == nil {
		input = &DeleteTrafficPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTrafficPolicyOutput{}
	req.Data = output
	return
}

// DeleteTrafficPolicy API operation for Amazon Route 53.
//
// Deletes a traffic policy.
//
// Send a DELETE request to the /Amazon Route 53 API version/trafficpolicy resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DeleteTrafficPolicy for usage and error information.
//
// Returned Error Codes:
//   * NoSuchTrafficPolicy
//   No traffic policy exists with the specified ID.
//
//   * InvalidInput
//   The input is not valid.
//
//   * TrafficPolicyInUse
//   One or more traffic policy instances were created by using the specified
//   traffic policy.
//
//   * ConcurrentModification
//   Another user submitted a request to update the object at the same time that
//   you did. Retry the request.
//
func (c *Route53) DeleteTrafficPolicy(input *DeleteTrafficPolicyInput) (*DeleteTrafficPolicyOutput, error) {
	req, out := c.DeleteTrafficPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTrafficPolicyInstance = "DeleteTrafficPolicyInstance"

// DeleteTrafficPolicyInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrafficPolicyInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTrafficPolicyInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTrafficPolicyInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTrafficPolicyInstanceRequest method.
//    req, resp := client.DeleteTrafficPolicyInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) DeleteTrafficPolicyInstanceRequest(input *DeleteTrafficPolicyInstanceInput) (req *request.Request, output *DeleteTrafficPolicyInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficPolicyInstance,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/trafficpolicyinstance/{Id}",
	}

	if input == nil {
		input = &DeleteTrafficPolicyInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTrafficPolicyInstanceOutput{}
	req.Data = output
	return
}

// DeleteTrafficPolicyInstance API operation for Amazon Route 53.
//
// Deletes a traffic policy instance and all of the resource record sets that
// Amazon Route 53 created when you created the instance.
//
// Send a DELETE request to the /Amazon Route 53 API version/trafficpolicy/traffic
// policy instance ID resource.
//
// In the Amazon Route 53 console, traffic policy instances are known as policy
// records.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DeleteTrafficPolicyInstance for usage and error information.
//
// Returned Error Codes:
//   * NoSuchTrafficPolicyInstance
//   No traffic policy instance exists with the specified ID.
//
//   * InvalidInput
//   The input is not valid.
//
//   * PriorRequestNotComplete
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Amazon Route 53 returns this error repeatedly
//   for the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
func (c *Route53) DeleteTrafficPolicyInstance(input *DeleteTrafficPolicyInstanceInput) (*DeleteTrafficPolicyInstanceOutput, error) {
	req, out := c.DeleteTrafficPolicyInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opDisassociateVPCFromHostedZone = "DisassociateVPCFromHostedZone"

// DisassociateVPCFromHostedZoneRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateVPCFromHostedZone operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisassociateVPCFromHostedZone for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisassociateVPCFromHostedZone method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisassociateVPCFromHostedZoneRequest method.
//    req, resp := client.DisassociateVPCFromHostedZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) DisassociateVPCFromHostedZoneRequest(input *DisassociateVPCFromHostedZoneInput) (req *request.Request, output *DisassociateVPCFromHostedZoneOutput) {
	op := &request.Operation{
		Name:       opDisassociateVPCFromHostedZone,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/disassociatevpc",
	}

	if input == nil {
		input = &DisassociateVPCFromHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisassociateVPCFromHostedZoneOutput{}
	req.Data = output
	return
}

// DisassociateVPCFromHostedZone API operation for Amazon Route 53.
//
// Disassociates a VPC from a Amazon Route 53 private hosted zone.
//
// Send a POST request to the /2013-04-01/hostedzone/hosted zone ID/disassociatevpc
// resource. The request body must include an XML document with a DisassociateVPCFromHostedZoneRequest
// element. The response returns the DisassociateVPCFromHostedZoneResponse element.
//
// You can only disassociate a VPC from a private hosted zone when two or more
// VPCs are associated with that hosted zone. You cannot convert a private hosted
// zone into a public hosted zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation DisassociateVPCFromHostedZone for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
//   * InvalidVPCId
//   The hosted zone you are trying to create for your VPC_ID does not belong
//   to you. Amazon Route 53 returns this error when the VPC specified by VPCId
//   does not belong to you.
//
//   * VPCAssociationNotFound
//   The specified VPC and hosted zone are not currently associated.
//
//   * LastVPCAssociation
//   Only one VPC is currently associated with the hosted zone. You cannot convert
//   a private hosted zone into a public hosted zone by disassociating the last
//   VPC from a hosted zone.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) DisassociateVPCFromHostedZone(input *DisassociateVPCFromHostedZoneInput) (*DisassociateVPCFromHostedZoneOutput, error) {
	req, out := c.DisassociateVPCFromHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opGetChange = "GetChange"

// GetChangeRequest generates a "aws/request.Request" representing the
// client's request for the GetChange operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetChange for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetChange method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetChangeRequest method.
//    req, resp := client.GetChangeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) GetChangeRequest(input *GetChangeInput) (req *request.Request, output *GetChangeOutput) {
	op := &request.Operation{
		Name:       opGetChange,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/change/{Id}",
	}

	if input == nil {
		input = &GetChangeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetChangeOutput{}
	req.Data = output
	return
}

// GetChange API operation for Amazon Route 53.
//
// Returns the current status of a change batch request. The status is one of
// the following values:
//
//    * PENDING indicates that the changes in this request have not replicated
//    to all Amazon Route 53 DNS servers. This is the initial status of all
//    change batch requests.
//
//    * INSYNC indicates that the changes have replicated to all Amazon Route
//    53 DNS servers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetChange for usage and error information.
//
// Returned Error Codes:
//   * NoSuchChange
//   A change with the specified change ID does not exist.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) GetChange(input *GetChangeInput) (*GetChangeOutput, error) {
	req, out := c.GetChangeRequest(input)
	err := req.Send()
	return out, err
}

const opGetChangeDetails = "GetChangeDetails"

// GetChangeDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetChangeDetails operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetChangeDetails for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetChangeDetails method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetChangeDetailsRequest method.
//    req, resp := client.GetChangeDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) GetChangeDetailsRequest(input *GetChangeDetailsInput) (req *request.Request, output *GetChangeDetailsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetChangeDetails, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetChangeDetails,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/changedetails/{Id}",
	}

	if input == nil {
		input = &GetChangeDetailsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetChangeDetailsOutput{}
	req.Data = output
	return
}

// GetChangeDetails API operation for Amazon Route 53.
//
// Returns the status and changes of a change batch request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetChangeDetails for usage and error information.
//
// Returned Error Codes:
//   * NoSuchChange
//   A change with the specified change ID does not exist.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) GetChangeDetails(input *GetChangeDetailsInput) (*GetChangeDetailsOutput, error) {
	req, out := c.GetChangeDetailsRequest(input)
	err := req.Send()
	return out, err
}

const opGetCheckerIpRanges = "GetCheckerIpRanges"

// GetCheckerIpRangesRequest generates a "aws/request.Request" representing the
// client's request for the GetCheckerIpRanges operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetCheckerIpRanges for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetCheckerIpRanges method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetCheckerIpRangesRequest method.
//    req, resp := client.GetCheckerIpRangesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) GetCheckerIpRangesRequest(input *GetCheckerIpRangesInput) (req *request.Request, output *GetCheckerIpRangesOutput) {
	op := &request.Operation{
		Name:       opGetCheckerIpRanges,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/checkeripranges",
	}

	if input == nil {
		input = &GetCheckerIpRangesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetCheckerIpRangesOutput{}
	req.Data = output
	return
}

// GetCheckerIpRanges API operation for Amazon Route 53.
//
// Retrieves a list of the IP ranges used by Amazon Route 53 health checkers
// to check the health of your resources. Send a GET request to the /Amazon
// Route 53 API version/checkeripranges resource. Use these IP addresses to
// configure router and firewall rules to allow health checkers to check the
// health of your resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetCheckerIpRanges for usage and error information.
func (c *Route53) GetCheckerIpRanges(input *GetCheckerIpRangesInput) (*GetCheckerIpRangesOutput, error) {
	req, out := c.GetCheckerIpRangesRequest(input)
	err := req.Send()
	return out, err
}

const opGetGeoLocation = "GetGeoLocation"

// GetGeoLocationRequest generates a "aws/request.Request" representing the
// client's request for the GetGeoLocation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetGeoLocation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetGeoLocation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetGeoLocationRequest method.
//    req, resp := client.GetGeoLocationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) GetGeoLocationRequest(input *GetGeoLocationInput) (req *request.Request, output *GetGeoLocationOutput) {
	op := &request.Operation{
		Name:       opGetGeoLocation,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/geolocation",
	}

	if input == nil {
		input = &GetGeoLocationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetGeoLocationOutput{}
	req.Data = output
	return
}

// GetGeoLocation API operation for Amazon Route 53.
//
// Retrieves a single geo location. Send a GET request to the /2013-04-01/geolocation
// resource with one of these options: continentcode | countrycode | countrycode
// and subdivisioncode.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetGeoLocation for usage and error information.
//
// Returned Error Codes:
//   * NoSuchGeoLocation
//   Amazon Route 53 doesn't support the specified geolocation.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) GetGeoLocation(input *GetGeoLocationInput) (*GetGeoLocationOutput, error) {
	req, out := c.GetGeoLocationRequest(input)
	err := req.Send()
	return out, err
}

const opGetHealthCheck = "GetHealthCheck"

// GetHealthCheckRequest generates a "aws/request.Request" representing the
// client's request for the GetHealthCheck operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetHealthCheck for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetHealthCheck method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetHealthCheckRequest method.
//    req, resp := client.GetHealthCheckRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) GetHealthCheckRequest(input *GetHealthCheckInput) (req *request.Request, output *GetHealthCheckOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheck,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}",
	}

	if input == nil {
		input = &GetHealthCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHealthCheckOutput{}
	req.Data = output
	return
}

// GetHealthCheck API operation for Amazon Route 53.
//
// Gets information about a specified health check. Send a GET request to the
// /2013-04-01/healthcheck/health check ID resource. For more information about
// using the console to perform this operation, see Amazon Route 53 Health Checks
// and DNS Failover (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html)
// in the Amazon Route 53 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetHealthCheck for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHealthCheck
//   No health check exists with the ID that you specified in the DeleteHealthCheck
//   request.
//
//   * InvalidInput
//   The input is not valid.
//
//   * IncompatibleVersion
//   The resource you are trying to access is unsupported on this Amazon Route
//   53 endpoint. Please consider using a newer endpoint or a tool that does so.
//
func (c *Route53) GetHealthCheck(input *GetHealthCheckInput) (*GetHealthCheckOutput, error) {
	req, out := c.GetHealthCheckRequest(input)
	err := req.Send()
	return out, err
}

const opGetHealthCheckCount = "GetHealthCheckCount"

// GetHealthCheckCountRequest generates a "aws/request.Request" representing the
// client's request for the GetHealthCheckCount operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetHealthCheckCount for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetHealthCheckCount method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetHealthCheckCountRequest method.
//    req, resp := client.GetHealthCheckCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) GetHealthCheckCountRequest(input *GetHealthCheckCountInput) (req *request.Request, output *GetHealthCheckCountOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheckCount,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheckcount",
	}

	if input == nil {
		input = &GetHealthCheckCountInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHealthCheckCountOutput{}
	req.Data = output
	return
}

// GetHealthCheckCount API operation for Amazon Route 53.
//
// To retrieve a count of all your health checks, send a GET request to the
// /2013-04-01/healthcheckcount resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetHealthCheckCount for usage and error information.
func (c *Route53) GetHealthCheckCount(input *GetHealthCheckCountInput) (*GetHealthCheckCountOutput, error) {
	req, out := c.GetHealthCheckCountRequest(input)
	err := req.Send()
	return out, err
}

const opGetHealthCheckLastFailureReason = "GetHealthCheckLastFailureReason"

// GetHealthCheckLastFailureReasonRequest generates a "aws/request.Request" representing the
// client's request for the GetHealthCheckLastFailureReason operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetHealthCheckLastFailureReason for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetHealthCheckLastFailureReason method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetHealthCheckLastFailureReasonRequest method.
//    req, resp := client.GetHealthCheckLastFailureReasonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) GetHealthCheckLastFailureReasonRequest(input *GetHealthCheckLastFailureReasonInput) (req *request.Request, output *GetHealthCheckLastFailureReasonOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheckLastFailureReason,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}/lastfailurereason",
	}

	if input == nil {
		input = &GetHealthCheckLastFailureReasonInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHealthCheckLastFailureReasonOutput{}
	req.Data = output
	return
}

// GetHealthCheckLastFailureReason API operation for Amazon Route 53.
//
// If you want to learn why a health check is currently failing or why it failed
// most recently (if at all), you can get the failure reason for the most recent
// failure. Send a GET request to the /Amazon Route 53 API version/healthcheck/health
// check ID/lastfailurereason resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetHealthCheckLastFailureReason for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHealthCheck
//   No health check exists with the ID that you specified in the DeleteHealthCheck
//   request.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) GetHealthCheckLastFailureReason(input *GetHealthCheckLastFailureReasonInput) (*GetHealthCheckLastFailureReasonOutput, error) {
	req, out := c.GetHealthCheckLastFailureReasonRequest(input)
	err := req.Send()
	return out, err
}

const opGetHealthCheckStatus = "GetHealthCheckStatus"

// GetHealthCheckStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetHealthCheckStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetHealthCheckStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetHealthCheckStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetHealthCheckStatusRequest method.
//    req, resp := client.GetHealthCheckStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) GetHealthCheckStatusRequest(input *GetHealthCheckStatusInput) (req *request.Request, output *GetHealthCheckStatusOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheckStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}/status",
	}

	if input == nil {
		input = &GetHealthCheckStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHealthCheckStatusOutput{}
	req.Data = output
	return
}

// GetHealthCheckStatus API operation for Amazon Route 53.
//
// Gets status of a specified health check. Send a GET request to the /2013-04-01/healthcheck/health
// check ID/status resource. You can use this call to get a health check's current
// status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetHealthCheckStatus for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHealthCheck
//   No health check exists with the ID that you specified in the DeleteHealthCheck
//   request.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) GetHealthCheckStatus(input *GetHealthCheckStatusInput) (*GetHealthCheckStatusOutput, error) {
	req, out := c.GetHealthCheckStatusRequest(input)
	err := req.Send()
	return out, err
}

const opGetHostedZone = "GetHostedZone"

// GetHostedZoneRequest generates a "aws/request.Request" representing the
// client's request for the GetHostedZone operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetHostedZone for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetHostedZone method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetHostedZoneRequest method.
//    req, resp := client.GetHostedZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) GetHostedZoneRequest(input *GetHostedZoneInput) (req *request.Request, output *GetHostedZoneOutput) {
	op := &request.Operation{
		Name:       opGetHostedZone,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}",
	}

	if input == nil {
		input = &GetHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHostedZoneOutput{}
	req.Data = output
	return
}

// GetHostedZone API operation for Amazon Route 53.
//
// Retrieves the delegation set for a hosted zone, including the four name servers
// assigned to the hosted zone. Send a GET request to the /Amazon Route 53 API
// version/hostedzone/hosted zone ID resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetHostedZone for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) GetHostedZone(input *GetHostedZoneInput) (*GetHostedZoneOutput, error) {
	req, out := c.GetHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opGetHostedZoneCount = "GetHostedZoneCount"

// GetHostedZoneCountRequest generates a "aws/request.Request" representing the
// client's request for the GetHostedZoneCount operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetHostedZoneCount for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetHostedZoneCount method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetHostedZoneCountRequest method.
//    req, resp := client.GetHostedZoneCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) GetHostedZoneCountRequest(input *GetHostedZoneCountInput) (req *request.Request, output *GetHostedZoneCountOutput) {
	op := &request.Operation{
		Name:       opGetHostedZoneCount,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzonecount",
	}

	if input == nil {
		input = &GetHostedZoneCountInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHostedZoneCountOutput{}
	req.Data = output
	return
}

// GetHostedZoneCount API operation for Amazon Route 53.
//
// Retrieves a count of all your hosted zones. Send a GET request to the /2013-04-01/hostedzonecount
// resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetHostedZoneCount for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) GetHostedZoneCount(input *GetHostedZoneCountInput) (*GetHostedZoneCountOutput, error) {
	req, out := c.GetHostedZoneCountRequest(input)
	err := req.Send()
	return out, err
}

const opGetReusableDelegationSet = "GetReusableDelegationSet"

// GetReusableDelegationSetRequest generates a "aws/request.Request" representing the
// client's request for the GetReusableDelegationSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetReusableDelegationSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetReusableDelegationSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetReusableDelegationSetRequest method.
//    req, resp := client.GetReusableDelegationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) GetReusableDelegationSetRequest(input *GetReusableDelegationSetInput) (req *request.Request, output *GetReusableDelegationSetOutput) {
	op := &request.Operation{
		Name:       opGetReusableDelegationSet,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/delegationset/{Id}",
	}

	if input == nil {
		input = &GetReusableDelegationSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetReusableDelegationSetOutput{}
	req.Data = output
	return
}

// GetReusableDelegationSet API operation for Amazon Route 53.
//
// Retrieves the reusable delegation set. Send a GET request to the /2013-04-01/delegationset/delegation
// set ID resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetReusableDelegationSet for usage and error information.
//
// Returned Error Codes:
//   * NoSuchDelegationSet
//   A reusable delegation set with the specified ID does not exist.
//
//   * DelegationSetNotReusable
//   A reusable delegation set with the specified ID does not exist.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) GetReusableDelegationSet(input *GetReusableDelegationSetInput) (*GetReusableDelegationSetOutput, error) {
	req, out := c.GetReusableDelegationSetRequest(input)
	err := req.Send()
	return out, err
}

const opGetTrafficPolicy = "GetTrafficPolicy"

// GetTrafficPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetTrafficPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetTrafficPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetTrafficPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetTrafficPolicyRequest method.
//    req, resp := client.GetTrafficPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) GetTrafficPolicyRequest(input *GetTrafficPolicyInput) (req *request.Request, output *GetTrafficPolicyOutput) {
	op := &request.Operation{
		Name:       opGetTrafficPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicy/{Id}/{Version}",
	}

	if input == nil {
		input = &GetTrafficPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetTrafficPolicyOutput{}
	req.Data = output
	return
}

// GetTrafficPolicy API operation for Amazon Route 53.
//
// Gets information about a specific traffic policy version.
//
// Send a GET request to the /Amazon Route 53 API version/trafficpolicy resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetTrafficPolicy for usage and error information.
//
// Returned Error Codes:
//   * NoSuchTrafficPolicy
//   No traffic policy exists with the specified ID.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) GetTrafficPolicy(input *GetTrafficPolicyInput) (*GetTrafficPolicyOutput, error) {
	req, out := c.GetTrafficPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetTrafficPolicyInstance = "GetTrafficPolicyInstance"

// GetTrafficPolicyInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetTrafficPolicyInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetTrafficPolicyInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetTrafficPolicyInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetTrafficPolicyInstanceRequest method.
//    req, resp := client.GetTrafficPolicyInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) GetTrafficPolicyInstanceRequest(input *GetTrafficPolicyInstanceInput) (req *request.Request, output *GetTrafficPolicyInstanceOutput) {
	op := &request.Operation{
		Name:       opGetTrafficPolicyInstance,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstance/{Id}",
	}

	if input == nil {
		input = &GetTrafficPolicyInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetTrafficPolicyInstanceOutput{}
	req.Data = output
	return
}

// GetTrafficPolicyInstance API operation for Amazon Route 53.
//
// Gets information about a specified traffic policy instance.
//
// Send a GET request to the /Amazon Route 53 API version/trafficpolicyinstance
// resource.
//
// After you submit a CreateTrafficPolicyInstance or an UpdateTrafficPolicyInstance
// request, there's a brief delay while Amazon Route 53 creates the resource
// record sets that are specified in the traffic policy definition. For more
// information, see the State response element.
//
// In the Amazon Route 53 console, traffic policy instances are known as policy
// records.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetTrafficPolicyInstance for usage and error information.
//
// Returned Error Codes:
//   * NoSuchTrafficPolicyInstance
//   No traffic policy instance exists with the specified ID.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) GetTrafficPolicyInstance(input *GetTrafficPolicyInstanceInput) (*GetTrafficPolicyInstanceOutput, error) {
	req, out := c.GetTrafficPolicyInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opGetTrafficPolicyInstanceCount = "GetTrafficPolicyInstanceCount"

// GetTrafficPolicyInstanceCountRequest generates a "aws/request.Request" representing the
// client's request for the GetTrafficPolicyInstanceCount operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetTrafficPolicyInstanceCount for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetTrafficPolicyInstanceCount method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetTrafficPolicyInstanceCountRequest method.
//    req, resp := client.GetTrafficPolicyInstanceCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) GetTrafficPolicyInstanceCountRequest(input *GetTrafficPolicyInstanceCountInput) (req *request.Request, output *GetTrafficPolicyInstanceCountOutput) {
	op := &request.Operation{
		Name:       opGetTrafficPolicyInstanceCount,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstancecount",
	}

	if input == nil {
		input = &GetTrafficPolicyInstanceCountInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetTrafficPolicyInstanceCountOutput{}
	req.Data = output
	return
}

// GetTrafficPolicyInstanceCount API operation for Amazon Route 53.
//
// Gets the number of traffic policy instances that are associated with the
// current AWS account.
//
// To get the number of traffic policy instances, send a GET request to the
// /2013-04-01/trafficpolicyinstancecount resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation GetTrafficPolicyInstanceCount for usage and error information.
func (c *Route53) GetTrafficPolicyInstanceCount(input *GetTrafficPolicyInstanceCountInput) (*GetTrafficPolicyInstanceCountOutput, error) {
	req, out := c.GetTrafficPolicyInstanceCountRequest(input)
	err := req.Send()
	return out, err
}

const opListChangeBatchesByHostedZone = "ListChangeBatchesByHostedZone"

// ListChangeBatchesByHostedZoneRequest generates a "aws/request.Request" representing the
// client's request for the ListChangeBatchesByHostedZone operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListChangeBatchesByHostedZone for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListChangeBatchesByHostedZone method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListChangeBatchesByHostedZoneRequest method.
//    req, resp := client.ListChangeBatchesByHostedZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListChangeBatchesByHostedZoneRequest(input *ListChangeBatchesByHostedZoneInput) (req *request.Request, output *ListChangeBatchesByHostedZoneOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListChangeBatchesByHostedZone, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListChangeBatchesByHostedZone,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/changes",
	}

	if input == nil {
		input = &ListChangeBatchesByHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListChangeBatchesByHostedZoneOutput{}
	req.Data = output
	return
}

// ListChangeBatchesByHostedZone API operation for Amazon Route 53.
//
// Gets the list of ChangeBatches in a given time period for a given hosted
// zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListChangeBatchesByHostedZone for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) ListChangeBatchesByHostedZone(input *ListChangeBatchesByHostedZoneInput) (*ListChangeBatchesByHostedZoneOutput, error) {
	req, out := c.ListChangeBatchesByHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opListChangeBatchesByRRSet = "ListChangeBatchesByRRSet"

// ListChangeBatchesByRRSetRequest generates a "aws/request.Request" representing the
// client's request for the ListChangeBatchesByRRSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListChangeBatchesByRRSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListChangeBatchesByRRSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListChangeBatchesByRRSetRequest method.
//    req, resp := client.ListChangeBatchesByRRSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListChangeBatchesByRRSetRequest(input *ListChangeBatchesByRRSetInput) (req *request.Request, output *ListChangeBatchesByRRSetOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListChangeBatchesByRRSet, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListChangeBatchesByRRSet,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/rrsChanges",
	}

	if input == nil {
		input = &ListChangeBatchesByRRSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListChangeBatchesByRRSetOutput{}
	req.Data = output
	return
}

// ListChangeBatchesByRRSet API operation for Amazon Route 53.
//
// Gets the list of ChangeBatches in a given time period for a given hosted
// zone and RRSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListChangeBatchesByRRSet for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) ListChangeBatchesByRRSet(input *ListChangeBatchesByRRSetInput) (*ListChangeBatchesByRRSetOutput, error) {
	req, out := c.ListChangeBatchesByRRSetRequest(input)
	err := req.Send()
	return out, err
}

const opListGeoLocations = "ListGeoLocations"

// ListGeoLocationsRequest generates a "aws/request.Request" representing the
// client's request for the ListGeoLocations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListGeoLocations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListGeoLocations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListGeoLocationsRequest method.
//    req, resp := client.ListGeoLocationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListGeoLocationsRequest(input *ListGeoLocationsInput) (req *request.Request, output *ListGeoLocationsOutput) {
	op := &request.Operation{
		Name:       opListGeoLocations,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/geolocations",
	}

	if input == nil {
		input = &ListGeoLocationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListGeoLocationsOutput{}
	req.Data = output
	return
}

// ListGeoLocations API operation for Amazon Route 53.
//
// Retrieves a list of supported geo locations. Send a GET request to the /2013-04-01/geolocations
// resource. The response to this request includes a GeoLocationDetailsList
// element for each location that Amazon Route 53 supports.
//
// Countries are listed first, and continents are listed last. If Amazon Route
// 53 supports subdivisions for a country (for example, states or provinces),
// the subdivisions for that country are listed in alphabetical order immediately
// after the corresponding country.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListGeoLocations for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) ListGeoLocations(input *ListGeoLocationsInput) (*ListGeoLocationsOutput, error) {
	req, out := c.ListGeoLocationsRequest(input)
	err := req.Send()
	return out, err
}

const opListHealthChecks = "ListHealthChecks"

// ListHealthChecksRequest generates a "aws/request.Request" representing the
// client's request for the ListHealthChecks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListHealthChecks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListHealthChecks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListHealthChecksRequest method.
//    req, resp := client.ListHealthChecksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListHealthChecksRequest(input *ListHealthChecksInput) (req *request.Request, output *ListHealthChecksOutput) {
	op := &request.Operation{
		Name:       opListHealthChecks,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListHealthChecksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListHealthChecksOutput{}
	req.Data = output
	return
}

// ListHealthChecks API operation for Amazon Route 53.
//
// Retrieve a list of your health checks. Send a GET request to the /2013-04-01/healthcheck
// resource. The response to this request includes a HealthChecks element with
// zero or more HealthCheck child elements. By default, the list of health checks
// is displayed on a single page. You can control the length of the page that
// is displayed by using the MaxItems parameter. You can use the Marker parameter
// to control the health check that the list begins with.
//
// For information about listing health checks using the Amazon Route 53 console,
// see Amazon Route 53 Health Checks and DNS Failover (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListHealthChecks for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
//   * IncompatibleVersion
//   The resource you are trying to access is unsupported on this Amazon Route
//   53 endpoint. Please consider using a newer endpoint or a tool that does so.
//
func (c *Route53) ListHealthChecks(input *ListHealthChecksInput) (*ListHealthChecksOutput, error) {
	req, out := c.ListHealthChecksRequest(input)
	err := req.Send()
	return out, err
}

// ListHealthChecksPages iterates over the pages of a ListHealthChecks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHealthChecks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHealthChecks operation.
//    pageNum := 0
//    err := client.ListHealthChecksPages(params,
//        func(page *ListHealthChecksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53) ListHealthChecksPages(input *ListHealthChecksInput, fn func(p *ListHealthChecksOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListHealthChecksRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListHealthChecksOutput), lastPage)
	})
}

const opListHostedZones = "ListHostedZones"

// ListHostedZonesRequest generates a "aws/request.Request" representing the
// client's request for the ListHostedZones operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListHostedZones for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListHostedZones method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListHostedZonesRequest method.
//    req, resp := client.ListHostedZonesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListHostedZonesRequest(input *ListHostedZonesInput) (req *request.Request, output *ListHostedZonesOutput) {
	op := &request.Operation{
		Name:       opListHostedZones,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListHostedZonesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListHostedZonesOutput{}
	req.Data = output
	return
}

// ListHostedZones API operation for Amazon Route 53.
//
// To retrieve a list of your public and private hosted zones, send a GET request
// to the /2013-04-01/hostedzone resource. The response to this request includes
// a HostedZones child element for each hosted zone created by the current AWS
// account.
//
// Amazon Route 53 returns a maximum of 100 items in each response. If you have
// a lot of hosted zones, you can use the maxitems parameter to list them in
// groups of up to 100. The response includes four values that help navigate
// from one group of maxitems hosted zones to the next:
//
//    * MaxItems is the value specified for the maxitems parameter in the request
//    that produced the current response.
//
//    * If the value of IsTruncated in the response is true, there are more
//    hosted zones associated with the current AWS account.
//
//    * NextMarker is the hosted zone ID of the next hosted zone that is associated
//    with the current AWS account. If you want to list more hosted zones, make
//    another call to ListHostedZones, and specify the value of the NextMarker
//    element in the marker parameter.
//
// If IsTruncated is false, the NextMarker element is omitted from the response.
//
//    * If you're making the second or subsequent call to ListHostedZones, the
//    Marker element matches the value that you specified in the marker parameter
//    in the previous request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListHostedZones for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
//   * NoSuchDelegationSet
//   A reusable delegation set with the specified ID does not exist.
//
//   * DelegationSetNotReusable
//   A reusable delegation set with the specified ID does not exist.
//
func (c *Route53) ListHostedZones(input *ListHostedZonesInput) (*ListHostedZonesOutput, error) {
	req, out := c.ListHostedZonesRequest(input)
	err := req.Send()
	return out, err
}

// ListHostedZonesPages iterates over the pages of a ListHostedZones operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHostedZones method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHostedZones operation.
//    pageNum := 0
//    err := client.ListHostedZonesPages(params,
//        func(page *ListHostedZonesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53) ListHostedZonesPages(input *ListHostedZonesInput, fn func(p *ListHostedZonesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListHostedZonesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListHostedZonesOutput), lastPage)
	})
}

const opListHostedZonesByName = "ListHostedZonesByName"

// ListHostedZonesByNameRequest generates a "aws/request.Request" representing the
// client's request for the ListHostedZonesByName operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListHostedZonesByName for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListHostedZonesByName method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListHostedZonesByNameRequest method.
//    req, resp := client.ListHostedZonesByNameRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListHostedZonesByNameRequest(input *ListHostedZonesByNameInput) (req *request.Request, output *ListHostedZonesByNameOutput) {
	op := &request.Operation{
		Name:       opListHostedZonesByName,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzonesbyname",
	}

	if input == nil {
		input = &ListHostedZonesByNameInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListHostedZonesByNameOutput{}
	req.Data = output
	return
}

// ListHostedZonesByName API operation for Amazon Route 53.
//
// Retrieves a list of your hosted zones in lexicographic order. Send a GET
// request to the /2013-04-01/hostedzonesbyname resource. The response includes
// a HostedZones child element for each hosted zone created by the current AWS
// account.
//
// ListHostedZonesByName sorts hosted zones by name with the labels reversed.
// For example:
//
//    * com.example.www.
//
// Note the trailing dot, which can change the sort order in some circumstances.
//
// If the domain name includes escape characters or Punycode, ListHostedZonesByName
// alphabetizes the domain name using the escaped or Punycoded value, which
// is the format that Amazon Route 53 saves in its database. For example, to
// create a hosted zone for example.com, specify ex\344mple.com for the domain
// name. ListHostedZonesByName alphabetizes it as:
//
//    * com.ex\344mple.
//
// The labels are reversed and alphabetized using the escaped value. For more
// information about valid domain name formats, including internationalized
// domain names, see DNS Domain Name Format (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html)
// in the Amazon Route 53 Developer Guide.
//
// Amazon Route 53 returns up to 100 items in each response. If you have a lot
// of hosted zones, use the MaxItems parameter to list them in groups of up
// to 100. The response includes values that help navigate from one group of
// MaxItems hosted zones to the next:
//
//    * The DNSName and HostedZoneId elements in the response contain the values,
//    if any, specified for the dnsname and hostedzoneid parameters in the request
//    that produced the current response.
//
//    * The MaxItems element in the response contains the value, if any, that
//    you specified for the maxitems parameter in the request that produced
//    the current response.
//
//    * If the value of IsTruncated in the response is true, there are more
//    hosted zones associated with the current AWS account.
//
// If IsTruncated is false, this response includes the last hosted zone that
//    is associated with the current account. The NextDNSName element and NextHostedZoneId
//    elements are omitted from the response.
//
//    * The NextDNSName and NextHostedZoneId elements in the response contain
//    the domain name and the hosted zone ID of the next hosted zone that is
//    associated with the current AWS account. If you want to list more hosted
//    zones, make another call to ListHostedZonesByName, and specify the value
//    of NextDNSName and NextHostedZoneId in the dnsname and hostedzoneid parameters,
//    respectively.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListHostedZonesByName for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
//   * InvalidDomainName
//   The specified domain name is not valid.
//
func (c *Route53) ListHostedZonesByName(input *ListHostedZonesByNameInput) (*ListHostedZonesByNameOutput, error) {
	req, out := c.ListHostedZonesByNameRequest(input)
	err := req.Send()
	return out, err
}

const opListResourceRecordSets = "ListResourceRecordSets"

// ListResourceRecordSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceRecordSets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListResourceRecordSets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListResourceRecordSets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListResourceRecordSetsRequest method.
//    req, resp := client.ListResourceRecordSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListResourceRecordSetsRequest(input *ListResourceRecordSetsInput) (req *request.Request, output *ListResourceRecordSetsOutput) {
	op := &request.Operation{
		Name:       opListResourceRecordSets,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/rrset",
		Paginator: &request.Paginator{
			InputTokens:     []string{"StartRecordName", "StartRecordType", "StartRecordIdentifier"},
			OutputTokens:    []string{"NextRecordName", "NextRecordType", "NextRecordIdentifier"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListResourceRecordSetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListResourceRecordSetsOutput{}
	req.Data = output
	return
}

// ListResourceRecordSets API operation for Amazon Route 53.
//
// Lists the resource record sets in a specified hosted zone.
//
// ListResourceRecordSets returns up to 100 resource record sets at a time in
// ASCII order, beginning at a position specified by the name and type elements.
// The action sorts results first by DNS name with the labels reversed, for
// example:
//
// com.example.www.
//
// Note the trailing dot, which can change the sort order in some circumstances.
//
// When multiple records have the same DNS name, the action sorts results by
// the record type.
//
// You can use the name and type elements to adjust the beginning position of
// the list of resource record sets returned:
//
// If you do not specify Name or TypeThe results begin with the first resource
// record set that the hosted zone contains.
//
// If you specify Name but not TypeThe results begin with the first resource
// record set in the list whose name is greater than or equal to Name.
//
// If you specify Type but not NameAmazon Route 53 returns the InvalidInput
// error.
//
// If you specify both Name and TypeThe results begin with the first resource
// record set in the list whose name is greater than or equal to Name, and whose
// type is greater than or equal to Type.
//
// This action returns the most current version of the records. This includes
// records that are PENDING, and that are not yet available on all Amazon Route
// 53 DNS servers.
//
// To ensure that you get an accurate listing of the resource record sets for
// a hosted zone at a point in time, do not submit a ChangeResourceRecordSets
// request while you're paging through the results of a ListResourceRecordSets
// request. If you do, some pages may display results without the latest changes
// while other pages display results with the latest changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListResourceRecordSets for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) ListResourceRecordSets(input *ListResourceRecordSetsInput) (*ListResourceRecordSetsOutput, error) {
	req, out := c.ListResourceRecordSetsRequest(input)
	err := req.Send()
	return out, err
}

// ListResourceRecordSetsPages iterates over the pages of a ListResourceRecordSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourceRecordSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResourceRecordSets operation.
//    pageNum := 0
//    err := client.ListResourceRecordSetsPages(params,
//        func(page *ListResourceRecordSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53) ListResourceRecordSetsPages(input *ListResourceRecordSetsInput, fn func(p *ListResourceRecordSetsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListResourceRecordSetsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListResourceRecordSetsOutput), lastPage)
	})
}

const opListReusableDelegationSets = "ListReusableDelegationSets"

// ListReusableDelegationSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListReusableDelegationSets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListReusableDelegationSets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListReusableDelegationSets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListReusableDelegationSetsRequest method.
//    req, resp := client.ListReusableDelegationSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListReusableDelegationSetsRequest(input *ListReusableDelegationSetsInput) (req *request.Request, output *ListReusableDelegationSetsOutput) {
	op := &request.Operation{
		Name:       opListReusableDelegationSets,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/delegationset",
	}

	if input == nil {
		input = &ListReusableDelegationSetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListReusableDelegationSetsOutput{}
	req.Data = output
	return
}

// ListReusableDelegationSets API operation for Amazon Route 53.
//
// To retrieve a list of your reusable delegation sets, send a GET request to
// the /2013-04-01/delegationset resource. The response to this request includes
// a DelegationSets element with zero, one, or multiple DelegationSet child
// elements. By default, the list of delegation sets is displayed on a single
// page. You can control the length of the page that is displayed by using the
// MaxItems parameter. You can use the Marker parameter to control the delegation
// set that the list begins with.
//
// Amazon Route 53 returns a maximum of 100 items. If you set MaxItems to a
// value greater than 100, Amazon Route 53 returns only the first 100.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListReusableDelegationSets for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) ListReusableDelegationSets(input *ListReusableDelegationSetsInput) (*ListReusableDelegationSetsOutput, error) {
	req, out := c.ListReusableDelegationSetsRequest(input)
	err := req.Send()
	return out, err
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTagsForResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTagsForResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/tags/{ResourceType}/{ResourceId}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForResourceOutput{}
	req.Data = output
	return
}

// ListTagsForResource API operation for Amazon Route 53.
//
// Lists tags for one health check or hosted zone.
//
// For information about using tags for cost allocation, see Using Cost Allocation
// Tags (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
// in the AWS Billing and Cost Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
//   * NoSuchHealthCheck
//   No health check exists with the ID that you specified in the DeleteHealthCheck
//   request.
//
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
//   * PriorRequestNotComplete
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Amazon Route 53 returns this error repeatedly
//   for the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
//   * ThrottlingException

//
func (c *Route53) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opListTagsForResources = "ListTagsForResources"

// ListTagsForResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResources operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTagsForResources for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTagsForResources method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTagsForResourcesRequest method.
//    req, resp := client.ListTagsForResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListTagsForResourcesRequest(input *ListTagsForResourcesInput) (req *request.Request, output *ListTagsForResourcesOutput) {
	op := &request.Operation{
		Name:       opListTagsForResources,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/tags/{ResourceType}",
	}

	if input == nil {
		input = &ListTagsForResourcesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForResourcesOutput{}
	req.Data = output
	return
}

// ListTagsForResources API operation for Amazon Route 53.
//
// Lists tags for up to 10 health checks or hosted zones.
//
// For information about using tags for cost allocation, see Using Cost Allocation
// Tags (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
// in the AWS Billing and Cost Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListTagsForResources for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
//   * NoSuchHealthCheck
//   No health check exists with the ID that you specified in the DeleteHealthCheck
//   request.
//
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
//   * PriorRequestNotComplete
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Amazon Route 53 returns this error repeatedly
//   for the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
//   * ThrottlingException

//
func (c *Route53) ListTagsForResources(input *ListTagsForResourcesInput) (*ListTagsForResourcesOutput, error) {
	req, out := c.ListTagsForResourcesRequest(input)
	err := req.Send()
	return out, err
}

const opListTrafficPolicies = "ListTrafficPolicies"

// ListTrafficPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListTrafficPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTrafficPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTrafficPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTrafficPoliciesRequest method.
//    req, resp := client.ListTrafficPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListTrafficPoliciesRequest(input *ListTrafficPoliciesInput) (req *request.Request, output *ListTrafficPoliciesOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicies",
	}

	if input == nil {
		input = &ListTrafficPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTrafficPoliciesOutput{}
	req.Data = output
	return
}

// ListTrafficPolicies API operation for Amazon Route 53.
//
// Gets information about the latest version for every traffic policy that is
// associated with the current AWS account. Send a GET request to the /Amazon
// Route 53 API version/trafficpolicy resource.
//
// Amazon Route 53 returns a maximum of 100 items in each response. If you have
// a lot of traffic policies, you can use the maxitems parameter to list them
// in groups of up to 100.
//
// The response includes three values that help you navigate from one group
// of maxitems traffic policies to the next:
//
//    * IsTruncated
//
// If the value of IsTruncated in the response is true, there are more traffic
//    policies associated with the current AWS account.
//
// If IsTruncated is false, this response includes the last traffic policy that
//    is associated with the current account.
//
//    * TrafficPolicyIdMarker
//
// If IsTruncated is true, TrafficPolicyIdMarker is the ID of the first traffic
//    policy in the next group of MaxItems traffic policies. If you want to
//    list more traffic policies, make another call to ListTrafficPolicies,
//    and specify the value of the TrafficPolicyIdMarker element from the response
//    in the TrafficPolicyIdMarker request parameter.
//
// If IsTruncated is false, the TrafficPolicyIdMarker element is omitted from
//    the response.
//
//    * MaxItems
//
// The value that you specified for the MaxItems parameter in the request that
//    produced the current response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListTrafficPolicies for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) ListTrafficPolicies(input *ListTrafficPoliciesInput) (*ListTrafficPoliciesOutput, error) {
	req, out := c.ListTrafficPoliciesRequest(input)
	err := req.Send()
	return out, err
}

const opListTrafficPolicyInstances = "ListTrafficPolicyInstances"

// ListTrafficPolicyInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListTrafficPolicyInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTrafficPolicyInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTrafficPolicyInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTrafficPolicyInstancesRequest method.
//    req, resp := client.ListTrafficPolicyInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListTrafficPolicyInstancesRequest(input *ListTrafficPolicyInstancesInput) (req *request.Request, output *ListTrafficPolicyInstancesOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicyInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstances",
	}

	if input == nil {
		input = &ListTrafficPolicyInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTrafficPolicyInstancesOutput{}
	req.Data = output
	return
}

// ListTrafficPolicyInstances API operation for Amazon Route 53.
//
// Gets information about the traffic policy instances that you created by using
// the current AWS account.
//
// After you submit an UpdateTrafficPolicyInstance request, there's a brief
// delay while Amazon Route 53 creates the resource record sets that are specified
// in the traffic policy definition. For more information, see the State response
// element.
//
// Send a GET request to the /Amazon Route 53 API version/trafficpolicyinstance
// resource.
//
// Amazon Route 53 returns a maximum of 100 items in each response. If you have
// a lot of traffic policy instances, you can use the MaxItems parameter to
// list them in groups of up to 100.
//
// The response includes five values that help you navigate from one group of
// MaxItems traffic policy instances to the next:
//
//    * IsTruncated
//
// If the value of IsTruncated in the response is true, there are more traffic
//    policy instances associated with the current AWS account.
//
// If IsTruncated is false, this response includes the last traffic policy instance
//    that is associated with the current account.
//
//    * MaxItems
//
// The value that you specified for the MaxItems parameter in the request that
//    produced the current response.
//
//    * HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
//
// If IsTruncated is true, these three values in the response represent the
//    first traffic policy instance in the next group of MaxItems traffic policy
//    instances. To list more traffic policy instances, make another call to
//    ListTrafficPolicyInstances, and specify these values in the corresponding
//    request parameters.
//
// If IsTruncated is false, all three elements are omitted from the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListTrafficPolicyInstances for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
//   * NoSuchTrafficPolicyInstance
//   No traffic policy instance exists with the specified ID.
//
func (c *Route53) ListTrafficPolicyInstances(input *ListTrafficPolicyInstancesInput) (*ListTrafficPolicyInstancesOutput, error) {
	req, out := c.ListTrafficPolicyInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opListTrafficPolicyInstancesByHostedZone = "ListTrafficPolicyInstancesByHostedZone"

// ListTrafficPolicyInstancesByHostedZoneRequest generates a "aws/request.Request" representing the
// client's request for the ListTrafficPolicyInstancesByHostedZone operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTrafficPolicyInstancesByHostedZone for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTrafficPolicyInstancesByHostedZone method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTrafficPolicyInstancesByHostedZoneRequest method.
//    req, resp := client.ListTrafficPolicyInstancesByHostedZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListTrafficPolicyInstancesByHostedZoneRequest(input *ListTrafficPolicyInstancesByHostedZoneInput) (req *request.Request, output *ListTrafficPolicyInstancesByHostedZoneOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicyInstancesByHostedZone,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstances/hostedzone",
	}

	if input == nil {
		input = &ListTrafficPolicyInstancesByHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTrafficPolicyInstancesByHostedZoneOutput{}
	req.Data = output
	return
}

// ListTrafficPolicyInstancesByHostedZone API operation for Amazon Route 53.
//
// Gets information about the traffic policy instances that you created in a
// specified hosted zone.
//
// After you submit an UpdateTrafficPolicyInstance request, there's a brief
// delay while Amazon Route 53 creates the resource record sets that are specified
// in the traffic policy definition. For more information, see the State response
// element.
//
// Send a GET request to the /Amazon Route 53 API version/trafficpolicyinstance
// resource and include the ID of the hosted zone.
//
// Amazon Route 53 returns a maximum of 100 items in each response. If you have
// a lot of traffic policy instances, you can use the MaxItems parameter to
// list them in groups of up to 100.
//
// The response includes four values that help you navigate from one group of
// MaxItems traffic policy instances to the next:
//
//    * IsTruncated
//
// If the value of IsTruncated in the response is true, there are more traffic
//    policy instances associated with the current AWS account.
//
//    * If IsTruncated is false, this response includes the last traffic policy
//    instance that is associated with the current account.
//
//    * MaxItems
//
//    * The value that you specified for the MaxItems parameter in the request
//    that produced the current response.
//
//    * TrafficPolicyInstanceNameMarker and TrafficPolicyInstanceTypeMarker
//
//    * If IsTruncated is true, these two values in the response represent the
//    first traffic policy instance in the next group of MaxItems traffic policy
//    instances. To list more traffic policy instances, make another call to
//    ListTrafficPolicyInstancesByHostedZone, and specify these values in the
//    corresponding request parameters.
//
//    * If IsTruncated is false, all three elements are omitted from the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListTrafficPolicyInstancesByHostedZone for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
//   * NoSuchTrafficPolicyInstance
//   No traffic policy instance exists with the specified ID.
//
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
func (c *Route53) ListTrafficPolicyInstancesByHostedZone(input *ListTrafficPolicyInstancesByHostedZoneInput) (*ListTrafficPolicyInstancesByHostedZoneOutput, error) {
	req, out := c.ListTrafficPolicyInstancesByHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opListTrafficPolicyInstancesByPolicy = "ListTrafficPolicyInstancesByPolicy"

// ListTrafficPolicyInstancesByPolicyRequest generates a "aws/request.Request" representing the
// client's request for the ListTrafficPolicyInstancesByPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTrafficPolicyInstancesByPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTrafficPolicyInstancesByPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTrafficPolicyInstancesByPolicyRequest method.
//    req, resp := client.ListTrafficPolicyInstancesByPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListTrafficPolicyInstancesByPolicyRequest(input *ListTrafficPolicyInstancesByPolicyInput) (req *request.Request, output *ListTrafficPolicyInstancesByPolicyOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicyInstancesByPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstances/trafficpolicy",
	}

	if input == nil {
		input = &ListTrafficPolicyInstancesByPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTrafficPolicyInstancesByPolicyOutput{}
	req.Data = output
	return
}

// ListTrafficPolicyInstancesByPolicy API operation for Amazon Route 53.
//
// Gets information about the traffic policy instances that you created by using
// a specify traffic policy version.
//
// After you submit a CreateTrafficPolicyInstance or an UpdateTrafficPolicyInstance
// request, there's a brief delay while Amazon Route 53 creates the resource
// record sets that are specified in the traffic policy definition. For more
// information, see the State response element.
//
// Send a GET request to the /Route 53 API version/trafficpolicyinstance resource
// and include the ID and version of the traffic policy.
//
// Amazon Route 53 returns a maximum of 100 items in each response. If you have
// a lot of traffic policy instances, you can use the MaxItems parameter to
// list them in groups of up to 100.
//
// The response includes five values that help you navigate from one group of
// MaxItems traffic policy instances to the next:
//
//    * IsTruncated
//
// If the value of IsTruncated in the response is true, there are more traffic
//    policy instances associated with the specified traffic policy.
//
// If IsTruncated is false, this response includes the last traffic policy instance
//    that is associated with the specified traffic policy.
//
//    * MaxItems
//
// The value that you specified for the MaxItems parameter in the request that
//    produced the current response.
//
//    * HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
//
// If IsTruncated is true, these values in the response represent the first
//    traffic policy instance in the next group of MaxItems traffic policy instances.
//    To list more traffic policy instances, make another call to ListTrafficPolicyInstancesByPolicy,
//    and specify these values in the corresponding request parameters.
//
// If IsTruncated is false, all three elements are omitted from the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListTrafficPolicyInstancesByPolicy for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
//   * NoSuchTrafficPolicyInstance
//   No traffic policy instance exists with the specified ID.
//
//   * NoSuchTrafficPolicy
//   No traffic policy exists with the specified ID.
//
func (c *Route53) ListTrafficPolicyInstancesByPolicy(input *ListTrafficPolicyInstancesByPolicyInput) (*ListTrafficPolicyInstancesByPolicyOutput, error) {
	req, out := c.ListTrafficPolicyInstancesByPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opListTrafficPolicyVersions = "ListTrafficPolicyVersions"

// ListTrafficPolicyVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTrafficPolicyVersions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTrafficPolicyVersions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTrafficPolicyVersions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTrafficPolicyVersionsRequest method.
//    req, resp := client.ListTrafficPolicyVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) ListTrafficPolicyVersionsRequest(input *ListTrafficPolicyVersionsInput) (req *request.Request, output *ListTrafficPolicyVersionsOutput) {
	op := &request.Operation{
		Name:       opListTrafficPolicyVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicies/{Id}/versions",
	}

	if input == nil {
		input = &ListTrafficPolicyVersionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTrafficPolicyVersionsOutput{}
	req.Data = output
	return
}

// ListTrafficPolicyVersions API operation for Amazon Route 53.
//
// Gets information about all of the versions for a specified traffic policy.
//
// Send a GET request to the /Amazon Route 53 API version/trafficpolicy resource
// and specify the ID of the traffic policy for which you want to list versions.
//
// Amazon Route 53 returns a maximum of 100 items in each response. If you have
// a lot of traffic policies, you can use the maxitems parameter to list them
// in groups of up to 100.
//
// The response includes three values that help you navigate from one group
// of maxitems traffic policies to the next:
//
//    * IsTruncated
//
// If the value of IsTruncated in the response is true, there are more traffic
//    policy versions associated with the specified traffic policy.
//
// If IsTruncated is false, this response includes the last traffic policy version
//    that is associated with the specified traffic policy.
//
//    * TrafficPolicyVersionMarker
//
// The ID of the next traffic policy version that is associated with the current
//    AWS account. If you want to list more traffic policies, make another call
//    to ListTrafficPolicyVersions, and specify the value of the TrafficPolicyVersionMarker
//    element in the TrafficPolicyVersionMarker request parameter.
//
// If IsTruncated is false, Amazon Route 53 omits the TrafficPolicyVersionMarker
//    element from the response.
//
//    * MaxItems
//
// The value that you specified for the MaxItems parameter in the request that
//    produced the current response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation ListTrafficPolicyVersions for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
//   * NoSuchTrafficPolicy
//   No traffic policy exists with the specified ID.
//
func (c *Route53) ListTrafficPolicyVersions(input *ListTrafficPolicyVersionsInput) (*ListTrafficPolicyVersionsOutput, error) {
	req, out := c.ListTrafficPolicyVersionsRequest(input)
	err := req.Send()
	return out, err
}

const opTestDNSAnswer = "TestDNSAnswer"

// TestDNSAnswerRequest generates a "aws/request.Request" representing the
// client's request for the TestDNSAnswer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TestDNSAnswer for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TestDNSAnswer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TestDNSAnswerRequest method.
//    req, resp := client.TestDNSAnswerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) TestDNSAnswerRequest(input *TestDNSAnswerInput) (req *request.Request, output *TestDNSAnswerOutput) {
	op := &request.Operation{
		Name:       opTestDNSAnswer,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/testdnsanswer",
	}

	if input == nil {
		input = &TestDNSAnswerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TestDNSAnswerOutput{}
	req.Data = output
	return
}

// TestDNSAnswer API operation for Amazon Route 53.
//
// Gets the value that Amazon Route 53 returns in response to a DNS request
// for a specified record name and type. You can optionally specify the IP address
// of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation TestDNSAnswer for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) TestDNSAnswer(input *TestDNSAnswerInput) (*TestDNSAnswerOutput, error) {
	req, out := c.TestDNSAnswerRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateHealthCheck = "UpdateHealthCheck"

// UpdateHealthCheckRequest generates a "aws/request.Request" representing the
// client's request for the UpdateHealthCheck operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateHealthCheck for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateHealthCheck method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateHealthCheckRequest method.
//    req, resp := client.UpdateHealthCheckRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) UpdateHealthCheckRequest(input *UpdateHealthCheckInput) (req *request.Request, output *UpdateHealthCheckOutput) {
	op := &request.Operation{
		Name:       opUpdateHealthCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}",
	}

	if input == nil {
		input = &UpdateHealthCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateHealthCheckOutput{}
	req.Data = output
	return
}

// UpdateHealthCheck API operation for Amazon Route 53.
//
// Updates an existing health check.
//
// Send a POST request to the /2013-04-01/healthcheck/health check ID resource.
// The request body must include an XML document with an UpdateHealthCheckRequest
// element. For more information about updating health checks, see Creating,
// Updating, and Deleting Health Checks (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html)
// in the Amazon Route 53 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation UpdateHealthCheck for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHealthCheck
//   No health check exists with the ID that you specified in the DeleteHealthCheck
//   request.
//
//   * InvalidInput
//   The input is not valid.
//
//   * HealthCheckVersionMismatch
//   The value of HealthCheckVersion in the request doesn't match the value of
//   HealthCheckVersion in the health check.
//
func (c *Route53) UpdateHealthCheck(input *UpdateHealthCheckInput) (*UpdateHealthCheckOutput, error) {
	req, out := c.UpdateHealthCheckRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateHostedZoneComment = "UpdateHostedZoneComment"

// UpdateHostedZoneCommentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateHostedZoneComment operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateHostedZoneComment for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateHostedZoneComment method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateHostedZoneCommentRequest method.
//    req, resp := client.UpdateHostedZoneCommentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) UpdateHostedZoneCommentRequest(input *UpdateHostedZoneCommentInput) (req *request.Request, output *UpdateHostedZoneCommentOutput) {
	op := &request.Operation{
		Name:       opUpdateHostedZoneComment,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}",
	}

	if input == nil {
		input = &UpdateHostedZoneCommentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateHostedZoneCommentOutput{}
	req.Data = output
	return
}

// UpdateHostedZoneComment API operation for Amazon Route 53.
//
// Updates the hosted zone comment. Send a POST request to the /2013-04-01/hostedzone/hosted
// zone ID resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation UpdateHostedZoneComment for usage and error information.
//
// Returned Error Codes:
//   * NoSuchHostedZone
//   No hosted zone exists with the ID that you specified.
//
//   * InvalidInput
//   The input is not valid.
//
func (c *Route53) UpdateHostedZoneComment(input *UpdateHostedZoneCommentInput) (*UpdateHostedZoneCommentOutput, error) {
	req, out := c.UpdateHostedZoneCommentRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateTrafficPolicyComment = "UpdateTrafficPolicyComment"

// UpdateTrafficPolicyCommentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrafficPolicyComment operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateTrafficPolicyComment for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateTrafficPolicyComment method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateTrafficPolicyCommentRequest method.
//    req, resp := client.UpdateTrafficPolicyCommentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) UpdateTrafficPolicyCommentRequest(input *UpdateTrafficPolicyCommentInput) (req *request.Request, output *UpdateTrafficPolicyCommentOutput) {
	op := &request.Operation{
		Name:       opUpdateTrafficPolicyComment,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicy/{Id}/{Version}",
	}

	if input == nil {
		input = &UpdateTrafficPolicyCommentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateTrafficPolicyCommentOutput{}
	req.Data = output
	return
}

// UpdateTrafficPolicyComment API operation for Amazon Route 53.
//
// Updates the comment for a specified traffic policy version.
//
// Send a POST request to the /2013-04-01/trafficpolicy/ resource.
//
// The request body must include a document with an UpdateTrafficPolicyCommentRequest
// element.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation UpdateTrafficPolicyComment for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
//   * NoSuchTrafficPolicy
//   No traffic policy exists with the specified ID.
//
//   * ConcurrentModification
//   Another user submitted a request to update the object at the same time that
//   you did. Retry the request.
//
func (c *Route53) UpdateTrafficPolicyComment(input *UpdateTrafficPolicyCommentInput) (*UpdateTrafficPolicyCommentOutput, error) {
	req, out := c.UpdateTrafficPolicyCommentRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateTrafficPolicyInstance = "UpdateTrafficPolicyInstance"

// UpdateTrafficPolicyInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrafficPolicyInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateTrafficPolicyInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateTrafficPolicyInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateTrafficPolicyInstanceRequest method.
//    req, resp := client.UpdateTrafficPolicyInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53) UpdateTrafficPolicyInstanceRequest(input *UpdateTrafficPolicyInstanceInput) (req *request.Request, output *UpdateTrafficPolicyInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateTrafficPolicyInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicyinstance/{Id}",
	}

	if input == nil {
		input = &UpdateTrafficPolicyInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateTrafficPolicyInstanceOutput{}
	req.Data = output
	return
}

// UpdateTrafficPolicyInstance API operation for Amazon Route 53.
//
// Updates the resource record sets in a specified hosted zone that were created
// based on the settings in a specified traffic policy version.
//
// Send a POST request to the /2013-04-01/trafficpolicyinstance/traffic policy
// ID resource. The request body must include a document with an UpdateTrafficPolicyInstanceRequest
// element.
//
// When you update a traffic policy instance, Amazon Route 53 continues to respond
// to DNS queries for the root resource record set name (such as example.com)
// while it replaces one group of resource record sets with another. Amazon
// Route 53 performs the following operations:
//
// Amazon Route 53 creates a new group of resource record sets based on the
// specified traffic policy. This is true regardless of how substantial the
// differences are between the existing resource record sets and the new resource
// record sets.
//
// When all of the new resource record sets have been created, Amazon Route
// 53 starts to respond to DNS queries for the root resource record set name
// (such as example.com) by using the new resource record sets.
//
// Amazon Route 53 deletes the old group of resource record sets that are associated
// with the root resource record set name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53's
// API operation UpdateTrafficPolicyInstance for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The input is not valid.
//
//   * NoSuchTrafficPolicy
//   No traffic policy exists with the specified ID.
//
//   * NoSuchTrafficPolicyInstance
//   No traffic policy instance exists with the specified ID.
//
//   * PriorRequestNotComplete
//   If Amazon Route 53 can't process a request before the next request arrives,
//   it will reject subsequent requests for the same hosted zone and return an
//   HTTP 400 error (Bad request). If Amazon Route 53 returns this error repeatedly
//   for the same request, we recommend that you wait, in intervals of increasing
//   duration, before you try the request again.
//
//   * ConflictingTypes
//   You tried to update a traffic policy instance by using a traffic policy version
//   that has a different DNS type than the current type for the instance. You
//   specified the type in the JSON document in the CreateTrafficPolicy or CreateTrafficPolicyVersionrequest.
//
func (c *Route53) UpdateTrafficPolicyInstance(input *UpdateTrafficPolicyInstanceInput) (*UpdateTrafficPolicyInstanceOutput, error) {
	req, out := c.UpdateTrafficPolicyInstanceRequest(input)
	err := req.Send()
	return out, err
}

// A complex type that identifies the CloudWatch alarm that you want Amazon
// Route 53 health checkers to use to determine whether this health check is
// healthy.
type AlarmIdentifier struct {
	_ struct{} `type:"structure"`

	// The name of the CloudWatch alarm that you want Amazon Route 53 health checkers
	// to use to determine whether this health check is healthy.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A complex type that identifies the CloudWatch alarm that you want Amazon
	// Route 53 health checkers to use to determine whether this health check is
	// healthy.
	//
	// For the current list of CloudWatch regions, see Amazon CloudWatch (http://docs.aws.amazon.com/general/latest/gr/rande.html#cw_region)
	// in AWS Regions and Endpoints in the Amazon Web Services General Reference.
	//
	// Region is a required field
	Region *string `min:"1" type:"string" required:"true" enum:"CloudWatchRegion"`
}

// String returns the string representation
func (s AlarmIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlarmIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlarmIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlarmIdentifier"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Region == nil {
		invalidParams.Add(request.NewErrParamRequired("Region"))
	}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Alias resource record sets only: Information about the CloudFront distribution,
// Elastic Beanstalk environment, ELB load balancer, Amazon S3 bucket, or Amazon
// Route 53 resource record set to which you are redirecting queries. The Elastic
// Beanstalk environment must have a regionalized subdomain.
//
// When creating resource record sets for a private hosted zone, note the following:
//
//    * Resource record sets cannot be created for CloudFront distributions
//    in a private hosted zone.
//
//    * Creating geolocation alias resource record sets or latency alias resource
//    record sets in a private hosted zone is unsupported.
//
//    * For information about creating failover resource record sets in a private
//    hosted zone, see Configuring Failover in a Private Hosted Zone (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html).
type AliasTarget struct {
	_ struct{} `type:"structure"`

	// Alias resource record sets only: The value that you specify depends on where
	// you want to route queries:
	//
	//    * A CloudFront distribution: Specify the domain name that CloudFront assigned
	//    when you created your distribution.
	//
	// Your CloudFront distribution must include an alternate domain name that matches
	//    the name of the resource record set. For example, if the name of the resource
	//    record set is acme.example.com, your CloudFront distribution must include
	//    acme.example.com as one of the alternate domain names. For more information,
	//    see Using Alternate Domain Names (CNAMEs) (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html)
	//    in the Amazon CloudFront Developer Guide.
	//
	//    * Elastic Beanstalk environment: Specify the CNAME attribute for the environment.
	//    (The environment must have a regionalized domain name.) You can use the
	//    following methods to get the value of the CNAME attribute:
	//
	// AWS Managment Console: For information about how to get the value by using
	//    the console, see Using Custom Domains with Elastic Beanstalk (http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/customdomains.html)
	//    in the AWS Elastic Beanstalk Developer Guide.
	//
	// Elastic Load Balancing API: Use the DescribeEnvironments action to get the
	//    value of the CNAME attribute. For more information, see DescribeEnvironments
	//    (http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/API_DescribeEnvironments.html)
	//    in the AWS Elastic Beanstalk API Reference.
	//
	// AWS CLI: Use the describe-environments command to get the value of the CNAME
	//    attribute. For more information, see describe-environments (http://docs.aws.amazon.com/cli/latest/reference/elasticbeanstalk/describe-environments.html)
	//    in the AWS Command Line Interface Reference.
	//
	//    * An ELB load balancer: Specify the DNS name associated with the load
	//    balancer. Get the DNS name by using the AWS Management Console, the ELB
	//    API, or the AWS CLI. Use the same method to get values for HostedZoneId
	//    and DNSName. If you get one value from the console and the other value
	//    from the API or the CLI, creating the resource record set will fail.
	//
	// AWS Management Console: Go to the Amazon EC2 page, click Load Balancers in
	//    the navigation pane, choose the load balancer, choose the Description
	//    tab, and get the value of the DNS Name field that begins with dualstack.
	//    Use the same process to get the Hosted Zone ID. See HostedZone$Id.
	//
	// Elastic Load Balancing API: Use DescribeLoadBalancers (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	//    to get the value of CanonicalHostedZoneName. Use the same process to get
	//    the CanonicalHostedZoneNameId. See HostedZone$Id.
	//
	// AWS CLI: Use describe-load-balancers (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	//    to get the value of CanonicalHostedZoneName. Use the same process to get
	//    the CanonicalHostedZoneNameId. See HostedZoneId.
	//
	//    * An Amazon S3 bucket that is configured as a static website: Specify
	//    the domain name of the Amazon S3 website endpoint in which you created
	//    the bucket; for example, s3-website-us-east-1.amazonaws.com. For more
	//    information about valid values, see the table Amazon Simple Storage Service
	//    (S3) Website Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
	//    in the Amazon Web Services General Reference. For more information about
	//    using Amazon S3 buckets for websites, see Hosting a Static Website on
	//    Amazon S3 (http://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html)
	//    in the Amazon Simple Storage Service Developer Guide.
	//
	//    * Another Amazon Route 53 resource record set: Specify the value of the
	//    Name element for a resource record set in the current hosted zone.
	//
	// DNSName is a required field
	DNSName *string `type:"string" required:"true"`

	// Applies only to alias, weighted alias, latency alias, and failover alias
	// record sets: If you set the value of EvaluateTargetHealth to true for the
	// resource record set or sets in an alias, weighted alias, latency alias, or
	// failover alias resource record set, and if you specify a value for HealthCheck$Id
	// for every resource record set that is referenced by these alias resource
	// record sets, the alias resource record sets inherit the health of the referenced
	// resource record sets.
	//
	// In this configuration, when Amazon Route 53 receives a DNS query for an alias
	// resource record set:
	//
	//    * Amazon Route 53 looks at the resource record sets that are referenced
	//    by the alias resource record sets to determine which health checks they're
	//    using.
	//
	//    * Amazon Route 53 checks the current status of each health check. (Amazon
	//    Route 53 periodically checks the health of the endpoint that is specified
	//    in a health check; it doesn't perform the health check when the DNS query
	//    arrives.)
	//
	//    * Based on the status of the health checks, Amazon Route 53 determines
	//    which resource record sets are healthy. Unhealthy resource record sets
	//    are immediately removed from consideration. In addition, if all of the
	//    resource record sets that are referenced by an alias resource record set
	//    are unhealthy, that alias resource record set also is immediately removed
	//    from consideration.
	//
	//    * Based on the configuration of the alias resource record sets (weighted
	//    alias or latency alias, for example) and the configuration of the resource
	//    record sets that they reference, Amazon Route 53 chooses a resource record
	//    set from the healthy resource record sets, and responds to the query.
	//
	// Note the following:
	//
	//    * You cannot set EvaluateTargetHealth to true when the alias target is
	//    a CloudFront distribution.
	//
	//    * If the AWS resource that you specify in AliasTarget is a resource record
	//    set or a group of resource record sets (for example, a group of weighted
	//    resource record sets), but it is not another alias resource record set,
	//    we recommend that you associate a health check with all of the resource
	//    record sets in the alias target.For more information, see What Happens
	//    When You Omit Health Checks? (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-complex-configs.html#dns-failover-complex-configs-hc-omitting)
	//    in the Amazon Route 53 Developer Guide.
	//
	//    * If you specify an Elastic Beanstalk environment in HostedZoneId and
	//    DNSName, and if the environment contains an ELB load balancer, Elastic
	//    Load Balancing routes queries only to the healthy Amazon EC2 instances
	//    that are registered with the load balancer. (An environment automatically
	//    contains an ELB load balancer if it includes more than one Amazon EC2
	//    instance.) If you set EvaluateTargetHealth to true and either no Amazon
	//    EC2 instances are healthy or the load balancer itself is unhealthy, Amazon
	//    Route 53 routes queries to other available resources that are healthy,
	//    if any.
	//
	// If the environment contains a single Amazon EC2 instance, there are no special
	//    requirements.
	//
	//    * If you specify an ELB load balancer in AliasTarget, Elastic Load Balancing
	//    routes queries only to the healthy Amazon EC2 instances that are registered
	//    with the load balancer. If no Amazon EC2 instances are healthy or if the
	//    load balancer itself is unhealthy, and if EvaluateTargetHealth is true
	//    for the corresponding alias resource record set, Amazon Route 53 routes
	//    queries to other resources. When you create a load balancer, you configure
	//    settings for Elastic Load Balancing health checks; they're not Amazon
	//    Route 53 health checks, but they perform a similar function. Do not create
	//    Amazon Route 53 health checks for the Amazon EC2 instances that you register
	//    with an ELB load balancer.
	//
	// For more information, see How Health Checks Work in More Complex Amazon Route
	//    53 Configurations (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-complex-configs.html)
	//    in the Amazon Route 53 Developers Guide.
	//
	//    * We recommend that you set EvaluateTargetHealth to true only when you
	//    have enough idle capacity to handle the failure of one or more endpoints.
	//
	// For more information and examples, see Amazon Route 53 Health Checks and
	// DNS Failover (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// EvaluateTargetHealth is a required field
	EvaluateTargetHealth *bool `type:"boolean" required:"true"`

	// Alias resource records sets only: The value used depends on where the queries
	// are routed:
	//
	// A CloudFront distributionSpecify Z2FDTNDATAQYW2.
	//
	// Alias resource record sets for CloudFront cannot be created in a private
	// zone.
	//
	// Elastic Beanstalk environmentSpecify the hosted zone ID for the region in
	// which you created the environment. The environment must have a regionalized
	// subdomain. For a list of regions and the corresponding hosted zone IDs, see
	// AWS Elastic Beanstalk (http://docs.aws.amazon.com/general/latest/gr/rande.html#elasticbeanstalk_region)
	// in the Regions and Endpoints chapter of the AWS General Reference.
	//
	// ELB load balancerSpecify the value of the hosted zone ID for the load balancer.
	// Use the following methods to get the hosted zone ID:
	//
	// AWS Management Console: Go to the Amazon EC2; page, click Load Balancers
	// in the navigation pane, select the load balancer, and get the value of the
	// Hosted Zone ID field on the Description tab. Use the same process to get
	// the DNS Name. See HostedZone$Name.
	//
	// Elastic Load Balancing API: Use DescribeLoadBalancers to get the value of
	// CanonicalHostedZoneNameID. Use the same process to get the CanonicalHostedZoneName.
	// See HostedZone$Name.
	//
	// AWS CLI: Use describe-load-balancers (http://docs.aws.amazon.com/cli/latest/reference/elb/describe-load-balancers.html)
	// to get the value of CanonicalHostedZoneNameID. Use the same process to get
	// the CanonicalHostedZoneName. See HostedZone$Name.
	//
	// An Amazon S3 bucket configured as a static websiteSpecify the hosted zone
	// ID for the Amazon S3 website endpoint in which you created the bucket. For
	// more information about valid values, see the table  Amazon S3 (S3) Website
	// Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
	// in the Amazon Web Services General Reference.
	//
	// Another Amazon Route 53 resource record set in your hosted zoneSpecify the
	// hosted zone ID of your hosted zone. (An alias resource record set cannot
	// reference a resource record set in a different hosted zone.)
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AliasTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AliasTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AliasTarget"}
	if s.DNSName == nil {
		invalidParams.Add(request.NewErrParamRequired("DNSName"))
	}
	if s.EvaluateTargetHealth == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluateTargetHealth"))
	}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains information about the VPC and the hosted zone
// that you want to associate.
type AssociateVPCWithHostedZoneInput struct {
	_ struct{} `locationName:"AssociateVPCWithHostedZoneRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// Optional: A comment about the association request.
	Comment *string `type:"string"`

	// The ID of the hosted zone you want to associate your VPC with.
	//
	// Note that you cannot associate a VPC with a hosted zone that doesn't have
	// an existing VPC association.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// A complex type containing information about the Amazon VPC that you're associating
	// with the specified hosted zone.
	//
	// VPC is a required field
	VPC *VPC `type:"structure" required:"true"`
}

// String returns the string representation
func (s AssociateVPCWithHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateVPCWithHostedZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateVPCWithHostedZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateVPCWithHostedZoneInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.VPC == nil {
		invalidParams.Add(request.NewErrParamRequired("VPC"))
	}
	if s.VPC != nil {
		if err := s.VPC.Validate(); err != nil {
			invalidParams.AddNested("VPC", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the response information for the hosted zone.
type AssociateVPCWithHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that describes the changes made to your hosted zone.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s AssociateVPCWithHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateVPCWithHostedZoneOutput) GoString() string {
	return s.String()
}

// The information for each resource record set that you want to change.
type Change struct {
	_ struct{} `type:"structure"`

	// The action to perform:
	//
	//    * CREATE: Creates a resource record set that has the specified values.
	//
	//    * DELETE: Deletes a existing resource record set that has the specified
	//    values for Name, Type, SetIdentifier (for latency, weighted, geolocation,
	//    and failover resource record sets), and TTL (except alias resource record
	//    sets, for which the TTL is determined by the AWS resource that you're
	//    routing DNS queries to).
	//
	// To delete the resource record set that is associated with a traffic policy
	//    instance, use DeleteTrafficPolicyInstance. Amazon Route 53will delete
	//    the resource record set automatically. If you delete the resource record
	//    set by using ChangeResourceRecordSets, Amazon Route 53 doesn't automatically
	//    delete the traffic policy instance, and you'll continue to be charged
	//    for it even though it's no longer in use.
	//
	//    * UPSERT: If a resource record set does not already exist, Amazon Route
	//    53 creates it. If a resource record set does exist, Amazon Route 53 updates
	//    it with the values in the request. Amazon Route 53 can update an existing
	//    resource record set only when all of the following values match: Name,
	//    Type, and SetIdentifier (for weighted, latency, geolocation, and failover
	//    resource record sets).
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// Information about the resource record set to create or delete.
	//
	// ResourceRecordSet is a required field
	ResourceRecordSet *ResourceRecordSet `type:"structure" required:"true"`
}

// String returns the string representation
func (s Change) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Change) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Change) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Change"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.ResourceRecordSet == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceRecordSet"))
	}
	if s.ResourceRecordSet != nil {
		if err := s.ResourceRecordSet.Validate(); err != nil {
			invalidParams.AddNested("ResourceRecordSet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The information for a change request.
type ChangeBatch struct {
	_ struct{} `type:"structure"`

	// Information about the changes to make to the record sets.
	//
	// Changes is a required field
	Changes []*Change `locationNameList:"Change" min:"1" type:"list" required:"true"`

	// Optional: Any comments you want to include about a change batch request.
	Comment *string `type:"string"`
}

// String returns the string representation
func (s ChangeBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeBatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangeBatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChangeBatch"}
	if s.Changes == nil {
		invalidParams.Add(request.NewErrParamRequired("Changes"))
	}
	if s.Changes != nil && len(s.Changes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Changes", 1))
	}
	if s.Changes != nil {
		for i, v := range s.Changes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Changes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that lists the changes and information for a ChangeBatch.
type ChangeBatchRecord struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// A list of changes made in the ChangeBatch.
	Changes []*Change `locationNameList:"Change" min:"1" type:"list"`

	// A complex type that describes change information about changes made to your
	// hosted zone.
	//
	// This element contains an ID that you use when performing a GetChange action
	// to get detailed information about the change.
	Comment *string `type:"string"`

	// The ID of the request. Use this ID to track when the change has completed
	// across all Amazon Route 53 DNS servers.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The current state of the request. PENDING indicates that this request has
	// not yet been applied to all Amazon Route 53 DNS servers.
	//
	// Valid Values: PENDING | INSYNC
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ChangeStatus"`

	// The date and time the change was submitted, in the format YYYY-MM-DDThh:mm:ssZ,
	// as specified in the ISO 8601 standard (for example, 2009-11-19T19:37:58Z).
	// The Z after the time indicates that the time is listed in Coordinated Universal
	// Time (UTC).
	SubmittedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The AWS account ID attached to the changes.
	Submitter *string `type:"string"`
}

// String returns the string representation
func (s ChangeBatchRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeBatchRecord) GoString() string {
	return s.String()
}

// A complex type that describes change information about changes made to your
// hosted zone.
type ChangeInfo struct {
	_ struct{} `type:"structure"`

	// A complex type that describes change information about changes made to your
	// hosted zone.
	//
	// This element contains an ID that you use when performing a GetChange action
	// to get detailed information about the change.
	Comment *string `type:"string"`

	// The ID of the request.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The current state of the request. PENDING indicates that this request has
	// not yet been applied to all Amazon Route 53 DNS servers.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ChangeStatus"`

	// The date and time the change request was submitted, in Coordinated Universal
	// Time (UTC) format: YYYY-MM-DDThh:mm:ssZ. For more information, see the Wikipedia
	// entry ISO 8601 (https://en.wikipedia.org/wiki/ISO_8601).
	//
	// SubmittedAt is a required field
	SubmittedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ChangeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeInfo) GoString() string {
	return s.String()
}

// A complex type that contains change information for the resource record set.
type ChangeResourceRecordSetsInput struct {
	_ struct{} `locationName:"ChangeResourceRecordSetsRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A complex type that contains an optional comment and the Changes element.
	//
	// ChangeBatch is a required field
	ChangeBatch *ChangeBatch `type:"structure" required:"true"`

	// The ID of the hosted zone that contains the resource record sets that you
	// want to change.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s ChangeResourceRecordSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeResourceRecordSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangeResourceRecordSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChangeResourceRecordSetsInput"}
	if s.ChangeBatch == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeBatch"))
	}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.ChangeBatch != nil {
		if err := s.ChangeBatch.Validate(); err != nil {
			invalidParams.AddNested("ChangeBatch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type containing the response for the request.
type ChangeResourceRecordSetsOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about changes made to your hosted
	// zone.
	//
	// This element contains an ID that you use when performing a GetChange action
	// to get detailed information about the change.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s ChangeResourceRecordSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeResourceRecordSetsOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the tags that you want to
// add, edit, or delete.
type ChangeTagsForResourceInput struct {
	_ struct{} `locationName:"ChangeTagsForResourceRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A complex type that contains a list of the tags that you want to add to the
	// specified health check or hosted zone and/or the tags for which you want
	// to edit the Value element.
	//
	// You can add a maximum of 10 tags to a health check or a hosted zone.
	AddTags []*Tag `locationNameList:"Tag" min:"1" type:"list"`

	// A complex type that contains a list of the tags that you want to delete from
	// the specified health check or hosted zone. You can specify up to 10 keys.
	RemoveTagKeys []*string `locationNameList:"Key" min:"1" type:"list"`

	// The ID of the resource for which you want to add, change, or delete tags.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" type:"string" required:"true"`

	// The type of the resource.
	//
	//    * The resource type for health checks is healthcheck.
	//
	//    * The resource type for hosted zones is hostedzone.
	//
	// ResourceType is a required field
	ResourceType *string `location:"uri" locationName:"ResourceType" type:"string" required:"true" enum:"TagResourceType"`
}

// String returns the string representation
func (s ChangeTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangeTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChangeTagsForResourceInput"}
	if s.AddTags != nil && len(s.AddTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddTags", 1))
	}
	if s.RemoveTagKeys != nil && len(s.RemoveTagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RemoveTagKeys", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Empty response for the request.
type ChangeTagsForResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ChangeTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeTagsForResourceOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the CloudWatch alarm that
// Amazon Route 53 is monitoring for this health check.
type CloudWatchAlarmConfiguration struct {
	_ struct{} `type:"structure"`

	// For the metric that the CloudWatch alarm is associated with, the arithmetic
	// operation that is used for the comparison.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperator"`

	// For the metric that the CloudWatch alarm is associated with, a complex type
	// that contains information about the dimensions for the metric.For information,
	// see Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference ( http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html)
	// in the Amazon CloudWatch Developer Guide.
	Dimensions []*Dimension `locationNameList:"Dimension" type:"list"`

	// For the metric that the CloudWatch alarm is associated with, the number of
	// periods that the metric is compared to the threshold.
	//
	// EvaluationPeriods is a required field
	EvaluationPeriods *int64 `min:"1" type:"integer" required:"true"`

	// The name of the CloudWatch metric that the alarm is associated with.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace of the metric that the alarm is associated with. For more information,
	// see Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html)
	// in the Amazon CloudWatch Developer Guide.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// For the metric that the CloudWatch alarm is associated with, the duration
	// of one evaluation period in seconds.
	//
	// Period is a required field
	Period *int64 `min:"60" type:"integer" required:"true"`

	// For the metric that the CloudWatch alarm is associated with, the statistic
	// that is applied to the metric.
	//
	// Statistic is a required field
	Statistic *string `type:"string" required:"true" enum:"Statistic"`

	// For the metric that the CloudWatch alarm is associated with, the value the
	// metric is compared with.
	//
	// Threshold is a required field
	Threshold *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s CloudWatchAlarmConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchAlarmConfiguration) GoString() string {
	return s.String()
}

// A complex type that contains the health check request information.
type CreateHealthCheckInput struct {
	_ struct{} `locationName:"CreateHealthCheckRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A unique string that identifies the request and that allows failed CreateHealthCheck
	// requests to be retried without the risk of executing the operation twice.
	// You must use a unique CallerReference string every time you create a health
	// check.
	//
	// CallerReference is a required field
	CallerReference *string `min:"1" type:"string" required:"true"`

	// A complex type that contains the response to a CreateHealthCheck request.
	//
	// HealthCheckConfig is a required field
	HealthCheckConfig *HealthCheckConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHealthCheckInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHealthCheckInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHealthCheckInput"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.CallerReference != nil && len(*s.CallerReference) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallerReference", 1))
	}
	if s.HealthCheckConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheckConfig"))
	}
	if s.HealthCheckConfig != nil {
		if err := s.HealthCheckConfig.Validate(); err != nil {
			invalidParams.AddNested("HealthCheckConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type containing the response information for the new health check.
type CreateHealthCheckOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains identifying information about the health check.
	//
	// HealthCheck is a required field
	HealthCheck *HealthCheck `type:"structure" required:"true"`

	// The unique URL representing the new health check.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHealthCheckOutput) GoString() string {
	return s.String()
}

// A complex type containing the hosted zone request information.
type CreateHostedZoneInput struct {
	_ struct{} `locationName:"CreateHostedZoneRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A unique string that identifies the request and that allows failed CreateHostedZone
	// requests to be retried without the risk of executing the operation twice.
	// You must use a unique CallerReference string every time you create a hosted
	// zone. CallerReference can be any unique string, for example, a date/time
	// stamp.
	//
	// CallerReference is a required field
	CallerReference *string `min:"1" type:"string" required:"true"`

	// If you want to associate a reusable delegation set with this hosted zone,
	// the ID that Amazon Route 53 assigned to the reusable delegation set when
	// you created it. For more information about reusable delegation sets, see
	// CreateReusableDelegationSet.
	//
	// TypeString
	//
	// DefaultNone
	//
	// ParentCreatedHostedZoneRequest
	DelegationSetId *string `type:"string"`

	// (Optional) A complex type that contains an optional comment about your hosted
	// zone. If you don't want to specify a comment, omit both the HostedZoneConfig
	// and Comment elements.
	HostedZoneConfig *HostedZoneConfig `type:"structure"`

	// The name of the domain. For resource record types that include a domain name,
	// specify a fully qualified domain name, for example, www.example.com. The
	// trailing dot is optional; Amazon Route 53 assumes that the domain name is
	// fully qualified. This means that Amazon Route 53 treats www.example.com (without
	// a trailing dot) and www.example.com. (with a trailing dot) as identical.
	//
	// If you're creating a public hosted zone, this is the name you have registered
	// with your DNS registrar. If your domain name is registered with a registrar
	// other than Amazon Route 53, change the name servers for your domain to the
	// set of NameServers that CreateHostedZone returns in the DelegationSet element.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The VPC that you want your hosted zone to be associated with. By providing
	// this parameter, your newly created hosted cannot be resolved anywhere other
	// than the given VPC.
	VPC *VPC `type:"structure"`
}

// String returns the string representation
func (s CreateHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHostedZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHostedZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHostedZoneInput"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.CallerReference != nil && len(*s.CallerReference) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallerReference", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.VPC != nil {
		if err := s.VPC.Validate(); err != nil {
			invalidParams.AddNested("VPC", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type containing the response information for the hosted zone.
type CreateHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that describes the changes made to your hosted zone.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`

	// A complex type that describes the name servers for this hosted zone.
	//
	// DelegationSet is a required field
	DelegationSet *DelegationSet `type:"structure" required:"true"`

	// A complex type that contains general information about the hosted zone.
	//
	// HostedZone is a required field
	HostedZone *HostedZone `type:"structure" required:"true"`

	// The unique URL representing the new hosted zone.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	// A complex type that contains information about an Amazon VPC that you associated
	// with this hosted zone.
	VPC *VPC `type:"structure"`
}

// String returns the string representation
func (s CreateHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHostedZoneOutput) GoString() string {
	return s.String()
}

type CreateReusableDelegationSetInput struct {
	_ struct{} `locationName:"CreateReusableDelegationSetRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A unique string that identifies the request, and that allows you to retry
	// failed CreateReusableDelegationSet requests without the risk of executing
	// the operation twice. You must use a unique CallerReference string every time
	// you submit a CreateReusableDelegationSet request. CallerReference can be
	// any unique string, for example a date/time stamp.
	//
	// CallerReference is a required field
	CallerReference *string `min:"1" type:"string" required:"true"`

	// If you want to mark the delegation set for an existing hosted zone as reusable,
	// the ID for that hosted zone.
	HostedZoneId *string `type:"string"`
}

// String returns the string representation
func (s CreateReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReusableDelegationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReusableDelegationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReusableDelegationSetInput"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.CallerReference != nil && len(*s.CallerReference) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallerReference", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateReusableDelegationSetOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains name server information.
	//
	// DelegationSet is a required field
	DelegationSet *DelegationSet `type:"structure" required:"true"`

	// The unique URL representing the new reusable delegation set.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReusableDelegationSetOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the traffic policy that you
// want to create.
type CreateTrafficPolicyInput struct {
	_ struct{} `locationName:"CreateTrafficPolicyRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// (Optional) Any comments that you want to include about the traffic policy.
	Comment *string `type:"string"`

	// The definition of this traffic policy in JSON format. For more information,
	// see Traffic Policy Document Format (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/api-policies-traffic-policy-document-format.html)
	// in the Amazon Route 53 API Reference.
	//
	// Document is a required field
	Document *string `type:"string" required:"true"`

	// The name of the traffic policy.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrafficPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrafficPolicyInput"}
	if s.Document == nil {
		invalidParams.Add(request.NewErrParamRequired("Document"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains information about the resource record sets that
// you want to create based on a specified traffic policy.
type CreateTrafficPolicyInstanceInput struct {
	_ struct{} `locationName:"CreateTrafficPolicyInstanceRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The ID of the hosted zone in which you want Amazon Route 53 to create resource
	// record sets by using the configuration in a traffic policy.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`

	// The domain name (such as example.com) or subdomain name (such as www.example.com)
	// for which Amazon Route 53 responds to DNS queries by using the resource record
	// sets that Amazon Route 53 creates for this traffic policy instance.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// (Optional) The TTL that you want Amazon Route 53 to assign to all of the
	// resource record sets that it creates in the specified hosted zone.
	//
	// TTL is a required field
	TTL *int64 `type:"long" required:"true"`

	// The ID of the traffic policy that you want to use to create resource record
	// sets in the specified hosted zone.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `type:"string" required:"true"`

	// The version of the traffic policy that you want to use to create resource
	// record sets in the specified hosted zone.
	//
	// TrafficPolicyVersion is a required field
	TrafficPolicyVersion *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrafficPolicyInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrafficPolicyInstanceInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.TTL == nil {
		invalidParams.Add(request.NewErrParamRequired("TTL"))
	}
	if s.TrafficPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyId"))
	}
	if s.TrafficPolicyVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyVersion"))
	}
	if s.TrafficPolicyVersion != nil && *s.TrafficPolicyVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TrafficPolicyVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the response information for the CreateTrafficPolicyInstance
// request.
type CreateTrafficPolicyInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A unique URL that represents a new traffic policy instance.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	// A complex type that contains settings for the new traffic policy instance.
	//
	// TrafficPolicyInstance is a required field
	TrafficPolicyInstance *TrafficPolicyInstance `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyInstanceOutput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the CreateTrafficPolicy
// request.
type CreateTrafficPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A unique URL that represents a new traffic policy.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	// A complex type that contains settings for the new traffic policy.
	//
	// TrafficPolicy is a required field
	TrafficPolicy *TrafficPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the traffic policy for which
// you want to create a new version.
type CreateTrafficPolicyVersionInput struct {
	_ struct{} `locationName:"CreateTrafficPolicyVersionRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The comment that you specified in the CreateTrafficPolicyVersion request,
	// if any.
	Comment *string `type:"string"`

	// The definition of this version of the traffic policy, in JSON format. You
	// specified the JSON in the CreateTrafficPolicyVersion request. For more information
	// about the JSON format, see CreateTrafficPolicy.
	//
	// Document is a required field
	Document *string `type:"string" required:"true"`

	// The ID of the traffic policy for which you want to create a new version.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrafficPolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrafficPolicyVersionInput"}
	if s.Document == nil {
		invalidParams.Add(request.NewErrParamRequired("Document"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the response information for the CreateTrafficPolicyVersion
// request.
type CreateTrafficPolicyVersionOutput struct {
	_ struct{} `type:"structure"`

	// A unique URL that represents a new traffic policy version.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	// A complex type that contains settings for the new version of the traffic
	// policy.
	//
	// TrafficPolicy is a required field
	TrafficPolicy *TrafficPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrafficPolicyVersionOutput) GoString() string {
	return s.String()
}

// A complex type that describes the name servers for this hosted zone.
type DelegationSet struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request, and that allows you to retry
	// failed CreateReusableDelegationSet requests without the risk of executing
	// the operation twice. You must use a unique CallerReference string every time
	// you submit a CreateReusableDelegationSet request. CallerReference can be
	// any unique string, for example, a date/time stamp.
	CallerReference *string `min:"1" type:"string"`

	// The ID that Amazon Route 53 assigns to a reusable delegation set.
	Id *string `type:"string"`

	// A complex type that contains a list of the authoritative name servers for
	// the hosted zone.
	//
	// NameServers is a required field
	NameServers []*string `locationNameList:"NameServer" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DelegationSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DelegationSet) GoString() string {
	return s.String()
}

// This action deletes a health check. Send a DELETE request to the /2013-04-01/DeleteHealthCheckRequest
// resource.
type DeleteHealthCheckInput struct {
	_ struct{} `type:"structure"`

	// The ID of the health check that you want to delete.
	//
	// HealthCheckId is a required field
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHealthCheckInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHealthCheckInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHealthCheckInput"}
	if s.HealthCheckId == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheckId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An empty element.
type DeleteHealthCheckOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHealthCheckOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the hosted zone that you want
// to delete.
type DeleteHostedZoneInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone you want to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHostedZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHostedZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHostedZoneInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type containing the response information for the request.
type DeleteHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the ID, the status, and the date and time of
	// your delete request.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHostedZoneOutput) GoString() string {
	return s.String()
}

// A complex type containing the information for the delete request.
type DeleteReusableDelegationSetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the reusable delegation set you want to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReusableDelegationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReusableDelegationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReusableDelegationSetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An empty element.
type DeleteReusableDelegationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReusableDelegationSetOutput) GoString() string {
	return s.String()
}

// A request to delete a specified traffic policy version.
type DeleteTrafficPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the traffic policy that you want to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The version number of the traffic policy that you want to delete.
	//
	// Version is a required field
	Version *int64 `location:"uri" locationName:"Version" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s DeleteTrafficPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrafficPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrafficPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrafficPolicyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && *s.Version < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains information about the traffic policy instance
// that you want to delete.
type DeleteTrafficPolicyInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the traffic policy instance that you want to delete.
	//
	// When you delete a traffic policy instance, Amazon Route 53 also deletes all
	// of the resource record sets that were created when you created the traffic
	// policy instance.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTrafficPolicyInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrafficPolicyInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrafficPolicyInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrafficPolicyInstanceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An empty element.
type DeleteTrafficPolicyInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTrafficPolicyInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrafficPolicyInstanceOutput) GoString() string {
	return s.String()
}

// An empty element.
type DeleteTrafficPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTrafficPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrafficPolicyOutput) GoString() string {
	return s.String()
}

// For the metric that the CloudWatch alarm is associated with, a complex type
// that contains information about one dimension.
type Dimension struct {
	_ struct{} `type:"structure"`

	// For the metric that the CloudWatch alarm is associated with, the name of
	// one dimension.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// For the metric that the CloudWatch alarm is associated with, the value of
	// one dimension.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Dimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Dimension) GoString() string {
	return s.String()
}

// A complex type that contains information about the VPC and the hosted zone
// that you want to disassociate.
type DisassociateVPCFromHostedZoneInput struct {
	_ struct{} `locationName:"DisassociateVPCFromHostedZoneRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// Optional: A comment about the disassociation request.
	Comment *string `type:"string"`

	// The ID of the VPC that you want to disassociate from an Amazon Route 53 hosted
	// zone.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// A complex type containing information about the Amazon VPC that you're disassociating
	// from the specified hosted zone.
	//
	// VPC is a required field
	VPC *VPC `type:"structure" required:"true"`
}

// String returns the string representation
func (s DisassociateVPCFromHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateVPCFromHostedZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateVPCFromHostedZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateVPCFromHostedZoneInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.VPC == nil {
		invalidParams.Add(request.NewErrParamRequired("VPC"))
	}
	if s.VPC != nil {
		if err := s.VPC.Validate(); err != nil {
			invalidParams.AddNested("VPC", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the response information for the disassociate
// request.
type DisassociateVPCFromHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that describes the changes made to your hosted zone.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s DisassociateVPCFromHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateVPCFromHostedZoneOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about a geo location.
type GeoLocation struct {
	_ struct{} `type:"structure"`

	// The two-letter code for the continent.
	//
	// Valid values: AF | AN | AS | EU | OC | NA | SA
	//
	// Constraint: Specifying ContinentCode with either CountryCode or SubdivisionCode
	// returns an InvalidInput error.
	ContinentCode *string `min:"2" type:"string"`

	// The two-letter code for the country.
	CountryCode *string `min:"1" type:"string"`

	// The code for the subdivision, for example, a state in the United States or
	// a province in Canada.
	SubdivisionCode *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GeoLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeoLocation"}
	if s.ContinentCode != nil && len(*s.ContinentCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ContinentCode", 2))
	}
	if s.CountryCode != nil && len(*s.CountryCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CountryCode", 1))
	}
	if s.SubdivisionCode != nil && len(*s.SubdivisionCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubdivisionCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the codes and full continent, country, and subdivision
// names for the specified geolocation code.
type GeoLocationDetails struct {
	_ struct{} `type:"structure"`

	// The two-letter code for the continent.
	ContinentCode *string `min:"2" type:"string"`

	// The full name of the continent.
	ContinentName *string `min:"1" type:"string"`

	// The two-letter code for the country.
	CountryCode *string `min:"1" type:"string"`

	// The name of the country.
	CountryName *string `min:"1" type:"string"`

	// The code for the subdivision, for example, a state in the United States or
	// a province in Canada.
	SubdivisionCode *string `min:"1" type:"string"`

	// The full name of the subdivision, for example, a state in the United States
	// or a province in Canada.
	SubdivisionName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GeoLocationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoLocationDetails) GoString() string {
	return s.String()
}

// The input for a GetChangeDetails request.
type GetChangeDetailsInput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The ID of the change batch. This is the value that you specified in the change
	// ID parameter when you submitted the request.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetChangeDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChangeDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChangeDetailsInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the ChangeBatchRecord element.
type GetChangeDetailsOutput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// A complex type that contains information about the specified change batch,
	// including the change batch ID, the status of the change, and the contained
	// changes.
	//
	// ChangeBatchRecord is a required field
	ChangeBatchRecord *ChangeBatchRecord `deprecated:"true" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetChangeDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeDetailsOutput) GoString() string {
	return s.String()
}

// The input for a GetChange request.
type GetChangeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the change batch request. The value that you specify here is the
	// value that ChangeResourceRecordSets returned in the Id element when you submitted
	// the request.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetChangeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChangeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChangeInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the ChangeInfo element.
type GetChangeOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the specified change batch.
	//
	// ChangeInfo is a required field
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetChangeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeOutput) GoString() string {
	return s.String()
}

// Empty request.
type GetCheckerIpRangesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetCheckerIpRangesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCheckerIpRangesInput) GoString() string {
	return s.String()
}

// A complex type that contains the CheckerIpRanges element.
type GetCheckerIpRangesOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains sorted list of IP ranges in CIDR format for
	// Amazon Route 53 health checkers.
	//
	// CheckerIpRanges is a required field
	CheckerIpRanges []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetCheckerIpRangesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCheckerIpRangesOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to get a geo location.
type GetGeoLocationInput struct {
	_ struct{} `type:"structure"`

	// Amazon Route 53 supports the following continent codes:
	//
	//    * AF: Africa
	//
	//    * AN: Antarctica
	//
	//    * AS: Asia
	//
	//    * EU: Europe
	//
	//    * OC: Oceania
	//
	//    * NA: North America
	//
	//    * SA: South America
	ContinentCode *string `location:"querystring" locationName:"continentcode" min:"2" type:"string"`

	// Amazon Route 53 uses the two-letter country codes that are specified in ISO
	// standard 3166-1 alpha-2 (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
	CountryCode *string `location:"querystring" locationName:"countrycode" min:"1" type:"string"`

	// Amazon Route 53 uses the one- to three-letter subdivision codes that are
	// specified in ISO standard 3166-1 alpha-2 (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
	// Amazon Route 53 doesn't support subdivision codes for all countries. If you
	// specify SubdivisionCode, you must also specify CountryCode.
	SubdivisionCode *string `location:"querystring" locationName:"subdivisioncode" min:"1" type:"string"`
}

// String returns the string representation
func (s GetGeoLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGeoLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGeoLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGeoLocationInput"}
	if s.ContinentCode != nil && len(*s.ContinentCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ContinentCode", 2))
	}
	if s.CountryCode != nil && len(*s.CountryCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CountryCode", 1))
	}
	if s.SubdivisionCode != nil && len(*s.SubdivisionCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubdivisionCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the response information for the specified geolocation
// code.
type GetGeoLocationOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the codes and full continent, country, and subdivision
	// names for the specified geolocation code.
	//
	// GeoLocationDetails is a required field
	GeoLocationDetails *GeoLocationDetails `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetGeoLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGeoLocationOutput) GoString() string {
	return s.String()
}

// To retrieve a count of all your health checks, send a GET request to the
// /2013-04-01/healthcheckcount resource.
type GetHealthCheckCountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetHealthCheckCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckCountInput) GoString() string {
	return s.String()
}

// A complex type that contains the response to a healthcheckcount request.
type GetHealthCheckCountOutput struct {
	_ struct{} `type:"structure"`

	// The number of health checks associated with the current AWS account.
	//
	// HealthCheckCount is a required field
	HealthCheckCount *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckCountOutput) GoString() string {
	return s.String()
}

// This action gets information about a specified health check.
//
// Send a GET request to the /Amazon Route 53 API version/gethealthcheckrequest
// resource.
//
// For information about getting information about a health check using the
// Amazon Route 53 console, see Amazon Route 53 Health Checks and DNS Failover
// (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html)
// in the Amazon Route 53 Developer Guide.
type GetHealthCheckInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Route 53 assigned to the health check when you
	// created it. When you add or update a resource record set, you use this value
	// to specify which health check to use. The value can be up to 64 characters
	// long.
	//
	// HealthCheckId is a required field
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHealthCheckInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHealthCheckInput"}
	if s.HealthCheckId == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheckId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This action gets the reason that a specified health check failed most recently.
//
// To get the reason for the last failure of a health check, send a GET request
// to the /2013-04-01/healthcheck/health check ID/lastfailurereason resource.
//
// For information about viewing the last failure reason for a health check
// using the Amazon Route 53 console, see Viewing Health Check Status and the
// Reason for Health Check Failures (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-monitor-view-status.html)
// in the Amazon Route 53 Developer Guide.
type GetHealthCheckLastFailureReasonInput struct {
	_ struct{} `type:"structure"`

	// The ID for the health check for which you want the last failure reason. When
	// you created the health check, CreateHealthCheck returned the ID in the response,
	// in the HealthCheckId element.
	//
	// HealthCheckId is a required field
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckLastFailureReasonInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckLastFailureReasonInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHealthCheckLastFailureReasonInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHealthCheckLastFailureReasonInput"}
	if s.HealthCheckId == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheckId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the response to a GetHealthCheckLastFailureReason
// request.
type GetHealthCheckLastFailureReasonOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains one Observation element for each Amazon Route 53 health
	// checker that is reporting a last failure reason.
	//
	// HealthCheckObservations is a required field
	HealthCheckObservations []*HealthCheckObservation `locationNameList:"HealthCheckObservation" type:"list" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckLastFailureReasonOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckLastFailureReasonOutput) GoString() string {
	return s.String()
}

// A complex type that contains the response to a GetHealthCheck request.
type GetHealthCheckOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about one health check that is associated
	// with the current AWS account.
	//
	// HealthCheck is a required field
	HealthCheck *HealthCheck `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to get health
// check status for a health check.
type GetHealthCheckStatusInput struct {
	_ struct{} `type:"structure"`

	// If you want Amazon Route 53 to return this resource record set in response
	// to a DNS query only when a health check is passing, include the HealthCheckId
	// element and specify the ID of the applicable health check.
	//
	// Amazon Route 53 determines whether a resource record set is healthy by periodically
	// sending a request to the endpoint that is specified in the health check.
	// If that endpoint returns an HTTP status code of 2xx or 3xx, the endpoint
	// is healthy. If the endpoint returns an HTTP status code of 400 or greater,
	// or if the endpoint doesn't respond for a certain amount of time, Amazon Route
	// 53 considers the endpoint unhealthy and also considers the resource record
	// set unhealthy.
	//
	// The HealthCheckId element is only useful when Amazon Route 53 is choosing
	// between two or more resource record sets to respond to a DNS query, and you
	// want Amazon Route 53 to base the choice in part on the status of a health
	// check. Configuring health checks only makes sense in the following configurations:
	//
	//    * You're checking the health of the resource record sets in a weighted,
	//    latency, geolocation, or failover resource record set, and you specify
	//    health check IDs for all of the resource record sets. If the health check
	//    for one resource record set specifies an endpoint that is not healthy,
	//    Amazon Route 53 stops responding to queries using the value for that resource
	//    record set.
	//
	//    * You set EvaluateTargetHealth to true for the resource record sets in
	//    an alias, weighted alias, latency alias, geolocation alias, or failover
	//    alias resource record set, and you specify health check IDs for all of
	//    the resource record sets that are referenced by the alias resource record
	//    sets. For more information about this configuration, see EvaluateTargetHealth.
	//
	// Amazon Route 53 doesn't check the health of the endpoint specified in the
	//    resource record set, for example, the endpoint specified by the IP address
	//    in the Value element. When you add a HealthCheckId element to a resource
	//    record set, Amazon Route 53 checks the health of the endpoint that you
	//    specified in the health check.
	//
	// For geolocation resource record sets, if an endpoint is unhealthy, Amazon
	// Route 53 looks for a resource record set for the larger, associated geographic
	// region. For example, suppose you have resource record sets for a state in
	// the United States, for the United States, for North America, and for all
	// locations. If the endpoint for the state resource record set is unhealthy,
	// Amazon Route 53 checks the resource record sets for the United States, for
	// North America, and for all locations (a resource record set for which the
	// value of CountryCode is *), in that order, until it finds a resource record
	// set for which the endpoint is healthy.
	//
	// If your health checks specify the endpoint only by domain name, we recommend
	// that you create a separate health check for each endpoint. For example, create
	// a health check for each HTTP server that is serving content for www.example.com.
	// For the value of FullyQualifiedDomainName, specify the domain name of the
	// server (such as us-east-1-www.example.com), not the name of the resource
	// record sets (example.com).
	//
	// In this configuration, if you create a health check for which the value of
	// FullyQualifiedDomainName matches the name of the resource record sets and
	// then associate the health check with those resource record sets, health check
	// results will be unpredictable.
	//
	// HealthCheckId is a required field
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHealthCheckStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHealthCheckStatusInput"}
	if s.HealthCheckId == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheckId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the response to a GetHealthCheck request.
type GetHealthCheckStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains one HealthCheckObservation element for each Amazon Route
	// 53 health checker that is reporting a status about the health check endpoint.
	//
	// HealthCheckObservations is a required field
	HealthCheckObservations []*HealthCheckObservation `locationNameList:"HealthCheckObservation" type:"list" required:"true"`
}

// String returns the string representation
func (s GetHealthCheckStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckStatusOutput) GoString() string {
	return s.String()
}

// To retrieve a count of all your hosted zones, send a GET request to the /2013-04-01/hostedzonecount
// resource.
type GetHostedZoneCountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetHostedZoneCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneCountInput) GoString() string {
	return s.String()
}

// A complex type that contains the response to a hostedzonecount request.
type GetHostedZoneCountOutput struct {
	_ struct{} `type:"structure"`

	// The total number of public and private hosted zones associated with the current
	// AWS account.
	//
	// HostedZoneCount is a required field
	HostedZoneCount *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s GetHostedZoneCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneCountOutput) GoString() string {
	return s.String()
}

// The input for a GetHostedZone request.
type GetHostedZoneInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone for which you want to get a list of the name servers
	// in the delegation set.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHostedZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHostedZoneInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type containing the response information for the hosted zone.
type GetHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that describes the name servers for this hosted zone.
	DelegationSet *DelegationSet `type:"structure"`

	// A complex type that contains general information about the hosted zone.
	//
	// HostedZone is a required field
	HostedZone *HostedZone `type:"structure" required:"true"`

	// A complex type that contains information about VPCs associated with the specified
	// hosted zone.
	VPCs []*VPC `locationNameList:"VPC" min:"1" type:"list"`
}

// String returns the string representation
func (s GetHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneOutput) GoString() string {
	return s.String()
}

// The input for a GetReusableDelegationSet request.
type GetReusableDelegationSetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the reusable delegation set for which you want to get a list of
	// the name server.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReusableDelegationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReusableDelegationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReusableDelegationSetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the response to the GetReusableDelegationSet
// request.
type GetReusableDelegationSetOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the reusable delegation set.
	//
	// DelegationSet is a required field
	DelegationSet *DelegationSet `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReusableDelegationSetOutput) GoString() string {
	return s.String()
}

// Gets information about a specific traffic policy version. To get the information,
// send a GET request to the /2013-04-01/trafficpolicy resource, and specify
// the ID and the version of the traffic policy.
type GetTrafficPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the traffic policy that you want to get information about.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The version number of the traffic policy that you want to get information
	// about.
	//
	// Version is a required field
	Version *int64 `location:"uri" locationName:"Version" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTrafficPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTrafficPolicyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && *s.Version < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// To retrieve a count of all your traffic policy instances, send a GET request
// to the /2013-04-01/trafficpolicyinstancecount resource.
type GetTrafficPolicyInstanceCountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetTrafficPolicyInstanceCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInstanceCountInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the resource record sets that
// Amazon Route 53 created based on a specified traffic policy.
type GetTrafficPolicyInstanceCountOutput struct {
	_ struct{} `type:"structure"`

	// The number of traffic policy instances that are associated with the current
	// AWS account.
	//
	// TrafficPolicyInstanceCount is a required field
	TrafficPolicyInstanceCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyInstanceCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInstanceCountOutput) GoString() string {
	return s.String()
}

// Gets information about a specified traffic policy instance.
//
// To get information about a traffic policy instance, send a GET request to
// the /Amazon Route 53 API version/trafficpolicyinstance/Id resource.
type GetTrafficPolicyInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the traffic policy instance that you want to get information about.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTrafficPolicyInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTrafficPolicyInstanceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains information about the resource record sets that
// Amazon Route 53 created based on a specified traffic policy.
type GetTrafficPolicyInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the traffic policy instance.
	//
	// TrafficPolicyInstance is a required field
	TrafficPolicyInstance *TrafficPolicyInstance `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyInstanceOutput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the request.
type GetTrafficPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the specified traffic policy.
	//
	// TrafficPolicy is a required field
	TrafficPolicy *TrafficPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetTrafficPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrafficPolicyOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about one health check that is associated
// with the current AWS account.
type HealthCheck struct {
	_ struct{} `type:"structure"`

	// A unique string that you specified when you created the health check.
	//
	// CallerReference is a required field
	CallerReference *string `min:"1" type:"string" required:"true"`

	// A complex type that contains information about the CloudWatch alarm that
	// Amazon Route 53 is monitoring for this health check.
	CloudWatchAlarmConfiguration *CloudWatchAlarmConfiguration `type:"structure"`

	// A complex type that contains detailed information about one health check.
	//
	// HealthCheckConfig is a required field
	HealthCheckConfig *HealthCheckConfig `type:"structure" required:"true"`

	// The version of the health check. You can optionally pass this value in a
	// call to UpdateHealthCheck to prevent overwriting another change to the health
	// check.
	//
	// HealthCheckVersion is a required field
	HealthCheckVersion *int64 `min:"1" type:"long" required:"true"`

	// The identifier that Amazon Route 53assigned to the health check when you
	// created it. When you add or update a resource record set, you use this value
	// to specify which health check to use. The value can be up to 64 characters
	// long.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s HealthCheck) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheck) GoString() string {
	return s.String()
}

// A complex type that contains information about the health check.
type HealthCheckConfig struct {
	_ struct{} `type:"structure"`

	// A complex type that identifies the CloudWatch alarm that you want Amazon
	// Route 53 health checkers to use to determine whether this health check is
	// healthy.
	AlarmIdentifier *AlarmIdentifier `type:"structure"`

	// (CALCULATED Health Checks Only) A complex type that contains one ChildHealthCheck
	// element for each health check that you want to associate with a CALCULATED
	// health check.
	ChildHealthChecks []*string `locationNameList:"ChildHealthCheck" type:"list"`

	// Specify whether you want Amazon Route 53 to send the value of FullyQualifiedDomainName
	// to the endpoint in the client_hello message during TLS negotiation. This
	// allows the endpoint to respond to HTTPS health check requests with the applicable
	// SSL/TLS certificate.
	//
	// Some endpoints require that HTTPS requests include the host name in the client_hello
	// message. If you don't enable SNI, the status of the health check will be
	// SSL alert handshake_failure. A health check can also have that status for
	// other reasons. If SNI is enabled and you're still getting the error, check
	// the SSL/TLS configuration on your endpoint and confirm that your certificate
	// is valid.
	//
	// The SSL/TLS certificate on your endpoint includes a domain name in the Common
	// Name field and possibly several more in the Subject Alternative Names field.
	// One of the domain names in the certificate should match the value that you
	// specify for FullyQualifiedDomainName. If the endpoint responds to the client_hello
	// message with a certificate that does not include the domain name that you
	// specified in FullyQualifiedDomainName, a health checker will retry the handshake.
	// In the second attempt, the health checker will omit FullyQualifiedDomainName
	// from the client_hello message.
	EnableSNI *bool `type:"boolean"`

	// The number of consecutive health checks that an endpoint must pass or fail
	// for Amazon Route 53 to change the current status of the endpoint from unhealthy
	// to healthy or vice versa. For more information, see How Amazon Route 53 Determines
	// Whether an Endpoint Is Healthy (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	// in the Amazon Route 53 Developer Guide.
	FailureThreshold *int64 `min:"1" type:"integer"`

	// Amazon Route 53 behavior depends on whether you specify a value for IPAddress.
	//
	// If you specifyIPAddress:
	//
	// The value that you want Amazon Route 53 to pass in the Host header in all
	// health checks except TCP health checks. This is typically the fully qualified
	// DNS name of the website that you are attempting to health check. When Amazon
	// Route 53 checks the health of an endpoint, here is how it constructs the
	// Host header:
	//
	//    * If you specify a value of 80 for Port and HTTP or HTTP_STR_MATCH for
	//    Type, Amazon Route 53 passes the value of FullyQualifiedDomainName to
	//    the endpoint in the Host header.
	//
	//    * If you specify a value of 443 for Port and HTTPS or HTTPS_STR_MATCH
	//    for Type, Amazon Route 53 passes the value of FullyQualifiedDomainName
	//    to the endpoint in the Host header.
	//
	//    * If you specify another value for Port and any value except TCP for Type,
	//    Amazon Route 53 passes FullyQualifiedDomainName:Port to the endpoint in
	//    the Host header.
	//
	// If you don't specify a value for FullyQualifiedDomainName, Amazon Route 53
	// substitutes the value of IPAddress in the Host header in each of the preceding
	// cases.
	//
	// If you don't specifyIPAddress:
	//
	// If you don't specify a value for IPAddress, Amazon Route 53 sends a DNS request
	// to the domain that you specify in FullyQualifiedDomainName at the interval
	// you specify in RequestInterval. Using an IP address that DNS returns, Amazon
	// Route 53 then checks the health of the endpoint.
	//
	// If you want to check the health of weighted, latency, or failover resource
	// record sets and you choose to specify the endpoint only by FullyQualifiedDomainName,
	// we recommend that you create a separate health check for each endpoint. For
	// example, create a health check for each HTTP server that is serving content
	// for www.example.com. For the value of FullyQualifiedDomainName, specify the
	// domain name of the server (such as us-east-1-www.example.com), not the name
	// of the resource record sets (www.example.com).
	//
	// In this configuration, if you create a health check for which the value of
	// FullyQualifiedDomainName matches the name of the resource record sets and
	// you then associate the health check with those resource record sets, health
	// check results will be unpredictable.
	//
	// In addition, if the value that you specify for Type is HTTP, HTTPS, HTTP_STR_MATCH,
	// or HTTPS_STR_MATCH, Amazon Route 53 passes the value of FullyQualifiedDomainName
	// in the Host header, as it does when you specify a value for IPAddress. If
	// the value of Type is TCP, Amazon Route 53 doesn't pass a Host header.
	FullyQualifiedDomainName *string `type:"string"`

	// The number of child health checks that are associated with a CALCULATED health
	// that Amazon Route 53 must consider healthy for the CALCULATED health check
	// to be considered healthy. To specify the child health checks that you want
	// to associate with a CALCULATED health check, use the HealthCheckConfig$ChildHealthChecks
	// and HealthCheckConfig$ChildHealthChecks elements.
	//
	// Note the following:
	//
	//    * If you specify a number greater than the number of child health checks,
	//    Amazon Route 53 always considers this health check to be unhealthy.
	//
	//    * If you specify 0, Amazon Route 53 always considers this health check
	//    to be healthy.
	HealthThreshold *int64 `type:"integer"`

	// The IPv4 IP address of the endpoint on which you want Amazon Route 53 to
	// perform health checks. If you don't specify a value for IPAddress, Amazon
	// Route 53 sends a DNS request to resolve the domain name that you specify
	// in FullyQualifiedDomainName at the interval that you specify in RequestInterval.
	// Using an IP address that DNS returns, Amazon Route 53 then checks the health
	// of the endpoint.
	//
	// If the endpoint is an Amazon EC2 instance, we recommend that you create an
	// Elastic IP address, associate it with your Amazon EC2 instance, and specify
	// the Elastic IP address for IPAddress. This ensures that the IP address of
	// your instance will never change.
	//
	// For more information, see HealthCheckConfig$FullyQualifiedDomainName.
	//
	// Contraints: Amazon Route 53 cannot check the health of endpoints for which
	// the IP address is in local, private, non-routable, or multicast ranges. For
	// more information about IP addresses for which you cannot create health checks,
	// see RFC 5735, Special Use IPv4 Addresses (https://tools.ietf.org/html/rfc5735)
	// and RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space (https://tools.ietf.org/html/rfc6598).
	//
	// When the value of Type is CALCULATED or CLOUDWATCH_METRIC, omit IPAddress.
	IPAddress *string `type:"string"`

	// When CloudWatch has insufficient data about the metric to determine the alarm
	// state, the status that you want Amazon Route 53 to assign to the health check:
	//
	//    * Healthy: Amazon Route 53 considers the health check to be healthy.
	//
	//    * Unhealthy: Amazon Route 53 considers the health check to be unhealthy.
	//
	//    * LastKnownStatus: Amazon Route 53uses the status of the health check
	//    from the last time CloudWatch had sufficient data to determine the alarm
	//    state. For new health checks that have no last known status, the default
	//    status for the health check is healthy.
	InsufficientDataHealthStatus *string `type:"string" enum:"InsufficientDataHealthStatus"`

	// Specify whether you want Amazon Route 53 to invert the status of a health
	// check, for example, to consider a health check unhealthy when it otherwise
	// would be considered healthy.
	Inverted *bool `type:"boolean"`

	// Specify whether you want Amazon Route 53 to measure the latency between health
	// checkers in multiple AWS regions and your endpoint, and to display CloudWatch
	// latency graphs on the Health Checks page in the Amazon Route 53 console.
	//
	// You can't change the value of MeasureLatency after you create a health check.
	MeasureLatency *bool `type:"boolean"`

	// The port on the endpoint on which you want Amazon Route 53 to perform health
	// checks. Specify a value for Port only when you specify a value for IPAddress.
	Port *int64 `min:"1" type:"integer"`

	// A complex type that contains one Region element for each region from which
	// you want Amazon Route 53 health checkers to check the specified endpoint.
	Regions []*string `locationNameList:"Region" min:"1" type:"list"`

	// The number of seconds between the time that Amazon Route 53 gets a response
	// from your endpoint and the time that it sends the next health-check request.
	// Each Amazon Route 53 health checker makes requests at this interval.
	//
	// You can't change the value of RequestInterval after you create a health check.
	RequestInterval *int64 `min:"10" type:"integer"`

	// The path, if any, that you want Amazon Route 53 to request when performing
	// health checks. The path can be any value for which your endpoint will return
	// an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example,
	// the file /docs/route53-health-check.html.
	ResourcePath *string `type:"string"`

	// If the value of Type is HTTP_STR_MATCH or HTTP_STR_MATCH, the string that
	// you want Amazon Route 53 to search for in the response body from the specified
	// resource. If the string appears in the response body, Amazon Route 53 considers
	// the resource healthy.
	//
	// Amazon Route 53 considers case when searching for SearchString in the response
	// body.
	SearchString *string `type:"string"`

	// The type of health check that you want to create, which indicates how Amazon
	// Route 53 determines whether an endpoint is healthy.
	//
	// You can't change the value of Type after you create a health check.
	//
	// You can create the following types of health checks:
	//
	//    * HTTP: Amazon Route 53 tries to establish a TCP connection. If successful,
	//    Amazon Route 53 submits an HTTP request and waits for an HTTP status code
	//    of 200 or greater and less than 400.
	//
	//    * HTTPS: Amazon Route 53 tries to establish a TCP connection. If successful,
	//    Amazon Route 53 submits an HTTPS request and waits for an HTTP status
	//    code of 200 or greater and less than 400.
	//
	// If you specify HTTPS for the value of Type, the endpoint must support TLS
	//    v1.0 or later.
	//
	//    * HTTP_STR_MATCH: Amazon Route 53 tries to establish a TCP connection.
	//    If successful, Amazon Route 53 submits an HTTP request and searches the
	//    first 5,120 bytes of the response body for the string that you specify
	//    in SearchString.
	//
	//    * HTTPS_STR_MATCH: Amazon Route 53 tries to establish a TCP connection.
	//    If successful, Amazon Route 53 submits an HTTPS request and searches the
	//    first 5,120 bytes of the response body for the string that you specify
	//    in SearchString.
	//
	//    * TCP: Amazon Route 53 tries to establish a TCP connection.
	//
	//    * CLOUDWATCH_METRIC: The health check is associated with a CloudWatch
	//    alarm. If the state of the alarm is OK, the health check is considered
	//    healthy. If the state is ALARM, the health check is considered unhealthy.
	//    If CloudWatch doesn't have sufficient data to determine whether the state
	//    is OK or ALARM, the health check status depends on the setting for InsufficientDataHealthStatus:
	//    Healthy, Unhealthy, or LastKnownStatus.
	//
	//    * CALCULATED: For health checks that monitor the status of other health
	//    checks, Amazon Route 53 adds up the number of health checks that Amazon
	//    Route 53 health checkers consider to be healthy and compares that number
	//    with the value of HealthThreshold.
	//
	// For more information about how Amazon Route 53 determines whether an endpoint
	// is healthy, see the introduction to this topic.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"HealthCheckType"`
}

// String returns the string representation
func (s HealthCheckConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HealthCheckConfig"}
	if s.FailureThreshold != nil && *s.FailureThreshold < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FailureThreshold", 1))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Regions != nil && len(s.Regions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Regions", 1))
	}
	if s.RequestInterval != nil && *s.RequestInterval < 10 {
		invalidParams.Add(request.NewErrParamMinValue("RequestInterval", 10))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.AlarmIdentifier != nil {
		if err := s.AlarmIdentifier.Validate(); err != nil {
			invalidParams.AddNested("AlarmIdentifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the last failure reason as reported by one Amazon
// Route 53 health checker.
type HealthCheckObservation struct {
	_ struct{} `type:"structure"`

	// The IP address of the Amazon Route 53 health checker that provided the failure
	// reason in StatusReport.
	IPAddress *string `type:"string"`

	// The region of the Amazon Route 53 health checker that provided the status
	// in StatusReport.
	Region *string `min:"1" type:"string" enum:"HealthCheckRegion"`

	// A complex type that contains the last failure reason as reported by one Amazon
	// Route 53 health checker and the time of the failed health check.
	StatusReport *StatusReport `type:"structure"`
}

// String returns the string representation
func (s HealthCheckObservation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckObservation) GoString() string {
	return s.String()
}

// A complex type that contains general information about the hosted zone.
type HostedZone struct {
	_ struct{} `type:"structure"`

	// The value that you specified for CallerReference when you created the hosted
	// zone.
	//
	// CallerReference is a required field
	CallerReference *string `min:"1" type:"string" required:"true"`

	// A complex type that includes the Comment and PrivateZone elements. If you
	// omitted the HostedZoneConfig and Comment elements from the request, the Config
	// and Comment elements don't appear in the response.
	Config *HostedZoneConfig `type:"structure"`

	// The ID that Amazon Route 53 assigned to the hosted zone when you created
	// it.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The name of the domain. For public hosted zones, this is the name that you
	// have registered with your DNS registrar.
	//
	// For information about how to specify characters other than a-z, 0-9, and
	// - (hyphen) and how to specify internationalized domain names, see CreateHostedZone.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The number of resource record sets in the hosted zone.
	ResourceRecordSetCount *int64 `type:"long"`
}

// String returns the string representation
func (s HostedZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HostedZone) GoString() string {
	return s.String()
}

// A complex type that contains an optional comment about your hosted zone.
// If you don't want to specify a comment, omit both the HostedZoneConfig and
// Comment elements.
type HostedZoneConfig struct {
	_ struct{} `type:"structure"`

	// Any comments that you want to include about the hosted zone.
	Comment *string `type:"string"`

	// A value that indicates whether this is a private hosted zone.
	PrivateZone *bool `type:"boolean"`
}

// String returns the string representation
func (s HostedZoneConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HostedZoneConfig) GoString() string {
	return s.String()
}

// The input for a ListChangeBatchesByHostedZone request.
type ListChangeBatchesByHostedZoneInput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The end of the time period you want to see changes for.
	//
	// EndDate is a required field
	EndDate *string `location:"querystring" locationName:"endDate" deprecated:"true" type:"string" required:"true"`

	// The ID of the hosted zone that you want to see changes for.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The page marker.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The maximum number of items on a page.
	MaxItems *string `location:"querystring" locationName:"maxItems" type:"string"`

	// The start of the time period you want to see changes for.
	//
	// StartDate is a required field
	StartDate *string `location:"querystring" locationName:"startDate" deprecated:"true" type:"string" required:"true"`
}

// String returns the string representation
func (s ListChangeBatchesByHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeBatchesByHostedZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChangeBatchesByHostedZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChangeBatchesByHostedZoneInput"}
	if s.EndDate == nil {
		invalidParams.Add(request.NewErrParamRequired("EndDate"))
	}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.StartDate == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type containing the response information for the request.
type ListChangeBatchesByHostedZoneOutput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The change batches within the given hosted zone and time period.
	//
	// ChangeBatchRecords is a required field
	ChangeBatchRecords []*ChangeBatchRecord `locationNameList:"ChangeBatchRecord" min:"1" deprecated:"true" type:"list" required:"true"`

	// A flag that indicates if there are more change batches to list.
	IsTruncated *bool `type:"boolean"`

	// For the second and subsequent calls to ListHostedZones, Marker is the value
	// that you specified for the marker parameter in the request that produced
	// the current response.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value that you specified for the maxitems parameter in the call to ListHostedZones
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// The next page marker.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListChangeBatchesByHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeBatchesByHostedZoneOutput) GoString() string {
	return s.String()
}

// The input for a ListChangeBatchesByRRSet request.
type ListChangeBatchesByRRSetInput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The end of the time period you want to see changes for.
	//
	// EndDate is a required field
	EndDate *string `location:"querystring" locationName:"endDate" deprecated:"true" type:"string" required:"true"`

	// The ID of the hosted zone that you want to see changes for.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The page marker.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The maximum number of items on a page.
	MaxItems *string `location:"querystring" locationName:"maxItems" type:"string"`

	// The name of the RRSet that you want to see changes for.
	//
	// Name is a required field
	Name *string `location:"querystring" locationName:"rrSet_name" type:"string" required:"true"`

	// The identifier of the RRSet that you want to see changes for.
	SetIdentifier *string `location:"querystring" locationName:"identifier" min:"1" type:"string"`

	// The start of the time period you want to see changes for.
	//
	// StartDate is a required field
	StartDate *string `location:"querystring" locationName:"startDate" deprecated:"true" type:"string" required:"true"`

	// The type of the RRSet that you want to see changes for.
	//
	// Type is a required field
	Type *string `location:"querystring" locationName:"type" type:"string" required:"true" enum:"RRType"`
}

// String returns the string representation
func (s ListChangeBatchesByRRSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeBatchesByRRSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChangeBatchesByRRSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChangeBatchesByRRSetInput"}
	if s.EndDate == nil {
		invalidParams.Add(request.NewErrParamRequired("EndDate"))
	}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SetIdentifier != nil && len(*s.SetIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SetIdentifier", 1))
	}
	if s.StartDate == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDate"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The input for a ListChangeBatchesByRRSet request.
type ListChangeBatchesByRRSetOutput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The change batches within the given hosted zone and time period.
	//
	// ChangeBatchRecords is a required field
	ChangeBatchRecords []*ChangeBatchRecord `locationNameList:"ChangeBatchRecord" min:"1" deprecated:"true" type:"list" required:"true"`

	// A flag that indicates if there are more change batches to list.
	IsTruncated *bool `type:"boolean"`

	// The page marker.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The maximum number of items on a page.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// The next page marker.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListChangeBatchesByRRSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeBatchesByRRSetOutput) GoString() string {
	return s.String()
}

// To get a list of geographic locations that Amazon Route 53 supports for geolocation,
// send a GET request to the /Amazon Route 53 API version/geolocations resource.
// The response to this request includes a GeoLocationDetails element for each
// location that Amazon Route 53 supports.
//
// Countries are listed first, and continents are listed last. If Amazon Route
// 53 supports subdivisions for a country (for example, states or provinces),
// the subdivisions for that country are listed in alphabetical order immediately
// after the corresponding country.
type ListGeoLocationsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) The maximum number of geolocations to be included in the response
	// body for this request. If more than MaxItems geolocations remain to be listed,
	// then the value of the IsTruncated element in the response is true.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// The code for the continent with which you want to start listing locations
	// that Amazon Route 53 supports for geolocation. If Amazon Route 53 has already
	// returned a page or more of results, if IsTruncated is true, and if NextContinentCode
	// from the previous response has a value, enter that value in StartContinentCode
	// to return the next page of results.
	//
	// Include StartContinentCode only if you want to list continents. Don't include
	// StartContinentCode when you're listing countries or countries with their
	// subdivisions.
	StartContinentCode *string `location:"querystring" locationName:"startcontinentcode" min:"2" type:"string"`

	// The code for the country with which you want to start listing locations that
	// Amazon Route 53 supports for geolocation. If Amazon Route 53 has already
	// returned a page or more of results, if IsTruncated is true, and if NextCountryCode
	// from the previous response has a value, enter that value in StartCountryCode
	// to return the next page of results.
	//
	// Amazon Route 53 uses the two-letter country codes that are specified in ISO
	// standard 3166-1 alpha-2 (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
	StartCountryCode *string `location:"querystring" locationName:"startcountrycode" min:"1" type:"string"`

	// The code for the subdivision (for example, state or province) with which
	// you want to start listing locations that Amazon Route 53 supports for geolocation.
	// If Amazon Route 53 has already returned a page or more of results, if IsTruncated
	// is true, and if NextSubdivisionCode from the previous response has a value,
	// enter that value in StartSubdivisionCode to return the next page of results.
	//
	// To list subdivisions of a country, you must include both StartCountryCode
	// and StartSubdivisionCode.
	StartSubdivisionCode *string `location:"querystring" locationName:"startsubdivisioncode" min:"1" type:"string"`
}

// String returns the string representation
func (s ListGeoLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeoLocationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGeoLocationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGeoLocationsInput"}
	if s.StartContinentCode != nil && len(*s.StartContinentCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("StartContinentCode", 2))
	}
	if s.StartCountryCode != nil && len(*s.StartCountryCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartCountryCode", 1))
	}
	if s.StartSubdivisionCode != nil && len(*s.StartSubdivisionCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartSubdivisionCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type containing the response information for the request.
type ListGeoLocationsOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains one GeoLocationDetails element for each location
	// that Amazon Route 53 supports for geolocation.
	//
	// GeoLocationDetailsList is a required field
	GeoLocationDetailsList []*GeoLocationDetails `locationNameList:"GeoLocationDetails" type:"list" required:"true"`

	// A value that indicates whether more locations remain to be listed after the
	// last location in this response. If so, the value of IsTruncated is true.
	// To get more values, submit another request and include the values of NextContinentCode,
	// NextCountryCode, and NextSubdivisionCode in the StartContinentCode, StartCountryCode,
	// and StartSubdivisionCode, as applicable.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for MaxItems in the request.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, you can make a follow-up request to display more
	// locations. Enter the value of NextContinentCode in the StartContinentCode
	// parameter in another GETListGeoLocations request.
	NextContinentCode *string `min:"2" type:"string"`

	// If IsTruncated is true, you can make a follow-up request to display more
	// locations. Enter the value of NextCountryCode in the StartCountryCode parameter
	// in another GETListGeoLocations request.
	NextCountryCode *string `min:"1" type:"string"`

	// If IsTruncated is true, you can make a follow-up request to display more
	// locations. Enter the value of NextSubdivisionCode in the StartSubdivisionCode
	// parameter in another GETListGeoLocations request.
	NextSubdivisionCode *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGeoLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeoLocationsOutput) GoString() string {
	return s.String()
}

// To retrieve a list of your health checks, send a GET request to the /2013-04-01/healthcheck
// resource. The response to this request includes a HealthChecks element with
// zero or more HealthCheck child elements. By default, the list of health checks
// is displayed on a single page. You can control the length of the page that
// is displayed by using the MaxItems parameter. You can use the Marker parameter
// to control the health check that the list begins with.
//
// Amazon Route 53 returns a maximum of 100 items. If you set MaxItems to a
// value greater than 100, Amazon Route 53 returns only the first 100.
type ListHealthChecksInput struct {
	_ struct{} `type:"structure"`

	// If the response to a ListHealthChecks is more than one page, marker is the
	// health check ID for the first health check on the next page of results. For
	// more information, see ListHealthChecksResponse$MaxItems.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The maximum number of HealthCheck elements you want ListHealthChecks to return
	// on each page of the response body. If the AWS account includes more HealthCheck
	// elements than the value of maxitems, the response is broken into pages. Each
	// page contains the number of HealthCheck elements specified by maxitems.
	//
	// For example, suppose you specify 10 for maxitems and the current AWS account
	// has 51 health checks. In the response, ListHealthChecks sets ListHealthChecksResponse$IsTruncated
	// to true and includes the ListHealthChecksResponse$NextMarker element. To
	// access the second and subsequent pages, you resend the GETListHealthChecks
	// request, add the ListHealthChecksResponse$Marker parameter to the request,
	// and specify the value of the ListHealthChecksResponse$NextMarker element
	// from the previous response. On the last (sixth) page of the response, which
	// contains only one HealthCheck element:
	//
	//    * The value of ListHealthChecksResponse$IsTruncated is false.
	//
	//    * ListHealthChecksResponse$NextMarker is omitted.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`
}

// String returns the string representation
func (s ListHealthChecksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHealthChecksInput) GoString() string {
	return s.String()
}

// A complex type that contains the response to a ListHealthChecks request.
type ListHealthChecksOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains one HealthCheck element for each health check
	// that is associated with the current AWS account.
	//
	// HealthChecks is a required field
	HealthChecks []*HealthCheck `locationNameList:"HealthCheck" type:"list" required:"true"`

	// A flag that indicates whether there are more health checks to be listed.
	// If the response was truncated, you can get the next group of maxitems health
	// checks by calling ListHealthChecks again and specifying the value of the
	// NextMarker element in the marker parameter.
	//
	// Valid Values: true | false
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// For the second and subsequent calls to ListHealthChecks, Marker is the value
	// that you specified for the marker parameter in the previous request.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value that you specified for the maxitems parameter in the call to ListHealthChecks
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, the value of NextMarker identifies the first health
	// check in the next group of maxitems health checks. Call ListHealthChecks
	// again and specify the value of NextMarker in the marker parameter.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListHealthChecksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHealthChecksOutput) GoString() string {
	return s.String()
}

// To retrieve a list of your public and private hosted zones in ASCII order
// by domain name, send a GET request to the /Amazon Route 53 API version/hostedzonesbyname
// resource. The response to this request includes a HostedZone child element
// for each hosted zone that was created by the current AWS account. ListHostedZonesByName
// sorts hosted zones by name with the labels reversed, for example:
//
// com.example.www.
//
// Note the trailing dot, which can change the sort order in some circumstances.
//
// If the domain name includes escape characters or Punycode, ListHostedZonesByName
// alphabetizes the domain name using the escaped or Punycoded value, which
// is the format that Amazon Route 53 saves in its database. For example, to
// create a hosted zone for exämple.com, you specify ex\344mple.com for the
// domain name. ListHostedZonesByName alphabetizes it as: com.ex\344mple. The
// labels are reversed, and it's alphabetized using the escaped value. For more
// information about valid domain name formats, including internationalized
// domain names, see DNS Domain Name Format (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html)
// in the Amazon Route 53 Developer Guide.
//
// Amazon Route 53 returns up to 100 items in each response. If you have a lot
// of hosted zones, you can use the MaxItems parameter to list them in groups
// of up to 100. The response includes values that help you navigate from one
// group of MaxItems hosted zones to the next:
//
//    * The DNSName and HostedZoneId elements in the response contain the values,
//    if any, that you specified for the dnsname and hostedzoneid parameters
//    in the request that produced the current response.
//
//    * The MaxItems element in the response contains the value, if any, that
//    you specified for the maxitems parameter in the request that produced
//    the current response.
//
//    * If the value of IsTruncated in the response is true, there are more
//    hosted zones associated with the current Amazon Route 53 account.
//
// If IsTruncated is false, this response includes the last hosted zone that
//    is associated with the current account. The NextDNSName element and NextHostedZoneId
//    elements are omitted from the response.
//
//    * The NextDNSName and NextHostedZoneId elements in the response contain
//    the domain name and the hosted zone ID of the next hosted zone that is
//    associated with the current AWS account. If you want to list more hosted
//    zones, make another call to ListHostedZonesByName, and specify the value
//    of NextDNSName and NextHostedZoneId in the dnsname and hostedzoneid parameters,
//    respectively.
type ListHostedZonesByNameInput struct {
	_ struct{} `type:"structure"`

	// (Optional) For your first request to ListHostedZonesByName, include the dnsname
	// parameter only if you want to specify the name of the first hosted zone in
	// the response. If you don't include the dnsname parameter, Amazon Route 53
	// returns all of the hosted zones that were created by the current AWS account,
	// in ASCII order. For subsequent requests, include both dnsname and hostedzoneid
	// parameters. For dnsname, specify the value of NextDNSName from the previous
	// response.
	DNSName *string `location:"querystring" locationName:"dnsname" type:"string"`

	// (Optional) For your first request to ListHostedZonesByName, do not include
	// the hostedzoneid parameter.
	//
	// If you have more hosted zones than the value of maxitems, ListHostedZonesByName
	// returns only the first maxitems hosted zones. To get the next group of maxitems
	// hosted zones, submit another request to ListHostedZonesByName and include
	// both dnsname and hostedzoneid parameters. For the value of hostedzoneid,
	// specify the value of the NextHostedZoneId element from the previous response.
	HostedZoneId *string `location:"querystring" locationName:"hostedzoneid" type:"string"`

	// The maximum number of hosted zones to be included in the response body for
	// this request. If you have more than maxitems hosted zones, then the value
	// of the IsTruncated element in the response is true, and the values of NextDNSName
	// and NextHostedZoneId specify the first hosted zone in the next group of maxitems
	// hosted zones.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`
}

// String returns the string representation
func (s ListHostedZonesByNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesByNameInput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the request.
type ListHostedZonesByNameOutput struct {
	_ struct{} `type:"structure"`

	// For the second and subsequent calls to ListHostedZonesByName, DNSName is
	// the value that you specified for the dnsname parameter in the request that
	// produced the current response.
	DNSName *string `type:"string"`

	// The ID that Amazon Route 53 assigned to the hosted zone when you created
	// it.
	HostedZoneId *string `type:"string"`

	// A complex type that contains general information about the hosted zone.
	//
	// HostedZones is a required field
	HostedZones []*HostedZone `locationNameList:"HostedZone" type:"list" required:"true"`

	// A flag that indicates whether there are more hosted zones to be listed. If
	// the response was truncated, you can get the next group of maxitems hosted
	// zones by calling ListHostedZonesByName again and specifying the values of
	// NextDNSName and NextHostedZoneId elements in the dnsname and hostedzoneid
	// parameters.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the maxitems parameter in the call to ListHostedZonesByName
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, the value of NextDNSName is the name of the first
	// hosted zone in the next group of maxitems hosted zones. Call ListHostedZonesByName
	// again and specify the value of NextDNSName and NextHostedZoneId in the dnsname
	// and hostedzoneid parameters, respectively.
	//
	// This element is present only if IsTruncated is true.
	NextDNSName *string `type:"string"`

	// If IsTruncated is true, the value of NextHostedZoneId identifies the first
	// hosted zone in the next group of maxitems hosted zones. Call ListHostedZonesByName
	// again and specify the value of NextDNSName and NextHostedZoneId in the dnsname
	// and hostedzoneid parameters, respectively.
	//
	// This element is present only if IsTruncated is true.
	NextHostedZoneId *string `type:"string"`
}

// String returns the string representation
func (s ListHostedZonesByNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesByNameOutput) GoString() string {
	return s.String()
}

// To retrieve a list of your public and private hosted zones, send a GET request
// to the /2013-04-01/hostedzone resource. The response to this request includes
// a HostedZone child element for each hosted zone that was created by the current
// AWS account.
//
// Amazon Route 53 returns a maximum of 100 items in each response. If you have
// a lot of hosted zones, you can use the maxitems parameter to list them in
// groups of up to 100. The response includes four values that help you navigate
// from one group of maxitems hosted zones to the next:
//
//    * MaxItems is the value that you specified for the maxitems parameter
//    in the request that produced the current response.
//
//    * If the value of IsTruncated in the response is true, there are more
//    hosted zones associated with the current AWS account.
//
// If IsTruncated is false, this response includes the last hosted zone that
//    is associated with the current account.
//
//    * NextMarker is the hosted zone ID of the next hosted zone that is associated
//    with the current AWS account. If you want to list more hosted zones, make
//    another call to ListHostedZones, and specify the value of the NextMarker
//    element in the marker parameter.
//
// If IsTruncated is false, the NextMarker element is omitted from the response.
//
//    * If you're making the second or subsequent call to ListHostedZones, the
//    Marker element matches the value that you specified in the marker parameter
//    in the previous request.
type ListHostedZonesInput struct {
	_ struct{} `type:"structure"`

	// If you're using reusable delegation sets and you want to list all of the
	// hosted zones that are associated with a reusable delegation set, specify
	// the ID of that reusable delegation set.
	DelegationSetId *string `location:"querystring" locationName:"delegationsetid" type:"string"`

	// (Optional) If you have more hosted zones than the value of maxitems, ListHostedZones
	// returns only the first maxitems hosted zones. To get the next group of maxitems
	// hosted zones, submit another request to ListHostedZones. For the value of
	// marker, specify the value of the NextMarker element that was returned in
	// the previous response.
	//
	// Hosted zones are listed in the order in which they were created.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// (Optional) The maximum number of hosted zones to be included in the response
	// body for this request. If you have more than maxitems hosted zones, the value
	// of the IsTruncated element in the response is true, and the value of the
	// NextMarker element is the hosted zone ID of the first hosted zone in the
	// next group of maxitems hosted zones.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`
}

// String returns the string representation
func (s ListHostedZonesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesInput) GoString() string {
	return s.String()
}

type ListHostedZonesOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains general information about the hosted zone.
	//
	// HostedZones is a required field
	HostedZones []*HostedZone `locationNameList:"HostedZone" type:"list" required:"true"`

	// A flag indicating whether there are more hosted zones to be listed. If the
	// response was truncated, you can get the next group of maxitems hosted zones
	// by calling ListHostedZones again and specifying the value of the NextMarker
	// element in the marker parameter.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// For the second and subsequent calls to ListHostedZones, Marker is the value
	// that you specified for the marker parameter in the request that produced
	// the current response.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value that you specified for the maxitems parameter in the call to ListHostedZones
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, the value of NextMarker identifies the first hosted
	// zone in the next group of maxitems hosted zones. Call ListHostedZones again
	// and specify the value of NextMarker in the marker parameter.
	//
	// This element is present only if IsTruncated is true.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListHostedZonesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesOutput) GoString() string {
	return s.String()
}

// The input for a ListResourceRecordSets request.
type ListResourceRecordSetsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone that contains the resource record sets that you
	// want to get.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// (Optional) The maximum number of resource records sets to include in the
	// response body for this request. If the response includes more than maxitems
	// resource record sets, the value of the IsTruncated element in the response
	// is true, and the values of the NextRecordName and NextRecordType elements
	// in the response identify the first resource record set in the next group
	// of maxitems resource record sets.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// Weighted resource record sets only: If results were truncated for a given
	// DNS name and type, specify the value of NextRecordIdentifier from the previous
	// response to get the next resource record set that has the current DNS name
	// and type.
	StartRecordIdentifier *string `location:"querystring" locationName:"identifier" min:"1" type:"string"`

	// The first name in the lexicographic ordering of domain names that you want
	// the ListResourceRecordSets request to list.
	StartRecordName *string `location:"querystring" locationName:"name" type:"string"`

	// The type of resource record set to begin the record listing from.
	//
	// Valid values for basic resource record sets: A | AAAA | CNAME | MX | NAPTR
	// | NS | PTR | SOA | SPF | SRV | TXT
	//
	// Values for weighted, latency, geo, and failover resource record sets: A |
	// AAAA | CNAME | MX | NAPTR | PTR | SPF | SRV | TXT
	//
	// Values for alias resource record sets:
	//
	//    * CloudFront distribution: A
	//
	//    * Elastic Beanstalk environment that has a regionalized subdomain: A
	//
	//    * ELB load balancer: A | AAAA
	//
	//    * Amazon S3 bucket: A
	//
	// Constraint: Specifying type without specifying name returns an InvalidInput
	// error.
	StartRecordType *string `location:"querystring" locationName:"type" type:"string" enum:"RRType"`
}

// String returns the string representation
func (s ListResourceRecordSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceRecordSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceRecordSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceRecordSetsInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.StartRecordIdentifier != nil && len(*s.StartRecordIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartRecordIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains list information for the resource record set.
type ListResourceRecordSetsOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more resource record sets remain to be listed.
	// If your results were truncated, you can make a follow-up pagination request
	// by using the NextRecordName element.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The maximum number of records you requested.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// Weighted, latency, geolocation, and failover resource record sets only: If
	// results were truncated for a given DNS name and type, the value of SetIdentifier
	// for the next resource record set that has the current DNS name and type.
	NextRecordIdentifier *string `min:"1" type:"string"`

	// If the results were truncated, the name of the next record in the list.
	//
	// This element is present only if IsTruncated is true.
	NextRecordName *string `type:"string"`

	// If the results were truncated, the type of the next record in the list.
	//
	// This element is present only if IsTruncated is true.
	NextRecordType *string `type:"string" enum:"RRType"`

	// Information about multiple resource record sets.
	//
	// ResourceRecordSets is a required field
	ResourceRecordSets []*ResourceRecordSet `locationNameList:"ResourceRecordSet" type:"list" required:"true"`
}

// String returns the string representation
func (s ListResourceRecordSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceRecordSetsOutput) GoString() string {
	return s.String()
}

// To retrieve a list of your reusable delegation sets, send a GET request to
// the /2013-04-01/delegationset resource. The response to this request includes
// a DelegationSets element with zero or more DelegationSet child elements.
// By default, the list of reusable delegation sets is displayed on a single
// page. You can control the length of the page that is displayed by using the
// MaxItems parameter. You can use the Marker parameter to control the delegation
// set that the list begins with.
//
// Amazon Route 53 returns a maximum of 100 items. If you set MaxItems to a
// value greater than 100, Amazon Route 53 returns only the first 100.
type ListReusableDelegationSetsInput struct {
	_ struct{} `type:"structure"`

	// If you're making the second or subsequent call to ListReusableDelegationSets,
	// the Marker element matches the value that you specified in the marker parameter
	// in the previous request.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The value that you specified for the maxitems parameter in the request that
	// produced the current response.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`
}

// String returns the string representation
func (s ListReusableDelegationSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReusableDelegationSetsInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the reusable delegation sets
// that are associated with the current AWS account.
type ListReusableDelegationSetsOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains one DelegationSet element for each reusable
	// delegation set that was created by the current AWS account.
	//
	// DelegationSets is a required field
	DelegationSets []*DelegationSet `locationNameList:"DelegationSet" type:"list" required:"true"`

	// A flag that indicates whether there are more reusable delegation sets to
	// be listed. If the response is truncated, you can get the next group of maxitems
	// reusable delegation sets by calling ListReusableDelegationSets again and
	// specifying the value of the NextMarker element in the marker parameter.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// For the second and subsequent calls to ListReusableDelegationSets, Marker
	// is the value that you specified for the marker parameter in the request that
	// produced the current response.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value that you specified for the maxitems parameter in the call to ListReusableDelegationSets
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, the value of NextMarker identifies the first reusable
	// delegation set in the next group of maxitems reusable delegation sets. Call
	// ListReusableDelegationSets again and specify the value of NextMarker in the
	// marker parameter.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListReusableDelegationSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReusableDelegationSetsOutput) GoString() string {
	return s.String()
}

// A complex type containing information about a request for a list of the tags
// that are associated with an individual resource.
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resource for which you want to retrieve tags.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" type:"string" required:"true"`

	// The type of the resource.
	//
	//    * The resource type for health checks is healthcheck.
	//
	//    * The resource type for hosted zones is hostedzone.
	//
	// ResourceType is a required field
	ResourceType *string `location:"uri" locationName:"ResourceType" type:"string" required:"true" enum:"TagResourceType"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains information about the health checks or hosted
// zones for which you want to list tags.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A ResourceTagSet containing tags associated with the specified resource.
	//
	// ResourceTagSet is a required field
	ResourceTagSet *ResourceTagSet `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the health checks or hosted
// zones for which you want to list tags.
type ListTagsForResourcesInput struct {
	_ struct{} `locationName:"ListTagsForResourcesRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A complex type that contains the ResourceId element for each resource for
	// which you want to get a list of tags.
	//
	// ResourceIds is a required field
	ResourceIds []*string `locationNameList:"ResourceId" min:"1" type:"list" required:"true"`

	// The type of the resources.
	//
	//    * The resource type for health checks is healthcheck.
	//
	//    * The resource type for hosted zones is hostedzone.
	//
	// ResourceType is a required field
	ResourceType *string `location:"uri" locationName:"ResourceType" type:"string" required:"true" enum:"TagResourceType"`
}

// String returns the string representation
func (s ListTagsForResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourcesInput"}
	if s.ResourceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIds"))
	}
	if s.ResourceIds != nil && len(s.ResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIds", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type containing tags for the specified resources.
type ListTagsForResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of ResourceTagSets containing tags associated with the specified resources.
	//
	// ResourceTagSets is a required field
	ResourceTagSets []*ResourceTagSet `locationNameList:"ResourceTagSet" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourcesOutput) GoString() string {
	return s.String()
}

// A complex type that contains the information about the request to list the
// traffic policies that are associated with the current AWS account.
type ListTrafficPoliciesInput struct {
	_ struct{} `type:"structure"`

	// (Optional) The maximum number of traffic policies to be included in the response
	// body for this request. If you have more than MaxItems traffic policies, the
	// value of the IsTruncated element in the response is true, and the value of
	// the TrafficPolicyIdMarker element is the ID of the first traffic policy in
	// the next group of MaxItems traffic policies.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// (Conditional) For your first request to ListTrafficPolicies, do not include
	// the TrafficPolicyIdMarker parameter.
	//
	// If you have more traffic policies than the value of MaxItems, ListTrafficPolicies
	// returns only the first MaxItems traffic policies. To get the next group of
	// MaxItems policies, submit another request to ListTrafficPolicies. For the
	// value of TrafficPolicyIdMarker, specify the value of the TrafficPolicyIdMarker
	// element that was returned in the previous response.
	//
	// Policies are listed in the order in which they were created.
	TrafficPolicyIdMarker *string `location:"querystring" locationName:"trafficpolicyid" type:"string"`
}

// String returns the string representation
func (s ListTrafficPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPoliciesInput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the request.
type ListTrafficPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more traffic policies to be listed.
	// If the response was truncated, you can get the next group of MaxItems traffic
	// policies by calling ListTrafficPolicies again and specifying the value of
	// the TrafficPolicyIdMarker element in the TrafficPolicyIdMarker request parameter.
	//
	// Valid Values: true | false
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the MaxItems parameter in the call to ListTrafficPolicies
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If the value of IsTruncated is true, TrafficPolicyIdMarker is the ID of the
	// first traffic policy in the next group of MaxItems traffic policies.
	//
	// TrafficPolicyIdMarker is a required field
	TrafficPolicyIdMarker *string `type:"string" required:"true"`

	// A list that contains one TrafficPolicySummary element for each traffic policy
	// that was created by the current AWS account.
	//
	// TrafficPolicySummaries is a required field
	TrafficPolicySummaries []*TrafficPolicySummary `locationNameList:"TrafficPolicySummary" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrafficPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPoliciesOutput) GoString() string {
	return s.String()
}

// A request for the traffic policy instances that you created in a specified
// hosted zone.
type ListTrafficPolicyInstancesByHostedZoneInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone for which you want to list traffic policy instances.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"querystring" locationName:"id" type:"string" required:"true"`

	// The maximum number of traffic policy instances to be included in the response
	// body for this request. If you have more than MaxItems traffic policy instances,
	// the value of the IsTruncated element in the response is true, and the values
	// of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
	// represent the first traffic policy instance in the next group of MaxItems
	// traffic policy instances.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// For the first request to ListTrafficPolicyInstancesByHostedZone, omit this
	// value.
	//
	// If the value of IsTruncated in the previous response was true, TrafficPolicyInstanceNameMarker
	// is the name of the first traffic policy instance in the next group of MaxItems
	// traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get for this hosted zone.
	//
	// If the value of IsTruncated in the previous response was false, omit this
	// value.
	TrafficPolicyInstanceNameMarker *string `location:"querystring" locationName:"trafficpolicyinstancename" type:"string"`

	// For the first request to ListTrafficPolicyInstancesByHostedZone, omit this
	// value.
	//
	// If the value of IsTruncated in the previous response was true, TrafficPolicyInstanceTypeMarker
	// is the DNS type of the first traffic policy instance in the next group of
	// MaxItems traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get for this hosted zone.
	TrafficPolicyInstanceTypeMarker *string `location:"querystring" locationName:"trafficpolicyinstancetype" type:"string" enum:"RRType"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesByHostedZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrafficPolicyInstancesByHostedZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrafficPolicyInstancesByHostedZoneInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the response information for the request.
type ListTrafficPolicyInstancesByHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more traffic policy instances to
	// be listed. If the response was truncated, you can get the next group of MaxItems
	// traffic policy instances by calling ListTrafficPolicyInstancesByHostedZone
	// again and specifying the values of the HostedZoneIdMarker, TrafficPolicyInstanceNameMarker,
	// and TrafficPolicyInstanceTypeMarker elements in the corresponding request
	// parameters.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the MaxItems parameter in the call to ListTrafficPolicyInstancesByHostedZone
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, TrafficPolicyInstanceNameMarker is the name of the
	// first traffic policy instance in the next group of MaxItems traffic policy
	// instances.
	TrafficPolicyInstanceNameMarker *string `type:"string"`

	// If IsTruncated is true, TrafficPolicyInstanceTypeMarker is the DNS type of
	// the resource record sets that are associated with the first traffic policy
	// instance in the next group of MaxItems traffic policy instances.
	TrafficPolicyInstanceTypeMarker *string `type:"string" enum:"RRType"`

	// A list that contains one TrafficPolicyInstance element for each traffic policy
	// instance that matches the elements in the request.
	//
	// TrafficPolicyInstances is a required field
	TrafficPolicyInstances []*TrafficPolicyInstance `locationNameList:"TrafficPolicyInstance" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesByHostedZoneOutput) GoString() string {
	return s.String()
}

// A complex type that contains the information about the request to list your
// traffic policy instances.
type ListTrafficPolicyInstancesByPolicyInput struct {
	_ struct{} `type:"structure"`

	// For the first request to ListTrafficPolicyInstancesByPolicy, omit this value.
	//
	// If the value of IsTruncated in the previous response was true, HostedZoneIdMarker
	// is the ID of the hosted zone for the first traffic policy instance in the
	// next group of MaxItems traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get for this hosted zone.
	//
	// If the value of IsTruncated in the previous response was false, omit this
	// value.
	HostedZoneIdMarker *string `location:"querystring" locationName:"hostedzoneid" type:"string"`

	// The maximum number of traffic policy instances to be included in the response
	// body for this request. If you have more than MaxItems traffic policy instances,
	// the value of the IsTruncated element in the response is true, and the values
	// of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
	// represent the first traffic policy instance in the next group of MaxItems
	// traffic policy instances.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// The ID of the traffic policy for which you want to list traffic policy instances.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `location:"querystring" locationName:"id" type:"string" required:"true"`

	// For the first request to ListTrafficPolicyInstancesByPolicy, omit this value.
	//
	// If the value of IsTruncated in the previous response was true, TrafficPolicyInstanceNameMarker
	// is the name of the first traffic policy instance in the next group of MaxItems
	// traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get for this hosted zone.
	//
	// If the value of IsTruncated in the previous response was false, omit this
	// value.
	TrafficPolicyInstanceNameMarker *string `location:"querystring" locationName:"trafficpolicyinstancename" type:"string"`

	// For the first request to ListTrafficPolicyInstancesByPolicy, omit this value.
	//
	// If the value of IsTruncated in the previous response was true, TrafficPolicyInstanceTypeMarker
	// is the DNS type of the first traffic policy instance in the next group of
	// MaxItems traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get for this hosted zone.
	TrafficPolicyInstanceTypeMarker *string `location:"querystring" locationName:"trafficpolicyinstancetype" type:"string" enum:"RRType"`

	// The version of the traffic policy for which you want to list traffic policy
	// instances. The version must be associated with the traffic policy that is
	// specified by TrafficPolicyId.
	//
	// TrafficPolicyVersion is a required field
	TrafficPolicyVersion *int64 `location:"querystring" locationName:"version" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesByPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrafficPolicyInstancesByPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrafficPolicyInstancesByPolicyInput"}
	if s.TrafficPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyId"))
	}
	if s.TrafficPolicyVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyVersion"))
	}
	if s.TrafficPolicyVersion != nil && *s.TrafficPolicyVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TrafficPolicyVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the response information for the request.
type ListTrafficPolicyInstancesByPolicyOutput struct {
	_ struct{} `type:"structure"`

	// If IsTruncated is true, HostedZoneIdMarker is the ID of the hosted zone of
	// the first traffic policy instance in the next group of MaxItems traffic policy
	// instances.
	HostedZoneIdMarker *string `type:"string"`

	// A flag that indicates whether there are more traffic policy instances to
	// be listed. If the response was truncated, you can get the next group of MaxItems
	// traffic policy instances by calling ListTrafficPolicyInstancesByPolicy again
	// and specifying the values of the HostedZoneIdMarker, TrafficPolicyInstanceNameMarker,
	// and TrafficPolicyInstanceTypeMarker elements in the corresponding request
	// parameters.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the MaxItems parameter in the call to ListTrafficPolicyInstancesByPolicy
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, TrafficPolicyInstanceNameMarker is the name of the
	// first traffic policy instance in the next group of MaxItems traffic policy
	// instances.
	TrafficPolicyInstanceNameMarker *string `type:"string"`

	// If IsTruncated is true, TrafficPolicyInstanceTypeMarker is the DNS type of
	// the resource record sets that are associated with the first traffic policy
	// instance in the next group of MaxItems traffic policy instances.
	TrafficPolicyInstanceTypeMarker *string `type:"string" enum:"RRType"`

	// A list that contains one TrafficPolicyInstance element for each traffic policy
	// instance that matches the elements in the request.
	//
	// TrafficPolicyInstances is a required field
	TrafficPolicyInstances []*TrafficPolicyInstance `locationNameList:"TrafficPolicyInstance" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesByPolicyOutput) GoString() string {
	return s.String()
}

// A complex type that contains the information about the request to list your
// traffic policy instances.
type ListTrafficPolicyInstancesInput struct {
	_ struct{} `type:"structure"`

	// For the first request to ListTrafficPolicyInstances, omit this value.
	//
	// If the value of IsTruncated in the previous response was true, you have more
	// traffic policy instances. To get the next group of MaxItems traffic policy
	// instances, submit another ListTrafficPolicyInstances request. For the value
	// of HostedZoneIdMarker, specify the value of HostedZoneIdMarker from the previous
	// response, which is the hosted zone ID of the first traffic policy instance
	// in the next group of MaxItems traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	HostedZoneIdMarker *string `location:"querystring" locationName:"hostedzoneid" type:"string"`

	// The maximum number of traffic policy instances to be included in the response
	// body for this request. If you have more than MaxItems traffic policy instances,
	// the value of the IsTruncated element in the response is true, and the values
	// of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
	// represent the first traffic policy instance in the next group of MaxItems
	// traffic policy instances.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// For the first request to ListTrafficPolicyInstances, omit this value.
	//
	// If the value of IsTruncated in the previous response was true, TrafficPolicyInstanceNameMarker
	// is the name of the first traffic policy instance in the next group of MaxItems
	// traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	TrafficPolicyInstanceNameMarker *string `location:"querystring" locationName:"trafficpolicyinstancename" type:"string"`

	// For the first request to ListTrafficPolicyInstances, omit this value.
	//
	// If the value of IsTruncated in the previous response was true, TrafficPolicyInstanceTypeMarker
	// is the DNS type of the first traffic policy instance in the next group of
	// MaxItems traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	TrafficPolicyInstanceTypeMarker *string `location:"querystring" locationName:"trafficpolicyinstancetype" type:"string" enum:"RRType"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesInput) GoString() string {
	return s.String()
}

// A complex type that contains the response information for the request.
type ListTrafficPolicyInstancesOutput struct {
	_ struct{} `type:"structure"`

	// If IsTruncated is true, HostedZoneIdMarker is the ID of the hosted zone of
	// the first traffic policy instance in the next group of MaxItems traffic policy
	// instances.
	HostedZoneIdMarker *string `type:"string"`

	// A flag that indicates whether there are more traffic policy instances to
	// be listed. If the response was truncated, you can get the next group of MaxItems
	// traffic policy instances by calling ListTrafficPolicyInstances again and
	// specifying the values of the HostedZoneIdMarker, TrafficPolicyInstanceNameMarker,
	// and TrafficPolicyInstanceTypeMarker elements in the corresponding request
	// parameters.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the MaxItems parameter in the call to ListTrafficPolicyInstances
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, TrafficPolicyInstanceNameMarker is the name of the
	// first traffic policy instance in the next group of MaxItems traffic policy
	// instances.
	TrafficPolicyInstanceNameMarker *string `type:"string"`

	// If IsTruncated is true, TrafficPolicyInstanceTypeMarker is the DNS type of
	// the resource record sets that are associated with the first traffic policy
	// instance in the next group of MaxItems traffic policy instances.
	TrafficPolicyInstanceTypeMarker *string `type:"string" enum:"RRType"`

	// A list that contains one TrafficPolicyInstance element for each traffic policy
	// instance that matches the elements in the request.
	//
	// TrafficPolicyInstances is a required field
	TrafficPolicyInstances []*TrafficPolicyInstance `locationNameList:"TrafficPolicyInstance" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyInstancesOutput) GoString() string {
	return s.String()
}

// A complex type that contains the information about the request to list your
// traffic policies.
type ListTrafficPolicyVersionsInput struct {
	_ struct{} `type:"structure"`

	// Specify the value of Id of the traffic policy for which you want to list
	// all versions.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The maximum number of traffic policy versions that you want Amazon Route
	// 53 to include in the response body for this request. If the specified traffic
	// policy has more than MaxItems versions, the value of the IsTruncated element
	// in the response is true, and the value of the TrafficPolicyVersionMarker
	// element is the ID of the first version in the next group of MaxItems traffic
	// policy versions.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// For your first request to ListTrafficPolicyVersions, do not include the TrafficPolicyVersionMarker
	// parameter.
	//
	// If you have more traffic policy versions than the value of MaxItems, ListTrafficPolicyVersions
	// returns only the first group of MaxItems versions. To get the next group
	// of MaxItems traffic policy versions, submit another request to ListTrafficPolicyVersions.
	// For the value of TrafficPolicyVersionMarker, specify the value of the TrafficPolicyVersionMarker
	// element that was returned in the previous response.
	//
	// Traffic policy versions are listed in sequential order.
	TrafficPolicyVersionMarker *string `location:"querystring" locationName:"trafficpolicyversion" type:"string"`
}

// String returns the string representation
func (s ListTrafficPolicyVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrafficPolicyVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrafficPolicyVersionsInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the response information for the request.
type ListTrafficPolicyVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more traffic policies to be listed.
	// If the response was truncated, you can get the next group of maxitems traffic
	// policies by calling ListTrafficPolicyVersions again and specifying the value
	// of the NextMarker element in the marker parameter.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the maxitems parameter in the call to ListTrafficPolicyVersions
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// A list that contains one TrafficPolicy element for each traffic policy version
	// that is associated with the specified traffic policy.
	//
	// TrafficPolicies is a required field
	TrafficPolicies []*TrafficPolicy `locationNameList:"TrafficPolicy" type:"list" required:"true"`

	// If IsTruncated is true, the value of TrafficPolicyVersionMarker identifies
	// the first traffic policy in the next group of MaxItems traffic policies.
	// Call ListTrafficPolicyVersions again and specify the value of TrafficPolicyVersionMarker
	// in the TrafficPolicyVersionMarker request parameter.
	//
	// This element is present only if IsTruncated is true.
	//
	// TrafficPolicyVersionMarker is a required field
	TrafficPolicyVersionMarker *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrafficPolicyVersionsOutput) GoString() string {
	return s.String()
}

// Information specific to the resource record.
//
// If you are creating an alias resource record set, omit ResourceRecord.
type ResourceRecord struct {
	_ struct{} `type:"structure"`

	// The current or new DNS record value, not to exceed 4,000 characters. In the
	// case of a DELETE action, if the current value does not match the actual value,
	// an error is returned. For descriptions about how to format Value for different
	// record types, see Supported DNS Resource Record Types (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// You can specify more than one value for all record types except CNAME and
	// SOA.
	//
	// If you are creating an alias resource record set, omit Value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceRecord) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceRecord) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceRecord"}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the resource record set to create or delete.
type ResourceRecordSet struct {
	_ struct{} `type:"structure"`

	// Alias resource record sets only: Information about the CloudFront distribution,
	// Elastic Beanstalk environment, ELB load balancer, Amazon S3 bucket, or Amazon
	// Route 53 resource record set to which you are redirecting queries. The Elastic
	// Beanstalk environment must have a regionalized subdomain.
	//
	// If you're creating resource records sets for a private hosted zone, note
	// the following:
	//
	//    * You can't create alias resource record sets for CloudFront distributions
	//    in a private hosted zone.
	//
	//    * Creating geolocation alias resource record sets or latency alias resource
	//    record sets in a private hosted zone is unsupported.
	//
	//    * For information about creating failover resource record sets in a private
	//    hosted zone, see Configuring Failover in a Private Hosted Zone (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html)
	//    in the Amazon Route 53 Developer Guide.
	AliasTarget *AliasTarget `type:"structure"`

	// Failover resource record sets only: To configure failover, you add the Failover
	// element to two resource record sets. For one resource record set, you specify
	// PRIMARY as the value for Failover; for the other resource record set, you
	// specify SECONDARY. In addition, you include the HealthCheckId element and
	// specify the health check that you want Amazon Route 53 to perform for each
	// resource record set.
	//
	// Except where noted, the following failover behaviors assume that you have
	// included the HealthCheckId element in both resource record sets:
	//
	//    * When the primary resource record set is healthy, Amazon Route 53 responds
	//    to DNS queries with the applicable value from the primary resource record
	//    set regardless of the health of the secondary resource record set.
	//
	//    * When the primary resource record set is unhealthy and the secondary
	//    resource record set is healthy, Amazon Route 53 responds to DNS queries
	//    with the applicable value from the secondary resource record set.
	//
	//    * When the secondary resource record set is unhealthy, Amazon Route 53
	//    responds to DNS queries with the applicable value from the primary resource
	//    record set regardless of the health of the primary resource record set.
	//
	//    * If you omit the HealthCheckId element for the secondary resource record
	//    set, and if the primary resource record set is unhealthy, Amazon Route
	//    53 always responds to DNS queries with the applicable value from the secondary
	//    resource record set. This is true regardless of the health of the associated
	//    endpoint.
	//
	// You cannot create non-failover resource record sets that have the same values
	// for the Name and Type elements as failover resource record sets.
	//
	// For failover alias resource record sets, you must also include the EvaluateTargetHealth
	// element and set the value to true.
	//
	// For more information about configuring failover for Amazon Route 53, see
	// the following topics in the Amazon Route 53 Developer Guide:
	//
	//    * Amazon Route 53 Health Checks and DNS Failover (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html)
	//
	//    * Configuring Failover in a Private Hosted Zone (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html)
	//
	// Valid values: PRIMARY | SECONDARY
	Failover *string `type:"string" enum:"ResourceRecordSetFailover"`

	// Geo location resource record sets only: A complex type that lets you control
	// how Amazon Route 53 responds to DNS queries based on the geographic origin
	// of the query. For example, if you want all queries from Africa to be routed
	// to a web server with an IP address of 192.0.2.111, create a resource record
	// set with a Type of A and a ContinentCode of AF.
	//
	// Creating geolocation and geolocation alias resource record sets in private
	// hosted zones is not supported.
	//
	// If you create separate resource record sets for overlapping geographic regions
	// (for example, one resource record set for a continent and one for a country
	// on the same continent), priority goes to the smallest geographic region.
	// This allows you to route most queries for a continent to one resource and
	// to route queries for a country on that continent to a different resource.
	//
	// You cannot create two geolocation resource record sets that specify the same
	// geographic location.
	//
	// The value * in the CountryCode element matches all geographic locations that
	// aren't specified in other geolocation resource record sets that have the
	// same values for the Name and Type elements.
	//
	// Geolocation works by mapping IP addresses to locations. However, some IP
	// addresses aren't mapped to geographic locations, so even if you create geolocation
	// resource record sets that cover all seven continents, Amazon Route 53 will
	// receive some DNS queries from locations that it can't identify. We recommend
	// that you create a resource record set for which the value of CountryCode
	// is *, which handles both queries that come from locations for which you haven't
	// created geolocation resource record sets and queries from IP addresses that
	// aren't mapped to a location. If you don't create a * resource record set,
	// Amazon Route 53 returns a "no answer" response for queries from those locations.
	//
	// You cannot create non-geolocation resource record sets that have the same
	// values for the Name and Type elements as geolocation resource record sets.
	GeoLocation *GeoLocation `type:"structure"`

	// If you want Amazon Route 53 to return this resource record set in response
	// to a DNS query only when a health check is passing, include the HealthCheckId
	// element and specify the ID of the applicable health check.
	//
	// Amazon Route 53 determines whether a resource record set is healthy based
	// on one of the following:
	//
	//    * By periodically sending a request to the endpoint that is specified
	//    in the health check
	//
	//    * By aggregating the status of a specified group of health checks (calculated
	//    health checks)
	//
	//    * By determining the current state of a CloudWatch alarm (CloudWatch metric
	//    health checks)
	//
	// For information about how Amazon Route 53 determines whether a health check
	// is healthy, see CreateHealthCheck.
	//
	// The HealthCheckId element is only useful when Amazon Route 53 is choosing
	// between two or more resource record sets to respond to a DNS query, and you
	// want Amazon Route 53 to base the choice in part on the status of a health
	// check. Configuring health checks only makes sense in the following configurations:
	//
	//    * You're checking the health of the resource record sets in a weighted,
	//    latency, geolocation, or failover resource record set, and you specify
	//    health check IDs for all of the resource record sets. If the health check
	//    for one resource record set specifies an endpoint that is not healthy,
	//    Amazon Route 53 stops responding to queries using the value for that resource
	//    record set.
	//
	//    * You set EvaluateTargetHealth to true for the resource record sets in
	//    an alias, weighted alias, latency alias, geolocation alias, or failover
	//    alias resource record set, and you specify health check IDs for all of
	//    the resource record sets that are referenced by the alias resource record
	//    sets.
	//
	// Amazon Route 53 doesn't check the health of the endpoint specified in the
	// resource record set, for example, the endpoint specified by the IP address
	// in the Value element. When you add a HealthCheckId element to a resource
	// record set, Amazon Route 53 checks the health of the endpoint that you specified
	// in the health check.
	//
	// For geolocation resource record sets, if an endpoint is unhealthy, Amazon
	// Route 53 looks for a resource record set for the larger, associated geographic
	// region. For example, suppose you have resource record sets for a state in
	// the United States, for the United States, for North America, and for all
	// locations. If the endpoint for the state resource record set is unhealthy,
	// Amazon Route 53 checks the resource record sets for the United States, for
	// North America, and for all locations (a resource record set for which the
	// value of CountryCode is *), in that order, until it finds a resource record
	// set for which the endpoint is healthy.
	//
	// If your health checks specify the endpoint only by domain name, we recommend
	// that you create a separate health check for each endpoint. For example, create
	// a health check for each HTTP server that is serving content for www.example.com.
	// For the value of FullyQualifiedDomainName, specify the domain name of the
	// server (such as us-east-1-www.example.com), not the name of the resource
	// record sets (example.com).
	//
	// n this configuration, if you create a health check for which the value of
	// FullyQualifiedDomainName matches the name of the resource record sets and
	// then associate the health check with those resource record sets, health check
	// results will be unpredictable.
	//
	// For more information, see the following topics in the Amazon Route 53 Developer
	// Guide:
	//
	//    * Amazon Route 53 Health Checks and DNS Failover (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html)
	//
	//    * Configuring Failover in a Private Hosted Zone (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html)
	HealthCheckId *string `type:"string"`

	// The name of the domain you want to perform the action on.
	//
	// Enter a fully qualified domain name, for example, www.example.com. You can
	// optionally include a trailing dot. If you omit the trailing dot, Amazon Route
	// 53 still assumes that the domain name that you specify is fully qualified.
	// This means that Amazon Route 53 treats www.example.com (without a trailing
	// dot) and www.example.com. (with a trailing dot) as identical.
	//
	// For information about how to specify characters other than a-z, 0-9, and
	// - (hyphen) and how to specify internationalized domain names, see DNS Domain
	// Name Format (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// You can use the asterisk (*) wildcard to replace the leftmost label in a
	// domain name. For example, *.example.com. Note the following:
	//
	//    * The * must replace the entire label. For example, you can't specify
	//    *prod.example.com or prod*.example.com.
	//
	//    * The * can't replace any of the middle labels, for example, marketing.*.example.com.
	//
	//    * If you include * in any position other than the leftmost label in a
	//    domain name, DNS treats it as an * character (ASCII 42), not as a wildcard.
	//
	// You can't use the * wildcard for resource records sets that have a type of
	//    NS.
	//
	// You can use the * wildcard as the leftmost label in a domain name, for example,
	// *.example.com. You cannot use an * for one of the middle labels, for example,
	// marketing.*.example.com. In addition, the * must replace the entire label;
	// for example, you can't specify prod*.example.com.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Latency-based resource record sets only: The Amazon EC2 region where the
	// resource that is specified in this resource record set resides. The resource
	// typically is an AWS resource, such as an Amazon EC2 instance or an ELB load
	// balancer, and is referred to by an IP address or a DNS domain name, depending
	// on the record type.
	//
	// Creating latency and latency alias resource record sets in private hosted
	// zones is not supported.
	//
	// When Amazon Route 53 receives a DNS query for a domain name and type for
	// which you have created latency resource record sets, Amazon Route 53 selects
	// the latency resource record set that has the lowest latency between the end
	// user and the associated Amazon EC2 region. Amazon Route 53 then returns the
	// value that is associated with the selected resource record set.
	//
	// Note the following:
	//
	//    * You can only specify one ResourceRecord per latency resource record
	//    set.
	//
	//    * You can only create one latency resource record set for each Amazon
	//    EC2 region.
	//
	//    * You are not required to create latency resource record sets for all
	//    Amazon EC2 regions. Amazon Route 53 will choose the region with the best
	//    latency from among the regions for which you create latency resource record
	//    sets.
	//
	//    * You cannot create non-latency resource record sets that have the same
	//    values for the Name and Type elements as latency resource record sets.
	Region *string `min:"1" type:"string" enum:"ResourceRecordSetRegion"`

	// Information about the resource records to act upon.
	//
	// If you are creating an alias resource record set, omit ResourceRecords.
	ResourceRecords []*ResourceRecord `locationNameList:"ResourceRecord" min:"1" type:"list"`

	// Weighted, Latency, Geo, and Failover resource record sets only: An identifier
	// that differentiates among multiple resource record sets that have the same
	// combination of DNS name and type. The value of SetIdentifier must be unique
	// for each resource record set that has the same combination of DNS name and
	// type. Omit SetIdentifier for any other types of record sets.
	SetIdentifier *string `min:"1" type:"string"`

	// The resource record cache time to live (TTL), in seconds. Note the following:
	//
	//    * If you're creating an alias resource record set, omit TTL. Amazon Route
	//    53 uses the value of TTL for the alias target.
	//
	//    * If you're associating this resource record set with a health check (if
	//    you're adding a HealthCheckId element), we recommend that you specify
	//    a TTL of 60 seconds or less so clients respond quickly to changes in health
	//    status.
	//
	//    * All of the resource record sets in a group of weighted, latency, geolocation,
	//    or failover resource record sets must have the same value for TTL.
	//
	//    * If a group of weighted resource record sets includes one or more weighted
	//    alias resource record sets for which the alias target is an ELB load balancer,
	//    we recommend that you specify a TTL of 60 seconds for all of the non-alias
	//    weighted resource record sets that have the same name and type. Values
	//    other than 60 seconds (the TTL for load balancers) will change the effect
	//    of the values that you specify for Weight.
	TTL *int64 `type:"long"`

	// When you create a traffic policy instance, Amazon Route 53 automatically
	// creates a resource record set. TrafficPolicyInstanceId is the ID of the traffic
	// policy instance that Amazon Route 53 created this resource record set for.
	//
	// To delete the resource record set that is associated with a traffic policy
	// instance, use DeleteTrafficPolicyInstance. Amazon Route 53 will delete the
	// resource record set automatically. If you delete the resource record set
	// by using ChangeResourceRecordSets, Amazon Route 53 doesn't automatically
	// delete the traffic policy instance, and you'll continue to be charged for
	// it even though it's no longer in use.
	TrafficPolicyInstanceId *string `type:"string"`

	// The DNS record type. For information about different record types and how
	// data is encoded for them, see Supported DNS Resource Record Types (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// Valid values for basic resource record sets: A | AAAA | CNAME | MX | NAPTR
	// | NS | PTR | SOA | SPF | SRV | TXT
	//
	// Values for weighted, latency, geolocation, and failover resource record sets:
	// A | AAAA | CNAME | MX | NAPTR | PTR | SPF | SRV | TXT. When creating a group
	// of weighted, latency, geolocation, or failover resource record sets, specify
	// the same value for all of the resource record sets in the group.
	//
	// SPF records were formerly used to verify the identity of the sender of email
	// messages. However, we no longer recommend that you create resource record
	// sets for which the value of Type is SPF. RFC 7208, Sender Policy Framework
	// (SPF) for Authorizing Use of Domains in Email, Version 1, has been updated
	// to say, "...[I]ts existence and mechanism defined in [RFC4408] have led to
	// some interoperability issues. Accordingly, its use is no longer appropriate
	// for SPF version 1; implementations are not to use it." In RFC 7208, see section
	// 14.1, The SPF DNS Record Type (http://tools.ietf.org/html/rfc7208#section-14.1).
	//
	// Values for alias resource record sets:
	//
	//    * CloudFront distributions:A
	//
	//    * Elastic Beanstalk environment that has a regionalized subdomain: A
	//
	//    * ELB load balancers:A | AAAA
	//
	//    * Amazon S3 buckets:A
	//
	//    * Another resource record set in this hosted zone: Specify the type of
	//    the resource record set for which you're creating the alias. Specify any
	//    value except NS or SOA.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"RRType"`

	// Weighted resource record sets only: Among resource record sets that have
	// the same combination of DNS name and type, a value that determines the proportion
	// of DNS queries that Amazon Route 53 responds to using the current resource
	// record set. Amazon Route 53 calculates the sum of the weights for the resource
	// record sets that have the same combination of DNS name and type. Amazon Route
	// 53 then responds to queries based on the ratio of a resource's weight to
	// the total. Note the following:
	//
	//    * You must specify a value for the Weight element for every weighted resource
	//    record set.
	//
	//    * You can only specify one ResourceRecord per weighted resource record
	//    set.
	//
	//    * You cannot create latency, failover, or geolocation resource record
	//    sets that have the same values for the Name and Type elements as weighted
	//    resource record sets.
	//
	//    * You can create a maximum of 100 weighted resource record sets that have
	//    the same values for the Name and Type elements.
	//
	//    * For weighted (but not weighted alias) resource record sets, if you set
	//    Weight to 0 for a resource record set, Amazon Route 53 never responds
	//    to queries with the applicable value for that resource record set. However,
	//    if you set Weight to 0 for all resource record sets that have the same
	//    combination of DNS name and type, traffic is routed to all resources with
	//    equal probability.
	//
	// The effect of setting Weight to 0 is different when you associate health
	//    checks with weighted resource record sets. For more information, see Options
	//    for Configuring Amazon Route 53 Active-Active and Active-Passive Failover
	//    (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html)
	//    in the Amazon Route 53 Developer Guide.
	Weight *int64 `type:"long"`
}

// String returns the string representation
func (s ResourceRecordSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceRecordSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceRecordSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceRecordSet"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 1))
	}
	if s.ResourceRecords != nil && len(s.ResourceRecords) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceRecords", 1))
	}
	if s.SetIdentifier != nil && len(*s.SetIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SetIdentifier", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.AliasTarget != nil {
		if err := s.AliasTarget.Validate(); err != nil {
			invalidParams.AddNested("AliasTarget", err.(request.ErrInvalidParams))
		}
	}
	if s.GeoLocation != nil {
		if err := s.GeoLocation.Validate(); err != nil {
			invalidParams.AddNested("GeoLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.ResourceRecords != nil {
		for i, v := range s.ResourceRecords {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRecords", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type containing a resource and its associated tags.
type ResourceTagSet struct {
	_ struct{} `type:"structure"`

	// The ID for the specified resource.
	ResourceId *string `type:"string"`

	// The type of the resource.
	//
	//    * The resource type for health checks is healthcheck.
	//
	//    * The resource type for hosted zones is hostedzone.
	ResourceType *string `type:"string" enum:"TagResourceType"`

	// The tags associated with the specified resource.
	Tags []*Tag `locationNameList:"Tag" min:"1" type:"list"`
}

// String returns the string representation
func (s ResourceTagSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagSet) GoString() string {
	return s.String()
}

// A complex type that contains the status that one Amazon Route 53 health checker
// reports and the time of the health check.
type StatusReport struct {
	_ struct{} `type:"structure"`

	// The time at which the health checker performed the health check in ISO 8601
	// format (https://en.wikipedia.org/wiki/ISO_8601) and Coordinated Universal
	// Time (UTC). For example, the value 2014-10-27T17:48:16.751Z represents October
	// 27, 2014 at 17:48:16.751 UTC.
	CheckedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A description of the status of the health check endpoint as reported by one
	// of the Amazon Route 53 health checkers.
	Status *string `type:"string"`
}

// String returns the string representation
func (s StatusReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusReport) GoString() string {
	return s.String()
}

// A complex type that contains information about a tag that you want to add
// or edit for the specified health check or hosted zone.
type Tag struct {
	_ struct{} `type:"structure"`

	// The value of Key depends on the operation that you want to perform:
	//
	//    * Add a tag to a health check or hosted zone: Key is the name that you
	//    want to give the new tag.
	//
	//    * Edit a tag: Key is the name of the tag whose Value element you want
	//    to remove.
	//
	//    *  Delete a key: Key is the name of the tag you want to remove.
	//
	//    * Give a name to a health check: Edit the default Name tag. In the Amazon
	//    Route 53 console, the list of your health checks includes a Name column
	//    that lets you see the name that you've given to each health check.
	Key *string `type:"string"`

	// The value of Value depends on the operation that you want to perform:
	//
	//    * Add a tag to a health check or hosted zone: Value is the value that
	//    you want to give the new tag.
	//
	//    * Edit a tag: Value is the new value that you want to assign the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Gets the value that Amazon Route 53 returns in response to a DNS request
// for a specified record name and type. You can optionally specify the IP address
// of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask.
//
// Parameters
//
// hostedzoneidThe ID of the hosted zone that you want Amazon Route 53 to simulate
// a query for.
//
// recordnameThe name of the resource record set that you want Amazon Route
// 53 to simulate a query for.
//
// recordtypeThe type of the resource record set.
//
// resolverip (optional)If you want to simulate a request from a specific DNS
// resolver, specify the IP address for that resolver. If you omit this value,
// TestDNSAnswer uses the IP address of a DNS resolver in the AWS US East region.
//
// edns0clientsubnetip (optional)If the resolver that you specified for resolverip
// supports EDNS0, specify the IP address of a client in the applicable location.
//
// edns0clientsubnetmask (optional)If you specify an IP address for edns0clientsubnetip,
// you can optionally specify the number of bits of the IP address that you
// want the checking tool to include in the DNS query. For example, if you specify
// 192.0.2.44 for edns0clientsubnetip and 24 for edns0clientsubnetmask, the
// checking tool will simulate a request from 192.0.2.0/24. The default value
// is 24 bits.
type TestDNSAnswerInput struct {
	_ struct{} `type:"structure"`

	// If the resolver that you specified for resolverip supports EDNS0, specify
	// the IP address of a client in the applicable location.
	EDNS0ClientSubnetIP *string `location:"querystring" locationName:"edns0clientsubnetip" type:"string"`

	// If you specify an IP address for edns0clientsubnetip, you can optionally
	// specify the number of bits of the IP address that you want the checking tool
	// to include in the DNS query. For example, if you specify 192.0.2.44 for edns0clientsubnetip
	// and 24 for edns0clientsubnetmask, the checking tool will simulate a request
	// from 192.0.2.0/24. The default value is 24 bits.
	EDNS0ClientSubnetMask *string `location:"querystring" locationName:"edns0clientsubnetmask" type:"string"`

	// The ID of the hosted zone that you want Amazon Route 53 to simulate a query
	// for.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"querystring" locationName:"hostedzoneid" type:"string" required:"true"`

	// The name of the resource record set that you want Amazon Route 53 to simulate
	// a query for.
	//
	// RecordName is a required field
	RecordName *string `location:"querystring" locationName:"recordname" type:"string" required:"true"`

	// The type of the resource record set.
	//
	// RecordType is a required field
	RecordType *string `location:"querystring" locationName:"recordtype" type:"string" required:"true" enum:"RRType"`

	// If you want to simulate a request from a specific DNS resolver, specify the
	// IP address for that resolver. If you omit this value, TestDnsAnswer uses
	// the IP address of a DNS resolver in the AWS US East region.
	ResolverIP *string `location:"querystring" locationName:"resolverip" type:"string"`
}

// String returns the string representation
func (s TestDNSAnswerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestDNSAnswerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestDNSAnswerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestDNSAnswerInput"}
	if s.HostedZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("HostedZoneId"))
	}
	if s.RecordName == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordName"))
	}
	if s.RecordType == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the response to a TestDNSAnswer request.
type TestDNSAnswerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Route 53 name server used to respond to the request.
	//
	// Nameserver is a required field
	Nameserver *string `type:"string" required:"true"`

	// The protocol that Amazon Route 53 used to respond to the request, either
	// UDP or TCP.
	//
	// Protocol is a required field
	Protocol *string `type:"string" required:"true"`

	// A list that contains values that Amazon Route 53 returned for this resource
	// record set.
	//
	// RecordData is a required field
	RecordData []*string `locationNameList:"RecordDataEntry" type:"list" required:"true"`

	// The name of the resource record set that you submitted a request for.
	//
	// RecordName is a required field
	RecordName *string `type:"string" required:"true"`

	// The type of the resource record set that you submitted a request for.
	//
	// RecordType is a required field
	RecordType *string `type:"string" required:"true" enum:"RRType"`

	// A code that indicates whether the request is valid or not. The most common
	// response code is NOERROR, meaning that the request is valid. If the response
	// is not valid, Amazon Route 53 returns a response code that describes the
	// error. For a list of possible response codes, see DNS RCODES (http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6)
	// on the IANA website.
	//
	// ResponseCode is a required field
	ResponseCode *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TestDNSAnswerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestDNSAnswerOutput) GoString() string {
	return s.String()
}

// A complex type that contains settings for a traffic policy.
type TrafficPolicy struct {
	_ struct{} `type:"structure"`

	// The comment that you specify in the CreateTrafficPolicy request, if any.
	Comment *string `type:"string"`

	// The definition of a traffic policy in JSON format. You specify the JSON document
	// to use for a new traffic policy in the CreateTrafficPolicy request. For more
	// information about the JSON format, see Traffic Policy Document Format (http://docs.aws.amazon.com/Route53/latest/api-reference/api-policies-traffic-policy-document-format.html).
	//
	// Document is a required field
	Document *string `type:"string" required:"true"`

	// The ID that Amazon Route 53 assigned to a traffic policy when you created
	// it.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The name that you specified when you created the traffic policy.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The DNS type of the resource record sets that Amazon Route 53 creates when
	// you use a traffic policy to create a traffic policy instance.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"RRType"`

	// The version number that Amazon Route 53 assigns to a traffic policy. For
	// a new traffic policy, the value of Version is always 1.
	//
	// Version is a required field
	Version *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s TrafficPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrafficPolicy) GoString() string {
	return s.String()
}

// A complex type that contains settings for the new traffic policy instance.
type TrafficPolicyInstance struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone that Amazon Route 53 created resource record sets
	// in.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`

	// The ID that Amazon Route 53 assigned to the new traffic policy instance.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// If State is Failed, an explanation of the reason for the failure. If State
	// is another value, Message is empty.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The DNS name, such as www.example.com, for which Amazon Route 53 responds
	// to queries by using the resource record sets that are associated with this
	// traffic policy instance.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of State is one of the following values:
	//
	// AppliedAmazon Route 53 has finished creating resource record sets, and changes
	// have propagated to all Amazon Route 53 edge locations.
	//
	// CreatingAmazon Route 53 is creating the resource record sets. Use GetTrafficPolicyInstance
	// to confirm that the CreateTrafficPolicyInstance request completed successfully.
	//
	// FailedAmazon Route 53 wasn't able to create or update the resource record
	// sets. When the value of State is Failed, see Message for an explanation of
	// what caused the request to fail.
	//
	// State is a required field
	State *string `type:"string" required:"true"`

	// The TTL that Amazon Route 53 assigned to all of the resource record sets
	// that it created in the specified hosted zone.
	//
	// TTL is a required field
	TTL *int64 `type:"long" required:"true"`

	// The ID of the traffic policy that Amazon Route 53 used to create resource
	// record sets in the specified hosted zone.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `type:"string" required:"true"`

	// The DNS type that Amazon Route 53 assigned to all of the resource record
	// sets that it created for this traffic policy instance.
	//
	// TrafficPolicyType is a required field
	TrafficPolicyType *string `type:"string" required:"true" enum:"RRType"`

	// The version of the traffic policy that Amazon Route 53 used to create resource
	// record sets in the specified hosted zone.
	//
	// TrafficPolicyVersion is a required field
	TrafficPolicyVersion *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s TrafficPolicyInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrafficPolicyInstance) GoString() string {
	return s.String()
}

// A complex type that contains information about the latest version of one
// traffic policy that is associated with the current AWS account.
type TrafficPolicySummary struct {
	_ struct{} `type:"structure"`

	// The ID that Amazon Route 53 assigned to the traffic policy when you created
	// it.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The version number of the latest version of the traffic policy.
	//
	// LatestVersion is a required field
	LatestVersion *int64 `min:"1" type:"integer" required:"true"`

	// The name that you specified for the traffic policy when you created it.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The number of traffic policies that are associated with the current AWS account.
	//
	// TrafficPolicyCount is a required field
	TrafficPolicyCount *int64 `min:"1" type:"integer" required:"true"`

	// The DNS type of the resource record sets that Amazon Route 53 creates when
	// you use a traffic policy to create a traffic policy instance.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"RRType"`
}

// String returns the string representation
func (s TrafficPolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrafficPolicySummary) GoString() string {
	return s.String()
}

// A complex type that contains the health check request information.
type UpdateHealthCheckInput struct {
	_ struct{} `locationName:"UpdateHealthCheckRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// A complex type that identifies the CloudWatch alarm that you want Amazon
	// Route 53 health checkers to use to determine whether this health check is
	// healthy.
	AlarmIdentifier *AlarmIdentifier `type:"structure"`

	// A complex type that contains one ChildHealthCheck element for each health
	// check that you want to associate with a CALCULATED health check.
	ChildHealthChecks []*string `locationNameList:"ChildHealthCheck" type:"list"`

	// Specify whether you want Amazon Route 53 to send the value of FullyQualifiedDomainName
	// to the endpoint in the client_hello message during TLS negotiation. This
	// allows the endpoint to respond to HTTPS health check requests with the applicable
	// SSL/TLS certificate.
	//
	// Some endpoints require that HTTPS requests include the host name in the client_hello
	// message. If you don't enable SNI, the status of the health check will be
	// SSL alert handshake_failure. A health check can also have that status for
	// other reasons. If SNI is enabled and you're still getting the error, check
	// the SSL/TLS configuration on your endpoint and confirm that your certificate
	// is valid.
	//
	// The SSL/TLS certificate on your endpoint includes a domain name in the Common
	// Name field and possibly several more in the Subject Alternative Names field.
	// One of the domain names in the certificate should match the value that you
	// specify for FullyQualifiedDomainName. If the endpoint responds to the client_hello
	// message with a certificate that does not include the domain name that you
	// specified in FullyQualifiedDomainName, a health checker will retry the handshake.
	// In the second attempt, the health checker will omit FullyQualifiedDomainName
	// from the client_hello message.
	EnableSNI *bool `type:"boolean"`

	// The number of consecutive health checks that an endpoint must pass or fail
	// for Amazon Route 53 to change the current status of the endpoint from unhealthy
	// to healthy or vice versa. For more information, see How Amazon Route 53 Determines
	// Whether an Endpoint Is Healthy (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	// in the Amazon Route 53 Developer Guide.
	FailureThreshold *int64 `min:"1" type:"integer"`

	// Amazon Route 53 behavior depends on whether you specify a value for IPAddress.
	//
	// If a health check already has a value for IPAddress, you can change the value.
	// However, you can't update an existing health check to add or remove the value
	// of IPAddress.
	//
	// If you specifyIPAddress:
	//
	// The value that you want Amazon Route 53 to pass in the Host header in all
	// health checks except TCP health checks. This is typically the fully qualified
	// DNS name of the endpoint on which you want Amazon Route 53 to perform health
	// checks. When Amazon Route 53 checks the health of an endpoint, here is how
	// it constructs the Host header:
	//
	//    * If you specify a value of 80 for Port and HTTP or HTTP_STR_MATCH for
	//    Type, Amazon Route 53 passes the value of FullyQualifiedDomainName to
	//    the endpoint in the Host header.
	//
	//    * If you specify a value of 443 for Port and HTTPS or HTTPS_STR_MATCH
	//    for Type, Amazon Route 53 passes the value of FullyQualifiedDomainName
	//    to the endpoint in the Host header.
	//
	//    * If you specify another value for Port and any value except TCP for Type,
	//    Amazon Route 53 passes FullyQualifiedDomainName:Port to the endpoint in
	//    the Host header.
	//
	// If you don't specify a value for FullyQualifiedDomainName, Amazon Route 53
	// substitutes the value of IPAddress in the Host header in each of the above
	// cases.
	//
	// If you don't specifyIPAddress:
	//
	// If you don't specify a value for IPAddress, Amazon Route 53 sends a DNS request
	// to the domain that you specify in FullyQualifiedDomainName at the interval
	// you specify in RequestInterval. Using an IP address that DNS returns, Amazon
	// Route 53 then checks the health of the endpoint.
	//
	// If you want to check the health of weighted, latency, or failover resource
	// record sets and you choose to specify the endpoint only by FullyQualifiedDomainName,
	// we recommend that you create a separate health check for each endpoint. For
	// example, create a health check for each HTTP server that is serving content
	// for www.example.com. For the value of FullyQualifiedDomainName, specify the
	// domain name of the server (such as us-east-1-www.example.com), not the name
	// of the resource record sets (www.example.com).
	//
	// In this configuration, if the value of FullyQualifiedDomainName matches the
	// name of the resource record sets and you then associate the health check
	// with those resource record sets, health check results will be unpredictable.
	//
	// In addition, if the value of Type is HTTP, HTTPS, HTTP_STR_MATCH, or HTTPS_STR_MATCH,
	// Amazon Route 53 passes the value of FullyQualifiedDomainName in the Host
	// header, as it does when you specify a value for IPAddress. If the value of
	// Type is TCP, Amazon Route 53 doesn't pass a Host header.
	FullyQualifiedDomainName *string `type:"string"`

	// The ID for the health check for which you want detailed information. When
	// you created the health check, CreateHealthCheck returned the ID in the response,
	// in the HealthCheckId element.
	//
	// HealthCheckId is a required field
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`

	// A sequential counter that Amazon Route 53 sets to 1 when you create a health
	// check and increments by 1 each time you update settings for the health check.
	//
	// We recommend that you use GetHealthCheck or ListHealthChecks to get the current
	// value of HealthCheckVersion for the health check that you want to update,
	// and that you include that value in your UpdateHealthCheck request. This prevents
	// Amazon Route 53 from overwriting an intervening update:
	//
	//    * f the value in the UpdateHealthCheck request matches the value of HealthCheckVersion
	//    in the health check, Amazon Route 53 updates the health check with the
	//    new settings.
	//
	//    * If the value of HealthCheckVersion in the health check is greater, the
	//    health check was changed after you got the version number. Amazon Route
	//    53 does not update the health check, and it returns a HealthCheckVersionMismatch
	//    error.
	HealthCheckVersion *int64 `min:"1" type:"long"`

	// The number of child health checks that are associated with a CALCULATED health
	// that Amazon Route 53 must consider healthy for the CALCULATED health check
	// to be considered healthy. To specify the child health checks that you want
	// to associate with a CALCULATED health check, use the ChildHealthChecks and
	// ChildHealthCheck elements.
	//
	// Note the following:
	//
	//    * If you specify a number greater than the number of child health checks,
	//    Amazon Route 53 always considers this health check to be unhealthy.
	//
	//    * If you specify 0, Amazon Route 53 always considers this health check
	//    to be healthy.
	HealthThreshold *int64 `type:"integer"`

	// The IPv4 IP address of the endpoint on which you want Amazon Route 53 to
	// perform health checks. If you don't specify a value for IPAddress, Amazon
	// Route 53 sends a DNS request to resolve the domain name that you specify
	// in FullyQualifiedDomainName at the interval you specify in RequestInterval.
	// Using an IP address that DNS returns, Amazon Route 53 then checks the health
	// of the endpoint.
	//
	// f the endpoint is an Amazon EC2 instance, we recommend that you create an
	// Elastic IP address, associate it with your Amazon EC2 instance, and specify
	// the Elastic IP address for IPAddress. This ensures that the IP address of
	// your instance never changes. For more information, see Elastic IP Addresses
	// (EIP) (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// If a health check already has a value for IPAddress, you can change the value.
	// However, you can't update an existing health check to add or remove the value
	// of IPAddress.
	//
	// For more information, see UpdateHealthCheckRequest$FullyQualifiedDomainName.
	IPAddress *string `type:"string"`

	// When CloudWatch has insufficient data about the metric to determine the alarm
	// state, the status that you want Amazon Route 53 to assign to the health check:
	//
	//    * Healthy: Amazon Route 53 considers the health check to be healthy.
	//
	//    * Unhealthy: Amazon Route 53 considers the health check to be unhealthy.
	//
	//    * LastKnownStatus: Amazon Route 53 uses the status of the health check
	//    from the last time CloudWatch had sufficient data to determine the alarm
	//    state. For new health checks that have no last known status, the default
	//    status for the health check is healthy.
	InsufficientDataHealthStatus *string `type:"string" enum:"InsufficientDataHealthStatus"`

	// Specify whether you want Amazon Route 53 to invert the status of a health
	// check, for example, to consider a health check unhealthy when it otherwise
	// would be considered healthy.
	Inverted *bool `type:"boolean"`

	// The port on the endpoint on which you want Amazon Route 53 to perform health
	// checks.
	Port *int64 `min:"1" type:"integer"`

	// A complex type that contains one Region element for each region from which
	// you want Amazon Route 53 health checkers to check the specified endpoint.
	Regions []*string `locationNameList:"Region" min:"1" type:"list"`

	// The path that you want Amazon Route 53 to request when performing health
	// checks. The path can be any value for which your endpoint will return an
	// HTTP status code of 2xx or 3xx when the endpoint is healthy, for example
	// the file /docs/route53-health-check.html.
	//
	// Specify this value only if you want to change it.
	ResourcePath *string `type:"string"`

	// If the value of Type is HTTP_STR_MATCH or HTTP_STR_MATCH, the string that
	// you want Amazon Route 53 to search for in the response body from the specified
	// resource. If the string appears in the response body, Amazon Route 53 considers
	// the resource healthy. (You can't change the value of Type when you update
	// a health check.)
	SearchString *string `type:"string"`
}

// String returns the string representation
func (s UpdateHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHealthCheckInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateHealthCheckInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateHealthCheckInput"}
	if s.FailureThreshold != nil && *s.FailureThreshold < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FailureThreshold", 1))
	}
	if s.HealthCheckId == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheckId"))
	}
	if s.HealthCheckVersion != nil && *s.HealthCheckVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("HealthCheckVersion", 1))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}
	if s.Regions != nil && len(s.Regions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Regions", 1))
	}
	if s.AlarmIdentifier != nil {
		if err := s.AlarmIdentifier.Validate(); err != nil {
			invalidParams.AddNested("AlarmIdentifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateHealthCheckOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about one health check that is associated
	// with the current AWS account.
	//
	// HealthCheck is a required field
	HealthCheck *HealthCheck `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHealthCheckOutput) GoString() string {
	return s.String()
}

// A complex type that contains the hosted zone request information.
type UpdateHostedZoneCommentInput struct {
	_ struct{} `locationName:"UpdateHostedZoneCommentRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The new comment for the hosted zone. If you don't specify a value for Comment,
	// Amazon Route 53 deletes the existing value of the Comment element, if any.
	Comment *string `type:"string"`

	// The ID for the hosted zone for which you want to update the comment.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateHostedZoneCommentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHostedZoneCommentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateHostedZoneCommentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateHostedZoneCommentInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the response to the UpdateHostedZoneCommentRequest.
type UpdateHostedZoneCommentOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains general information about the hosted zone.
	//
	// HostedZone is a required field
	HostedZone *HostedZone `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateHostedZoneCommentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHostedZoneCommentOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the traffic policy for which
// you want to update the comment.
type UpdateTrafficPolicyCommentInput struct {
	_ struct{} `locationName:"UpdateTrafficPolicyCommentRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The new comment for the specified traffic policy and version.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// The value of Id for the traffic policy for which you want to update the comment.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of Version for the traffic policy for which you want to update
	// the comment.
	//
	// Version is a required field
	Version *int64 `location:"uri" locationName:"Version" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateTrafficPolicyCommentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrafficPolicyCommentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTrafficPolicyCommentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTrafficPolicyCommentInput"}
	if s.Comment == nil {
		invalidParams.Add(request.NewErrParamRequired("Comment"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && *s.Version < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the response information for the traffic policy.
type UpdateTrafficPolicyCommentOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the specified traffic policy.
	//
	// TrafficPolicy is a required field
	TrafficPolicy *TrafficPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateTrafficPolicyCommentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrafficPolicyCommentOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the resource record sets that
// you want to update based on a specified traffic policy instance.
type UpdateTrafficPolicyInstanceInput struct {
	_ struct{} `locationName:"UpdateTrafficPolicyInstanceRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The ID of the traffic policy instance that you want to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The TTL that you want Amazon Route 53 to assign to all of the updated resource
	// record sets.
	//
	// TTL is a required field
	TTL *int64 `type:"long" required:"true"`

	// The ID of the traffic policy that you want Amazon Route 53 to use to update
	// resource record sets for the specified traffic policy instance.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `type:"string" required:"true"`

	// The version of the traffic policy that you want Amazon Route 53 to use to
	// update resource record sets for the specified traffic policy instance.
	//
	// TrafficPolicyVersion is a required field
	TrafficPolicyVersion *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateTrafficPolicyInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrafficPolicyInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTrafficPolicyInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTrafficPolicyInstanceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.TTL == nil {
		invalidParams.Add(request.NewErrParamRequired("TTL"))
	}
	if s.TrafficPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyId"))
	}
	if s.TrafficPolicyVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficPolicyVersion"))
	}
	if s.TrafficPolicyVersion != nil && *s.TrafficPolicyVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TrafficPolicyVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains information about the resource record sets that
// Amazon Route 53 created based on a specified traffic policy.
type UpdateTrafficPolicyInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the updated traffic policy instance.
	//
	// TrafficPolicyInstance is a required field
	TrafficPolicyInstance *TrafficPolicyInstance `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateTrafficPolicyInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrafficPolicyInstanceOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the Amazon VPC that you're
// associating with the specified hosted zone.
type VPC struct {
	_ struct{} `type:"structure"`

	// A VPC ID
	VPCId *string `type:"string"`

	// The region in which you created the VPC that you want to associate with the
	// specified Amazon Route 53 hosted zone.
	VPCRegion *string `min:"1" type:"string" enum:"VPCRegion"`
}

// String returns the string representation
func (s VPC) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VPC) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VPC) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VPC"}
	if s.VPCRegion != nil && len(*s.VPCRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

const (
	// ChangeActionCreate is a ChangeAction enum value
	ChangeActionCreate = "CREATE"

	// ChangeActionDelete is a ChangeAction enum value
	ChangeActionDelete = "DELETE"

	// ChangeActionUpsert is a ChangeAction enum value
	ChangeActionUpsert = "UPSERT"
)

const (
	// ChangeStatusPending is a ChangeStatus enum value
	ChangeStatusPending = "PENDING"

	// ChangeStatusInsync is a ChangeStatus enum value
	ChangeStatusInsync = "INSYNC"
)

const (
	// CloudWatchRegionUsEast1 is a CloudWatchRegion enum value
	CloudWatchRegionUsEast1 = "us-east-1"

	// CloudWatchRegionUsWest1 is a CloudWatchRegion enum value
	CloudWatchRegionUsWest1 = "us-west-1"

	// CloudWatchRegionUsWest2 is a CloudWatchRegion enum value
	CloudWatchRegionUsWest2 = "us-west-2"

	// CloudWatchRegionEuCentral1 is a CloudWatchRegion enum value
	CloudWatchRegionEuCentral1 = "eu-central-1"

	// CloudWatchRegionEuWest1 is a CloudWatchRegion enum value
	CloudWatchRegionEuWest1 = "eu-west-1"

	// CloudWatchRegionApSouth1 is a CloudWatchRegion enum value
	CloudWatchRegionApSouth1 = "ap-south-1"

	// CloudWatchRegionApSoutheast1 is a CloudWatchRegion enum value
	CloudWatchRegionApSoutheast1 = "ap-southeast-1"

	// CloudWatchRegionApSoutheast2 is a CloudWatchRegion enum value
	CloudWatchRegionApSoutheast2 = "ap-southeast-2"

	// CloudWatchRegionApNortheast1 is a CloudWatchRegion enum value
	CloudWatchRegionApNortheast1 = "ap-northeast-1"

	// CloudWatchRegionApNortheast2 is a CloudWatchRegion enum value
	CloudWatchRegionApNortheast2 = "ap-northeast-2"

	// CloudWatchRegionSaEast1 is a CloudWatchRegion enum value
	CloudWatchRegionSaEast1 = "sa-east-1"
)

const (
	// ComparisonOperatorGreaterThanOrEqualToThreshold is a ComparisonOperator enum value
	ComparisonOperatorGreaterThanOrEqualToThreshold = "GreaterThanOrEqualToThreshold"

	// ComparisonOperatorGreaterThanThreshold is a ComparisonOperator enum value
	ComparisonOperatorGreaterThanThreshold = "GreaterThanThreshold"

	// ComparisonOperatorLessThanThreshold is a ComparisonOperator enum value
	ComparisonOperatorLessThanThreshold = "LessThanThreshold"

	// ComparisonOperatorLessThanOrEqualToThreshold is a ComparisonOperator enum value
	ComparisonOperatorLessThanOrEqualToThreshold = "LessThanOrEqualToThreshold"
)

// An Amazon EC2 region that you want Amazon Route 53 to use to perform health
// checks.
const (
	// HealthCheckRegionUsEast1 is a HealthCheckRegion enum value
	HealthCheckRegionUsEast1 = "us-east-1"

	// HealthCheckRegionUsWest1 is a HealthCheckRegion enum value
	HealthCheckRegionUsWest1 = "us-west-1"

	// HealthCheckRegionUsWest2 is a HealthCheckRegion enum value
	HealthCheckRegionUsWest2 = "us-west-2"

	// HealthCheckRegionEuWest1 is a HealthCheckRegion enum value
	HealthCheckRegionEuWest1 = "eu-west-1"

	// HealthCheckRegionApSoutheast1 is a HealthCheckRegion enum value
	HealthCheckRegionApSoutheast1 = "ap-southeast-1"

	// HealthCheckRegionApSoutheast2 is a HealthCheckRegion enum value
	HealthCheckRegionApSoutheast2 = "ap-southeast-2"

	// HealthCheckRegionApNortheast1 is a HealthCheckRegion enum value
	HealthCheckRegionApNortheast1 = "ap-northeast-1"

	// HealthCheckRegionSaEast1 is a HealthCheckRegion enum value
	HealthCheckRegionSaEast1 = "sa-east-1"
)

const (
	// HealthCheckTypeHttp is a HealthCheckType enum value
	HealthCheckTypeHttp = "HTTP"

	// HealthCheckTypeHttps is a HealthCheckType enum value
	HealthCheckTypeHttps = "HTTPS"

	// HealthCheckTypeHttpStrMatch is a HealthCheckType enum value
	HealthCheckTypeHttpStrMatch = "HTTP_STR_MATCH"

	// HealthCheckTypeHttpsStrMatch is a HealthCheckType enum value
	HealthCheckTypeHttpsStrMatch = "HTTPS_STR_MATCH"

	// HealthCheckTypeTcp is a HealthCheckType enum value
	HealthCheckTypeTcp = "TCP"

	// HealthCheckTypeCalculated is a HealthCheckType enum value
	HealthCheckTypeCalculated = "CALCULATED"

	// HealthCheckTypeCloudwatchMetric is a HealthCheckType enum value
	HealthCheckTypeCloudwatchMetric = "CLOUDWATCH_METRIC"
)

const (
	// InsufficientDataHealthStatusHealthy is a InsufficientDataHealthStatus enum value
	InsufficientDataHealthStatusHealthy = "Healthy"

	// InsufficientDataHealthStatusUnhealthy is a InsufficientDataHealthStatus enum value
	InsufficientDataHealthStatusUnhealthy = "Unhealthy"

	// InsufficientDataHealthStatusLastKnownStatus is a InsufficientDataHealthStatus enum value
	InsufficientDataHealthStatusLastKnownStatus = "LastKnownStatus"
)

const (
	// RRTypeSoa is a RRType enum value
	RRTypeSoa = "SOA"

	// RRTypeA is a RRType enum value
	RRTypeA = "A"

	// RRTypeTxt is a RRType enum value
	RRTypeTxt = "TXT"

	// RRTypeNs is a RRType enum value
	RRTypeNs = "NS"

	// RRTypeCname is a RRType enum value
	RRTypeCname = "CNAME"

	// RRTypeMx is a RRType enum value
	RRTypeMx = "MX"

	// RRTypeNaptr is a RRType enum value
	RRTypeNaptr = "NAPTR"

	// RRTypePtr is a RRType enum value
	RRTypePtr = "PTR"

	// RRTypeSrv is a RRType enum value
	RRTypeSrv = "SRV"

	// RRTypeSpf is a RRType enum value
	RRTypeSpf = "SPF"

	// RRTypeAaaa is a RRType enum value
	RRTypeAaaa = "AAAA"
)

const (
	// ResourceRecordSetFailoverPrimary is a ResourceRecordSetFailover enum value
	ResourceRecordSetFailoverPrimary = "PRIMARY"

	// ResourceRecordSetFailoverSecondary is a ResourceRecordSetFailover enum value
	ResourceRecordSetFailoverSecondary = "SECONDARY"
)

const (
	// ResourceRecordSetRegionUsEast1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionUsEast1 = "us-east-1"

	// ResourceRecordSetRegionUsEast2 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionUsEast2 = "us-east-2"

	// ResourceRecordSetRegionUsWest1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionUsWest1 = "us-west-1"

	// ResourceRecordSetRegionUsWest2 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionUsWest2 = "us-west-2"

	// ResourceRecordSetRegionEuWest1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionEuWest1 = "eu-west-1"

	// ResourceRecordSetRegionEuCentral1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionEuCentral1 = "eu-central-1"

	// ResourceRecordSetRegionApSoutheast1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionApSoutheast1 = "ap-southeast-1"

	// ResourceRecordSetRegionApSoutheast2 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionApSoutheast2 = "ap-southeast-2"

	// ResourceRecordSetRegionApNortheast1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionApNortheast1 = "ap-northeast-1"

	// ResourceRecordSetRegionApNortheast2 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionApNortheast2 = "ap-northeast-2"

	// ResourceRecordSetRegionSaEast1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionSaEast1 = "sa-east-1"

	// ResourceRecordSetRegionCnNorth1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionCnNorth1 = "cn-north-1"

	// ResourceRecordSetRegionApSouth1 is a ResourceRecordSetRegion enum value
	ResourceRecordSetRegionApSouth1 = "ap-south-1"
)

const (
	// StatisticAverage is a Statistic enum value
	StatisticAverage = "Average"

	// StatisticSum is a Statistic enum value
	StatisticSum = "Sum"

	// StatisticSampleCount is a Statistic enum value
	StatisticSampleCount = "SampleCount"

	// StatisticMaximum is a Statistic enum value
	StatisticMaximum = "Maximum"

	// StatisticMinimum is a Statistic enum value
	StatisticMinimum = "Minimum"
)

const (
	// TagResourceTypeHealthcheck is a TagResourceType enum value
	TagResourceTypeHealthcheck = "healthcheck"

	// TagResourceTypeHostedzone is a TagResourceType enum value
	TagResourceTypeHostedzone = "hostedzone"
)

const (
	// VPCRegionUsEast1 is a VPCRegion enum value
	VPCRegionUsEast1 = "us-east-1"

	// VPCRegionUsEast2 is a VPCRegion enum value
	VPCRegionUsEast2 = "us-east-2"

	// VPCRegionUsWest1 is a VPCRegion enum value
	VPCRegionUsWest1 = "us-west-1"

	// VPCRegionUsWest2 is a VPCRegion enum value
	VPCRegionUsWest2 = "us-west-2"

	// VPCRegionEuWest1 is a VPCRegion enum value
	VPCRegionEuWest1 = "eu-west-1"

	// VPCRegionEuCentral1 is a VPCRegion enum value
	VPCRegionEuCentral1 = "eu-central-1"

	// VPCRegionApSoutheast1 is a VPCRegion enum value
	VPCRegionApSoutheast1 = "ap-southeast-1"

	// VPCRegionApSoutheast2 is a VPCRegion enum value
	VPCRegionApSoutheast2 = "ap-southeast-2"

	// VPCRegionApSouth1 is a VPCRegion enum value
	VPCRegionApSouth1 = "ap-south-1"

	// VPCRegionApNortheast1 is a VPCRegion enum value
	VPCRegionApNortheast1 = "ap-northeast-1"

	// VPCRegionApNortheast2 is a VPCRegion enum value
	VPCRegionApNortheast2 = "ap-northeast-2"

	// VPCRegionSaEast1 is a VPCRegion enum value
	VPCRegionSaEast1 = "sa-east-1"

	// VPCRegionCnNorth1 is a VPCRegion enum value
	VPCRegionCnNorth1 = "cn-north-1"
)
