# Upgrading to 1.0

## Introduction

**The 1.0 release is incompatible with 0.x**. It introduces a new and more transparent API key generation and validation scheme which allows to pass it in a single header, instead of two previously.

This document lists the steps necessary to upgrade from 0.x to 1.0.

## Steps

### 1. Backup existing API keys

Unfortunately, it is not possible to provide a migration that would preserve existing API keys. This is because the cryptographic generation and validation methods have changed fundamentally, which means that new keys cannot be inferred from existing ones.

As a result, **all existing API keys will be destroyed** during Step 1/ described below. You may want to backup the existing data so that you can regenerate keys notify clients once migration is complete.

### 2. Reset migrations

**This step will destroy existing API keys**. It is necessary for the new migrations to run correctly.

```bash
python manage.py migrate rest_framework_api_key zero
```

### 3. Upgrade

```bash
pip install "djangorestframework-api-key==1.0.*"
```

### 4. Run migrations

```bash
python manage.py migrate rest_framework_api_key
```
