#ifndef _ENTITY_RENDERABLETARGETINSTANCES_H_
#define _ENTITY_RENDERABLETARGETINSTANCES_H_

#include "Target.h"
#include <set>
#include "irenderable.h"

namespace entity {

// Forward declaration
class TargetableNode;

/**
 * greebo: This is a "container" for all TargetableInstances. These register
 *         themselves at construction time and will get invoked during
 *         the frontend render pass.
 *
 * This object is also a Renderable which is always attached to the
 * GlobalRenderSystem() during the entire module lifetime.
 */
class RenderableTargetInstances :
	public Renderable
{
	typedef std::set<TargetableNode*> TargetableNodes;
	TargetableNodes _nodes;

public:
	// Add/Remove a TargetableNode to this set
	void attach(TargetableNode& node);
	void detach(TargetableNode& node);

	// Renderable implementation
	void renderSolid(RenderableCollector& collector, const VolumeTest& volume) const;
	void renderWireframe(RenderableCollector& collector, const VolumeTest& volume) const;

	void setRenderSystem(const RenderSystemPtr& renderSystem)
	{}

	bool isHighlighted() const
	{
		return false; // never highlighted
	}

	// Accessor method to the singleton instance
	static RenderableTargetInstances& Instance();
};

} // namespace entity

#endif /* _ENTITY_RENDERABLETARGETINSTANCES_H_ */
