{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetPickable: boolean;
    procedure SetPickable(const Value: boolean);
  public
    procedure SetObjectType(const Value: array of string);
    procedure SetObjectType(const Value: TCastleStringList);
    property Pickable: boolean read GetPickable write SetPickable;

{$endif read_interface}

{$ifdef read_implementation}

{ TPickableGroupNode ----------------------------------------------- }

procedure TPickableGroupNode.SetObjectType(const Value: array of string);
begin
  FdObjectType.Send(Value);
end;

procedure TPickableGroupNode.SetObjectType(const Value: TCastleStringList);
begin
  FdObjectType.Send(Value);
end;

function TPickableGroupNode.GetPickable: boolean;
begin
  Result := FdPickable.Value;
end;

procedure TPickableGroupNode.SetPickable(const Value: boolean);
begin
  FdPickable.Send(Value);
end;

{$endif read_implementation}
