{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetLimitOrientation: TVector4;
    procedure SetLimitOrientation(const Value: TVector4);
    function GetNameField: string;
    procedure SetNameField(const Value: string);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScale: TVector3;
    procedure SetScale(const Value: TVector3);
    function GetScaleOrientation: TVector4;
    procedure SetScaleOrientation(const Value: TVector4);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
  public
    property Center: TVector3 read GetCenter write SetCenter;
    procedure SetDisplacers(const Value: array of THAnimDisplacerNode);
    property LimitOrientation: TVector4 read GetLimitOrientation write SetLimitOrientation;
    procedure SetLlimit(const Value: array of Single);
    procedure SetLlimit(const Value: TSingleList);
    property NameField: string read GetNameField write SetNameField;
    property Rotation: TVector4 read GetRotation write SetRotation;
    property Scale: TVector3 read GetScale write SetScale;
    property ScaleOrientation: TVector4 read GetScaleOrientation write SetScaleOrientation;
    procedure SetSkinCoordIndex(const Value: array of LongInt);
    procedure SetSkinCoordIndex(const Value: TLongIntList);
    procedure SetSkinCoordWeight(const Value: array of Single);
    procedure SetSkinCoordWeight(const Value: TSingleList);
    procedure SetStiffness(const Value: array of Single);
    procedure SetStiffness(const Value: TSingleList);
    property Translation: TVector3 read GetTranslation write SetTranslation;
    procedure SetUlimit(const Value: array of Single);
    procedure SetUlimit(const Value: TSingleList);

{$endif read_interface}

{$ifdef read_implementation}

{ THAnimJointNode ----------------------------------------------- }

function THAnimJointNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure THAnimJointNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

procedure THAnimJointNode.SetDisplacers(const Value: array of THAnimDisplacerNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimDisplacerNode));
  FdDisplacers.Send(A);
end;

function THAnimJointNode.GetLimitOrientation: TVector4;
begin
  Result := FdLimitOrientation.Value;
end;

procedure THAnimJointNode.SetLimitOrientation(const Value: TVector4);
begin
  FdLimitOrientation.Send(Value);
end;

procedure THAnimJointNode.SetLlimit(const Value: array of Single);
begin
  FdLlimit.Send(Value);
end;

procedure THAnimJointNode.SetLlimit(const Value: TSingleList);
begin
  FdLlimit.Send(Value);
end;

function THAnimJointNode.GetNameField: string;
begin
  Result := FdName.Value;
end;

procedure THAnimJointNode.SetNameField(const Value: string);
begin
  FdName.Send(Value);
end;

function THAnimJointNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure THAnimJointNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function THAnimJointNode.GetScale: TVector3;
begin
  Result := FdScale.Value;
end;

procedure THAnimJointNode.SetScale(const Value: TVector3);
begin
  FdScale.Send(Value);
end;

function THAnimJointNode.GetScaleOrientation: TVector4;
begin
  Result := FdScaleOrientation.Value;
end;

procedure THAnimJointNode.SetScaleOrientation(const Value: TVector4);
begin
  FdScaleOrientation.Send(Value);
end;

procedure THAnimJointNode.SetSkinCoordIndex(const Value: array of LongInt);
begin
  FdSkinCoordIndex.Send(Value);
end;

procedure THAnimJointNode.SetSkinCoordIndex(const Value: TLongIntList);
begin
  FdSkinCoordIndex.Send(Value);
end;

procedure THAnimJointNode.SetSkinCoordWeight(const Value: array of Single);
begin
  FdSkinCoordWeight.Send(Value);
end;

procedure THAnimJointNode.SetSkinCoordWeight(const Value: TSingleList);
begin
  FdSkinCoordWeight.Send(Value);
end;

procedure THAnimJointNode.SetStiffness(const Value: array of Single);
begin
  FdStiffness.Send(Value);
end;

procedure THAnimJointNode.SetStiffness(const Value: TSingleList);
begin
  FdStiffness.Send(Value);
end;

function THAnimJointNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure THAnimJointNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

procedure THAnimJointNode.SetUlimit(const Value: array of Single);
begin
  FdUlimit.Send(Value);
end;

procedure THAnimJointNode.SetUlimit(const Value: TSingleList);
begin
  FdUlimit.Send(Value);
end;

{$endif read_implementation}
