{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAngle: Single;
    procedure SetAngle(const Value: Single);
    function GetDirection: TVector3;
    procedure SetDirection(const Value: TVector3);
    function GetPosition: TVector3;
    procedure SetPosition(const Value: TVector3);
  public
    property Angle: Single read GetAngle write SetAngle;
    property Direction: TVector3 read GetDirection write SetDirection;
    property Position: TVector3 read GetPosition write SetPosition;

{$endif read_interface}

{$ifdef read_implementation}

{ TConeEmitterNode ----------------------------------------------- }

function TConeEmitterNode.GetAngle: Single;
begin
  Result := FdAngle.Value;
end;

procedure TConeEmitterNode.SetAngle(const Value: Single);
begin
  FdAngle.Send(Value);
end;

function TConeEmitterNode.GetDirection: TVector3;
begin
  Result := FdDirection.Value;
end;

procedure TConeEmitterNode.SetDirection(const Value: TVector3);
begin
  FdDirection.Send(Value);
end;

function TConeEmitterNode.GetPosition: TVector3;
begin
  Result := FdPosition.Value;
end;

procedure TConeEmitterNode.SetPosition(const Value: TVector3);
begin
  FdPosition.Send(Value);
end;

{$endif read_implementation}
