# calc-stats

## NAME

**calc-stats** − a series of wrappers for performing basic statistic calculations on files or standard input containing numbers, using awk

## SYNOPSIS


**calc-min** \[FILE\]

**calc-max** \[FILE\]

**calc-mean** \[FILE\]

**calc-avg** \[FILE\]

**calc-median** \[FILE\]

**calc-mode** \[FILE\]

**calc-stdev** \[FILE\]

**calc-histogram** \[FILE\]

**calc-sum** \[FILE\]

## OPTIONS

While none of these have options, the input may be specified either as a FILE argument, or as standard input.

## DESCRIPTION

This suite of simple tools will perform efficient statistics calculations on either a file or standard input containing numbers (integers or floats), one per line.

 - calc-min will print the largest numeric value from input
 - calc-max will print the smallest numeric value from input
 - calc-mean (and avg) will print the arithmetic mean (average) value from input
 - calc-mode will print the most frequently occurring value from input
 - calc-median will print the middle value of the sorted input
 - calc-stdev will print the standard deviation of all values in the input
 - calc-histogram will print a reverse sorted, weighted distribution of input values
 - calc-sum will calculate the sum of all input values
