// ---------------------------------------------------------------------------
// - Predcsm.hpp                                                             -
// - afnix:csm service - predicates declaration                              -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2019 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_PREDCSM_HPP
#define  AFNIX_PREDCSM_HPP

#ifndef  AFNIX_OBJECT_HPP
#include "Object.hpp"
#endif
 
namespace afnix {

  /// this file contains the predicates associated with the afnix:csm
  /// standard service.
  /// @author amaury darsch

  /// the part object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_partp (Runnable* robj, Nameset* nset, Cons* args);

  /// the blob object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_blobp (Runnable* robj, Nameset* nset, Cons* args);

  /// the bloc object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_blocp (Runnable* robj, Nameset* nset, Cons* args);

  /// the carrier blob object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_cblbp (Runnable* robj, Nameset* nset, Cons* args);

  /// the delegate blob object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_dblbp (Runnable* robj, Nameset* nset, Cons* args);

  /// the tracker blob object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_tckrp (Runnable* robj, Nameset* nset, Cons* args);
  
  /// the collection object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_collp (Runnable* robj, Nameset* nset, Cons* args);

  /// the domain object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_domnp (Runnable* robj, Nameset* nset, Cons* args);
  
  /// the session object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_sessp (Runnable* robj, Nameset* nset, Cons* args);

  /// the session set object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_ssetp (Runnable* robj, Nameset* nset, Cons* args);

  /// the workzone object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_wzonp (Runnable* robj, Nameset* nset, Cons* args);

  /// the workspace object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_wspcp (Runnable* robj, Nameset* nset, Cons* args);

  /// the localzone object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_lzonp (Runnable* robj, Nameset* nset, Cons* args);

  /// the localspace object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_lspcp (Runnable* robj, Nameset* nset, Cons* args);

  /// the userspace object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_uspcp (Runnable* robj, Nameset* nset, Cons* args);

  /// the realm object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_relmp (Runnable* robj, Nameset* nset, Cons* args);

  /// the realm zone object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_rzonp (Runnable* robj, Nameset* nset, Cons* args);

  /// the identity object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_idtyp (Runnable* robj, Nameset* nset, Cons* args);

  /// the authority object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_authp (Runnable* robj, Nameset* nset, Cons* args);

  /// the principal object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_pcplp (Runnable* robj, Nameset* nset, Cons* args);

  /// the act object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_xactp (Runnable* robj, Nameset* nset, Cons* args);

  /// the visa object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_visap (Runnable* robj, Nameset* nset, Cons* args);

  /// the credential object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_credp (Runnable* robj, Nameset* nset, Cons* args);

  /// the notary object predicate
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* csm_ntryp (Runnable* robj, Nameset* nset, Cons* args);
}

#endif
