/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.DNSException;
import IceInternal.InetSocketAddress;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public final class Network {
    public static boolean connectionLost(IOException iOException) {
        String string = iOException.getMessage().toLowerCase();
        if (string != null) {
            String[] stringArray = new String[]{"connection reset by peer", "cannot send after socket shutdown", "cannot send after transport endpoint shutdown", "software caused connection abort", "an existing connection was forcibly closed"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean connectionRefused(ConnectException connectException) {
        String string = connectException.getMessage().toLowerCase();
        if (string != null) {
            String[] stringArray = new String[]{"connection refused"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean notConnected(SocketException socketException) {
        String string = socketException.getMessage().toLowerCase();
        return string.indexOf("transport endpoint is not connected") != -1;
    }

    public static InetSocketAddress getAddress(String string, int n) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return new InetSocketAddress(inetAddress, n);
        }
        catch (UnknownHostException unknownHostException) {
            DNSException dNSException = new DNSException();
            dNSException.host = string;
            throw dNSException;
        }
    }

    public static String getLocalHost(boolean bl) {
        byte[] byArray = Network.getLocalAddress();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n;
            if (i != 0) {
                stringBuffer.append('.');
            }
            if ((n = byArray[i]) < 0) {
                n += 256;
            }
            stringBuffer.append(Integer.toString(n));
        }
        return stringBuffer.toString();
    }

    public static byte[] getLocalAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (inetAddress == null) {
            try {
                inetAddress = InetAddress.getByName("127.0.0.1");
            }
            catch (UnknownHostException unknownHostException) {
                DNSException dNSException = new DNSException();
                dNSException.host = "127.0.0.1";
                throw dNSException;
            }
        }
        return inetAddress.getAddress();
    }

    public static String fdToString(Socket socket) {
        if (socket == null) {
            return "<closed>";
        }
        InetAddress inetAddress = socket.getLocalAddress();
        int n = socket.getLocalPort();
        InetAddress inetAddress2 = socket.getInetAddress();
        int n2 = socket.getPort();
        return Network.addressesToString(inetAddress, n, inetAddress2, n2);
    }

    public static String addressesToString(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("local address = ");
        stringBuffer.append(inetAddress.getHostAddress());
        stringBuffer.append(':');
        stringBuffer.append(n);
        if (inetAddress2 == null) {
            stringBuffer.append("\nremote address = <not connected>");
        } else {
            stringBuffer.append("\nremote address = ");
            stringBuffer.append(inetAddress2.getHostAddress());
            stringBuffer.append(':');
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    public static String addrToString(InetSocketAddress inetSocketAddress) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(inetSocketAddress.getAddress().getHostAddress());
        stringBuffer.append(':');
        stringBuffer.append(inetSocketAddress.getPort());
        return stringBuffer.toString();
    }

    public static boolean interrupted(IOException iOException) {
        return iOException instanceof InterruptedIOException || iOException.getMessage().indexOf("Interrupted system call") >= 0;
    }
}

