/* partspace.h
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2001-2006,2008 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef PARTSPACE_H
#define PARTSPACE_H

#include "wdefines.h"
#include <aguix/lowlevelfunc.h>
#include "simplelist.hh"
#include <aguix/mutex.h>
#include <aguix/condvar.h>

class PartSpace
{
public:
  PartSpace();
  ~PartSpace();
  PartSpace( const PartSpace &other );
  PartSpace &operator=( const PartSpace &other );

  int readSpace( const char*name );
  
  loff_t getBlocksize();
  loff_t getFreeSpace();
  loff_t getSpace();
  
  std::string getFreeSpaceH() const;
  std::string getSpaceH() const;

  void slavehandler();
  
  void setLifetime( double t );
protected:
  loff_t blocksize;
  loff_t freespace;
  loff_t space;
  
  double info_lifetime;
  int spaceinfo_maxsize;
  
  struct {
    int running;
    bool stop;
    pthread_t th;
    
    CondVar waitvar;
  } slave;

  class SpaceRequestList
  {
  public:
    typedef struct _space_request_list_t {
      char *name;
      dev_t device;
#ifdef HAVE_STATVFS
      worker_struct_statvfs fsstatistic;
#elif defined( HAVE_STATFS )
      struct statfs fsstatistic;
#else
      int fsstatistic;
#endif
      int error;
      time_t readtime;
      struct _space_request_list_t *next;
    } space_request_list_t;

    SpaceRequestList();
    ~SpaceRequestList();
    SpaceRequestList( const SpaceRequestList &other );
    SpaceRequestList &operator=( const SpaceRequestList &other );

    bool isEmpty_locked();
    int put_locked( space_request_list_t *elem );
    space_request_list_t *remove_locked();

    void lock();
    void unlock();
    void wait();
    void signal();
  protected:
    CondVar ex;
    space_request_list_t *head, *tail;
    int elements;
  };

  SpaceRequestList *spacerequest;
  SpaceRequestList *spaceanswer;

#ifdef HAVE_STATVFS
  int getSpace( const char *name, worker_struct_statvfs *statbuf );
#elif defined( HAVE_STATFS )
  int getSpace( const char *name, struct statfs *statbuf );
#else
  int getSpace( const char *name, int *statbuf );
#endif

  List *spaceinfo;
};

#endif

