/* normalmode_externalcommand.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "normalmode.h"
#include "worker_locale.h"
#include "worker.h"
#include "wpucontext.h"
#include "execlass.h"
#include "nmexternfe.hh"
#include "nmextlist.hh"
#include "processexitaction.hh"
#include "datei.h"
#include "wconfig.h"

void NormalMode::externprog( class NM_externorder *extorder )
{
    char *tmpname,*tmpoutput,*exestr,*tstr;
    Datei *fp;
    int lastsize[2];
    bool useint;
    bool cancel=false;
    WPUContext *wpu;
    bool oldrec, oldtd;
    std::string string1;
    bool removeTMPFiles;

    if(extorder==NULL) return;
    if(extorder->com_str==NULL) return;  // nothing to do
    if ( extorder->wpu == NULL ) return;
    wpu = extorder->wpu;

    oldrec = wpu->getRecursive();
    oldtd = wpu->getTakeDirs();
    wpu->setRecursive( extorder->recursive );
    wpu->setTakeDirs( extorder->take_dirs );

    finishsearchmode();

    tmpname=Datei::createTMPName();
    tmpoutput=Datei::createTMPName();

    if ( tmpname != NULL && tmpoutput != NULL ) {
        // runCommand will remove the tmpfiles but if we do runCommand
        // (because of an error) remove them here
        removeTMPFiles = true;

        std::string tmpoutput_lnk;

        RefCount< GenericCallbackArg< void, int > > pea( NULL );
      
        if ( extorder->extstart == NM_externorder::NM_EXT_SHOW_OUTPUT_INT ) {
            tmpoutput_lnk = Datei::createTMPHardlink( tmpoutput );
            pea = new ProcessExitAction( true,
                                         tmpoutput_lnk,
                                         parentlister->getWorker() );
        }

        fp=new Datei();
        if(fp->open(tmpname,"w")==0) {
            fp->putString("#! /bin/sh\n");
            if ( wpu->getBaseDir() != NULL ) {
                if ( ( worker_islocal( wpu->getBaseDir() ) == 1 ) &&
                     ( extorder->dontcd == false ) ) {
                    tstr = AGUIX_catTrustedAndUnTrusted( "cd ", wpu->getBaseDir() );
                    fp->putString( tstr );
                    _freesafe( tstr );
                    fp->putString( "\n" );
                }
            }
            lastsize[0] = wpu->filelistRealSize( false );
            lastsize[1] = wpu->filelistRealSize( true );
            for(int loopnr=1;;loopnr++) {
                std::string res_str;
                if ( wpu->parse( extorder->com_str, res_str, EXE_STRING_LEN - strlen( tmpoutput ) - 3 ) == PARSE_SUCCESS ) {
                    string1 = Worker_secureCommandForShell( res_str.c_str() );
                    if ( string1.length() > 0 ) {
                        if ( extorder->extstart == extorder->NM_EXT_SHOW_OUTPUT ||
                             extorder->extstart == extorder->NM_EXT_SHOW_OUTPUT_INT ) {
                            tstr=(char*)_allocsafe(strlen(string1.c_str())+3+strlen(tmpoutput)+1);
                            if(loopnr==1) sprintf(tstr,"%s >%s",string1.c_str(),tmpoutput);
                            else sprintf(tstr,"%s >>%s",string1.c_str(),tmpoutput);
                            fp->putString( tstr);
                            _freesafe(tstr);
                        } else {
                            fp->putString( string1.c_str() );
                        }
                        fp->putString("\n");
                    }
                    if(extorder->separate_each_entry==false) break;
                    if ( wpu->filelistRealSize( false ) == 0 ) break;
                    if ( wpu->filelistRealSize( false ) == lastsize[0] ) {
                        // endless loop
                        //TODO: requester
                        break;
                    }
                } else {
                    cancel=true;
                    break;
                }
                lastsize[0] = wpu->filelistRealSize( false );
            }
            if(cancel==false) {
                if((extorder->extstart==extorder->NM_EXT_START_IN_TERMINAL_AND_WAIT4KEY)||
                   (extorder->extstart==extorder->NM_EXT_START_IN_TERMINAL)) {
                    /* in terminal starten */
                    if(extorder->extstart==extorder->NM_EXT_START_IN_TERMINAL_AND_WAIT4KEY) {
                        fp->putStringExt("echo %s\n",catalog.getLocale(201));
                        fp->putString("read x\n");
                    }
                    exestr=(char*)_allocsafe(strlen(wconfig->getTerminalStr())+strlen(tmpname)+1);
                    sprintf(exestr,wconfig->getTerminalStr(),tmpname);
                } else {
                    exestr=dupstring(tmpname);
                }
                if(extorder->extstart==extorder->NM_EXT_SHOW_OUTPUT) {
                    useint=true;
                    if(extorder->view_str!=NULL)
                        if(strlen(extorder->view_str)>2)
                            if(strstr(extorder->view_str,"%s")!=NULL) useint=false;
                    if(useint==true) fp->putStringExt(OUTPUT_BIN,tmpoutput);
                    else fp->putStringExt(extorder->view_str,tmpoutput);
                    fp->putString("\n");
                }
                fp->close();
      
                if ( fp->errors() == 0 ) {
                    worker_chmod( tmpname, 0700 );
                    removeTMPFiles = false;
                    parentlister->getWorker()->runCommand( exestr, tmpname, tmpoutput, extorder->inbackground, pea );
                } else {
                    std::string text = AGUIXUtils::formatStringToString( catalog.getLocale( 647 ), tmpname );
                    std::string button = catalog.getLocale( 11 );
                    request( catalog.getLocale( 347 ), text.c_str(), button.c_str() );
                }
                _freesafe(exestr);
            } else fp->close();
        }
        delete fp;
        if ( removeTMPFiles == true ) {
            worker_unlink( tmpname );
            worker_unlink( tmpoutput );

            if ( pea.getVal() != NULL ) {
                pea->callback( 0 );
            }
        }
    } else {
        std::string text = AGUIXUtils::formatStringToString( catalog.getLocale( 647 ), "" );
        std::string button = catalog.getLocale( 11 );
        request( catalog.getLocale( 347 ), text.c_str(), button.c_str() );
    }
  
    if ( tmpname != NULL ) _freesafe(tmpname);
    if ( tmpoutput != NULL ) _freesafe(tmpoutput);

    wpu->setRecursive( oldrec );
    wpu->setTakeDirs( oldtd );
}

class NM_CLI_String
{
public:
    NM_CLI_String( const size_t maxlen, const bool quote ) : m_maxlen( maxlen ),
                                                             m_quote( quote ),
                                                             m_error_occurred( false )
    {}

    bool add_str( const std::string str1, const bool force_noquoting )
    {
        return add_str( str1.c_str(), force_noquoting );
    }

    bool add_str( const char *str1, const bool force_noquoting )
    {
        if ( ! str1 ) return false;

        if ( m_quote == true && force_noquoting == false ) {

            char *newdstr = AGUIX_catTrustedAndUnTrusted( m_current_str.c_str(), str1 );

            if ( ! newdstr ) {
                m_error_occurred = true;
                return false;
            }

            if ( strlen( newdstr ) >= m_maxlen ) {
                _freesafe( newdstr );
                m_error_occurred = true;
                return false;
            }

            m_current_str = newdstr;
            m_last_valid_str = m_current_str;

            _freesafe( newdstr );
        } else {
            size_t tlen = strlen( str1 );

            if ( m_current_str.size() + tlen >= m_maxlen ) {
                m_error_occurred = true;
                return false;
            }

            m_current_str += str1;
            m_last_valid_str = m_current_str;
        }

        return true;
    }

    bool add_char( const char ch )
    {
        if ( m_current_str.size() + 1 >= m_maxlen ) {
            m_error_occurred = true;
            return false;
        }

        m_current_str.push_back( ch );

        return true;
    }

    std::string get_last_valid_string() const
    {
        if ( ! m_error_occurred ) return m_current_str;

        return m_last_valid_str;
    }

    bool is_error_occurred() const
    {
        return m_error_occurred;
    }

    size_t get_current_length() const
    {
        return m_current_str.size();
    }
private:
    std::string m_current_str;
    std::string m_last_valid_str;
    const size_t m_maxlen;
    const bool m_quote;
    bool m_error_occurred;
};

NormalMode::parse_com_str_t NormalMode::parseComStr( const char *sstr, class NM_externorder *extorder,
                                                     int maxlen, NMExtList *entries[2], bool quote,
                                                     std::string &return_str )
{
    char ch;
    int spos = 0, bracketcount = 0, bufpos = 0;
    int mode = 0, myside;
    NormalMode *nm2, *tnm;
    Lister *l2;
    ListerMode *lm1;
    bool ende;
    char *tstr;
    const char *ctstr;
    int id;
    bool cancel = false;
    int num;
    std::string str1;
    char *flagbuf;
    int flagbuf_size;
    NM_CLI_String res_cli_str( maxlen, quote );

    nm2 = NULL;
    l2 = parentlister->getWorker()->getOtherLister( parentlister );
    lm1 = l2->getActiveMode();
    if ( lm1 != NULL )
        if ( lm1->isType( "NormalMode" ) == true )
            nm2 = (NormalMode*)lm1;
  
    myside = parentlister->getSide();
    flagbuf_size = strlen( sstr );
    flagbuf = (char*)_allocsafe( flagbuf_size + 1 );
    for ( ende = false; ende == false; ) {
        ch = sstr[ spos++ ];
        if ( ch == '\0' ) break;
        switch ( mode ) {
            case 1:
                // we are in a open bracket and waiting for close bracket
                if ( ch == '{' ) {
                    // other flag, perhaps useless, but perhaps it is in a String-requester
                    // in any case just overtake it in the buffer
                    if ( bufpos < flagbuf_size ) flagbuf[ bufpos++ ] = ch;
                    bracketcount++;
                } else if ( ch == '}' ) {
                    // a closeing bracket
                    if ( bracketcount > 1 ) {
                        // this is a bracket in the bracket
                        if ( bufpos < flagbuf_size ) flagbuf[ bufpos++ ] = ch;
                    } else {
                        // this is the awaited closebracket
                        flagbuf[ bufpos ] = 0;
                        // now flagbuf contains a flag which must be parsed
                        mode = 3;
                    }
                    bracketcount--;
                } else if ( ch == '\\' ) {
                    // backslash are only resolved on toplevel (bracketcount==0)
                    // so overtake also this
                    if ( bufpos < flagbuf_size ) flagbuf[ bufpos++ ] = ch;
                    mode = 4;
                } else {
                    if ( bufpos < flagbuf_size ) flagbuf[ bufpos++ ] = ch;
                }
                break;
            case 2:
                if ( ! res_cli_str.add_char( ch ) ) {
                    ende = true;
                }
                mode = 0;
                break;
            case 4:
                if ( bufpos < flagbuf_size ) flagbuf[ bufpos++ ] = ch;
                mode = 1;
                break;
            default:
                // we are in no bracket
                if ( ch == '\\' ) {
                    // next character is protected and will be overtaken
                    mode = 2;
                } else if ( ch != '{' ) {
                    // a normal character
                    if ( ! res_cli_str.add_char( ch ) ) {
                        ende = true;
                    }
                } else {
                    mode = 1;
                    bracketcount++;
                    bufpos = 0;
                }
                break;
        }
        if ( mode == 3 ) {
            const char *buf1 = NULL;
            bool force_noquoting;

            if ( flagbuf[0] == '-' ) {
                force_noquoting = true;
                buf1 = flagbuf + 1;
            } else {
                force_noquoting = false;
                buf1 = flagbuf;
            }
            // parse buf1
            if ( strncmp( buf1, "Rs", 2 ) == 0 ) {
                // Stringrequest
                tstr = StringRequest( buf1, extorder, maxlen - res_cli_str.get_current_length(), entries );
                if ( tstr != NULL ) {
                    if ( ! res_cli_str.add_str( tstr, force_noquoting ) ) {
                        ende = true;
                    }
                    _freesafe( tstr );
                } else {
                    cancel = true;
                    ende = true;
                }
            } else if ( strncmp( buf1, "scripts", 7 ) == 0 ) {
                // dir of the scripts
                str1 = Worker::getDataDir();
                str1 += "/scripts";
                if ( ! res_cli_str.add_str( str1, force_noquoting ) ) {
                    ende = true;
                }
            } else if ( strncmp( buf1, "pop", 3 ) == 0 ) {
                if ( strlen( buf1 ) > 3 ) {
                    num = atoi( buf1 + 3 );
                    if ( num < 0 ) num = 0;
                } else {
                    num = 0;
                }
                if ( extorder->wpu != NULL ) {
                    if ( extorder->wpu->size( num ) > 0 ) {
                        str1 = extorder->wpu->pop( num );
                        if ( ! res_cli_str.add_str( str1, force_noquoting ) ) {
                            ende = true;
                        }
                    }
                }
            } else if ( strncmp( buf1, "top", 3 ) == 0 ) {
                if ( strlen( buf1 ) > 3 ) {
                    num = atoi( buf1 + 3 );
                    if ( num < 0 ) num = 0;
                } else {
                    num = 0;
                }
                if ( extorder->wpu != NULL ) {
                    if ( extorder->wpu->size( num ) > 0 ) {
                        str1 = extorder->wpu->top( num );
                        if ( ! res_cli_str.add_str( str1, force_noquoting ) ) {
                            ende = true;
                        }
                    }
                }
            } else if ( strncmp( buf1, "size", 4 ) == 0 ) {
                if ( strlen( buf1 ) > 4 ) {
                    num = atoi( buf1 + 4 );
                    if ( num < 0 ) num = 0;
                } else {
                    num = 0;
                }
                if ( extorder->wpu != NULL ) {
                    char buf2[ A_BYTESFORNUMBER( int ) + 2 ];

                    sprintf( buf2, "%d", extorder->wpu->size( num ) );
                    str1 = buf2;
                    if ( ! res_cli_str.add_str( str1, force_noquoting ) ) {
                        ende = true;
                    }
                }
            } else if ( strncmp( buf1, "p", 1 ) == 0 ) {
                // path
                ctstr = getCurrentDir();
                if ( ctstr != NULL ) {
                    if ( ! res_cli_str.add_str( ctstr, force_noquoting ) ) {
                        ende = true;
                    }
                }
            } else if ( strncmp( buf1, "op", 2 ) == 0 ) {
                // other side
                if ( nm2 == NULL ) ctstr = NULL;
                else ctstr = nm2->getCurrentDir();
                if ( ctstr != NULL ) {
                    if ( ! res_cli_str.add_str( ctstr, force_noquoting ) ) {
                        ende = true;
                    }
                }
            } else if ( strncmp( buf1, "lp", 2 ) == 0 ) {
                // left side
                if ( myside == 0 ) tnm = this;
                else tnm = nm2;
                if ( tnm == NULL ) ctstr = NULL;
                else ctstr = tnm->getCurrentDir();
                if ( ctstr != NULL ) {
                    if ( ! res_cli_str.add_str( ctstr, force_noquoting ) ) {
                        ende = true;
                    }
                }
            } else if ( strncmp( buf1, "rp", 2 ) == 0 ) {
                // right side
                if ( myside == 1 ) tnm = this;
                else tnm = nm2;
                if ( tnm == NULL ) ctstr = NULL;
                else ctstr = tnm->getCurrentDir();
                if ( ctstr != NULL ) {
                    if ( ! res_cli_str.add_str( ctstr, force_noquoting ) ) {
                        ende = true;
                    }
                }
            } else if ( strncmp( buf1, "dp", 2 ) == 0 ) {
                // destination path
                if ( extorder->destmode == NULL ) ctstr = NULL;
                else ctstr = extorder->destmode->getCurrentDir();
                if ( ctstr != NULL ) {
                    if ( ! res_cli_str.add_str( ctstr, force_noquoting ) ) {
                        ende = true;
                    }
                }
            } else if ( strncmp( buf1, "v", 1 ) == 0 ) {
                // env variable
                tstr = getenv( buf1 + 1 );
                if ( tstr != NULL ) {
                    if ( ! res_cli_str.add_str( tstr, force_noquoting ) ) {
                        ende = true;
                    }
                }
            } else {
                // file flag or unknown
                bool otherside, nounselect, noext;
                int filemode, tpos, tmode;

                filemode = -1;
                otherside = false;
                nounselect = false;
                noext = false;
                tpos = 0;
                tmode = 0;
                for( ; tmode < 4 && tpos < 4; ) {
                    ch = buf1[ tpos++ ];
                    if ( ch == 'o' ) {
                        if ( tmode < 1 ) {
                            otherside = true;
                            tmode = 1;
                        } else {
                            // an "o" at the wrong position
                            tmode = 6;
                        }
                    } else if ( ch == 'u' ) {
                        if ( tmode < 2 ) {
                            nounselect = true;
                            tmode = 2;
                        } else {
                            tmode = 6;
                        }
                    } else if ( ch == 'f' && tmode < 3 ) {
                        filemode = 0;
                        tmode = 3;
                    } else if ( ch == 'a' && tmode < 3 ) {
                        filemode = 1;
                        tmode = 3;
                    } else if ( ch == 'F' && tmode < 3 ) {
                        filemode = 2;
                        tmode = 3;
                    } else if ( ch == 'A' && tmode < 3 ) {
                        filemode = 3;
                        tmode = 3;
                    } else if ( ch == 'E' && tmode == 3 ) {
                        noext = true;
                        tmode = 4;
                    } else if ( ch == 't' && tmode < 3 ) {
                        filemode = 4;
                        tmode = 4;  // no E allowed so directly change to mode 4
                    } else if ( ch == '\0' ) tmode = 4;
                }
                if (  filemode >= 0 && filemode < 5 ) {
                    // we have a valid flag
                    bool takefirst = true;
                    NM_extern_fe *efe1;
                    NMExtList *l;
                    bool efeskip;

                    if ( filemode == 1 || filemode == 3 ) takefirst = false;
                    if ( otherside == true ) l = entries[1];
                    else l = entries[0];
                    id = l->initEnum();
                    efe1 = (NM_extern_fe*)l->getFirstElement( id );
                    for ( int c = 0;; ) {
                        if ( efe1 == NULL ) break;
              
                        efeskip = false;
                        if ( ( efe1->getDirFinished() != 0 ) &&
                             ( extorder->take_dirs == false ) ) {
                            efeskip = true;
                        } else {
                            // this is a valid entry
                            if ( filemode == 4 ) {
                                if ( extorder->wpu != NULL ) {
                                    ctstr = extorder->wpu->getTempName4File( efe1->getFullname( false ) );
                                } else {
                                    ctstr = NULL;
                                }
                            } else if ( filemode < 2 ) {
                                ctstr = efe1->getName( noext );
                            } else {
                                ctstr = efe1->getFullname( noext );
                            }

                            if ( ctstr != NULL ) {
                                if ( c > 0 ) {
                                    if ( ! res_cli_str.add_char( ' ' ) ) {
                                        ende = true;
                                    }
                                }
                                if ( ende == false && ! res_cli_str.add_str( ctstr, force_noquoting ) ) {
                                    ende = true;
                                }
                            }               
                            if ( ende == true ) break;
                        }
                        for (;;) {
                            if ( nounselect == false ) {
                                // remove efe1;
                                l->removeElement( efe1 );
                                // now deactivate LVC if not NULL
                                if ( efe1->getFE() != NULL ) {
                                    if ( otherside == false ) {
                                        // in my list
                                        deselect( efe1->getFE() );
                                    } else {
                                        if ( nm2 != NULL ) nm2->deselect( efe1->getFE() );
                                    }
                                }
                                delete efe1;
                                efe1 = (NM_extern_fe*)l->getFirstElement( id );
                            } else {
                                efe1 = (NM_extern_fe*)l->getNextElement( id );
                            }
                            if ( efe1 == NULL ) break;
                            if ( ( efe1->getDirFinished() == 0 ) ||
                                 ( extorder->take_dirs == true ) ) {
                                break;
                            }
                        }

                        if ( efeskip == true ) continue;
                        if ( c == 0 && takefirst == true ) break;
                        c = 1;
                    }
                    l->closeEnum( id );
                }
            }
            mode = 0;
        }
    }
    _freesafe( flagbuf );

    if ( cancel == true ) {
        return PARSE_ERROR;
    }

    if ( res_cli_str.is_error_occurred() ) {
        RefCount<AFontWidth> lencalc( new AFontWidth( aguix, NULL ) );

        std::string message = catalog.getLocale( 938 );
        message += sstr;

        TextStorageString ts( message, lencalc );

        std::string buttons = catalog.getLocale( 629 );
        buttons += "|";
        buttons += catalog.getLocale( 8 );

        int erg = parentlister->getWorker()->getRequester()->request( catalog.getLocale( 347 ), ts, buttons.c_str() );

        if ( erg == 1 ) {
            return PARSE_ERROR;
        }
    }

    return_str = res_cli_str.get_last_valid_string();
    return PARSE_SUCCESS;
}

char *NormalMode::StringRequest( const char *sstr, class NM_externorder *extorder, int maxlen, NMExtList *entries[2] )
{
    char *istr=NULL,ch;
    char *defstr=NULL;
    char *ristr=NULL,*rdefstr=NULL;
    int spos=0,bracketcount=0;
    int istart,iend,defstart,defend;
    int mode;
    char *buttonstr,*textstr,*return_str;
    int erg;
  
    spos=2; // buf1 starts with Rs
    istart=iend=defstart=defend=-1;
    mode=0;
    for(;mode<4;) {
        ch=sstr[spos++];
        if(ch=='\0') break;
        switch(mode) {
            case 0:
                // we are in no bracket
                if(ch=='{') {
                    mode=1;
                    bracketcount++;
                    istart=spos;
                }
                break;
            case 1:
                // in the infotext
                if(ch=='{') bracketcount++;
                else if(ch=='}') {
                    if(bracketcount==1) {
                        iend=spos-2;
                        mode=2;
                    }
                    bracketcount--;
                }
                break;
            case 2:
                // we are in no bracket
                if(ch=='{') {
                    mode=3;
                    bracketcount++;
                    defstart=spos;
                }
                break;
            case 3:
                // in the defaulttext
                if(ch=='{') bracketcount++;
                else if(ch=='}') {
                    if(bracketcount==1) {
                        defend=spos-2;
                        mode=4;
                    }
                    bracketcount--;
                }
                break;
            default:
                break;
        }
    }
    if((istart>=0)&&(iend>=istart)) {
        // we have an infotext
        istr=dupstring(&sstr[istart]);
        istr[iend-istart+1]=0;

        std::string res_str;

        if ( parseComStr(istr,extorder,maxlen,entries, false, res_str ) == PARSE_SUCCESS ) {
            ristr = dupstring( res_str.c_str() );
        }
        _freesafe(istr);
    }
    if((defstart>=0)&&(defend>=istart)) {
        // we have a defaulttext
        defstr=dupstring(&sstr[defstart]);
        defstr[defend-defstart+1]=0;

        std::string res_str;

        if ( parseComStr(defstr,extorder,maxlen,entries, false, res_str ) == PARSE_SUCCESS ) {
            rdefstr = dupstring( res_str.c_str() );
        }
        _freesafe(defstr);
    }
  
    textstr=NULL;
    if(ristr!=NULL) {
        if(strlen(ristr)>0) textstr=ristr;
        else _freesafe(ristr);
    }
    if(textstr==NULL) textstr=dupstring(catalog.getLocale(200));
    buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
                                strlen(catalog.getLocale(8))+1);
    sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
            catalog.getLocale(8));
    erg=string_request(catalog.getLocale(123),textstr,
                       (rdefstr!=NULL)?rdefstr:"",
                       buttonstr,&return_str);
    _freesafe(buttonstr);
    _freesafe(textstr);
    if(rdefstr!=NULL) _freesafe(rdefstr);
    if(erg!=0) {
        _freesafe(return_str);
        return NULL;
    }
    return return_str;
}

NormalMode::parse_com_str_t NormalMode::parseComStrExt( const char *sstr, class NM_externorder *extorder,
                                                        int maxlen, NMExtList *entries[2], bool quote,
                                                        std::string &return_str )
{
    return parseComStr( sstr, extorder, maxlen, entries, quote, return_str );
}

NM_externorder::NM_externorder()
{
    separate_each_entry = false;
    recursive = false;
    inbackground = false;

    extstart = NM_EXT_START_NORMAL;

    com_str = NULL;
    view_str = NULL;

    source = NM_ALLENTRIES;
    sources = NULL;
  
    destmode = NULL;
    wpu = NULL;
    take_dirs = false;
    dontcd = false;
}

NM_externorder::~NM_externorder()
{
    //TODO: at the moment I do nothing here but perhaps it's a good
    //      idea to free com_str/viewstr/sources... (it's done by the user of
    //      this class
}
