// This may look like C code, but it's really -*- C++ -*-
/*
 * Copyright (C) 2006 Wim Dumon, Koen Deforche
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef QTOBJECT_H_
#define QTOBJECT_H_

#ifdef SLOT
# undef SLOT
# undef signals
# undef slots
#endif

#include <QThread>

class HelloApplication;

/*! \class QtObject
 *  \brief A simple Qt object with sample signal and slot.
 *
 * This simple object class demonstrates that the Qt signal/slot
 * mechanism may be used alonglisde Wt's signal/slot mechanism.
 */
class QtObject : public QObject
{
  Q_OBJECT;

public:
  QtObject(HelloApplication *wt_, QObject *parent = 0);

  void passGreet(const QString&);

signals:
  void greet(const QString&);

public slots:
  void doGreet(const QString&);

private:
  HelloApplication *wt_;
};

#endif // QTOBJECT_H_
