/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <arpa/inet.h>

#include "common.h"
#include "defs.h"


bool
convert_ip(char *ip, struct in_addr *addr) {
#ifndef SOLARIS
  int retval;

  retval = inet_aton(ip, addr);
  if (retval == 0) {
#else
#ifndef INADDR_NONE
#define INADDR_NONE -1
#endif
  addr->s_addr = inet_addr(ip);
  if (addr->s_addr == INADDR_NONE) {
#endif
    fprintf(stderr, _("IP address error: %s\n"), ip);

    return false;
  }

  return true;
}

int
build_time(char *smonth, int day, int hour, int minute, int second) {
  int month = 0, now, then;
  struct tm *t;

  /*
  if (opt.mode != REALTIME_RESPONSE)
    t = localtime(&opt.now);
  else {
  */
    time_t rr_now;

    rr_now = time(NULL);
    t = localtime(&rr_now);
    /*
  }
    */

  now = (int)mktime(t);
  if (strncmp(smonth, "Jan", 3) == 0) { month = 0; }
  else if (strncmp(smonth, "Feb", 3) == 0) { month = 1; }
  else if (strncmp(smonth, "Mar", 3) == 0) { month = 2; }
  else if (strncmp(smonth, "Apr", 3) == 0) { month = 3; }
  else if (strncmp(smonth, "May", 3) == 0) { month = 4; }
  else if (strncmp(smonth, "Jun", 3) == 0) { month = 5; }
  else if (strncmp(smonth, "Jul", 3) == 0) { month = 6; }
  else if (strncmp(smonth, "Aug", 3) == 0) { month = 7; }
  else if (strncmp(smonth, "Sep", 3) == 0) { month = 8; }
  else if (strncmp(smonth, "Oct", 3) == 0) { month = 9; }
  else if (strncmp(smonth, "Nov", 3) == 0) { month = 10; }
  else if (strncmp(smonth, "Dec", 3) == 0) { month = 11; }
  t->tm_mon = month;
  t->tm_mday = day;
  t->tm_hour = hour;
  t->tm_min = minute;
  t->tm_sec = second;
  t->tm_isdst = -1;
  then = (int)mktime(t);
  if (then > now)
    --t->tm_year;

  return mktime(t);
}

bool
parse_date(char* input, wf_logentry* logentry) {
  char smonth[4];
  int day, hour, minute, second;
  char hostname[33];

  if (sscanf(input, "%3s %2d %2d:%2d:%2d %32s",
	     smonth, &day, &hour, &minute, &second, hostname) != 6)
    return false;

  logentry->start_time = build_time(smonth, day, hour, minute, second);
  logentry->hostname = hostname;
  return true;
}
