# -*- coding: utf-8 -*-

#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Tests for the tabbed panel."""

from PyQt4 import QtGui
from twisted.internet import defer
from twisted.trial.unittest import TestCase

from ubuntuone.controlpanel.gui.qt import tabbed_panel


class FakeOverlayWidget(QtGui.QLabel):
    """Fake a widget that does have the show_orvelay attribute."""

    def __init__(self, *args, **kwargs):
        super(FakeOverlayWidget, self).__init__(*args, **kwargs)
        self.show_overlay = False


class TabbedPanelTestCase(TestCase):
    """Test the tabbed panel."""

    @defer.inlineCallbacks
    def setUp(self):
        """Set the tests."""
        yield super(TabbedPanelTestCase, self).setUp()
        self.tab_widget = tabbed_panel.TabbedPanel()

    def test_all_overlay_supported(self):
        """Test when all the widgets support the overlay feature."""
        labels = [FakeOverlayWidget("Test"),
                  FakeOverlayWidget("Test"),
                  FakeOverlayWidget("Test")]
        for lab in labels:
            self.tab_widget.addTab(lab, 'label')

        self.tab_widget.show_overlay = True
        self.assertTrue(all([l.show_overlay for l in labels]))
        self.tab_widget.show_overlay = False
        self.assertFalse(any([l.show_overlay for l in labels]))
