# -*- coding: utf-8 -*-

# Authors: Roberto Alsina <roberto.alsina@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Wizard's side widget."""

from PyQt4 import QtGui

from ubuntuone.controlpanel.gui import (
    INSTALL,
    SIGN_IN,
    SELECT_FOLDERS,
    SYNC_STREAM_SHARE,
)
from ubuntuone.controlpanel.gui.qt.ui import side_widget_ui


class SideWidget(QtGui.QFrame):

    """Wizard's side widget."""

    install_stage = 0
    signin_stage = 1
    folders_stage = 2
    sync_stage = 3

    def __init__(self, *args, **kwargs):
        super(SideWidget, self).__init__(*args, **kwargs)
        self.ui = side_widget_ui.Ui_SideWidget()
        self.ui.setupUi(self)

        self.ui.install_label.setText(INSTALL)
        self.ui.signin_label.setText(SIGN_IN)
        self.ui.folders_label.setText(SELECT_FOLDERS)
        self.ui.sync_label.setText(SYNC_STREAM_SHARE)

        self._stage = 0

    def _get_stage(self):
        """Return the current stage."""
        return self._stage

    def _set_stage(self, stage):
        """Switch to the desired stage."""
        self._stage = stage

        self.set_stage_icon(self.ui.install_icon, self.install_stage)
        self.set_stage_icon(self.ui.signin_icon, self.signin_stage)
        self.set_stage_icon(self.ui.folders_icon, self.folders_stage)
        self.set_stage_icon(self.ui.sync_icon, self.sync_stage)

    stage = property(fget=_get_stage, fset=_set_stage)

    def set_stage_icon(self, icon, target_stage):
        """Set the icon depending on the proper state."""
        icon.setEnabled(self.stage >= target_stage)

        if self.stage == target_stage and icon == self.ui.sync_icon:
            icon.setPixmap(QtGui.QPixmap(":/progress_finish_orange.png"))
        elif self.stage == target_stage:
            icon.setPixmap(QtGui.QPixmap(":/progress_arrow_orange.png"))
        elif self.stage > target_stage:
            icon.setPixmap(QtGui.QPixmap(":/progress_tick.png"))
        elif icon == self.ui.sync_icon:
            icon.setPixmap(QtGui.QPixmap(":/progress_finish_grey.png"))
        else:
            icon.setPixmap(QtGui.QPixmap(":/progress_arrow_grey.png"))
