(*
    Tux Commander - UTranslation_CZ - Czech Localization constants
    Copyright (C) 2008 Tomas Bzatek <tbzatek@users.sourceforge.net>
    Check for updates on tuxcmd.sourceforge.net

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)
unit UTranslation_CZ;

interface

implementation

uses ULocale;

const LANGcsF2Button_Caption = 'F2 - Přejmenovat';
      LANGcsF3Button_Caption = 'F3 - Prohlížet';
      LANGcsF4Button_Caption = 'F4 - Upravit';
      LANGcsF5Button_Caption = 'F5 - Kopírovat';
      LANGcsF6Button_Caption = 'F6 - Přesunout';
      LANGcsF7Button_Caption = 'F7 - Nová složka';
      LANGcsF8Button_Caption = 'F8 - Smazat';

      LANGcsmnuFile_Caption = 'Sou_bor';
      LANGcsmnuMark_Caption = 'O_značení';
      LANGcsmnuCommands_Caption = 'Pří_kazy';
      LANGcsmnuHelp_Caption = 'Nápo_věda';
      LANGcsmiExit_Caption = '_Konec';
      LANGcsmiSelectGroup_Caption = 'Označit _skupinu...';
      LANGcsmiUnselectGroup_Caption = '_Odznačit skupinu...';
      LANGcsmiSelectAll_Caption = '_Vybrat vše';
      LANGcsmiUnselectAll_Caption = 'O_doznačit vše';
      LANGcsmiInvertSelection_Caption = '_Převrátit výběr';
      LANGcsmiRefresh_Caption = 'O_bnovit';
      LANGcsmiAbout_Caption = '_O programu...';

      LANGcsColumn1_Caption = 'Jméno';
      LANGcsColumn2_Caption = 'Přípona';
      LANGcsColumn3_Caption = 'Velikost';
      LANGcsColumn4_Caption = 'Datum';
      LANGcsColumn5_Caption = 'Atributy';

      LANGcsExpandSelection = 'Rozšířit výběr';
      LANGcsShrinkSelection = 'Zúžit výběr';
      LANGcsNoMatchesFound = 'Nenalezen žádný výskyt';
      LANGcsNoFilesSelected = 'Není označen žádný soubor!';
      LANGcsSelectedFilesDirectories = '%d označených souborů/složek';
      LANGcsDirectoryS = 'složku %s';
      LANGcsFileS = 'soubor %s';
      LANGcsDoYouReallyWantToDeleteTheS = 'Opravdu si přejete odstranit %s?';
      LANGcsDoYouReallyWantToDeleteTheSS = 'Opravdu si přejete odstranit %s?'#10'%s';
      LANGcsCopyFiles = 'Kopírovat soubory';
      LANGcsMoveRenameFiles = 'Přesunout/přejmenovat soubory';
      LANGcsCopyDFileDirectoriesTo = 'Zkopírovat %d souborů/složek do';
      LANGcsMoveRenameDFileDirectoriesTo = 'Přesunout/přejmenovat %d souborů/složek do';
      LANGcsCopySC = 'Kopírovat:';
      LANGcsMoveRenameSC = 'Přesunout/přejmenovat:';

      LANGcsQuickFind = '  Vyhledat:';

      LANGcsAboutString = 'Tux Commander'#10'Verze %s'#10'Datum sestavení: %s'#10#10'Copyright (c) 2008 Tomáš Bžatek'#10'E-mail: tbzatek@users.sourceforge.net'#10'WWW stránka: http://tuxcmd.sourceforge.net/';
      LANGcsAboutStringGnome = 'verze %s'#10'Datum sestavení: %s'#10'WWW stránka: http://tuxcmd.sourceforge.net/';
      LANGcsDiskStatFmt = '%s z %s volných';
      LANGcsDiskStatVolNameFmt = '[%s] %s z %s volných';
      LANGcsStatusLineFmt = '%s z %s v %d z %d souborů označeno';
      LANGcsPanelStrings : array[boolean] of string = ('pravém', 'levém');

      LANGcsDIR = '<DIR>';
      LANGcsErrorGettingListingForSPanel = 'Chyba při otevírání složky v %s panelu:'#10'    %s'#10#10'Cesta = ''%s''';
      LANGcsErrorGettingListingForSPanelNoPath = 'Chyba při otevírání složky v %s panelu:'#10'    %s';
      LANGcsErrorCreatingNewDirectorySInSPanel = 'Nelze vytvořit složku ''%s'' v %s panelu:'#10'    %s';
      LANGcsErrorCreatingNewDirectorySInSPanelNoPath = 'Nelze vytvořit složku ''%s'' v %s panelu:'#10'    %s';
      LANGcsTheFileDirectory = 'Soubor/adresář';
      LANGcsCouldNotBeDeleted = 'nemohl být smazán';
      LANGcsCouldNotBeDeletedS = 'nemohl být smazán:  %s';
      LANGcsUserCancelled = 'Operace přerušena!';
      LANGcsTheDirectorySIsNotEmpty = 'Složka %s není prázdná!';
      LANGcsCannotCopyFile = 'Nelze zkopírovat soubor';
      LANGcsCopyError = 'Chyba při kopírování';
      LANGcsMoveError = 'Chyba při přesouvání';
      LANGcsOverwriteS = 'Přepsat: %s';
      LANGcsWithFileS = 'Souborem: %s';
      LANGcsOvewriteSBytesS = '%s bytů, %s';
      LANGcsTheFile = 'Soubor';
      LANGcsCopy = 'Kopírovat';
      LANGcsMove = 'Přesunout';
      LANGcsTheDirectory = 'Adresář';
      LANGcsTheSymbolicLink = 'Symbolický odkaz';
      LANGcsCannotMoveFile = 'Nelze přesunout soubor';
      LANGcsCouldNotBeCreated = 'nemohl být vytvořen';
      LANGcsCouldNotBeCreatedS = 'nemohl být vytvořen:  %s';
      LANGcsFromS = 'Z: %s';
      LANGcsToS = 'Do: %s';
      LANGcsCannotCopyFileToItself = 'Zdrojový a cílový soubor jsou totožné!';
      LANGcsMemoryAllocationFailed = 'Chyba při alokaci paměti:';
      LANGcsCannotOpenSourceFile = 'Nelze otevřít zdrojový soubor';
      LANGcsCannotOpenDestinationFile = 'Nelze otevřít cílový soubor';
      LANGcsCannotCloseDestinationFile = 'Nelze uzavřít cílový soubor';
      LANGcsCannotCloseSourceFile = 'Nelze uzavřít zdrojový soubor';
      LANGcsCannotReadFromSourceFile = 'Nelze číst ze zdrojového souboru';
      LANGcsCannotWriteToDestinationFile = 'Nelze zapisovat do cílového souboru';

      LANGcsUnknownException = 'Neznámá chyba';
      LANGcsNoAccess = 'Přístup zamítnut';
      LANGcsUnknownError = 'Neznámá chyba';

      LANGcsCreateANewDirectory = 'Vytvořit novou složku';
      LANGcsEnterDirectoryName = 'Zadejte jmé_no složky:';

      LANGcsOverwriteQuestion = 'Potvrzení přepsání';
      LANGcsOverwriteButton_Caption = '_Přepsat';
      LANGcsOverwriteAllButton_Caption = 'Přepsat _vše';
      LANGcsSkipButton_Caption = 'Pře_skočit';
      LANGcsOverwriteAllOlderButton_Caption = 'Přepsat sta_rší';
      LANGcsSkipAllButton_Caption = 'Přeskočit vš_e';
      LANGcsRenameButton_Caption = 'Přej_menovat';
      LANGcsAppendButton_Caption = 'Připoji_t';
      LANGcsRename = 'Přejmenovat';
      LANGcsRenameFile = 'Přejmenovat soubor ''%s'' na';
      LANGcsIgnoreButton_Caption = '_Ignorovat';

      LANGcsProgress = 'Průběh operace';
      LANGcsCancel = '_Storno';
      LANGcsDelete = 'Mazání:';

      LANGcsSpecifyFileType = 'Zvolte _typ souboru:';

      LANGcsRemoveDirectory = 'Odstranit složku';
      LANGcsDoYouWantToDeleteItWithAllItsFilesAndSubdirectories = 'Opravdu si přejete vše smazat včetně vnořených složek?';
      LANGcsRetry = '_Opakovat';
      LANGcsDeleteButton_Caption = 'O_dstranit';
      LANGcsAll = '_Vše';

      LANGcsCopyFilesSC = 'Kopírovat soubory:';
      LANGcsAppendQuestion = 'Opravdu si přejete připojit soubor ''%s'' k souboru ''%s''?';
      LANGcsPreparingList = 'Připravuje se seznam souborů...';

      LANGcsYouMustSelectAValidFile = 'Musíte označit platný soubor!';
      LANGcsmiVerifyChecksums = '_Ověřit kontrolní součty';
      LANGcsVerifyChecksumsCaption = 'Ověřit kontrolní součty';
      LANGcsCheckButtonCaptionCheck = '_Ověřit';
      LANGcsCheckButtonCaptionStop = '_Stop';
      LANGcsFileListTooltip = '[?] - Dosud neověřeno'#10'[OK] - Kontrolní součet je správný'#10'[BAD] - Kontrolní součet je špatný'#10'[N/A] - Soubor není k dispozici';
      LANGcsFilenameColumnCaption = 'Soubor';
      LANGcsTheFileSYouAreTryingToOpenIsQuiteBig = 'Soubor ''%s'' který se pokoušíte načíst, je velký (%s bajtů). Nemusí se jednat o platný soubor s kontrolními součty.'#10#10'Přejete si pokračovat?';
      LANGcsAnErrorOccuredWhileInitializingMemoryBlock = 'Nastala chyba při alokaci místa v paměti. Pokuste se uvolnit paměť uzavřením několika aplikací a zkuste to znovu.';
      LANGcsAnErrorOccuredWhileOpeningFileSS = 'Nelze otevřít soubor ''%s'':'#10'  %s';
      LANGcsAnErrorOccuredWhileReadingFileSS = 'Nelze číst ze souboru ''%s'':'#10'  %s';
      LANGcsChecksumNotChecked = '<span weight="bold">Stav:</span> Nekontrolováno';
      LANGcsChecksumChecking = '<span weight="bold">Stav:</span> Probíhá kontrola...';
      LANGcsChecksumInterrupted = '<span weight="bold">Stav:</span> Přerušeno';
      LANGcsChecksumDOK = '<span weight="bold">Stav:</span> %d%% OK';

      LANGcsmiCreateChecksumsCaption = '_Vytvořit kontrolní součty...';
      LANGcsYouMustSelectAtLeastOneFileToCalculateChecksum = 'Musíte označit alespoň jeden platný soubor, pro který chcete vytvořit kontrolní součty!';
      LANGcsCreateChecksumsCaption = 'Vytvořit kontrolní součty';
      LANGcsCCHKSUMPage1Text = 'Chystáte se vytvořit kontrolní součty pro'#10'označené soubory v panelu. Jestliže nejsou'#10'označeny všechny potřebné soubory,'#10'ukončete tohoto průvodce a zkuste to znovu.';
      LANGcsCCHKSUMPage4Text = 'Průvodce je připraven vytvořit kontrolní součty.'#10'Tato operace může trvat několik minut.'#10'Stiskněte Vpřed pro pokračování.';
      LANGcsCCHKSUMPage6Text = 'Během operace nastaly následující chyby:';
      LANGcsCCHKSUMPage7Text = 'Kontrolní součty jsou připraveny k použití.'#10#10'Stisknutím Dokončit ukončíte průvodce.';
      LANGcsCCHKSUMPage1Title = '<span size="xx-large" weight="ultrabold">Příprava souborů</span>';
      LANGcsCCHKSUMPage2Title = '<span size="xx-large" weight="ultrabold">Vyberte typ součtového souboru</span>';
      LANGcsCCHKSUMPage3Title = '<span size="xx-large" weight="ultrabold">Zvolte jméno souboru</span>';
      LANGcsCCHKSUMPage4Title = '<span size="xx-large" weight="ultrabold">Připraveno pro operaci</span>';
      LANGcsCCHKSUMPage5Title = '<span size="xx-large" weight="ultrabold">Probíhá kontrola...</span>';
      LANGcsCCHKSUMPage6Title = '<span size="xx-large" weight="ultrabold">Chyba!</span>';
      LANGcsCCHKSUMPage7Title = '<span size="xx-large" weight="ultrabold">Dokončeno</span>';
      LANGcsCCHKSUMSFVFile = 'soubor SFV';
      LANGcsCCHKSUMMD5sumFile = 'soubor MD5';
      LANGcsCCHKSUMFileName = '_Název souboru:';
      LANGcsCCHKSUMCreateSeparateChecksumFiles = 'Samostatné _soubory se součty';
      LANGcsCCHKSUMNowProcessingFileS = 'Kontroluje se soubor: %s';
      LANGcsCCHKSUMFinishCaption = '_Dokončit';
      LANGcsCCHKSUMAreYouSureYouWantToAbortTheProcessing = 'Opravdu si přejete přerušit kontrolu?';
      LANGcsCCHKSUMAnErrorOccuredWhileOpeningFileSS = 'Nastala chyba při otevírání souboru ''%s'': %s'#10;
      LANGcsCCHKSUMAnErrorOccuredWhileReadingFileSS = 'Nastala chyba při čtení souboru ''%s'': %s'#10;
      LANGcsCCHKSUMAnErrorOccuredWhileWritingFileSS = 'Nastala chyba při pokusu o zápis do souboru ''%s'': %s'#10;

      LANGcsAnErrorOccuredWhileWritingFileSS = 'Nelze zapisovat do souboru ''%s'':'#10'  %s';
      LANGcsTheTargetFileSAlreadyExistsDoYouWantToOverwriteIt = 'Cílový soubor ''%s'' existuje. Přejete si ho přepsat?';
      LANGcsTheTargetFileSCannotBeRemovedS = 'Cílový soubor ''%s'' nemohl být odstraněn: %s';
      LANGcsMergeCaption = 'Spojit';
      LANGcsPleaseInsertNextDiskOrGiveDifferentLocation = 'Prosím vložte další disk nebo zadejte jiné umístění:';
      LANGcsMergeOfSSucceeded = 'Spojení souboru ''%s'' bylo úspěšně dokončeno (správný kontrolní součet).';
      LANGcsWarningCreatedFileFailsCRCCheck = 'Upozornění: Vytvořený soubor nemá správný kontrolní součet!';
      LANGcsMergeOfSSucceeded_NoCRCFileAvailable = 'Spojení souboru ''%s'' bylo úspěšně dokončeno (kontrolní součet není k dispozici).';
      LANGcsMergeSAndAllFilesWithAscendingNamesToTheFollowingDirectory = 'Spojit ''%s'' a všechny soubory s navazujícími jmény do následujícího adresáře:';
      LANGcsMergeSC = 'Spojit:';
      LANGcsmiSplitFileCaption = '_Rozdělit soubor...';
      LANGcsmiMergeFilesCaption = 'S_pojit soubory...';

      LANGcsSplitTheFileSToDirectory = '_Rozdělit soubor ''%s'' do cílového adresáře:';
      LANGcsSplitSC = 'Rozdělit:';
      LANGcsSplitFile = 'Rozdělit soubor';
      LANGcsBytesPerFile = '_Bajtů na soubor:';
      LANGcsAutomatic = 'Automaticky';
      LANGcsDeleteFilesOnTargetDisk = '_Smazat soubory na cílovém disku (vhodné pro vyjímatelné disky)';
      LANGcsSplitCaption = 'Rozdělit';
      LANGcsCannotOpenFileS = 'Nelze otevřít soubor ''%s''';
      LANGcsCannotSplitTheFileToMoreThan999Parts = 'Soubor nelze rozdělit do více než 999 částí!';
      LANGcsThereAreSomeFilesInTheTargetDirectorySDoYouWantToDeleteThem = 'V cílovém adresáři se nacházejí tyto soubory:'#10'%s'#10'Přejete si je smazat?';
      LANGcsThereAreDFilesInTheTargetDirectoryDoYouWantToDeleteThem = 'V cílovém adresáři se nachází %d souborů. Přejete si je smazat?';
      LANGcsAnErrorOccuredWhileOperationS = 'Při provádění operace nastala chyba : %s';
      LANGcsSplitOfSSucceeded = 'Rozdělení souboru ''%s'' bylo úspěšně dokončeno.';
      LANGcsSplitOfSFailed = 'Rozdělení souboru ''%s'' nebylo úspěšné!';

      LANGcsmnuShow_Caption = '_Zobrazení';
      LANGcsmiShowDotFiles_Caption = 'Zobrazit _skryté soubory';
      LANGcsTheFileYouAreTryingToOpenIsQuiteBig = 'Soubor, který se pokoušíte načíst, je velký. Otevřením v externí aplikaci (např. gedit) může dojít ke zpomalení reakcí systému.'#10'Přejete si pokračovat?';
      LANGcsCannotExecuteSPleaseCheckTheConfiguration = 'Nelze spustit ''%s''. Prosím zkontrolujte nastavení.';
      LANGcsEdit = 'Upravit';
      LANGcsEnterFilenameToEdit = 'Zad_ejte jméno souboru, který chcete upravit:';

      LANGcsmnuSettings_Caption = 'Nas_tavení';
      LANGcsmiFileTypes_Caption = '_Typy souborů...';
      LANGcsThereIsNoApplicationAssociatedWithS = 'Žádná aplikace není přiřazena k souboru "%s".'#10#10'Přejete si otevřít dialog s nastavením akcí k typům souborů?';
      LANGcsErrorExecutingCommand = 'Zadaný příkaz nelze vykonat!';
      LANGcsEditFileTypesCaption = 'Nastavení přiřazení';
      LANGcsTitleLabel_Caption = '<span size="x-large" weight="ultrabold">Typy souborů</span>';
      LANGcsExtensionsColumn = 'Přípony';
      LANGcsDescriptionColumn = 'Popis';
      LANGcsFileTypesList = 'Seznam typů souborů';
      LANGcsActionName = 'Název akce';
      LANGcsCommand = 'Příkaz';
      LANGcsSetDefaultActionButton_Caption = '_Nastavit jako výchozí';
      LANGcsRunInTerminalCheckBox_Caption = 'Spustit v _terminálu';
      LANGcsAutodetectCheckBox_Caption = 'Autodetekce _okenní aplikace';
      LANGcsBrowseButton_Caption = '_Prohledat...';
      LANGcsCommandLabel_Caption = 'Pří_kaz:';
      LANGcsDescriptionLabel_Caption = 'Náz_ev akce:';
      LANGcsFNameExtLabel_Caption = 'Při_dat typ:';
      LANGcsNotebookPageExtensions = 'Typ souboru';
      LANGcsNotebookPageActions = 'Akce';
      LANGcsDefault = ' (výchozí)';
      LANGcsCannotSaveFileTypeAssociationsBecauseOtherProcess = 'Nelze uložit seznam typů souborů, protože jiný proces mezitím uložený seznam změnil.';

      LANGcsDefaultColor = 'Výchozí _barva';
      LANGcsIcon = '_Ikona:';
      LANGcsBrowseForIcon = 'Vyhledat ikonu';
      LANGcsSelectFileTypeColor = 'Zvolit barvu typu souborů';
      LANGcsColor = 'Ba_rva:';

      LANGcsmiChangePermissions_Caption = 'Změnit oprá_vnění...';
      LANGcsmiChangeOwner_Caption = 'Změnit v_lastníka/skupinu...';
      LANGcsmiCreateSymlink_Caption = 'Vytvořit od_kaz...';
      LANGcsmiEditSymlink_Caption = '_Upravit odkaz...';
      LANGcsChmodProgress = 'Změna oprávnění:';
      LANGcsChownProgress = 'Změna vlastníka:';
      LANGcsYouMustSelectAValidSymbolicLink = 'Musíte vybrat platný odkaz!';
      LANGcsPopupRunS = 'Spus_tit %s';
      LANGcsPopupOpenS = '_Otevřít %s';
      LANGcsPopupGoUp = 'Přejít d_o nadřazeného adresáře';
      LANGcsPopupOpenWithS = 'Otevřít v %s';
      LANGcsPopupDefault = ' (výchozí)';
      LANGcsPopupOpenWith = '_Otevřít v...';
      LANGcsPopupViewFile = '_Zobrazit soubor';
      LANGcsPopupEditFile = 'Upravit _soubor';
      LANGcsPopupMakeSymlink = 'Vytvořit od_kaz';
      LANGcsPopupRename = '_Přejmenovat';
      LANGcsPopupDelete = 'O_dstranit';
      LANGcsDialogChangePermissions = 'Změnit oprávnění';
      LANGcsCouldNotBeChmoddedS = 'nelze změnit oprávnění:  %s';
      LANGcsDialogChangeOwner = 'Změnit vlastníka/skupinu';
      LANGcsCouldNotBeChownedS = 'nelze změnit vlastníka:  %s';
      LANGcsDialogMakeSymlink = 'Vytvořit odkaz';
      LANGcsDialogEditSymlink = 'Upravit odkaz';
      LANGcsFEditSymlink_Caption = 'Upravit symbolický odkaz';
      LANGcsFEditSymlink_SymbolicLinkFilename = '_Název odkazu:';
      LANGcsFEditSymlink_SymbolicLinkPointsTo = 'Odkaz _ukazuje na:';

      LANGcsFChmod_Caption = 'Oprávnění';
      LANGcsFChmod_PermissionFrame = 'Příznaky oprávnění';
      LANGcsFChmod_FileFrame = 'Soubor';
      LANGcsFChmod_ApplyRecursivelyFor = 'Použít _opakovaně pro';
      LANGcsFChmod_miAllFiles = 'Všechny soubory a adresáře';
      LANGcsFChmod_miDirectories = 'Pouze pro adresáře';
      LANGcsFChmod_OctalLabel = 'Čí_selné vyjádření:';
      LANGcsFChmod_SUID = 'SUID - Nastavit ID uživatele při spuštění';
      LANGcsFChmod_SGID = 'SGID - Nastavit ID skupiny při spuštění';
      LANGcsFChmod_Sticky = 'bit ''sticky''';
      LANGcsFChmod_RUSR = 'RUSR - Čtení vlastníkem';
      LANGcsFChmod_WUSR = 'WUSR - Zápis vlastníkem';
      LANGcsFChmod_XUSR = 'XUSR - Spouštění vlastníkem';
      LANGcsFChmod_RGRP = 'RGRP - Čtení skupinou';
      LANGcsFChmod_WGRP = 'WGRP - Zápis skupinou';
      LANGcsFChmod_XGRP = 'XGRP - Spouštění skupinou';
      LANGcsFChmod_ROTH = 'ROTH - Čtení ostatními';
      LANGcsFChmod_WOTH = 'WOTH - Zápis ostatními';
      LANGcsFChmod_XOTH = 'XOTH - Spouštění ostatními';
      LANGcsFChmod_TextLabel = '<span weight="ultrabold">Textové vyjádření:</span>  %s';
      LANGcsFChmod_FileLabel = '<span weight="ultrabold">Zvolený soubor:</span> %s'#10'<span weight="ultrabold">Textové vyjádření:</span> %s'#10 +
                               '<span weight="ultrabold">Číselné vyjádření:</span> %d'#10'<span weight="ultrabold">Vlastník:</span> %s'#10 +
                               '<span weight="ultrabold">Skupina:</span> %s';

      LANGcsFChown_Caption = 'Změnit vlastníka/skupinu';
      LANGcsFChown_OwnerFrame = 'Vlastník';
      LANGcsFChown_GroupFrame = 'Název skupiny';
      LANGcsFChown_FileFrame = 'Soubor';
      LANGcsFChown_ApplyRecursively = 'Použít _opakovaně';

      LANGcsFSymlink_Caption = 'Vytvořit symbolický odkaz';
      LANGcsFSymlink_ExistingFilename = '_Existující soubor (na který se bude odkazovat):';
      LANGcsFSymlink_SymlinkFilename = '_Název odkazu:';

      LANGcsmnuBookmarks_Caption = 'Záložk_y';
      LANGcsmiAddBookmark_Caption = 'Přidat záložku';
      LANGcsmiEditBookmarks_Caption = 'Upravit záložky';
      LANGcsBookmarkPopupDelete_Caption = '_Smazat';
      LANGcsmiPreferences_Caption = '_Nastavení...';
      LANGcsTheCurrentDirectoryAlreadyExistsInTheBookmarksList = 'Adresář který se pokoušíte přidat již existuje v seznamu záložek';
      LANGcsSomeOtherInstanceChanged = 'V některé další spuštěné instanci programu bylo změněno nastavení. Přejete si použít nové nastavení i pro aktuální okno?'#10#10'Upozornění: Pokud nepovolíte provedení změn, bude toto nové nastavení přepsáno při ukončení programu!';
      
      LANGcsPreferences_Caption = 'Nastavení aplikace';
      LANGcsPreferences_TitleLabel_Caption = '<span size="x-large" weight="ultrabold">Nastavení aplikace</span>';
      LANGcsPreferences_GeneralPage = 'Obecné';
      LANGcsPreferences_FontsPage = 'Písma';
      LANGcsPreferences_ColorsPage = 'Barvy';
      LANGcsPreferences_RowHeight = 'Výš_ka řádku:';
      LANGcsPreferences_NumHistoryItems = 'Položek v _historii příkazové řádky:';
      LANGcsPreferences_Default = 'Výchozí';
      LANGcsPreferences_ClearReadonlyAttribute = '_Odstranit atribut jen pro čtení při kopírování z CD-ROM';
      LANGcsPreferences_DisableMouseRenaming = 'Zakázat _rychlé přejmenování myší';
      LANGcsPreferences_ShowFiletypeIconsInList = 'Zobrazit přidružené _ikony typů souborů ';
      LANGcsPreferences_ExternalAppsLabel = '<span weight="ultrabold">Externí programy</span>';
      LANGcsPreferences_Viewer = '_Prohlížeč:';
      LANGcsPreferences_Editor = '_Editor:';
      LANGcsPreferences_Terminal = '_Terminál:';
      LANGcsPreferences_ListFont = 'Písmo v panelech:';
      LANGcsPreferences_Change = '_Změnit...';
      LANGcsPreferences_UseDefaultFont = 'Použít _výchozí písmo';
      LANGcsPreferences_Foreground = 'Text';
      LANGcsPreferences_Background = 'Pozadí';
      LANGcsPreferences_NormalItem = 'Normální položky:';
      LANGcsPreferences_SetToDefaultToUseGTKThemeColors = 'Při výchozím nastavení se použije barva aktuálního tématu systému GTK';
      LANGcsPreferences_Cursor = 'Kurzor:';
      LANGcsPreferences_InactiveItem = 'Neaktivní položky:';
      LANGcsPreferences_SelectedItem = 'Označené položky:';
      LANGcsPreferences_LinkItem = 'Symbolické odkazy:';
      LANGcsPreferences_LinkItemHint = 'Při výchozím nastavení se použije barva normálních položek';
      LANGcsPreferences_DotFileItem = 'Skryté soubory:';
      LANGcsPreferences_DotFileItemHint = 'Při výchozím nastavení se použije barva normálních položek';
      LANGcsPreferences_BrowseForApplication = 'Zvolit aplikaci';
      LANGcsPreferences_DefaultS = 'Výchozí: %s';
      LANGcsPreferences_SelectFont = 'Zvolit písmo';

  (***************  STRINGS ADDED TO v0.4.101  **********************************************************************************)
      LANGcsBookmarkButton_Tooltip = 'Zobrazit záložky';
      LANGcsUpButton_Tooltip = 'Přesunout se o adresář výš';
      LANGcsRootButton_Tooltip = 'Přesunout se do kořenového adresáře (/)';
      LANGcsHomeButton_Tooltip = 'Přesunout se do domovského adresáře (/home/user)';
      LANGcsLeftEqualButton_Tooltip = 'Změnit adresář v pravém panelu na aktuální';
      LANGcsRightEqualButton_Tooltip = 'Změnit adresář v levém panelu na aktuální';
      LANGcsmiShowDirectorySizes_Caption = 'Spočítat obsazený prostor';
      LANGcsmiTargetSource_Caption = 'Cílový adresář = Aktuální adresář';
      LANGcsFileTypeDirectory = 'Adresáře';
      LANGcsFileTypeFile = 'Soubory';
      LANGcsFileTypeMetafile = 'Společná položka';
      LANGcsPreferencesPanelsPage = 'Panely';
      LANGcsPreferencesApplicationsPage = 'Aplikace';
      LANGcsPreferencesExperimentalPage = 'Experimentální funkce';
      LANGcsPreferencesSelectAllDirectoriesCheckBox_Caption = 'Při hromadném označování zahrnout i _adresáře';
      LANGcsPreferencesNewStyleAltOCheckBox_Caption = 'No_vý styl Alt+O';
      LANGcsPreferencesNewStyleAltOCheckBox_Tooltip = 'Při přepnutí nemění aktuální adresář';
      LANGcsPreferencesShowFuncButtonsCheckBox_Caption = 'Zobrazit _funkční tlačítka (spodní lišta)';
      LANGcsPreferencesSizeFormatLabel_Caption = 'For_mát čísel:';
      LANGcsPreferencesmiSizeFormat1 = 'Systémový';
      LANGcsPreferencesmiSizeFormat6 = 'Dynamický';
      LANGcsPreferencesAutodetectXApp = 'Autodetekce X aplikace';
      LANGcsPreferencesAlwaysRunInTerminal = 'Spustit v terminálu';
      LANGcsPreferencesNeverRunInTerminal = 'Nespouštět v terminálu';
      LANGcsPreferencesCmdLineBehaviourLabel_Caption = 'Spouštění z _příkazové řádky:';
      LANGcsPreferencesFeatures = 'Funkce';
      LANGcsPreferencesDisableMouseRename_Tooltip = 'Pro rychlé přejmenování můžete vždy použít klávesovou kombinaci Shift+F6 i při zakázané této volbě';
      LANGcsPreferencesDisableFileTipsCheckBox_Caption = 'Zakázat plovoucí okno s plným _jménem souboru';
      LANGcsPreferencesDisableFileTipsCheckBox_Tooltip = 'Nezobrazovat plovoucí okno s plným jménem souboru jestliže je název souboru/adresáře v panelu zkrácený';
      LANGcsPreferencesShow = 'Zobrazení';
      LANGcsPreferencesDirsInBoldCheckBox_Caption = 'Adresáře _tučným fontem';
      LANGcsPreferencesDisableDirectoryBracketsCheckBox_Caption = 'Nezobrazovat _hranaté závorky v názvech adresářů';
      LANGcsPreferencesOctalPermissionsCheckBox_Caption = 'Zobrazit _oprávnění číselně';
      LANGcsPreferencesOctalPermissionsCheckBox_Tooltip = 'Zobrazit oprávnění souboru/adresáře v číselné formě';
      LANGcsPreferencesMovement = 'Pohyb v panelech';
      LANGcsPreferencesLynxLikeMotionCheckBox_Caption = 'Pohyb ve stylu prohlížeče _Lynx';
      LANGcsPreferencesInsertMovesDownCheckBox_Caption = 'In_sert posune kurzor dolů';
      LANGcsPreferencesSpaceMovesDownCheckBox_Caption = '_Mezerník posune kurzor dolů';
      LANGcsPreferencesViewer = 'Prohlížeč';
      LANGcsPreferencesCommandSC = 'Příkaz:';
      LANGcsPreferencesUseInternalViewer = 'Použít _interní prohlížeč';
      LANGcsPreferencesEditor = 'Editor';
      LANGcsPreferencesTerminal = 'Terminál';
      LANGcsPreferencesExperimentalFeatures = 'Experimentální funkce';
      LANGcsPreferencesExperimentalWarningLabel_Caption = '<span weight="ultrabold">Varování:</span> Tyto funkce jsou momentálně ve vývoji a není zaručena jejich bezchybná funkčnost. Používejte jen na vlastní nebezpečí!';
      LANGcsPreferencesFocusRefreshCheckBox_Caption = 'P_rovést znovunačtení panelů při vstupu do okna aplikace';
      LANGcsPreferencesFocusRefreshCheckBox_Tooltip = 'Tato operace trvá delší dobu v závislosti na počtu souborů v panelech';
      LANGcsPreferencesWMCompatModeCheckBox_Caption = 'Mód _kompatibility s okenními manažery';
      LANGcsPreferencesWMCompatModeCheckBox_Tooltip = 'Použijte v případě potíží s některými okenními manažery (např. IceWM neprovádí maximalizaci okna korektně)';
      LANGcsPreferencesCompatUseLibcSystemCheckBox_Caption = 'Použít funkci libc _system() pro spouštění procesů';
      LANGcsPreferencesCompatUseLibcSystemCheckBox_Tooltip = 'Použijte v případě potíží se zamrznutím nebo pády aplikace při spouštění programů';

  (***************  STRINGS ADDED TO v0.5.70  **********************************************************************************)
      LANGcsmiSearchCaption2 = '_Vyhledat soubory...';
      LANGcsmiNoMounterBarCaption = 'Nez_obrazovat pruh disků';
      LANGcsmiShowOneMounterBarCaption = 'Zobrazit _jeden pruh disků';
      LANGcsmiShowTwoMounterBarCaption = 'Zobrazit _dva pruhy disků';
      LANGcsmnuNetworkCaption = 'S_íť';
      LANGcsmiConnectionsCaption = '_Správce připojení...';
      LANGcsmiOpenConnectionCaption = '_Připojit se...';
      LANGcsmiQuickConnectCaption = '_Rychlé připojení...';
      LANGcsmnuPluginsCaption = '_Moduly';
      LANGcsmiTestPluginCaption = '_Test modulu...';
      LANGcsmiMounterSettingsCaption = 'Nastavení pruhu _disků...';
      LANGcsmiColumnsCaption = 'Nastavení sloup_ců...';
      LANGcsmiSavePositionCaption = '_Uložit pozici';
      LANGcsmiMountCaption = '_Připojit';
      LANGcsmiUmountCaption = '_Odpojit';
      LANGcsmiEjectCaption = '_Vysunout';
      LANGcsmiDuplicateTabCaption = '_Otevřít nový panel';
      LANGcsmiCloseTabCaption = '_Zavřít aktuální panel';
      LANGcsmiCloseAllTabsCaption = 'Zavřít _všechny panely';
      LANGcsCannotDetermineDestinationEngine = 'Nelze určit cílový adresář. Prosím zkontrolujte zadanou cestu a zkuste to znovu.';
      LANGcsCannotLoadFile = 'Nelze otevřít soubor ''%s''. Prosím zkontrolujte oprávnění a zkuste to znovu.';
      LANGcsMountPointDevice = 'Přípojný bod: %s'#10'Zařízení: %s';
      LANGcsMountSC = 'Připojit:';
      LANGcsNoPluginsFound = 'Modul nenalezen';
      LANGcsPluginAbout = 'O modulu...';
      LANGcsCouldntOpenURI = 'Nepodařilo se otevřít vzdálené připojení. Prosím zkontrolujte platnost adresy a přístupová práva.';
      LANGcsPluginAboutInside = 'Modul: %s'#10#10'%s'#10'%s';
      LANGcsAreYouSureCloseAllTabs = 'Opravdu si přejete zavřít všechny ostatní panely?';
      LANGcsCouldntOpenURIArchive = 'Nepodařilo se otevřít archív, pravděpodobně bude poškozen. Prosím zkontrolujte soubor a přístupová práva.';
      LANGcsThereIsNoModuleAvailable = 'Nelze nalézt odpovídající modul potřebný pro otevření tohoto spojení. Prosím zkontrolujte aktivní moduly.';
      LANGcsIgnoreError = 'Opravdu si přejete ignorovat tuto chybu? Zdrojový soubor bude smazán';
      LANGcsErrorMount = 'Nastala chyba při připojování zařízení ''%s'':'#10#10;
      LANGcsErrorUmount = 'Nastala chyba při odpojování zařízení ''%s'':'#10#10;
      LANGcsErrorEject = 'Nastala chyba při vysouvání zařízení ''%s'':'#10#10;

      LANGcsMounterPrefs_Caption = 'Nastavení panelu disků';
      LANGcsMounterPrefs_TitleLabelCaption = 'Nastavení panelu disků';
      LANGcsMounterPrefs_ListViewFrameCaption = 'Přípojné body';
      LANGcsMounterPrefs_MountName = 'Název';
      LANGcsMounterPrefs_MountPoint = 'Přípojný bod';
      LANGcsMounterPrefs_Device = 'Zařízení';
      LANGcsMounterPrefs_MoveUpButtonTooltip = 'Přesunout nahoru';
      LANGcsMounterPrefs_MoveDownButtonTooltip = 'Přesunout dolů';
      LANGcsMounterPrefs_UseFSTabDefaultsCheckBox = 'Použít _systémový seznam přípojných bodů';
      LANGcsMounterPrefs_UseFSTabDefaultsCheckBoxTooltip = 'Je-li tato možnost aktivní, použije se seznam přípojných bodů ze systémového souboru /etc/fstab';
      LANGcsMounterPrefs_ToggleModeCheckBox = 'Zamáčklá tlačítka _disků u připojených zařízení';
      LANGcsMounterPrefs_ToggleModeCheckBoxTooltip = 'Je-li tato položka aktivní, zůstanou tlačítka v panelu zamáčklá v případě, že je zařízení připojeno. Kliknutím zařízení odpojíte, příp. vysunete';
      LANGcsMounterPrefs_PropertiesFrameCaption = 'Vlastnosti přípojného bodu';
      LANGcsMounterPrefs_DisplayTextLabelCaption = '_Název:';
      LANGcsMounterPrefs_MountPointLabelCaption = 'Přípojný _bod:';
      LANGcsMounterPrefs_MountDeviceLabelCaption = '_Zařízení:';
      LANGcsMounterPrefs_DeviceTypeLabelCaption = 'T_yp zařízení:';
      LANGcsMounterPrefs_miLocalDiskCaption = 'Místní disk';
      LANGcsMounterPrefs_miRemovableCaption = 'Výměnný disk';
      LANGcsMounterPrefs_miCDCaption = 'CD/DVD jednotka';
      LANGcsMounterPrefs_miFloppyCaption = 'Disketová mechanika';
      LANGcsMounterPrefs_miNetworkCaption = 'Síťový prostředek';
      LANGcsMounterPrefs_MountCommandLabelCaption = 'Příkaz pro _připojení:';
      LANGcsMounterPrefs_UmountCommandLabelCaption = 'Příkaz pro _odpojení:';
      LANGcsMounterPrefs_MountCommandEntryTooltip = 'Syntaxe: použijte %dev místo zařízení a %dir pro cestu přípojného bodu. V případě, že nepoužíváte nestandardní příkaz pro připojení zařízení, nechte toto pole nevyplněné.'#10 + 'Upozornění: nepoužívejte příkazy vyžadující vstupy z klávesnice uživatele, program je nedokáže obsloužit!'#10'Příklad: smbmount %dev %dir -o username=netuser,password=heslo';
      LANGcsMounterPrefs_UmountCommandEntryTooltip = 'Syntaxe: použijte %dev místo zařízení a %dir pro cestu přípojného bodu. V případě, že nepoužíváte nestandardní příkaz pro odpojení zařízení, nechte toto pole nevyplněné.'#10'Příklad: smbumount %dir';
      LANGcsMounterPrefs_IconLabelCaption = '_Ikona:';

      LANGcsConnMgr_Caption = 'Otevřít nové spojení';
      LANGcsConnMgr_ConnectButton = '_Připojit';
      LANGcsConnMgr_OpenConnection = 'Otevřít nové spojení';
      LANGcsConnMgr_NameColumn = 'Název';
      LANGcsConnMgr_URIColumn = 'Adresa';
      LANGcsConnMgr_AddConnectionButtonCaption = 'N_ové spojení...';
      LANGcsConnMgr_AddConnectionButtonTooltip = 'Vytvořit nové spojení';
      LANGcsConnMgr_EditButtonCaption = '_Upravit...';
      LANGcsConnMgr_EditButtonTooltip = 'Upravit vybrané spojení';
      LANGcsConnMgr_RemoveButtonCaption = 'O_dstranit';
      LANGcsConnMgr_RemoveButtonTooltip = 'Odstranit vybrané spojení';
      LANGcsConnMgr_DoYouWantDelete = 'Opravdu si přejete odstranit vybrané spojení ''%s''?';

      LANGcsConnProp_FTP = 'FTP';
      LANGcsConnProp_SFTP = 'SFTP (ssh podsystém)';
      LANGcsConnProp_SMB = 'Sdílení v síti Windows (SMB)';
      LANGcsConnProp_HTTP = 'WebDAV (HTTP)';
      LANGcsConnProp_HTTPS = 'Zabezpečené WebDAV (HTTPS)';
      LANGcsConnProp_Other = 'Ostatní <span style="italic">(prosím upřesněte v adrese)</span>';
      LANGcsConnProp_Caption = 'Vlastnosti připojení';
      LANGcsConnProp_VFSModule = '_VFS modul:';
      LANGcsConnProp_URI = '_Adresa (URI):';
      LANGcsConnProp_URIEntryTooltip = 'Platná adresa URI by měla obsahovat řetězec typu služby a adresu síťového serveru';
      LANGcsConnProp_DetailedInformations = 'Upřesňující informace';
      LANGcsConnProp_Name = '_Název:';
      LANGcsConnProp_Server = 'Serve_r[:port]:';
      LANGcsConnProp_Username = 'Uživa_telské jméno:';
      LANGcsConnProp_UserNameEntryTooltip = 'Nevyplňujte, jedná-li se o anonymní přístup';
      LANGcsConnProp_Password = '_Heslo:';
      LANGcsConnProp_TargetDirectory = '_Cílový adresář:';
      LANGcsConnProp_ServiceType = 'Typ _služby:';
      LANGcsConnProp_MaskPassword = 'S_krýt heslo';
      LANGcsConnProp_MenuItemCaption = 'Výchozí <span style="italic">(všsechny dostupné moduly)</span>';

      LANGcsConnLogin_Caption = 'Přihlášení';
      LANGcsConnLogin_Login = 'Přihlášení';
      LANGcsConnLogin_ExperimentalWarningLabelCaption = 'Pro přístup k prostředku %s musíte být přihlášeni';
      LANGcsConnLogin_Username = '_Uživatelské jméno:';
      LANGcsConnLogin_Password = '_Heslo:';
      LANGcsConnLogin_AnonymousCheckButton = '_Anonymní přístup';

      LANGcsColumns_Caption = 'Nastavení sloupců hlavního panelu';
      LANGcsColumns_Title = 'Nastavení sloupců panelu';
      LANGcsColumns_MoveUpButtonTooltip = 'Přesunout položku nahoru';
      LANGcsColumns_MoveDownButtonTooltip = 'Přesunout položku dolů';
      LANGcsColumns_TitlesLongName = 'Jméno';
      LANGcsColumns_TitlesLongNameExt = 'Jméno + typ';
      LANGcsColumns_TitlesLongExt = 'Typ';
      LANGcsColumns_TitlesLongSize = 'Velikost';
      LANGcsColumns_TitlesLongDateTime = 'Datum změny + čas změny';
      LANGcsColumns_TitlesLongDate = 'Datum poslední změny';
      LANGcsColumns_TitlesLongTime = 'Čas poslední změny';
      LANGcsColumns_TitlesLongUser = 'Uživatel';
      LANGcsColumns_TitlesLongGroup = 'Skupina';
      LANGcsColumns_TitlesLongAttr = 'Atributy';
      LANGcsColumns_TitlesShortName = 'Jméno';
      LANGcsColumns_TitlesShortNameExt = 'Jméno';
      LANGcsColumns_TitlesShortExt = 'Typ';
      LANGcsColumns_TitlesShortSize = 'Velikost';
      LANGcsColumns_TitlesShortDateTime = 'Datum';
      LANGcsColumns_TitlesShortDate = 'Datum';
      LANGcsColumns_TitlesShortTime = 'Čas';
      LANGcsColumns_TitlesShortUser = 'Uživatel';
      LANGcsColumns_TitlesShortGroup = 'Skupina';
      LANGcsColumns_TitlesShortAttr = 'Atrib.';

      LANGcsTestPlugin_Caption = 'Test VFS modulu';
      LANGcsTestPlugin_Title = 'Test VFS modulu';
      LANGcsTestPlugin_ExperimentalWarningLabelCaption = '<span weight="ultrabold">Varování:</span> Podystém virtuálního souborového systému (VFS) a integrované moduly jsou momentálně ve vývoji a mohou obsahovat kritické chyby';
      LANGcsTestPlugin_Plugin = '_Modul:';
      LANGcsTestPlugin_Command = '_Adresa:';
      LANGcsTestPlugin_Username = '_Uživatel:';
      LANGcsTestPlugin_Password = '_Heslo:';
      LANGcsTestPlugin_AnonymousCheckButton = '_Anonymní přístup (bez volání funkce VFSLogin)';
      LANGcsTestPlugin_NoPluginsFound = 'Žádný modul není k dispozici';

      LANGcsRemoteWait_Caption = 'Probíhá operace';
      LANGcsRemoteWait_OperationInProgress = 'Aplikace nyní zpracovává váš požadavek, prosím o strpení...';
      LANGcsRemoteWait_ItemsFound = 'Nalezených položek: %d';

      LANGcsSearch_Bytes = 'bajtů';
      LANGcsSearch_kB = 'kB';
      LANGcsSearch_MB = 'MB';
      LANGcsSearch_days = 'dnech';
      LANGcsSearch_weeks = 'týdnech';
      LANGcsSearch_months = 'měsícech';
      LANGcsSearch_years = 'letech';
      LANGcsSearch_Caption = 'Vyhledat soubory';
      LANGcsSearch_General = 'Obecné';
      LANGcsSearch_Advanced = 'Upřesnění';
      LANGcsSearch_SearchResults = '_Výsledky hledání:';
      LANGcsSearch_SearchFor = '_Najít:';
      LANGcsSearch_FileMaskEntryTooltip = 'Tip: Použijte středník pro oddělení více hledaných výrazů';
      LANGcsSearch_SearchIn = 'Hledat _v:';
      LANGcsSearch_SearchArchivesCheckButton = 'Prohledávat _archívy';
      LANGcsSearch_FindText = 'Najít _text:';
      LANGcsSearch_FindTextEntryTooltip = 'Nechte toto pole nevyplněné, nechcete-li vyhledávat text v souboru'#10'Upozornění: řetězce jsou v kódování UTF-8';
      LANGcsSearch_CaseSensitiveCheckButton = '_Rozlišovat velká a malá písmena';
      LANGcsSearch_StayCurrentFSCheckButton = 'Vyhledávat i na připojených _zařízeních';
      LANGcsSearch_CaseSensitiveMatchCheckButton = 'Rozlišovat vel_ká a malá písmena';
      LANGcsSearch_Size = 'Velikost';
      LANGcsSearch_Date = 'Datum';
      LANGcsSearch_BiggerThan = '_Větší než';
      LANGcsSearch_SmallerThan = '_Menší než';
      LANGcsSearch_ModifiedBetweenRadioButton = '_Změněno mezi daty';
      LANGcsSearch_NotModifiedAfterRadioButton = '_Nebylo změněno po datu';
      LANGcsSearch_ModifiedLastRadioButton = 'Změněno v po_sledních';
      LANGcsSearch_ModifiedNotLastRadionButton =  'Nezměněn_o v posledních';
      LANGcsSearch_ModifiedBetweenEntry1 = '"Prosím použijte tento formát data:" c';
      LANGcsSearch_ViewButtonCaption = 'Prohlížet sou_bor';
      LANGcsSearch_NewSearchButtonCaption = 'Nové hle_dání';
      LANGcsSearch_GoToFileButtonCaption = 'Přejít na so_ubor';
      LANGcsSearch_FeedToListboxButtonCaption = 'Nap_lnit hlavní panel';
      LANGcsSearch_StatusSC = 'Stav:';
      LANGcsSearch_Ready = 'Připraveno.';
      LANGcsSearch_PreparingToSearch = 'Příprava hledání.';
      LANGcsSearch_SearchInProgress = 'Probíhá vyhledávání:';
      LANGcsSearch_UserCancelled = 'Přerušeno uživatelem.';
      LANGcsSearch_SearchFinished = 'Vyhledávání dokončeno';
      LANGcsSearch_FilesFound = 'Nalezeno %d souborů';
      LANGcsSearch_And = 'a';

  (***************  STRINGS ADDED TO v0.5.82  **********************************************************************************)
      LANGcsCloseOpenConnection = 'Pokoušíte se otevřít druhé spojení přes další aktivní spojení. Pokračováním bude původní spojení uzavřeno a nahrazeno novým.'#10#10'Přejete si pokračovat?';
      LANGcsDuplicateTabWarning = 'Pokoušíte se otevřít nový panel obsahující otevřené vzdálené spojení. Tato operace nemůže být provedena, protože duplikace spojení není podporováno. Nový panel bude přesměrován na lokální souborový systém.';
      LANGcsDontShowAgain = '_Příště tento dotaz nezobrazovat';
      LANGcsSwitchOtherPanelWarning = 'Pokoušíte se otevřít adresář vzdáleného spojení v druhém panelu. Tato operace nemůže být provedena, protože duplikace spojení není podporováno.';
      LANGcsOpenConnectionsWarning = 'V panelu stále existují otevřená spojení. Ukončením aplikace budou odpojeny.'#10#10'Přejete si aplikaci opravdu ukončit?';
      LANGcsmiDisconnect_Caption = 'O_dpojit';
      LANGcsDisconnectButton_Tooltip = 'Odpojit aktuální spojení';
      LANGcsLeaveArchiveButton_Tooltip = 'Zavřít archiv';
      LANGcsOpenTerminalButton_Tooltip = 'Otevře nové terminálové okno v aktuálním adresáři';
      LANGcsOpenTerminalButton_Caption = 'Te_rminál';
      LANGcsShowTextUIDsCheckBox_Caption = 'Zobrazit vlastníka a sk_upinu textově';
      LANGcsShowTextUIDsCheckBox_Tooltip = 'Použít textové vyjádření vlastníka a skupiny namísto číselné formy (UID/GID)';

  (***************  STRINGS ADDED TO v0.5.100  **********************************************************************************)
      LANGcsmiNewTab_Caption = 'Nový _panel';
      LANGcsFilePopupMenu_Properties = 'Vl_astnosti';
      LANGcsCommandEntry_Tooltip = 'Použijte ''%s'' jako zástupce pro jméno souboru/adresáře';
      LANGcsmiFiles_Caption = 'Pouze pro soubory';

  (***************  STRINGS ADDED TO v0.6.31  **********************************************************************************)
      LANGcsPasswordButton_Tooltip = 'Archív je zabezpečen heslem.'#10'Kliknutím nastavíte heslo.';
      LANGcsHandleRunFromArchive_Bytes = 'bajtů';
      LANGcsHandleRunFromArchive_FileTypeDesc_Unknown = '(není k dispozici)';
      LANGcsHandleRunFromArchive_NotAssociated = '(bez asociace)';
      LANGcsHandleRunFromArchive_SelfExecutable = '(spustitelný)';
      LANGcsHandleRunFromArchive_CouldntCreateTemporaryDirectory = 'Nepodařilo se vytvořit adresář "%s" pro dočasné soubory: %s.'#10#10'Zkontrolujte prosím zadanou cestu a operaci opakujte.';
      LANGcsFRunFromVFS_Caption = 'Vlastnosti souboru';
      LANGcsFRunFromVFS_TitleLabel = 'Vlastnosti';
      LANGcsFRunFromVFS_FileNameLabel = 'Název souboru:';
      LANGcsFRunFromVFS_FileTypeLabel = 'Typ souboru:';
      LANGcsFRunFromVFS_SizeLabel = 'Velikost:';
      LANGcsFRunFromVFS_PackedSizeLabel = 'Komprimovaná velikost:';
      LANGcsFRunFromVFS_DateLabel = 'Datum změny:';
      LANGcsFRunFromVFS_InfoLabel = 'Zobrazení souborů přímo z archívu není možné. Klepnutím na tlačítka níže se vámi vybrané soubory (resp. celý archív) rozbalí do dočasného adresáře, z nějž je lze jednoduše otevřít ve zvolené aplikaci.' +
                                     #10'Všechny dočasné soubory budou smazány při ukončení aplikace Tux Commander.';
      LANGcsFRunFromVFS_OpensWithLabel = 'Otevřít v:';
      LANGcsFRunFromVFS_ExecuteButton = 'E_xtrahovat a otevřít';
      LANGcsFRunFromVFS_ExecuteAllButton = 'Extrahovat _vše a otevřít';
      LANGcsFSetPassword_Caption = 'Heslo archívu';
      LANGcsFSetPassword_Label1_Caption = 'Zadejte prosím heslo';
      LANGcsFSetPassword_Label2_Caption = 'Pro přístup a práci s obsahem archívu je potřeba zadat heslo';
      LANGcsFSetPassword_ShowPasswordCheckButton = 'Od_krýt heslo';

  (***************  STRINGS ADDED TO v0.6.48  **********************************************************************************)
      LANGcsCopyFileNamesToClipboard = 'Zkopírovat jmé_na souborů do schránky';
      LANGcsCopyFullPathNamesToClipboard = 'Zkopírovat _absolutní cesty do schránky';
      LANGcsCopyPathToClipboard = 'Zkopírovat _cestu do schránky';
      LANGcsPreferences_DateFormatLabel_Caption = '_Formát data:';
      LANGcsPreferences_System = 'Systémový';
      LANGcsPreferences_Custom = 'Vlastní...';
      LANGcsPreferences_CustomDateFormatEntry_Tooltip = 'Zadejte prosím vlastní formát data.'#10'Formátovací značky lze nalézt v manuálové stránce "man strftime".';
      LANGcsPreferences_TimeFormatLabel_Caption = 'Formát čas_u:';
      LANGcsPreferences_CustomTimeFormatEntry_Tooltip = 'Zadejte prosím vlastní formát času.'#10'Formátovací značky lze nalézt v manuálové stránce "man strftime".';
      LANGcsPreferences_DateTimeFormatLabel_Caption = '_Pořadí data a času:';
      LANGcsPreferences_QuickRenameSkipExtCheckBox = 'Přej_menování bez koncovky souboru';
      LANGcsPreferences_QuickRenameSkipExtCheckBox_Tooltip = 'Nezahrnovat do výběru koncovku souboru při přejmenovávání';
      LANGcsPreferences_SortDirectoriesLikeFilesCheckBox = 'Řadit adresáře po_dle souborů';
      LANGcsPreferences_SortDirectoriesLikeFilesCheckBox_Tooltip = 'Je-li tato volba aktivní, budou adresáře řazeny stejně jako soubory. Adresáře se zobrazují vždy na začátku seznamu.'#10'Volba neaktivní: adresáře budou řazeny vždy podle jména.';
      LANGcsPreferences_QuickSearchLabel_Caption = 'Klávesy _rychlého vyhledávání:';
      LANGcsPreferences_QuickSearchOptionMenu_Tooltip = 'Klávesové zkratky Ctrl+S/Alt+S a "/" jsou aktivní vždy, nezávisle na dalším nastavení.';
      LANGcsPreferences_QuickSearch_Option1 = 'Jen Ctrl+S/Alt+S a "/"';
      LANGcsPreferences_QuickSearch_Option2 = 'Ctrl+Alt+písmena';
      LANGcsPreferences_QuickSearch_Option3 = 'Alt+písmena';
      LANGcsPreferences_QuickSearch_Option4 = 'přímo písmena';
      LANGcsPreferences_TempPathLabel_Caption = 'Dočasné soubory';
      LANGcsPreferences_VFSTempPathLabel_Caption = '_VFS subsystém:';
      LANGcsPreferences_VFSTempPathEntry_Tooltip = 'Umístění dočasných souborů VFS subsystému, použitých např. při otevírání souborů přímo z archívu. Všechny dočasné soubory budou odstraněny při ukončení aplikace.';



(********************************************************************************************************************************)
procedure SetTranslation;
begin
  LANGF2Button_Caption := LANGcsF2Button_Caption;
  LANGF3Button_Caption := LANGcsF3Button_Caption;
  LANGF4Button_Caption := LANGcsF4Button_Caption;
  LANGF5Button_Caption := LANGcsF5Button_Caption;
  LANGF6Button_Caption := LANGcsF6Button_Caption;
  LANGF7Button_Caption := LANGcsF7Button_Caption;
  LANGF8Button_Caption := LANGcsF8Button_Caption;

  LANGmnuFile_Caption := LANGcsmnuFile_Caption;
  LANGmnuMark_Caption := LANGcsmnuMark_Caption;
  LANGmnuCommands_Caption := LANGcsmnuCommands_Caption;
  LANGmnuHelp_Caption := LANGcsmnuHelp_Caption;
  LANGmiExit_Caption := LANGcsmiExit_Caption;
  LANGmiSelectGroup_Caption := LANGcsmiSelectGroup_Caption;
  LANGmiUnselectGroup_Caption := LANGcsmiUnselectGroup_Caption;
  LANGmiSelectAll_Caption := LANGcsmiSelectAll_Caption;
  LANGmiUnselectAll_Caption := LANGcsmiUnselectAll_Caption;
  LANGmiInvertSelection_Caption := LANGcsmiInvertSelection_Caption;
  LANGmiRefresh_Caption := LANGcsmiRefresh_Caption;
  LANGmiAbout_Caption := LANGcsmiAbout_Caption;

  LANGColumn1_Caption := LANGcsColumn1_Caption;
  LANGColumn2_Caption := LANGcsColumn2_Caption;
  LANGColumn3_Caption := LANGcsColumn3_Caption;
  LANGColumn4_Caption := LANGcsColumn4_Caption;
  LANGColumn5_Caption := LANGcsColumn5_Caption;

  LANGExpandSelection := LANGcsExpandSelection;
  LANGShrinkSelection := LANGcsShrinkSelection;
  LANGNoMatchesFound := LANGcsNoMatchesFound;
  LANGNoFilesSelected := LANGcsNoFilesSelected;
  LANGSelectedFilesDirectories := LANGcsSelectedFilesDirectories;
  LANGDirectoryS := LANGcsDirectoryS;
  LANGFileS := LANGcsFileS;
  LANGDoYouReallyWantToDeleteTheS := LANGcsDoYouReallyWantToDeleteTheS;
  LANGDoYouReallyWantToDeleteTheSS := LANGcsDoYouReallyWantToDeleteTheSS;
  LANGCopyFiles := LANGcsCopyFiles;
  LANGMoveRenameFiles := LANGcsMoveRenameFiles;
  LANGCopyDFileDirectoriesTo := LANGcsCopyDFileDirectoriesTo;
  LANGMoveRenameDFileDirectoriesTo := LANGcsMoveRenameDFileDirectoriesTo;
  LANGCopySC := LANGcsCopySC;
  LANGMoveRenameSC := LANGcsMoveRenameSC;

  LANGQuickFind := LANGcsQuickFind;

  LANGAboutString := LANGcsAboutString;
  LANGAboutStringGnome := LANGcsAboutStringGnome;
  LANGDiskStatFmt := LANGcsDiskStatFmt;
  LANGDiskStatVolNameFmt := LANGcsDiskStatVolNameFmt;
  LANGStatusLineFmt := LANGcsStatusLineFmt;
  LANGPanelStrings[False] := LANGcsPanelStrings[False];
  LANGPanelStrings[True] := LANGcsPanelStrings[True];
  LANGDIR := LANGcsDIR;
  LANGErrorGettingListingForSPanel := LANGcsErrorGettingListingForSPanel;
  LANGErrorGettingListingForSPanelNoPath := LANGcsErrorGettingListingForSPanelNoPath;
  LANGErrorCreatingNewDirectorySInSPanel := LANGcsErrorCreatingNewDirectorySInSPanel;
  LANGErrorCreatingNewDirectorySInSPanelNoPath := LANGcsErrorCreatingNewDirectorySInSPanelNoPath;
  LANGTheFileDirectory := LANGcsTheFileDirectory;
  LANGCouldNotBeDeleted := LANGcsCouldNotBeDeleted;
  LANGCouldNotBeDeletedS := LANGcsCouldNotBeDeletedS;
  LANGUserCancelled := LANGcsUserCancelled;
  LANGTheDirectorySIsNotEmpty := LANGcsTheDirectorySIsNotEmpty;
  LANGCannotCopyFile := LANGcsCannotCopyFile;
  LANGCopyError := LANGcsCopyError;
  LANGMoveError := LANGcsMoveError;
  LANGOverwriteS := LANGcsOverwriteS;
  LANGWithFileS := LANGcsWithFileS;
  LANGOvewriteSBytesS := LANGcsOvewriteSBytesS;
  LANGTheFile := LANGcsTheFile;
  LANGCopy := LANGcsCopy;
  LANGMove := LANGcsMove;
  LANGTheDirectory := LANGcsTheDirectory;
  LANGTheSymbolicLink := LANGcsTheSymbolicLink;
  LANGCannotMoveFile := LANGcsCannotMoveFile;
  LANGCouldNotBeCreated := LANGcsCouldNotBeCreated;
  LANGCouldNotBeCreatedS := LANGcsCouldNotBeCreatedS;
  LANGFromS := LANGcsFromS;
  LANGToS := LANGcsToS;
  LANGCannotCopyFileToItself := LANGcsCannotCopyFileToItself;
  LANGMemoryAllocationFailed := LANGcsMemoryAllocationFailed;
  LANGCannotOpenSourceFile := LANGcsCannotOpenSourceFile;
  LANGCannotOpenDestinationFile := LANGcsCannotOpenDestinationFile;
  LANGCannotCloseDestinationFile := LANGcsCannotCloseDestinationFile;
  LANGCannotCloseSourceFile := LANGcsCannotCloseSourceFile;
  LANGCannotReadFromSourceFile := LANGcsCannotReadFromSourceFile;
  LANGCannotWriteToDestinationFile := LANGcsCannotWriteToDestinationFile;

  LANGUnknownException := LANGcsUnknownException;
  LANGNoAccess := LANGcsNoAccess;
  LANGUnknownError := LANGcsUnknownError;

  LANGCreateANewDirectory := LANGcsCreateANewDirectory;
  LANGEnterDirectoryName := LANGcsEnterDirectoryName;

  LANGOverwriteQuestion := LANGcsOverwriteQuestion;
  LANGOverwriteButton_Caption := LANGcsOverwriteButton_Caption;
  LANGOverwriteAllButton_Caption := LANGcsOverwriteAllButton_Caption;
  LANGSkipButton_Caption := LANGcsSkipButton_Caption;
  LANGOverwriteAllOlderButton_Caption := LANGcsOverwriteAllOlderButton_Caption;
  LANGSkipAllButton_Caption := LANGcsSkipAllButton_Caption;
  LANGRenameButton_Caption := LANGcsRenameButton_Caption;
  LANGAppendButton_Caption := LANGcsAppendButton_Caption;
  LANGRename := LANGcsRename;
  LANGRenameFile := LANGcsRenameFile;
  LANGIgnoreButton_Caption := LANGcsIgnoreButton_Caption;

  LANGProgress := LANGcsProgress;
  LANGCancel := LANGcsCancel;
  LANGDelete := LANGcsDelete;

  LANGSpecifyFileType := LANGcsSpecifyFileType;

  LANGRemoveDirectory := LANGcsRemoveDirectory;
  LANGDoYouWantToDeleteItWithAllItsFilesAndSubdirectories := LANGcsDoYouWantToDeleteItWithAllItsFilesAndSubdirectories;
  LANGRetry := LANGcsRetry;
  LANGDeleteButton_Caption := LANGcsDeleteButton_Caption;
  LANGAll := LANGcsAll;

  LANGCopyFilesSC := LANGcsCopyFilesSC;
  LANGAppendQuestion := LANGcsAppendQuestion;
  LANGPreparingList := LANGcsPreparingList;

  LANGYouMustSelectAValidFile := LANGcsYouMustSelectAValidFile;
  LANGmiVerifyChecksums := LANGcsmiVerifyChecksums;
  LANGVerifyChecksumsCaption := LANGcsVerifyChecksumsCaption;
  LANGCheckButtonCaptionCheck := LANGcsCheckButtonCaptionCheck;
  LANGCheckButtonCaptionStop := LANGcsCheckButtonCaptionStop;
  LANGFileListTooltip := LANGcsFileListTooltip;
  LANGFilenameColumnCaption := LANGcsFilenameColumnCaption;
  LANGTheFileSYouAreTryingToOpenIsQuiteBig := LANGcsTheFileSYouAreTryingToOpenIsQuiteBig;
  LANGAnErrorOccuredWhileInitializingMemoryBlock := LANGcsAnErrorOccuredWhileInitializingMemoryBlock;
  LANGAnErrorOccuredWhileOpeningFileSS := LANGcsAnErrorOccuredWhileOpeningFileSS;
  LANGAnErrorOccuredWhileReadingFileSS := LANGcsAnErrorOccuredWhileReadingFileSS;
  LANGChecksumNotChecked := LANGcsChecksumNotChecked;
  LANGChecksumChecking := LANGcsChecksumChecking;
  LANGChecksumInterrupted := LANGcsChecksumInterrupted;
  LANGChecksumDOK := LANGcsChecksumDOK;

  LANGmiCreateChecksumsCaption := LANGcsmiCreateChecksumsCaption;
  LANGYouMustSelectAtLeastOneFileToCalculateChecksum := LANGcsYouMustSelectAtLeastOneFileToCalculateChecksum;
  LANGCreateChecksumsCaption := LANGcsCreateChecksumsCaption;
  LANGCCHKSUMPage1Text := LANGcsCCHKSUMPage1Text;
  LANGCCHKSUMPage4Text := LANGcsCCHKSUMPage4Text;
  LANGCCHKSUMPage6Text := LANGcsCCHKSUMPage6Text;
  LANGCCHKSUMPage7Text := LANGcsCCHKSUMPage7Text;
  LANGCCHKSUMPage1Title := LANGcsCCHKSUMPage1Title;
  LANGCCHKSUMPage2Title := LANGcsCCHKSUMPage2Title;
  LANGCCHKSUMPage3Title := LANGcsCCHKSUMPage3Title;
  LANGCCHKSUMPage4Title := LANGcsCCHKSUMPage4Title;
  LANGCCHKSUMPage5Title := LANGcsCCHKSUMPage5Title;
  LANGCCHKSUMPage6Title := LANGcsCCHKSUMPage6Title;
  LANGCCHKSUMPage7Title := LANGcsCCHKSUMPage7Title;
  LANGCCHKSUMSFVFile := LANGcsCCHKSUMSFVFile;
  LANGCCHKSUMMD5sumFile := LANGcsCCHKSUMMD5sumFile;
  LANGCCHKSUMFileName := LANGcsCCHKSUMFileName;
  LANGCCHKSUMCreateSeparateChecksumFiles := LANGcsCCHKSUMCreateSeparateChecksumFiles;
  LANGCCHKSUMNowProcessingFileS := LANGcsCCHKSUMNowProcessingFileS;
  LANGCCHKSUMFinishCaption := LANGcsCCHKSUMFinishCaption;
  LANGCCHKSUMAreYouSureYouWantToAbortTheProcessing := LANGcsCCHKSUMAreYouSureYouWantToAbortTheProcessing;
  LANGCCHKSUMAnErrorOccuredWhileOpeningFileSS := LANGcsCCHKSUMAnErrorOccuredWhileOpeningFileSS;
  LANGCCHKSUMAnErrorOccuredWhileReadingFileSS := LANGcsCCHKSUMAnErrorOccuredWhileReadingFileSS;
  LANGCCHKSUMAnErrorOccuredWhileWritingFileSS := LANGcsCCHKSUMAnErrorOccuredWhileWritingFileSS;

  LANGAnErrorOccuredWhileWritingFileSS := LANGcsAnErrorOccuredWhileWritingFileSS;
  LANGTheTargetFileSAlreadyExistsDoYouWantToOverwriteIt := LANGcsTheTargetFileSAlreadyExistsDoYouWantToOverwriteIt;
  LANGTheTargetFileSCannotBeRemovedS := LANGcsTheTargetFileSCannotBeRemovedS;
  LANGMergeCaption := LANGcsMergeCaption;
  LANGPleaseInsertNextDiskOrGiveDifferentLocation := LANGcsPleaseInsertNextDiskOrGiveDifferentLocation;
  LANGMergeOfSSucceeded := LANGcsMergeOfSSucceeded;
  LANGWarningCreatedFileFailsCRCCheck := LANGcsWarningCreatedFileFailsCRCCheck;
  LANGMergeOfSSucceeded_NoCRCFileAvailable := LANGcsMergeOfSSucceeded_NoCRCFileAvailable;
  LANGMergeSAndAllFilesWithAscendingNamesToTheFollowingDirectory := LANGcsMergeSAndAllFilesWithAscendingNamesToTheFollowingDirectory;
  LANGMergeSC := LANGcsMergeSC;
  LANGmiSplitFileCaption := LANGcsmiSplitFileCaption;
  LANGmiMergeFilesCaption := LANGcsmiMergeFilesCaption;
  
  LANGSplitTheFileSToDirectory := LANGcsSplitTheFileSToDirectory;
  LANGSplitSC := LANGcsSplitSC;
  LANGSplitFile := LANGcsSplitFile;
  LANGBytesPerFile := LANGcsBytesPerFile;
  LANGAutomatic := LANGcsAutomatic;
  LANGDeleteFilesOnTargetDisk := LANGcsDeleteFilesOnTargetDisk;
  LANGSplitCaption := LANGcsSplitCaption;
  LANGCannotOpenFileS := LANGcsCannotOpenFileS;
  LANGCannotSplitTheFileToMoreThan999Parts := LANGcsCannotSplitTheFileToMoreThan999Parts;
  LANGThereAreSomeFilesInTheTargetDirectorySDoYouWantToDeleteThem := LANGcsThereAreSomeFilesInTheTargetDirectorySDoYouWantToDeleteThem;
  LANGThereAreDFilesInTheTargetDirectoryDoYouWantToDeleteThem := LANGcsThereAreDFilesInTheTargetDirectoryDoYouWantToDeleteThem;
  LANGAnErrorOccuredWhileOperationS := LANGcsAnErrorOccuredWhileOperationS;
  LANGSplitOfSSucceeded := LANGcsSplitOfSSucceeded;
  LANGSplitOfSFailed := LANGcsSplitOfSFailed;

  LANGmnuShow_Caption := LANGcsmnuShow_Caption;
  LANGmiShowDotFiles_Caption := LANGcsmiShowDotFiles_Caption;
  LANGTheFileYouAreTryingToOpenIsQuiteBig := LANGcsTheFileYouAreTryingToOpenIsQuiteBig;
  LANGCannotExecuteSPleaseCheckTheConfiguration := LANGcsCannotExecuteSPleaseCheckTheConfiguration;
  LANGEdit := LANGcsEdit;
  LANGEnterFilenameToEdit := LANGcsEnterFilenameToEdit;

  LANGmnuSettings_Caption := LANGcsmnuSettings_Caption;
  LANGmiFileTypes_Caption := LANGcsmiFileTypes_Caption;
  LANGThereIsNoApplicationAssociatedWithS := LANGcsThereIsNoApplicationAssociatedWithS;
  LANGErrorExecutingCommand := LANGcsErrorExecutingCommand;
  LANGEditFileTypesCaption := LANGcsEditFileTypesCaption;
  LANGTitleLabel_Caption := LANGcsTitleLabel_Caption;
  LANGExtensionsColumn := LANGcsExtensionsColumn;
  LANGDescriptionColumn := LANGcsDescriptionColumn;
  LANGFileTypesList := LANGcsFileTypesList;
  LANGActionName := LANGcsActionName;
  LANGCommand := LANGcsCommand;
  LANGSetDefaultActionButton_Caption := LANGcsSetDefaultActionButton_Caption;
  LANGRunInTerminalCheckBox_Caption := LANGcsRunInTerminalCheckBox_Caption;
  LANGAutodetectCheckBox_Caption := LANGcsAutodetectCheckBox_Caption;
  LANGBrowseButton_Caption := LANGcsBrowseButton_Caption;
  LANGCommandLabel_Caption := LANGcsCommandLabel_Caption;
  LANGDescriptionLabel_Caption := LANGcsDescriptionLabel_Caption;
  LANGFNameExtLabel_Caption := LANGcsFNameExtLabel_Caption;
  LANGNotebookPageExtensions := LANGcsNotebookPageExtensions;
  LANGNotebookPageActions := LANGcsNotebookPageActions;
  LANGDefault := LANGcsDefault;
  LANGCannotSaveFileTypeAssociationsBecauseOtherProcess := LANGcsCannotSaveFileTypeAssociationsBecauseOtherProcess;

  LANGDefaultColor := LANGcsDefaultColor;
  LANGIcon := LANGcsIcon;
  LANGBrowseForIcon := LANGcsBrowseForIcon;
  LANGSelectFileTypeColor := LANGcsSelectFileTypeColor;
  LANGColor := LANGcsColor;

  LANGmiChangePermissions_Caption := LANGcsmiChangePermissions_Caption;
  LANGmiChangeOwner_Caption := LANGcsmiChangeOwner_Caption;
  LANGmiCreateSymlink_Caption := LANGcsmiCreateSymlink_Caption;
  LANGmiEditSymlink_Caption := LANGcsmiEditSymlink_Caption;
  LANGChmodProgress := LANGcsChmodProgress;
  LANGChownProgress := LANGcsChownProgress;
  LANGYouMustSelectAValidSymbolicLink := LANGcsYouMustSelectAValidSymbolicLink;
  LANGPopupRunS := LANGcsPopupRunS;
  LANGPopupOpenS := LANGcsPopupOpenS;
  LANGPopupGoUp := LANGcsPopupGoUp;
  LANGPopupOpenWithS := LANGcsPopupOpenWithS;
  LANGPopupDefault := LANGcsPopupDefault;
  LANGPopupOpenWith := LANGcsPopupOpenWith;
  LANGPopupViewFile := LANGcsPopupViewFile;
  LANGPopupEditFile := LANGcsPopupEditFile;
  LANGPopupMakeSymlink := LANGcsPopupMakeSymlink;
  LANGPopupRename := LANGcsPopupRename;
  LANGPopupDelete := LANGcsPopupDelete;
  LANGDialogChangePermissions := LANGcsDialogChangePermissions;
  LANGCouldNotBeChmoddedS := LANGcsCouldNotBeChmoddedS;
  LANGDialogChangeOwner := LANGcsDialogChangeOwner;
  LANGCouldNotBeChownedS := LANGcsCouldNotBeChownedS;
  LANGDialogMakeSymlink := LANGcsDialogMakeSymlink;
  LANGDialogEditSymlink := LANGcsDialogEditSymlink;
  LANGFEditSymlink_Caption := LANGcsFEditSymlink_Caption;
  LANGFEditSymlink_SymbolicLinkFilename := LANGcsFEditSymlink_SymbolicLinkFilename;
  LANGFEditSymlink_SymbolicLinkPointsTo := LANGcsFEditSymlink_SymbolicLinkPointsTo;

  LANGFChmod_Caption := LANGcsFChmod_Caption;
  LANGFChmod_PermissionFrame := LANGcsFChmod_PermissionFrame;
  LANGFChmod_FileFrame := LANGcsFChmod_FileFrame;
  LANGFChmod_ApplyRecursivelyFor := LANGcsFChmod_ApplyRecursivelyFor;
  LANGFChmod_miAllFiles := LANGcsFChmod_miAllFiles;
  LANGFChmod_miDirectories := LANGcsFChmod_miDirectories;
  LANGFChmod_OctalLabel := LANGcsFChmod_OctalLabel;
  LANGFChmod_SUID := LANGcsFChmod_SUID;
  LANGFChmod_SGID := LANGcsFChmod_SGID;
  LANGFChmod_Sticky := LANGcsFChmod_Sticky;
  LANGFChmod_RUSR := LANGcsFChmod_RUSR;
  LANGFChmod_WUSR := LANGcsFChmod_WUSR;
  LANGFChmod_XUSR := LANGcsFChmod_XUSR;
  LANGFChmod_RGRP := LANGcsFChmod_RGRP;
  LANGFChmod_WGRP := LANGcsFChmod_WGRP;
  LANGFChmod_XGRP := LANGcsFChmod_XGRP;
  LANGFChmod_ROTH := LANGcsFChmod_ROTH;
  LANGFChmod_WOTH := LANGcsFChmod_WOTH;
  LANGFChmod_XOTH := LANGcsFChmod_XOTH;
  LANGFChmod_TextLabel := LANGcsFChmod_TextLabel;
  LANGFChmod_FileLabel := LANGcsFChmod_FileLabel;
  LANGFChown_Caption := LANGcsFChown_Caption;
  LANGFChown_OwnerFrame := LANGcsFChown_OwnerFrame;
  LANGFChown_GroupFrame := LANGcsFChown_GroupFrame;
  LANGFChown_FileFrame := LANGcsFChown_FileFrame;
  LANGFChown_ApplyRecursively := LANGcsFChown_ApplyRecursively;

  LANGFSymlink_Caption := LANGcsFSymlink_Caption;
  LANGFSymlink_ExistingFilename := LANGcsFSymlink_ExistingFilename;
  LANGFSymlink_SymlinkFilename := LANGcsFSymlink_SymlinkFilename;

  LANGmnuBookmarks_Caption := LANGcsmnuBookmarks_Caption;
  LANGmiAddBookmark_Caption := LANGcsmiAddBookmark_Caption;
  LANGmiEditBookmarks_Caption := LANGcsmiEditBookmarks_Caption;
  LANGBookmarkPopupDelete_Caption := LANGcsBookmarkPopupDelete_Caption;
  LANGmiPreferences_Caption := LANGcsmiPreferences_Caption;
  LANGTheCurrentDirectoryAlreadyExistsInTheBookmarksList := LANGcsTheCurrentDirectoryAlreadyExistsInTheBookmarksList;
  LANGSomeOtherInstanceChanged := LANGcsSomeOtherInstanceChanged;

  LANGPreferences_Caption := LANGcsPreferences_Caption;
  LANGPreferences_TitleLabel_Caption := LANGcsPreferences_TitleLabel_Caption;
  LANGPreferences_GeneralPage := LANGcsPreferences_GeneralPage;
  LANGPreferences_FontsPage := LANGcsPreferences_FontsPage;
  LANGPreferences_ColorsPage := LANGcsPreferences_ColorsPage;
  LANGPreferences_RowHeight := LANGcsPreferences_RowHeight;
  LANGPreferences_NumHistoryItems := LANGcsPreferences_NumHistoryItems;
  LANGPreferences_Default := LANGcsPreferences_Default;
  LANGPreferences_ClearReadonlyAttribute := LANGcsPreferences_ClearReadonlyAttribute;
  LANGPreferences_DisableMouseRenaming := LANGcsPreferences_DisableMouseRenaming;
  LANGPreferences_ShowFiletypeIconsInList := LANGcsPreferences_ShowFiletypeIconsInList;
  LANGPreferences_ExternalAppsLabel := LANGcsPreferences_ExternalAppsLabel;
  LANGPreferences_Viewer := LANGcsPreferences_Viewer;
  LANGPreferences_Editor := LANGcsPreferences_Editor;
  LANGPreferences_Terminal := LANGcsPreferences_Terminal;
  LANGPreferences_ListFont := LANGcsPreferences_ListFont;
  LANGPreferences_Change := LANGcsPreferences_Change;
  LANGPreferences_UseDefaultFont := LANGcsPreferences_UseDefaultFont;
  LANGPreferences_Foreground := LANGcsPreferences_Foreground;
  LANGPreferences_Background := LANGcsPreferences_Background;
  LANGPreferences_NormalItem := LANGcsPreferences_NormalItem;
  LANGPreferences_SetToDefaultToUseGTKThemeColors := LANGcsPreferences_SetToDefaultToUseGTKThemeColors;
  LANGPreferences_Cursor := LANGcsPreferences_Cursor;
  LANGPreferences_InactiveItem := LANGcsPreferences_InactiveItem;
  LANGPreferences_SelectedItem := LANGcsPreferences_SelectedItem;
  LANGPreferences_LinkItem := LANGcsPreferences_LinkItem;
  LANGPreferences_LinkItemHint := LANGcsPreferences_LinkItemHint;
  LANGPreferences_DotFileItem := LANGcsPreferences_DotFileItem;
  LANGPreferences_DotFileItemHint := LANGcsPreferences_DotFileItemHint;
  LANGPreferences_BrowseForApplication := LANGcsPreferences_BrowseForApplication;
  LANGPreferences_DefaultS := LANGcsPreferences_DefaultS;
  LANGPreferences_SelectFont := LANGcsPreferences_SelectFont;

  LANGBookmarkButton_Tooltip := LANGcsBookmarkButton_Tooltip;
  LANGUpButton_Tooltip := LANGcsUpButton_Tooltip;
  LANGRootButton_Tooltip := LANGcsRootButton_Tooltip;
  LANGHomeButton_Tooltip := LANGcsHomeButton_Tooltip;
  LANGLeftEqualButton_Tooltip := LANGcsLeftEqualButton_Tooltip;
  LANGRightEqualButton_Tooltip := LANGcsRightEqualButton_Tooltip;
  LANGmiShowDirectorySizes_Caption := LANGcsmiShowDirectorySizes_Caption;
  LANGmiTargetSource_Caption := LANGcsmiTargetSource_Caption;
  LANGFileTypeDirectory := LANGcsFileTypeDirectory;
  LANGFileTypeFile := LANGcsFileTypeFile;
  LANGFileTypeMetafile := LANGcsFileTypeMetafile;
  LANGPreferencesPanelsPage := LANGcsPreferencesPanelsPage;
  LANGPreferencesApplicationsPage := LANGcsPreferencesApplicationsPage;
  LANGPreferencesExperimentalPage := LANGcsPreferencesExperimentalPage;
  LANGPreferencesSelectAllDirectoriesCheckBox_Caption := LANGcsPreferencesSelectAllDirectoriesCheckBox_Caption;
  LANGPreferencesNewStyleAltOCheckBox_Caption := LANGcsPreferencesNewStyleAltOCheckBox_Caption;
  LANGPreferencesNewStyleAltOCheckBox_Tooltip := LANGcsPreferencesNewStyleAltOCheckBox_Tooltip;
  LANGPreferencesShowFuncButtonsCheckBox_Caption := LANGcsPreferencesShowFuncButtonsCheckBox_Caption;
  LANGPreferencesSizeFormatLabel_Caption := LANGcsPreferencesSizeFormatLabel_Caption;
  LANGPreferencesmiSizeFormat1 := LANGcsPreferencesmiSizeFormat1;
  LANGPreferencesmiSizeFormat6 := LANGcsPreferencesmiSizeFormat6;
  LANGPreferencesAutodetectXApp := LANGcsPreferencesAutodetectXApp;
  LANGPreferencesAlwaysRunInTerminal := LANGcsPreferencesAlwaysRunInTerminal;
  LANGPreferencesNeverRunInTerminal := LANGcsPreferencesNeverRunInTerminal;
  LANGPreferencesCmdLineBehaviourLabel_Caption := LANGcsPreferencesCmdLineBehaviourLabel_Caption;
  LANGPreferencesFeatures := LANGcsPreferencesFeatures;
  LANGPreferencesDisableMouseRename_Tooltip := LANGcsPreferencesDisableMouseRename_Tooltip;
  LANGPreferencesDisableFileTipsCheckBox_Caption := LANGcsPreferencesDisableFileTipsCheckBox_Caption;
  LANGPreferencesDisableFileTipsCheckBox_Tooltip := LANGcsPreferencesDisableFileTipsCheckBox_Tooltip;
  LANGPreferencesShow := LANGcsPreferencesShow;
  LANGPreferencesDirsInBoldCheckBox_Caption := LANGcsPreferencesDirsInBoldCheckBox_Caption;
  LANGPreferencesDisableDirectoryBracketsCheckBox_Caption := LANGcsPreferencesDisableDirectoryBracketsCheckBox_Caption;
  LANGPreferencesOctalPermissionsCheckBox_Caption := LANGcsPreferencesOctalPermissionsCheckBox_Caption;
  LANGPreferencesOctalPermissionsCheckBox_Tooltip := LANGcsPreferencesOctalPermissionsCheckBox_Tooltip;
  LANGPreferencesMovement := LANGcsPreferencesMovement;
  LANGPreferencesLynxLikeMotionCheckBox_Caption := LANGcsPreferencesLynxLikeMotionCheckBox_Caption;
  LANGPreferencesInsertMovesDownCheckBox_Caption := LANGcsPreferencesInsertMovesDownCheckBox_Caption;
  LANGPreferencesSpaceMovesDownCheckBox_Caption := LANGcsPreferencesSpaceMovesDownCheckBox_Caption;
  LANGPreferencesViewer := LANGcsPreferencesViewer;
  LANGPreferencesCommandSC := LANGcsPreferencesCommandSC;
  LANGPreferencesUseInternalViewer := LANGcsPreferencesUseInternalViewer;
  LANGPreferencesEditor := LANGcsPreferencesEditor;
  LANGPreferencesTerminal := LANGcsPreferencesTerminal;
  LANGPreferencesExperimentalFeatures := LANGcsPreferencesExperimentalFeatures;
  LANGPreferencesExperimentalWarningLabel_Caption := LANGcsPreferencesExperimentalWarningLabel_Caption;
  LANGPreferencesFocusRefreshCheckBox_Caption := LANGcsPreferencesFocusRefreshCheckBox_Caption;
  LANGPreferencesFocusRefreshCheckBox_Tooltip := LANGcsPreferencesFocusRefreshCheckBox_Tooltip;
  LANGPreferencesWMCompatModeCheckBox_Caption := LANGcsPreferencesWMCompatModeCheckBox_Caption;
  LANGPreferencesWMCompatModeCheckBox_Tooltip := LANGcsPreferencesWMCompatModeCheckBox_Tooltip;
  LANGPreferencesCompatUseLibcSystemCheckBox_Caption := LANGcsPreferencesCompatUseLibcSystemCheckBox_Caption;
  LANGPreferencesCompatUseLibcSystemCheckBox_Tooltip := LANGcsPreferencesCompatUseLibcSystemCheckBox_Tooltip;

  LANGmiSearchCaption2 := LANGcsmiSearchCaption2;
  LANGmiNoMounterBarCaption := LANGcsmiNoMounterBarCaption;
  LANGmiShowOneMounterBarCaption := LANGcsmiShowOneMounterBarCaption;
  LANGmiShowTwoMounterBarCaption := LANGcsmiShowTwoMounterBarCaption;
  LANGmnuNetworkCaption := LANGcsmnuNetworkCaption;
  LANGmiConnectionsCaption := LANGcsmiConnectionsCaption;
  LANGmiOpenConnectionCaption := LANGcsmiOpenConnectionCaption;
  LANGmiQuickConnectCaption := LANGcsmiQuickConnectCaption;
  LANGmnuPluginsCaption := LANGcsmnuPluginsCaption;
  LANGmiTestPluginCaption := LANGcsmiTestPluginCaption;
  LANGmiMounterSettingsCaption := LANGcsmiMounterSettingsCaption;
  LANGmiColumnsCaption := LANGcsmiColumnsCaption;
  LANGmiSavePositionCaption := LANGcsmiSavePositionCaption;
  LANGmiMountCaption := LANGcsmiMountCaption;
  LANGmiUmountCaption := LANGcsmiUmountCaption;
  LANGmiEjectCaption := LANGcsmiEjectCaption;
  LANGmiDuplicateTabCaption := LANGcsmiDuplicateTabCaption;
  LANGmiCloseTabCaption := LANGcsmiCloseTabCaption;
  LANGmiCloseAllTabsCaption := LANGcsmiCloseAllTabsCaption;
  LANGCannotDetermineDestinationEngine := LANGcsCannotDetermineDestinationEngine;
  LANGCannotLoadFile := LANGcsCannotLoadFile;
  LANGMountPointDevice := LANGcsMountPointDevice;
  LANGMountSC := LANGcsMountSC;
  LANGNoPluginsFound := LANGcsNoPluginsFound;
  LANGPluginAbout := LANGcsPluginAbout;
  LANGCouldntOpenURI := LANGcsCouldntOpenURI;
  LANGPluginAboutInside := LANGcsPluginAboutInside;
  LANGAreYouSureCloseAllTabs := LANGcsAreYouSureCloseAllTabs;
  LANGCouldntOpenURIArchive := LANGcsCouldntOpenURIArchive;
  LANGThereIsNoModuleAvailable := LANGcsThereIsNoModuleAvailable;
  LANGIgnoreError := LANGcsIgnoreError;
  LANGErrorMount := LANGcsErrorMount;
  LANGErrorUmount := LANGcsErrorUmount;
  LANGErrorEject := LANGcsErrorEject;

  LANGMounterPrefs_Caption := LANGcsMounterPrefs_Caption;
  LANGMounterPrefs_TitleLabelCaption := LANGcsMounterPrefs_TitleLabelCaption;
  LANGMounterPrefs_ListViewFrameCaption := LANGcsMounterPrefs_ListViewFrameCaption;
  LANGMounterPrefs_MountName := LANGcsMounterPrefs_MountName;
  LANGMounterPrefs_MountPoint := LANGcsMounterPrefs_MountPoint;
  LANGMounterPrefs_Device := LANGcsMounterPrefs_Device;
  LANGMounterPrefs_MoveUpButtonTooltip := LANGcsMounterPrefs_MoveUpButtonTooltip;
  LANGMounterPrefs_MoveDownButtonTooltip := LANGcsMounterPrefs_MoveDownButtonTooltip;
  LANGMounterPrefs_UseFSTabDefaultsCheckBox := LANGcsMounterPrefs_UseFSTabDefaultsCheckBox;
  LANGMounterPrefs_UseFSTabDefaultsCheckBoxTooltip := LANGcsMounterPrefs_UseFSTabDefaultsCheckBoxTooltip;
  LANGMounterPrefs_ToggleModeCheckBox := LANGcsMounterPrefs_ToggleModeCheckBox;
  LANGMounterPrefs_ToggleModeCheckBoxTooltip := LANGcsMounterPrefs_ToggleModeCheckBoxTooltip;
  LANGMounterPrefs_PropertiesFrameCaption := LANGcsMounterPrefs_PropertiesFrameCaption;
  LANGMounterPrefs_DisplayTextLabelCaption := LANGcsMounterPrefs_DisplayTextLabelCaption;
  LANGMounterPrefs_MountPointLabelCaption := LANGcsMounterPrefs_MountPointLabelCaption;
  LANGMounterPrefs_MountDeviceLabelCaption := LANGcsMounterPrefs_MountDeviceLabelCaption;
  LANGMounterPrefs_DeviceTypeLabelCaption := LANGcsMounterPrefs_DeviceTypeLabelCaption;
  LANGMounterPrefs_miLocalDiskCaption := LANGcsMounterPrefs_miLocalDiskCaption;
  LANGMounterPrefs_miRemovableCaption := LANGcsMounterPrefs_miRemovableCaption;
  LANGMounterPrefs_miCDCaption := LANGcsMounterPrefs_miCDCaption;
  LANGMounterPrefs_miFloppyCaption := LANGcsMounterPrefs_miFloppyCaption;
  LANGMounterPrefs_miNetworkCaption := LANGcsMounterPrefs_miNetworkCaption;
  LANGMounterPrefs_MountCommandLabelCaption := LANGcsMounterPrefs_MountCommandLabelCaption;
  LANGMounterPrefs_UmountCommandLabelCaption := LANGcsMounterPrefs_UmountCommandLabelCaption;
  LANGMounterPrefs_MountCommandEntryTooltip := LANGcsMounterPrefs_MountCommandEntryTooltip;
  LANGMounterPrefs_UmountCommandEntryTooltip := LANGcsMounterPrefs_UmountCommandEntryTooltip;
  LANGMounterPrefs_IconLabelCaption := LANGcsMounterPrefs_IconLabelCaption;

  LANGConnMgr_Caption := LANGcsConnMgr_Caption;
  LANGConnMgr_ConnectButton := LANGcsConnMgr_ConnectButton;
  LANGConnMgr_OpenConnection := LANGcsConnMgr_OpenConnection;
  LANGConnMgr_NameColumn := LANGcsConnMgr_NameColumn;
  LANGConnMgr_URIColumn := LANGcsConnMgr_URIColumn;
  LANGConnMgr_AddConnectionButtonCaption := LANGcsConnMgr_AddConnectionButtonCaption;
  LANGConnMgr_AddConnectionButtonTooltip := LANGcsConnMgr_AddConnectionButtonTooltip;
  LANGConnMgr_EditButtonCaption := LANGcsConnMgr_EditButtonCaption;
  LANGConnMgr_EditButtonTooltip := LANGcsConnMgr_EditButtonTooltip;
  LANGConnMgr_RemoveButtonCaption := LANGcsConnMgr_RemoveButtonCaption;
  LANGConnMgr_RemoveButtonTooltip := LANGcsConnMgr_RemoveButtonTooltip;
  LANGConnMgr_DoYouWantDelete := LANGcsConnMgr_DoYouWantDelete;

  LANGConnProp_FTP := LANGcsConnProp_FTP;
  LANGConnProp_SFTP := LANGcsConnProp_SFTP;
  LANGConnProp_SMB := LANGcsConnProp_SMB;
  LANGConnProp_HTTP := LANGcsConnProp_HTTP;
  LANGConnProp_HTTPS := LANGcsConnProp_HTTPS;
  LANGConnProp_Other := LANGcsConnProp_Other;
  LANGConnProp_Caption := LANGcsConnProp_Caption;
  LANGConnProp_VFSModule := LANGcsConnProp_VFSModule;
  LANGConnProp_URI := LANGcsConnProp_URI;
  LANGConnProp_URIEntryTooltip := LANGcsConnProp_URIEntryTooltip;
  LANGConnProp_DetailedInformations := LANGcsConnProp_DetailedInformations;
  LANGConnProp_Name := LANGcsConnProp_Name;
  LANGConnProp_Server := LANGcsConnProp_Server;
  LANGConnProp_Username := LANGcsConnProp_Username;
  LANGConnProp_UserNameEntryTooltip := LANGcsConnProp_UserNameEntryTooltip;
  LANGConnProp_Password := LANGcsConnProp_Password;
  LANGConnProp_TargetDirectory := LANGcsConnProp_TargetDirectory;
  LANGConnProp_ServiceType := LANGcsConnProp_ServiceType; 
  LANGConnProp_MaskPassword := LANGcsConnProp_MaskPassword; 
  LANGConnProp_MenuItemCaption := LANGcsConnProp_MenuItemCaption; 

  LANGConnLogin_Caption := LANGcsConnLogin_Caption; 
  LANGConnLogin_Login := LANGcsConnLogin_Login;
  LANGConnLogin_ExperimentalWarningLabelCaption := LANGcsConnLogin_ExperimentalWarningLabelCaption; 
  LANGConnLogin_Username := LANGcsConnLogin_Username; 
  LANGConnLogin_Password := LANGcsConnLogin_Password; 
  LANGConnLogin_AnonymousCheckButton := LANGcsConnLogin_AnonymousCheckButton; 

  LANGColumns_Caption := LANGcsColumns_Caption;
  LANGColumns_Title := LANGcsColumns_Title;
  LANGColumns_MoveUpButtonTooltip := LANGcsColumns_MoveUpButtonTooltip;
  LANGColumns_MoveDownButtonTooltip := LANGcsColumns_MoveDownButtonTooltip; 
  LANGColumns_TitlesLongName := LANGcsColumns_TitlesLongName; 
  LANGColumns_TitlesLongNameExt := LANGcsColumns_TitlesLongNameExt; 
  LANGColumns_TitlesLongExt := LANGcsColumns_TitlesLongExt;
  LANGColumns_TitlesLongSize := LANGcsColumns_TitlesLongSize; 
  LANGColumns_TitlesLongDateTime := LANGcsColumns_TitlesLongDateTime; 
  LANGColumns_TitlesLongDate := LANGcsColumns_TitlesLongDate; 
  LANGColumns_TitlesLongTime := LANGcsColumns_TitlesLongTime; 
  LANGColumns_TitlesLongUser := LANGcsColumns_TitlesLongUser; 
  LANGColumns_TitlesLongGroup := LANGcsColumns_TitlesLongGroup;
  LANGColumns_TitlesLongAttr := LANGcsColumns_TitlesLongAttr; 
  LANGColumns_TitlesShortName := LANGcsColumns_TitlesShortName; 
  LANGColumns_TitlesShortNameExt := LANGcsColumns_TitlesShortNameExt; 
  LANGColumns_TitlesShortExt := LANGcsColumns_TitlesShortExt;
  LANGColumns_TitlesShortSize := LANGcsColumns_TitlesShortSize;
  LANGColumns_TitlesShortDateTime := LANGcsColumns_TitlesShortDateTime;
  LANGColumns_TitlesShortDate := LANGcsColumns_TitlesShortDate; 
  LANGColumns_TitlesShortTime := LANGcsColumns_TitlesShortTime; 
  LANGColumns_TitlesShortUser := LANGcsColumns_TitlesShortUser; 
  LANGColumns_TitlesShortGroup := LANGcsColumns_TitlesShortGroup; 
  LANGColumns_TitlesShortAttr := LANGcsColumns_TitlesShortAttr; 

  LANGTestPlugin_Caption := LANGcsTestPlugin_Caption; 
  LANGTestPlugin_Title := LANGcsTestPlugin_Title; 
  LANGTestPlugin_ExperimentalWarningLabelCaption := LANGcsTestPlugin_ExperimentalWarningLabelCaption;
  LANGTestPlugin_Plugin := LANGcsTestPlugin_Plugin; 
  LANGTestPlugin_Command := LANGcsTestPlugin_Command; 
  LANGTestPlugin_Username := LANGcsTestPlugin_Username;
  LANGTestPlugin_Password := LANGcsTestPlugin_Password; 
  LANGTestPlugin_AnonymousCheckButton := LANGcsTestPlugin_AnonymousCheckButton; 
  LANGTestPlugin_NoPluginsFound := LANGcsTestPlugin_NoPluginsFound; 

  LANGRemoteWait_Caption := LANGcsRemoteWait_Caption; 
  LANGRemoteWait_OperationInProgress := LANGcsRemoteWait_OperationInProgress;
  LANGRemoteWait_ItemsFound := LANGcsRemoteWait_ItemsFound; 

  LANGSearch_Bytes := LANGcsSearch_Bytes; 
  LANGSearch_kB := LANGcsSearch_kB; 
  LANGSearch_MB := LANGcsSearch_MB; 
  LANGSearch_days := LANGcsSearch_days;
  LANGSearch_weeks := LANGcsSearch_weeks; 
  LANGSearch_months := LANGcsSearch_months; 
  LANGSearch_years := LANGcsSearch_years; 
  LANGSearch_Caption := LANGcsSearch_Caption; 
  LANGSearch_General := LANGcsSearch_General; 
  LANGSearch_Advanced := LANGcsSearch_Advanced;
  LANGSearch_SearchResults := LANGcsSearch_SearchResults; 
  LANGSearch_SearchFor := LANGcsSearch_SearchFor; 
  LANGSearch_FileMaskEntryTooltip := LANGcsSearch_FileMaskEntryTooltip; 
  LANGSearch_SearchIn := LANGcsSearch_SearchIn; 
  LANGSearch_SearchArchivesCheckButton := LANGcsSearch_SearchArchivesCheckButton;
  LANGSearch_FindText := LANGcsSearch_FindText;
  LANGSearch_FindTextEntryTooltip := LANGcsSearch_FindTextEntryTooltip;
  LANGSearch_CaseSensitiveCheckButton := LANGcsSearch_CaseSensitiveCheckButton;
  LANGSearch_StayCurrentFSCheckButton := LANGcsSearch_StayCurrentFSCheckButton;
  LANGSearch_CaseSensitiveMatchCheckButton := LANGcsSearch_CaseSensitiveMatchCheckButton;
  LANGSearch_Size := LANGcsSearch_Size;
  LANGSearch_Date := LANGcsSearch_Date;
  LANGSearch_BiggerThan := LANGcsSearch_BiggerThan;
  LANGSearch_SmallerThan := LANGcsSearch_SmallerThan;
  LANGSearch_ModifiedBetweenRadioButton := LANGcsSearch_ModifiedBetweenRadioButton;
  LANGSearch_NotModifiedAfterRadioButton := LANGcsSearch_NotModifiedAfterRadioButton;
  LANGSearch_ModifiedLastRadioButton := LANGcsSearch_ModifiedLastRadioButton;
  LANGSearch_ModifiedNotLastRadionButton := LANGcsSearch_ModifiedNotLastRadionButton;
  LANGSearch_ModifiedBetweenEntry1 := LANGcsSearch_ModifiedBetweenEntry1;
  LANGSearch_ViewButtonCaption := LANGcsSearch_ViewButtonCaption;
  LANGSearch_NewSearchButtonCaption := LANGcsSearch_NewSearchButtonCaption;
  LANGSearch_GoToFileButtonCaption := LANGcsSearch_GoToFileButtonCaption;
  LANGSearch_FeedToListboxButtonCaption := LANGcsSearch_FeedToListboxButtonCaption;
  LANGSearch_StatusSC := LANGcsSearch_StatusSC;
  LANGSearch_Ready := LANGcsSearch_Ready;
  LANGSearch_PreparingToSearch := LANGcsSearch_PreparingToSearch;
  LANGSearch_SearchInProgress := LANGcsSearch_SearchInProgress;
  LANGSearch_UserCancelled := LANGcsSearch_UserCancelled;
  LANGSearch_SearchFinished := LANGcsSearch_SearchFinished;
  LANGSearch_FilesFound := LANGcsSearch_FilesFound;
  LANGSearch_And := LANGcsSearch_And;

  LANGCloseOpenConnection := LANGcsCloseOpenConnection;
  LANGDuplicateTabWarning := LANGcsDuplicateTabWarning;
  LANGDontShowAgain := LANGcsDontShowAgain;
  LANGSwitchOtherPanelWarning := LANGcsSwitchOtherPanelWarning;
  LANGOpenConnectionsWarning := LANGcsOpenConnectionsWarning;
  LANGmiDisconnect_Caption := LANGcsmiDisconnect_Caption;
  LANGDisconnectButton_Tooltip := LANGcsDisconnectButton_Tooltip;
  LANGLeaveArchiveButton_Tooltip := LANGcsLeaveArchiveButton_Tooltip;
  LANGOpenTerminalButton_Tooltip := LANGcsOpenTerminalButton_Tooltip;
  LANGOpenTerminalButton_Caption := LANGcsOpenTerminalButton_Caption;
  LANGShowTextUIDsCheckBox_Caption := LANGcsShowTextUIDsCheckBox_Caption;
  LANGShowTextUIDsCheckBox_Tooltip := LANGcsShowTextUIDsCheckBox_Tooltip;

  LANGmiNewTab_Caption := LANGcsmiNewTab_Caption;
  LANGFilePopupMenu_Properties := LANGcsFilePopupMenu_Properties;
  LANGCommandEntry_Tooltip := LANGcsCommandEntry_Tooltip;
  LANGmiFiles_Caption := LANGcsmiFiles_Caption;
  
  LANGPasswordButton_Tooltip := LANGcsPasswordButton_Tooltip;
  LANGHandleRunFromArchive_Bytes := LANGcsHandleRunFromArchive_Bytes;
  LANGHandleRunFromArchive_FileTypeDesc_Unknown := LANGcsHandleRunFromArchive_FileTypeDesc_Unknown;
  LANGHandleRunFromArchive_NotAssociated := LANGcsHandleRunFromArchive_NotAssociated;
  LANGHandleRunFromArchive_SelfExecutable := LANGcsHandleRunFromArchive_SelfExecutable;
  LANGHandleRunFromArchive_CouldntCreateTemporaryDirectory := LANGcsHandleRunFromArchive_CouldntCreateTemporaryDirectory;
  LANGFRunFromVFS_Caption := LANGcsFRunFromVFS_Caption;
  LANGFRunFromVFS_TitleLabel := LANGcsFRunFromVFS_TitleLabel;
  LANGFRunFromVFS_FileNameLabel := LANGcsFRunFromVFS_FileNameLabel;
  LANGFRunFromVFS_FileTypeLabel := LANGcsFRunFromVFS_FileTypeLabel;
  LANGFRunFromVFS_SizeLabel := LANGcsFRunFromVFS_SizeLabel;
  LANGFRunFromVFS_PackedSizeLabel := LANGcsFRunFromVFS_PackedSizeLabel;
  LANGFRunFromVFS_DateLabel := LANGcsFRunFromVFS_DateLabel;
  LANGFRunFromVFS_InfoLabel := LANGcsFRunFromVFS_InfoLabel;
  LANGFRunFromVFS_OpensWithLabel := LANGcsFRunFromVFS_OpensWithLabel;
  LANGFRunFromVFS_ExecuteButton := LANGcsFRunFromVFS_ExecuteButton;
  LANGFRunFromVFS_ExecuteAllButton := LANGcsFRunFromVFS_ExecuteAllButton;
  LANGFSetPassword_Caption := LANGcsFSetPassword_Caption;
  LANGFSetPassword_Label1_Caption := LANGcsFSetPassword_Label1_Caption;
  LANGFSetPassword_Label2_Caption := LANGcsFSetPassword_Label2_Caption;
  LANGFSetPassword_ShowPasswordCheckButton := LANGcsFSetPassword_ShowPasswordCheckButton;

  LANGCopyFileNamesToClipboard := LANGcsCopyFileNamesToClipboard;
  LANGCopyFullPathNamesToClipboard := LANGcsCopyFullPathNamesToClipboard;
  LANGCopyPathToClipboard := LANGcsCopyPathToClipboard;
  LANGPreferences_DateFormatLabel_Caption := LANGcsPreferences_DateFormatLabel_Caption;
  LANGPreferences_System := LANGcsPreferences_System;
  LANGPreferences_Custom := LANGcsPreferences_Custom;
  LANGPreferences_CustomDateFormatEntry_Tooltip := LANGcsPreferences_CustomDateFormatEntry_Tooltip;
  LANGPreferences_TimeFormatLabel_Caption := LANGcsPreferences_TimeFormatLabel_Caption;
  LANGPreferences_CustomTimeFormatEntry_Tooltip := LANGcsPreferences_CustomTimeFormatEntry_Tooltip;
  LANGPreferences_DateTimeFormatLabel_Caption := LANGcsPreferences_DateTimeFormatLabel_Caption;
  LANGPreferences_QuickRenameSkipExtCheckBox := LANGcsPreferences_QuickRenameSkipExtCheckBox;
  LANGPreferences_QuickRenameSkipExtCheckBox_Tooltip := LANGcsPreferences_QuickRenameSkipExtCheckBox_Tooltip;
  LANGPreferences_SortDirectoriesLikeFilesCheckBox := LANGcsPreferences_SortDirectoriesLikeFilesCheckBox;
  LANGPreferences_SortDirectoriesLikeFilesCheckBox_Tooltip := LANGcsPreferences_SortDirectoriesLikeFilesCheckBox_Tooltip;
  LANGPreferences_QuickSearchLabel_Caption := LANGcsPreferences_QuickSearchLabel_Caption;
  LANGPreferences_QuickSearchOptionMenu_Tooltip := LANGcsPreferences_QuickSearchOptionMenu_Tooltip;
  LANGPreferences_QuickSearch_Option1 := LANGcsPreferences_QuickSearch_Option1;
  LANGPreferences_QuickSearch_Option2 := LANGcsPreferences_QuickSearch_Option2;
  LANGPreferences_QuickSearch_Option3 := LANGcsPreferences_QuickSearch_Option3;
  LANGPreferences_QuickSearch_Option4 := LANGcsPreferences_QuickSearch_Option4;
  LANGPreferences_TempPathLabel_Caption := LANGcsPreferences_TempPathLabel_Caption;
  LANGPreferences_VFSTempPathLabel_Caption := LANGcsPreferences_VFSTempPathLabel_Caption;
  LANGPreferences_VFSTempPathEntry_Tooltip := LANGcsPreferences_VFSTempPathEntry_Tooltip;
end;

initialization
  AddTranslation('cz_CZ', @SetTranslation);
  AddTranslation('CS', @SetTranslation);
  AddTranslation('CZ', @SetTranslation);
end.
