(*
    UGTKLoader - Special unit, which has to be loaded before gtk_init in GTKForms
    Copyright (C) 2004 Tomas Bzatek <tbzatek@users.sourceforge.net>
    Check for updates on tuxcmd.sourceforge.net

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

unit UGTKLoader;

interface

implementation

uses glib2, gtk2, Classes, SysUtils;

const ConfDefaultSettingsDir = '.tuxcmd';


procedure WriteGTKRCTreeViewFix;
var s, s2: string;
    StringList: TStringList;
begin
  s := IncludeTrailingPathDelimiter(g_get_home_dir) + ConfDefaultSettingsDir;
  s2 := IncludeTrailingPathDelimiter(s) + 'gtkrc';
  if not FileExists(s2) then begin
    StringList := TStringList.Create;
    StringList.Add('style "treeview-style" {');
    StringList.Add('  GtkTreeView::horizontal_separator = 0');
    StringList.Add('  GtkTreeView::vertical_separator = 0');
    StringList.Add('}');
    StringList.Add('class "GtkTreeView" style "treeview-style"');
    try
      if not DirectoryExists(s) then
        if not ForceDirectories(s) then begin
          WriteLn('*** Error: Cannot make homedir');
          Exit;
        end;
      StringList.SaveToFile(s2);
      StringList.Free;
    except
      on E: Exception do WriteLn('*** Error: Cannot save .gtkrc in your home (', E.ClassName, '): ', E.Message);
    end;
  end;
  if gtk_check_version(2, 4, 0) = nil then gtk_rc_add_default_file(PChar(s2));
end;

initialization
  WriteGTKRCTreeViewFix;
end.
