/***************************************************************************
 * copyright            : (C) 2006 Seb Ruiz <me@sebruiz.net>               *
 **************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

extern "C" {
    #include <glib-object.h> //g_type_init
}

#include "ipodexportdialog.h"

#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("A photo uploader for iPods");

static const char version[] = "0.4";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    g_type_init();

    KAboutData about( "tripod", I18N_NOOP("tripod"), version, description,
                       KAboutData::License_Custom, "(C) 2006 Seb Ruiz", 0, 0, "me@sebruiz.net");
    about.addAuthor( "Seb Ruiz", 0, "me@sebruiz.net" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;

    IpodExport::UploadDialog *mainWin = 0;

    // no session.. just start up normally
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    /// @todo do something with the command line args here

    mainWin = new IpodExport::UploadDialog( "iPod Photo Uploader" );
    app.setMainWidget( mainWin );
    mainWin->setMinimumWidth( 500 );
    mainWin->show();

    args->clear();
    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

