#include "ImageResource.hpp"

#include <cmath>
#include <algorithm>

using namespace indii::tint;

ImageResource::ImageResource() {
  //
}

ImageResource::~ImageResource() {
  //
}

void ImageResource::fitOutside(const int widthBound, const int heightBound,
    int* width, int* height) {
  const double ratio = (double)getWidth() / (double)getHeight();
  
  if (ratio*heightBound > widthBound) {
    /* reduce height */
    *width = ratio*heightBound;
    *height = heightBound;
  } else if (widthBound > heightBound*ratio) {
    /* reduce width */
    *width = widthBound;
    *height = widthBound/ratio;
  } else {
    /* bounds same aspect ratio */
    *width = widthBound;
    *height = heightBound;
  }
}

void ImageResource::fitInside(const int widthBound, const int heightBound,
    int* width, int* height) {
  const double ratio = (double)getWidth() / getHeight();
  
  if (ratio*heightBound < widthBound) {
    /* reduce height */
    *width = ratio*heightBound;
    *height = heightBound;
  } else if (widthBound < heightBound*ratio) {
    /* reduce width */
    *width = widthBound;
    *height = widthBound/ratio;
  } else {
    /* bounds same aspect ratio */
    *width = widthBound;
    *height = heightBound;
  }  
}

unsigned int ImageResource::fitScale(const int widthBound,
    const int heightBound) {
  double widthScale, heightScale;
  widthScale = log((double)getWidth() / widthBound) / log(2.0);
  heightScale = log((double)getHeight() / heightBound) / log(2.0);
  
  return static_cast<unsigned int>(ceil(std::max(widthScale, heightScale)));
}
