/*
  $Id: ServerBase.h 9076 2011-03-23 09:41:30Z sloot $
  $URL: https://ilk.uvt.nl/svn/trunk/sources/TimblServer/include/timblserver/ServerBase.h $

  Copyright (c) 1998 - 2011
  ILK   - Tilburg University
  CLiPS - University of Antwerp
 
  This file is part of timblserver

  timblserver is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  timblserver is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, see <http://www.gnu.org/licenses/>.

  For questions and suggestions, see:
      http://ilk.uvt.nl/software.html
  or send mail to:
      timbl@uvt.nl
*/

#ifndef TIMBLSERVER_H
#define TIMBLSERVER_H

#include "timbl/TimblAPI.h"
#include "timbl/LogStream.h"
#include "timblserver/SocketBasics.h"

namespace Timbl {

  class TimblServer : public MsgClass {
    friend class TimblServerAPI;
    friend TimblServer *CreateServerPimpl( AlgorithmType, GetOptClass * );
  public:
    LogStream myLog;
    bool doDebug() { return debug; };
    bool doSetOptions( TimblExperiment *, const std::string&  );
    bool classifyOneLine( TimblExperiment *, const std::string& );
    TimblExperiment *theExp(){ return exp; };
    virtual ~TimblServer();
    static std::string VersionInfo( bool );
    static int daemonize( int , int );
  protected:
    TimblServer();
    bool getConfig( const std::string& );
    bool startClassicServer( int, int=0 );
    bool startMultiServer( const std::string& );
    void RunClassicServer();
    void RunHttpServer();
    TimblExperiment *splitChild() const;
    void setDebug( bool d ){ debug = d; };
    Sockets::ServerSocket *TcpSocket() const { return tcp_socket; };
    TimblExperiment *exp;
    std::string logFile;
    std::string pidFile;
    bool doDaemon;
  private:
    bool debug;
    int maxConn;
    int serverPort;
    Sockets::ServerSocket *tcp_socket;
    std::string serverProtocol;
    std::string serverConfigFile;
    std::map<std::string, std::string> serverConfig;
  };

  TimblExperiment *createClient( const TimblExperiment *,
				 Sockets::ServerSocket* );

  class IB1_Server: public TimblServer {
  public:
    IB1_Server( GetOptClass * );
  };
  
  class IG_Server: public TimblServer {
  public:
    IG_Server( GetOptClass * );
  };
 
  class TRIBL_Server: public TimblServer {
  public:
    TRIBL_Server( GetOptClass * );
  };
  
  class TRIBL2_Server: public TimblServer {
  public:
    TRIBL2_Server( GetOptClass * );
  };

}
#endif // TIMBLSERVER_H
