/*
 *	libetm-0.4 / error.h - Copyright (C) Emmanuel Thomas-Maurin 2008-2011
 * 	<manutm007@gmail.com
 *
 *	- error handling -
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INC_LIBETM_ERROR_H
#define INC_LIBETM_ERROR_H

typedef enum {
	LIBETM_OK,
	OUT_OF_MEMORY,
	ZERO_RQ_SIZE,
	/*NEG_RQ_SIZE,*/
	NULL_DEST,
	SRC_EQ_DEST,
	STR_OVERLAP,
	NULL_POINTER_FREE,
	RNDSTR_UNKNOWN_MODE,
#ifdef WIN32_V
	WIN32REGKEY_NOT_FOUND,
	WIN32REGKEY_CREATE_ERROR,
	WIN32REGKEY_SAVE_ERROR,
	WIN32REGKEY_OTHER_ERROR,
#endif
	LIBETM_LASTERRORCODE
} lib_error_code;

/*
 * app defined "fatal" error handler prototype
 * error code from app should enum above LIB_LASTERRORCODE
 */
int big_error(int, const char *, const char *, const char *, const char *);

/*
 * this will call big_error() function defined in app
 */
int big_error_in_lib(lib_error_code, const char *);

/*
 * if error code > LIBETM_LASTERRORCODE, returns ""
 */
const char *get_lib_error_str(lib_error_code);
#endif /* INC_LIBETM_ERROR_H */
