/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2011 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef SA_GLOBAL_H_
#define SA_GLOBAL_H_

#ifndef LIBSYSACTIVITY_H_
#warning You should not include this file directly from your source code. Include <libsysactivity/libsysactivity.h> instead.
#endif

#define SA_VERSION_MAJOR 0
#define SA_VERSION_SMALL 6
#define SA_VERSION_MINOR 2

#if __GNUC__ >= 4
	#define SA_EXPORT __attribute__ ((visibility("default")))
#else
	#define SA_EXPORT
#endif

#if __GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ >= 3)
	#define SA_HOT __attribute__ ((hot))
#else
	#define SA_HOT
#endif

#define SA_NONNULL __attribute__((nonnull))

#if __STDC_VERSION__ < 199901L
	#define SA_INLINE inline
#else
	#define SA_INLINE //In C99, inline means that a function's definition is provided only for inlining, and that there is another definition (without inline) somewhere else in the program
#endif

#include "cpu.h"
#include "disk.h"
#include "memory.h"
#include "network.h"
#include "process.h"
#include "swap.h"

#endif /* SA_CPU_H_ */
