/* utils.c generated by valac 0.11.6, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "gwibber.h"
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>

#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GwibberUtilsPrivate {
	DBusGConnection* conn;
	DBusGProxy* bus;
	gchar* interface_name;
};


static gpointer gwibber_utils_parent_class = NULL;

#define GWIBBER_UTILS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_UTILS, GwibberUtilsPrivate))
enum  {
	GWIBBER_UTILS_DUMMY_PROPERTY
};
GwibberUtils* gwibber_utils_new (void);
GwibberUtils* gwibber_utils_construct (GType object_type);
static void gwibber_utils_on_name_owner_changed (GwibberUtils* self, DBusGProxy* sender, const gchar* name, const gchar* old_owner, const gchar* new_owner);
static void gwibber_utils_list_names_reply_cb (GwibberUtils* self, gchar** names, int names_length1, GError* e);
static gboolean gwibber_utils_on_ready (GwibberUtils* self);
static void _dynamic_list_names0 (DBusGProxy* self, gpointer param1, void* param1_target, GError** error);
void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error);
static void _gwibber_utils_on_name_owner_changed_dynamic_NameOwnerChanged0_ (DBusGProxy* _sender, const gchar* name, const gchar* old_owner, const gchar* new_owner, gpointer self);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
void _dynamic_NameOwnerChanged1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data);
static gboolean _gwibber_utils_on_ready_gsource_func (gpointer self);
static GObject * gwibber_utils_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gwibber_utils_finalize (GObject* obj);


GwibberUtils* gwibber_utils_construct (GType object_type) {
	GwibberUtils * self = NULL;
	self = (GwibberUtils*) g_object_new (object_type, NULL);
	return self;
}


GwibberUtils* gwibber_utils_new (void) {
	return gwibber_utils_construct (GWIBBER_TYPE_UTILS);
}


static void gwibber_utils_on_name_owner_changed (GwibberUtils* self, DBusGProxy* sender, const gchar* name, const gchar* old_owner, const gchar* new_owner) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (old_owner != NULL);
	g_return_if_fail (new_owner != NULL);
	if (g_strcmp0 (name, self->priv->interface_name) == 0) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (g_strcmp0 (new_owner, "") != 0) {
			_tmp0_ = g_strcmp0 (old_owner, "") == 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			g_message ("utils.vala:50: %s is available", name);
			g_signal_emit_by_name (self, "available", TRUE);
		}
		if (g_strcmp0 (old_owner, "") != 0) {
			_tmp1_ = g_strcmp0 (new_owner, "") == 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			g_signal_emit_by_name (self, "available", FALSE);
			g_message ("utils.vala:56: %s is no longer available", name);
		}
	}
}


static void gwibber_utils_list_names_reply_cb (GwibberUtils* self, gchar** names, int names_length1, GError* e) {
	g_return_if_fail (self != NULL);
	{
		gchar** name_collection;
		int name_collection_length1;
		int name_it;
		name_collection = names;
		name_collection_length1 = names_length1;
		for (name_it = 0; name_it < names_length1; name_it = name_it + 1) {
			gchar* _tmp0_;
			gchar* name;
			_tmp0_ = g_strdup (name_collection[name_it]);
			name = _tmp0_;
			{
				if (g_strcmp0 (name, self->priv->interface_name) == 0) {
					g_message ("utils.vala:65: %s is available", name);
					g_signal_emit_by_name (self, "available", TRUE);
					_g_free0 (name);
					break;
				}
				_g_free0 (name);
			}
		}
	}
}


static void _gwibber_utils_list_names_reply_cb_cb (DBusGProxy* proxy, DBusGProxyCall* call, void* user_data) {
	GError* error;
	gchar** names;
	error = NULL;
	dbus_g_proxy_end_call (proxy, call, &error, G_TYPE_STRV, &names, G_TYPE_INVALID);
	gwibber_utils_list_names_reply_cb (user_data, names, g_strv_length (names), error);
	g_object_unref (user_data);
}


static void _dynamic_list_names0 (DBusGProxy* self, gpointer param1, void* param1_target, GError** error) {
	dbus_g_proxy_begin_call (self, "ListNames", _gwibber_utils_list_names_reply_cb_cb, g_object_ref (param1_target), NULL, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


static gboolean gwibber_utils_on_ready (GwibberUtils* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_dynamic_list_names0 (self->priv->bus, gwibber_utils_list_names_reply_cb, self, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch23_g_error;
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("utils.vala:77: Can't list: %s", e->message);
		_g_error_free0 (e);
	}
	__finally23:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static void _gwibber_utils_on_name_owner_changed_dynamic_NameOwnerChanged0_ (DBusGProxy* _sender, const gchar* name, const gchar* old_owner, const gchar* new_owner, gpointer self) {
	gwibber_utils_on_name_owner_changed (self, _sender, name, old_owner, new_owner);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}


void _dynamic_NameOwnerChanged1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data) {
	dbus_g_object_register_marshaller (g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INVALID);
	dbus_g_proxy_add_signal (obj, "NameOwnerChanged", G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INVALID);
	dbus_g_proxy_connect_signal (obj, "NameOwnerChanged", handler, data, NULL);
}


static gboolean _gwibber_utils_on_ready_gsource_func (gpointer self) {
	gboolean result;
	result = gwibber_utils_on_ready (self);
	return result;
}


void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	DBusGConnection* _tmp2_ = NULL;
	DBusGConnection* _tmp3_;
	DBusGConnection* _tmp4_;
	DBusGProxy* _tmp5_ = NULL;
	DBusGProxy* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup (name);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->interface_name);
	self->priv->interface_name = _tmp1_;
	_tmp2_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch24_dbus_gerror;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = _tmp3_;
	_dbus_g_connection_unref0 (self->priv->conn);
	self->priv->conn = _tmp4_;
	_tmp5_ = dbus_g_proxy_new_for_name (self->priv->conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
	_tmp6_ = _tmp5_;
	_g_object_unref0 (self->priv->bus);
	self->priv->bus = _tmp6_;
	_dynamic_NameOwnerChanged1_connect (self->priv->bus, "NameOwnerChanged", (GCallback) _gwibber_utils_on_name_owner_changed_dynamic_NameOwnerChanged0_, self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _gwibber_utils_on_ready_gsource_func, g_object_ref (self), g_object_unref);
	goto __finally24;
	__catch24_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("utils.vala:94: %s", e->message);
		_g_error_free0 (e);
	}
	__finally24:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static GObject * gwibber_utils_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberUtils * self;
	parent_class = G_OBJECT_CLASS (gwibber_utils_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_UTILS (obj);
	return obj;
}


static void gwibber_utils_class_init (GwibberUtilsClass * klass) {
	gwibber_utils_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberUtilsPrivate));
	G_OBJECT_CLASS (klass)->constructor = gwibber_utils_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_utils_finalize;
	/** 
	            Utils::available:
	    @arg0: bool
	            Emitted when the DBus service becomes available
	        */
	g_signal_new ("available", GWIBBER_TYPE_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void gwibber_utils_instance_init (GwibberUtils * self) {
	self->priv = GWIBBER_UTILS_GET_PRIVATE (self);
}


static void gwibber_utils_finalize (GObject* obj) {
	GwibberUtils * self;
	self = GWIBBER_UTILS (obj);
	_dbus_g_connection_unref0 (self->priv->conn);
	_g_object_unref0 (self->priv->bus);
	_g_free0 (self->priv->interface_name);
	G_OBJECT_CLASS (gwibber_utils_parent_class)->finalize (obj);
}


GType gwibber_utils_get_type (void) {
	static volatile gsize gwibber_utils_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_utils_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberUtils), 0, (GInstanceInitFunc) gwibber_utils_instance_init, NULL };
		GType gwibber_utils_type_id;
		gwibber_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "GwibberUtils", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_utils_type_id__volatile, gwibber_utils_type_id);
	}
	return gwibber_utils_type_id__volatile;
}



