/*
 * Copyright (C) 2006,2007  Stefan Siegl <stesie@brokenpipe.de>, Germany
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef GEIER_VERSION_H
#define GEIER_VERSION_H

#ifdef __cplusplus 
#define GEIER_BEGIN_PROTOS	extern "C" {
#define GEIER_END_PROTOS	}
#else
#define GEIER_BEGIN_PROTOS
#define GEIER_END_PROTOS
#endif

/**
 * LIBGEIER_CRYPTO_MODULE:
 *
 * The crypto module the GEIER library is linked against.  Currently
 * this is either "nss" or "openssl".
 */
#define LIBGEIER_CRYPTO_MODULE "nss"

/**
 * LIBGEIER_TEST_CRYPTO_MODULE
 *
 * Check whether the crypto module's name of the installed header file
 * (used and installed at compile time) matches the name of the installed
 * library's crypto module.
 *
 * If the names don't match, a warning message is written to stderr.
 */
#define LIBGEIER_TEST_CRYPTO_MODULE \
  geier_check_crypto_module(LIBGEIER_CRYPTO_MODULE);

/** 
 * LIBGEIER_DOTTED_VERSION:
 * 
 * The version string of the GEIER library shipping this header file,
 * not including the crypto module specification.
 */
#define LIBGEIER_DOTTED_VERSION "0.10"

/**
 * LIBGEIER_TEST_VERSION:
 *
 * Check whether the version of the installed header file (used and
 * installed at compile time) matches the installed library version. 
 * 
 * If the versions don't match, a warning message is written to
 * stderr.
 */
#define LIBGEIER_TEST_VERSION   geier_check_version(LIBGEIER_DOTTED_VERSION)

GEIER_BEGIN_PROTOS

/**
 * geier_check_version
 * @version: the version number to check the library against.
 *
 * Check whether the version number of the library matches the
 * provided version information.  If not, a warning message is emitted
 * to stderr.
 *
 * The name of the crypto module is not compared.
 */
void geier_check_version(const char *version);

/**
 * geier_check_crypto_module
 * @module_name: the crypto module name to check the library against.
 *
 * Check whether the crypto module's name of the library matches the 
 * provided name.  If not, a warning message is emitted to stderr.
 */
void geier_check_crypto_module(const char *module_name);

GEIER_END_PROTOS


#endif /* GEIER_VERSION_H */
