/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * TrueTypeFontMetricsFactory.java
 * ------------
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.fonts.io.FileFontDataInputSource;
import org.pentaho.reporting.libraries.fonts.io.FontDataInputSource;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

/**
 * This class is still experimental. At a later time, this class should be refactored to work without file references.
 *
 * @author Thomas Morgner
 */
public class TrueTypeFontMetricsFactory implements FontMetricsFactory
{
  private static Log logger = LogFactory.getLog(TrueTypeFontMetricsFactory.class);
  private HashMap fontRecords;

  public TrueTypeFontMetricsFactory()
  {
    this.fontRecords = new HashMap();
  }

  public FontMetrics createMetrics(final FontIdentifier record,
                                   final FontContext context)
  {
    if (FontType.OPENTYPE.equals(record.getFontType()) == false)
    {
      throw new IllegalArgumentException
          ("This identifier does not belong to the OpenType-font system.");
    }

    final TrueTypeFontIdentifier ttfId = (TrueTypeFontIdentifier) record;

    final ScalableTrueTypeFontMetrics fromCache =
        (ScalableTrueTypeFontMetrics) fontRecords.get(ttfId);
    if (fromCache != null)
    {
      return new TrueTypeFontMetrics(fromCache, context.getFontSize());
    }

    try
    {
      final String fontSource = ttfId.getFontSource();
      final FontDataInputSource fdis =
          new FileFontDataInputSource(new File(fontSource));
      final TrueTypeFont font = new TrueTypeFont(fdis);
      final ScalableTrueTypeFontMetrics fontMetrics =
          new ScalableTrueTypeFontMetrics(font);
      this.fontRecords.put(ttfId, fontMetrics);
      return new TrueTypeFontMetrics(fontMetrics, context.getFontSize());
    }
    catch (IOException e)
    {
      logger.warn("Unable to read the font.", e);
      // todo: We should throw a better exception instead, shouldnt we?
      throw new IllegalStateException();
    }
  }
}
