/*--------------------------------------------------------------------------+
$Id: ModelResolver.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.xml.example;

import edu.tum.cs.commons.xml.IXMLResolver;

/**
 * Example XML resolver that uses the enum's <code>name()</code>-method for
 * elements. For attributes it replaces underscores by dashes.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: 58CDB50CCE853539A0521CFAA5145A6B
 */
public class ModelResolver implements IXMLResolver<EXMLElement, EXMLAttribute> {

	/** {@inheritDoc} */
	public Class<EXMLAttribute> getAttributeClass() {
		return EXMLAttribute.class;
	}

	/** {@inheritDoc} */
	public String resolveAttributeName(EXMLAttribute attribute) {
		return attribute.name().replace('_', '-').toLowerCase();
	}

	/** {@inheritDoc} */
	public String resolveElementName(EXMLElement element) {
		return element.name();
	}

}