/* ---------------------------------- logDialog.cpp ---------------------------------------------------------------------------
 Class to display the "view log" dialog

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.


 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 25 Nov 2009
===============================================================================================================================
===============================================================================================================================
*/


#include "logDialog.h"

// class logDialog Constructor=================================================================================================

logDialog::logDialog (QUrl logUrl, QWidget *parent) : QDialog (parent)
{
	uiL.setupUi(this);
	logText = "";
	errorCount = 0;
	totalErrors = 0;
	
	connect ( uiL.button_close, SIGNAL( clicked() ), this, SLOT( closeLog() ) );	//connect close pushButton SLOT ----------------
	connect ( uiL.button_previous, SIGNAL( clicked() ), this, SLOT( prevError() ) );	//connect previous pushButton SLOT
	connect ( uiL.button_next, SIGNAL( clicked() ), this, SLOT( nextError() ) );	//connect next pushButton SLOT
	
	logUrl.setScheme("file");
	if (logUrl.toString() == "file:Does_not_exist")			// if the logfile does not exist for a reason display a message
	{
		logText = tr("Could not locate the logfile") + "!!";
		uiL.button_next -> setEnabled(FALSE);
		uiL.button_previous -> setEnabled(FALSE);
	}
	else
	{
		if (!logfile.open(QIODevice::ReadOnly | QIODevice::Text))	//if it exists try to open it
		{
			logText = tr("Could not open the logfile") + "!!<br><font color=red>"+ logfile.errorString() + "</font>";
			uiL.button_next -> setEnabled(FALSE);
			uiL.button_previous -> setEnabled(FALSE);
		}
		else
		{
			QTextStream in(&logfile);
			while (!in.atEnd())	// read the logfile line by line
			{
				QString logLine = in.readLine();
				logLine.append("<br>");
				logText.append(logLine);
				
				if (logLine.startsWith("<a name=\"error"))	// if the line is an error update the relevant errorLine Qstring
				{
					//errorLine[errorCount] = logLine;
					errorLine[errorCount] = "error" + countStr.setNum(errorCount+1);
					errorCount++;
				}
			}
			logfile.close();
			totalErrors = errorCount;
			if (totalErrors == 0)
				uiL.button_next -> setEnabled(FALSE);
			uiL.button_previous -> setEnabled(FALSE);
			errorCount = 0;		//set current error to be the first of the logfile
			firstScroll=TRUE;
		}
	}
	
	uiL.logView -> setText(logText);
}

// close button pressed=====================================================================================================
void logDialog::closeLog()
{
	close();	//emmit a QcloseEvent
}

// previous button pressed=====================================================================================================
void logDialog::prevError()
{
	errorCount--;		//decrease the current error by one

	if (errorCount == 0 )		// if the current error is the first within the logfile disable the previous button
		uiL.button_previous -> setEnabled(FALSE);
	
	if (errorCount < totalErrors-1)	//if the current error is less than the last one within the logfile enable the next button
		uiL.button_next -> setEnabled(TRUE);
	
	uiL.logView -> scrollToAnchor(errorLine[errorCount]);
}

// next button pressed=====================================================================================================
void logDialog::nextError()
{
	if (!firstScroll)
		errorCount++;	// increase the current error by one
	firstScroll = FALSE;
	
	if (errorCount == totalErrors-1)		// If the current error is the last within the logfile disable the next button
		uiL.button_next -> setEnabled(FALSE);
	
	if (errorCount > 0)				// if the current error is greater than the first one within the logfile enable the previous button
		uiL.button_previous -> setEnabled(TRUE);
	
	uiL.logView -> scrollToAnchor(errorLine[errorCount]);	//scroll to the current error
}

// end of logDialog.cpp ---------------------------------------------------------------------------

