/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lm-line-graph.h"

#include "lm-line-graph-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 61 "src/lm-line-graph.gob"

#include <time.h>
#include <glib/gi18n.h>
#include "lm-util.h"
#include "lm-applet.h"
#include "lm-host-frontend.h"

#define LINE_WIDTH			1.0

#define XALIGN				0.5
#define YALIGN				0.5

/* spacing between graph and labels */
#define GRAPH_MARGIN			3

#line 42 "lm-line-graph.c"
/* self casting macros */
#define SELF(x) LM_LINE_GRAPH(x)
#define SELF_CONST(x) LM_LINE_GRAPH_CONST(x)
#define IS_SELF(x) LM_IS_LINE_GRAPH(x)
#define TYPE_SELF LM_TYPE_LINE_GRAPH
#define SELF_CLASS(x) LM_LINE_GRAPH_CLASS(x)

#define SELF_GET_CLASS(x) LM_LINE_GRAPH_GET_CLASS(x)

/* self typedefs */
typedef LMLineGraph Self;
typedef LMLineGraphClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
#line 0 "src/lm-line-graph.gob"
static void lm_line_graph_init (LMLineGraph * o);
#line 61 "lm-line-graph.c"
#line 99 "src/lm-line-graph.gob"
static void lm_line_graph_class_init (LMLineGraphClass * class);
#line 64 "lm-line-graph.c"
#line 117 "src/lm-line-graph.gob"
static void lm_line_graph_constructor (LMLineGraph * self);
#line 67 "lm-line-graph.c"
#line 143 "src/lm-line-graph.gob"
static void lm_line_graph_dispose (LMLineGraph * self);
#line 70 "lm-line-graph.c"
#line 152 "src/lm-line-graph.gob"
static void lm_line_graph_tooltip_graph_span_changed (LMLineGraph * self);
#line 73 "lm-line-graph.c"
#line 164 "src/lm-line-graph.gob"
static void ___5_lm_line_graph_size_request (GtkWidget * widget, GtkRequisition * requisition);
#line 76 "lm-line-graph.c"
#line 175 "src/lm-line-graph.gob"
static void lm_line_graph_clear_labels (LMLineGraph * self);
#line 79 "lm-line-graph.c"
#line 185 "src/lm-line-graph.gob"
static void lm_line_graph_clear_labels_real (LMLineGraph * self, LabelInfo * infos, int num_infos);
#line 82 "lm-line-graph.c"
#line 199 "src/lm-line-graph.gob"
static void lm_line_graph_clear_labels_and_queue_resize (LMLineGraph * self);
#line 85 "lm-line-graph.c"
#line 206 "src/lm-line-graph.gob"
static void lm_line_graph_ensure_labels (LMLineGraph * self);
#line 88 "lm-line-graph.c"
#line 329 "src/lm-line-graph.gob"
static PangoLayout * lm_line_graph_create_pango_layout (LMLineGraph * self, const char * text, int * max_width, int * max_height);
#line 91 "lm-line-graph.c"
#line 355 "src/lm-line-graph.gob"
static gboolean ___b_lm_line_graph_expose_event (GtkWidget * widget, GdkEventExpose * event);
#line 94 "lm-line-graph.c"
#line 466 "src/lm-line-graph.gob"
static void lm_line_graph_draw_labels (LMLineGraph * self, GdkEventExpose * event, int x, int y);
#line 97 "lm-line-graph.c"
#line 473 "src/lm-line-graph.gob"
static void lm_line_graph_draw_labels_real (LMLineGraph * self, const LabelInfo * infos, int num_infos, GdkEventExpose * event, int x, int y);
#line 100 "lm-line-graph.c"
#line 501 "src/lm-line-graph.gob"
static void lm_line_graph_draw_subdivisions (LMLineGraph * self, int graph_area_x, int graph_area_y);
#line 103 "lm-line-graph.c"
#line 579 "src/lm-line-graph.gob"
static void lm_line_graph_plot_host (LMLineGraph * self, LMHostFrontend * host, cairo_t * cr, LMTimeSpan now, LMTimeSpan scale, LMTimeSpan span);
#line 106 "lm-line-graph.c"
#line 641 "src/lm-line-graph.gob"
static gboolean lm_line_graph_update_cb (gpointer data);
#line 109 "lm-line-graph.c"
#line 660 "src/lm-line-graph.gob"
static gboolean lm_line_graph_update_time_cb (gpointer data);
#line 112 "lm-line-graph.c"
#line 671 "src/lm-line-graph.gob"
static gboolean lm_line_graph_update_not_done_cb (gpointer data);
#line 115 "lm-line-graph.c"

enum {
	PROP_0,
	PROP_APPLET
};

/* pointer to the class of our parent */
static GtkWidgetClass *parent_class = NULL;

/* Short form macros */
#define self_tooltip_graph_span_changed lm_line_graph_tooltip_graph_span_changed
#define self_clear_labels lm_line_graph_clear_labels
#define self_clear_labels_real lm_line_graph_clear_labels_real
#define self_clear_labels_and_queue_resize lm_line_graph_clear_labels_and_queue_resize
#define self_ensure_labels lm_line_graph_ensure_labels
#define self_create_pango_layout lm_line_graph_create_pango_layout
#define self_draw_labels lm_line_graph_draw_labels
#define self_draw_labels_real lm_line_graph_draw_labels_real
#define self_draw_subdivisions lm_line_graph_draw_subdivisions
#define self_plot_host lm_line_graph_plot_host
#define self_update_cb lm_line_graph_update_cb
#define self_update_time_cb lm_line_graph_update_time_cb
#define self_update_not_done_cb lm_line_graph_update_not_done_cb
#define self_new lm_line_graph_new
GType
lm_line_graph_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LMLineGraphClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lm_line_graph_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LMLineGraph),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lm_line_graph_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_WIDGET, "LMLineGraph", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LMLineGraph *)g_object_new(lm_line_graph_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LMLineGraph * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LMLineGraph *
GET_NEW_VARG (const char *first, ...)
{
	LMLineGraph *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LMLineGraph *)g_object_new_valist (lm_line_graph_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static GObject *
___constructor (GType type, guint n_construct_properties, GObjectConstructParam *construct_properties)
{
#define __GOB_FUNCTION__ "LM:Line:Graph::constructor"
	GObject *obj_self;
	LMLineGraph *self;
	obj_self = G_OBJECT_CLASS (parent_class)->constructor (type, n_construct_properties, construct_properties);
	self = LM_LINE_GRAPH (obj_self);
#line 117 "src/lm-line-graph.gob"
	lm_line_graph_constructor (self);
#line 193 "lm-line-graph.c"
	return obj_self;
}
#undef __GOB_FUNCTION__


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Line:Graph::dispose"
	LMLineGraph *self G_GNUC_UNUSED = LM_LINE_GRAPH (obj_self);
#line 143 "src/lm-line-graph.gob"
	lm_line_graph_dispose (self);
#line 206 "lm-line-graph.c"
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 97 "src/lm-line-graph.gob"
	if(self->_priv->subdivision_gc) { g_object_unref ((gpointer) self->_priv->subdivision_gc); self->_priv->subdivision_gc = NULL; }
#line 211 "lm-line-graph.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Line:Graph::finalize"
	LMLineGraph *self G_GNUC_UNUSED = LM_LINE_GRAPH (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
lm_line_graph_init (LMLineGraph * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Line:Graph::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,LM_TYPE_LINE_GRAPH,LMLineGraphPrivate);
}
#undef __GOB_FUNCTION__
#line 99 "src/lm-line-graph.gob"
static void 
lm_line_graph_class_init (LMLineGraphClass * class G_GNUC_UNUSED)
{
#line 238 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	GtkWidgetClass *gtk_widget_class = (GtkWidgetClass *)class;

	g_type_class_add_private(class,sizeof(LMLineGraphPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_WIDGET);

#line 164 "src/lm-line-graph.gob"
	gtk_widget_class->size_request = ___5_lm_line_graph_size_request;
#line 355 "src/lm-line-graph.gob"
	gtk_widget_class->expose_event = ___b_lm_line_graph_expose_event;
#line 251 "lm-line-graph.c"
	g_object_class->constructor = ___constructor;
	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("applet" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_APPLET,
		param_spec);
    }
 {
#line 100 "src/lm-line-graph.gob"

    GtkWidgetClass *widget_class = GTK_WIDGET_CLASS(class);

    gtk_widget_class_install_style_property(widget_class,
					    g_param_spec_boxed("minor-subdivision-color",
							       NULL,
							       NULL,
							       GDK_TYPE_COLOR,
							       G_PARAM_READABLE));
    gtk_widget_class_install_style_property(widget_class,
					    g_param_spec_boxed("major-subdivision-color",
							       NULL,
							       NULL,
							       GDK_TYPE_COLOR,
							       G_PARAM_READABLE));
  
#line 287 "lm-line-graph.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Line:Graph::set_property"
{
	LMLineGraph *self G_GNUC_UNUSED;

	self = LM_LINE_GRAPH (object);

	switch (property_id) {
	case PROP_APPLET:
		{
#line 80 "src/lm-line-graph.gob"
self->_priv->applet = g_value_get_pointer (VAL);
#line 308 "lm-line-graph.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Line:Graph::get_property"
{
	LMLineGraph *self G_GNUC_UNUSED;

	self = LM_LINE_GRAPH (object);

	switch (property_id) {
	case PROP_APPLET:
		{
#line 80 "src/lm-line-graph.gob"
g_value_set_pointer (VAL, self->_priv->applet);
#line 339 "lm-line-graph.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 117 "src/lm-line-graph.gob"
static void 
lm_line_graph_constructor (LMLineGraph * self)
{
#line 360 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::constructor"
{
#line 118 "src/lm-line-graph.gob"
	
    int i;

    GTK_WIDGET_SET_FLAGS(self, GTK_NO_WINDOW);

    g_object_connect(self,
		     "signal::style-set", self_clear_labels_and_queue_resize, self,
		     "signal::direction-changed", self_clear_labels_and_queue_resize, self,
		     NULL);

    lm_g_object_connect(self, selfp->applet,
			"swapped-signal::notify::scale", self_clear_labels_and_queue_resize, self,
			"swapped-signal::notify::tooltip-graph-span", self_tooltip_graph_span_changed, self,
			NULL);

    LM_ARRAY_FOREACH(i, selfp->applet->hosts)
      {
	LMHostFrontend *host = g_ptr_array_index(selfp->applet->hosts, i);

	lm_g_object_connect(self, host,
			    "swapped-signal::notify::color", gtk_widget_queue_draw, self,
			    NULL);
      }
  }}
#line 388 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 143 "src/lm-line-graph.gob"
static void 
lm_line_graph_dispose (LMLineGraph * self)
{
#line 395 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::dispose"
{
#line 144 "src/lm-line-graph.gob"
	
    lm_source_clear(&selfp->update_timeout_id);
    lm_source_clear(&selfp->update_time_timeout_id);
    lm_source_clear(&selfp->update_not_done_timeout_id);

    self_clear_labels(self);
  }}
#line 406 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 152 "src/lm-line-graph.gob"
static void 
lm_line_graph_tooltip_graph_span_changed (LMLineGraph * self)
{
#line 413 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::tooltip_graph_span_changed"
#line 152 "src/lm-line-graph.gob"
	g_return_if_fail (self != NULL);
#line 152 "src/lm-line-graph.gob"
	g_return_if_fail (LM_IS_LINE_GRAPH (self));
#line 419 "lm-line-graph.c"
{
#line 154 "src/lm-line-graph.gob"
	
    /*
     * We must clear the update timeout since a new one is needed
     * (expose_event() will install it).
     */
    lm_source_clear(&selfp->update_timeout_id);

    self_clear_labels_and_queue_resize(self);
  }}
#line 431 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 164 "src/lm-line-graph.gob"
static void 
___5_lm_line_graph_size_request (GtkWidget * widget G_GNUC_UNUSED, GtkRequisition * requisition)
#line 437 "lm-line-graph.c"
#define PARENT_HANDLER(___widget,___requisition) \
	{ if(GTK_WIDGET_CLASS(parent_class)->size_request) \
		(* GTK_WIDGET_CLASS(parent_class)->size_request)(___widget,___requisition); }
{
#define __GOB_FUNCTION__ "LM:Line:Graph::size_request"
{
#line 166 "src/lm-line-graph.gob"
	
    Self *self = SELF(widget);

    self_ensure_labels(self);

    requisition->width = selfp->width;
    requisition->height = selfp->height;
  }}
#line 453 "lm-line-graph.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 175 "src/lm-line-graph.gob"
static void 
lm_line_graph_clear_labels (LMLineGraph * self)
{
#line 461 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::clear_labels"
#line 175 "src/lm-line-graph.gob"
	g_return_if_fail (self != NULL);
#line 175 "src/lm-line-graph.gob"
	g_return_if_fail (LM_IS_LINE_GRAPH (self));
#line 467 "lm-line-graph.c"
{
#line 177 "src/lm-line-graph.gob"
	
    if (! selfp->x_labels[0].layout)
      return;

    self_clear_labels_real(self, selfp->x_labels, X_LABELS);
    self_clear_labels_real(self, selfp->y_labels, Y_LABELS);
  }}
#line 477 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 185 "src/lm-line-graph.gob"
static void 
lm_line_graph_clear_labels_real (LMLineGraph * self, LabelInfo * infos, int num_infos)
{
#line 484 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::clear_labels_real"
#line 185 "src/lm-line-graph.gob"
	g_return_if_fail (self != NULL);
#line 185 "src/lm-line-graph.gob"
	g_return_if_fail (LM_IS_LINE_GRAPH (self));
#line 490 "lm-line-graph.c"
{
#line 187 "src/lm-line-graph.gob"
	
    int i;

    for (i = 0; i < num_infos; i++)
      {
	LabelInfo *info = &infos[i];

	g_object_unref(info->layout);
	info->layout = NULL;
      }
  }}
#line 504 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 199 "src/lm-line-graph.gob"
static void 
lm_line_graph_clear_labels_and_queue_resize (LMLineGraph * self)
{
#line 511 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::clear_labels_and_queue_resize"
#line 199 "src/lm-line-graph.gob"
	g_return_if_fail (self != NULL);
#line 199 "src/lm-line-graph.gob"
	g_return_if_fail (LM_IS_LINE_GRAPH (self));
#line 517 "lm-line-graph.c"
{
#line 201 "src/lm-line-graph.gob"
	
    self_clear_labels(self);
    gtk_widget_queue_resize(GTK_WIDGET(self));
  }}
#line 524 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 206 "src/lm-line-graph.gob"
static void 
lm_line_graph_ensure_labels (LMLineGraph * self)
{
#line 531 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::ensure_labels"
#line 206 "src/lm-line-graph.gob"
	g_return_if_fail (self != NULL);
#line 206 "src/lm-line-graph.gob"
	g_return_if_fail (LM_IS_LINE_GRAPH (self));
#line 537 "lm-line-graph.c"
{
#line 208 "src/lm-line-graph.gob"
	
    int i;
    GTimeVal now;
    double step;
    const char *time_format;
    int step_usec;
    int y_precision;
    int x_label_width = 0;
    int x_label_height = 0;
    int y_label_width = 0;
    int y_label_height = 0;
    PangoRectangle rect;
    int x_left_margin;
    int y_left_margin;
    double step_pixels;

    if (selfp->x_labels[0].layout)
      return;

    /* create horizontal labels */

    g_get_current_time(&now);

    step = (double) selfp->applet->tooltip_graph_span / X_MAJOR_SUBDIVISIONS;

    if (selfp->applet->tooltip_graph_span < 3600)
      time_format = "%T";
    else if (selfp->applet->tooltip_graph_span < 86400)
      time_format = "%R";
    else
      time_format = "%a %R";

    for (i = 0; i < X_LABELS; i++)
      {
	LabelInfo *info = &selfp->x_labels[i];
	time_t label_time;
	struct tm *tm;
	char *str;

	label_time = now.tv_sec - step * (X_MAJOR_SUBDIVISIONS - i);
	tm = localtime(&label_time);

	str = lm_strftime(time_format, tm);
	info->layout = self_create_pango_layout(self, str, &x_label_width, &x_label_height);
	g_free(str);
      }

    /* create vertical labels */

    step = (double) selfp->applet->scale / Y_MAJOR_SUBDIVISIONS;

    /* display a suitable number of decimals */
    step_usec = selfp->applet->scale * 1000 / Y_MAJOR_SUBDIVISIONS;
    if (step_usec % 1000 == 0)
      y_precision = 0;
    else if (step_usec % 100 == 0)
      y_precision = 1;
    else
      y_precision = 2;

    for (i = 0; i < Y_LABELS; i++)
      {
	LabelInfo *info = &selfp->y_labels[i];
	char *str;

	str = g_strdup_printf(_("%.*f ms"), y_precision, step * (Y_MAJOR_SUBDIVISIONS - i));
	info->layout = self_create_pango_layout(self, str, &y_label_width, &y_label_height);
	g_free(str);
      }

    /* compute margins, graph size and position */

    pango_layout_get_pixel_extents(selfp->x_labels[0].layout, NULL, &rect);

    x_left_margin = rect.width / 2;
    y_left_margin = y_label_width + GRAPH_MARGIN;

    selfp->graph_x = MAX(x_left_margin, y_left_margin);
    selfp->graph_y = y_label_height / 2;

    pango_layout_get_pixel_extents(selfp->x_labels[X_LABELS - 1].layout, NULL, &rect);

    selfp->width = selfp->graph_x + LM_LINE_GRAPH_WIDTH + rect.width / 2;
    selfp->height = selfp->graph_y + LM_LINE_GRAPH_HEIGHT + GRAPH_MARGIN + x_label_height;

    /* compute horizontal labels positions */

    step_pixels = LM_LINE_GRAPH_WIDTH / X_MAJOR_SUBDIVISIONS;

    for (i = 0; i < X_LABELS; i++)
      {
	LabelInfo *info = &selfp->x_labels[i];

	pango_layout_get_pixel_extents(info->layout, NULL, &rect);

	info->x = selfp->graph_x + step_pixels * i - rect.width / 2;
	info->y = selfp->graph_y + LM_LINE_GRAPH_HEIGHT + GRAPH_MARGIN + y_label_height - rect.height;
      }

    /* compute vertical labels positions */

    step_pixels = LM_LINE_GRAPH_HEIGHT / Y_MAJOR_SUBDIVISIONS;

    for (i = 0; i < Y_LABELS; i++)
      {
	LabelInfo *info = &selfp->y_labels[i];

	pango_layout_get_pixel_extents(info->layout, NULL, &rect);

	info->x = selfp->graph_x - GRAPH_MARGIN - rect.width;
	info->y = selfp->graph_y + step_pixels * i - rect.height / 2;
      }

    /* update the time labels when the second will change */

    if (selfp->update_time_timeout_id)
      g_source_remove(selfp->update_time_timeout_id);

    selfp->update_time_timeout_id = gdk_threads_add_timeout((1000 - now.tv_usec / 1000) + 1, self_update_time_cb, self);
  }}
#line 660 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 329 "src/lm-line-graph.gob"
static PangoLayout * 
lm_line_graph_create_pango_layout (LMLineGraph * self, const char * text, int * max_width, int * max_height)
{
#line 667 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::create_pango_layout"
#line 329 "src/lm-line-graph.gob"
	g_return_val_if_fail (self != NULL, (PangoLayout * )0);
#line 329 "src/lm-line-graph.gob"
	g_return_val_if_fail (LM_IS_LINE_GRAPH (self), (PangoLayout * )0);
#line 329 "src/lm-line-graph.gob"
	g_return_val_if_fail (text != NULL, (PangoLayout * )0);
#line 329 "src/lm-line-graph.gob"
	g_return_val_if_fail (max_width != NULL, (PangoLayout * )0);
#line 329 "src/lm-line-graph.gob"
	g_return_val_if_fail (max_height != NULL, (PangoLayout * )0);
#line 679 "lm-line-graph.c"
{
#line 334 "src/lm-line-graph.gob"
	
    PangoLayout *layout;
    char *markup;
    PangoRectangle rect;

    layout = gtk_widget_create_pango_layout(GTK_WIDGET(self), NULL);

    markup = g_strdup_printf("<span size=\"smaller\">%s</span>", text);
    pango_layout_set_markup(layout, markup, -1);
    g_free(markup);

    pango_layout_get_pixel_extents(layout, NULL, &rect);

    if (rect.width > *max_width)
      *max_width = rect.width;
    if (rect.height > *max_height)
      *max_height = rect.height;

    return layout;
  }}
#line 702 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 355 "src/lm-line-graph.gob"
static gboolean 
___b_lm_line_graph_expose_event (GtkWidget * widget G_GNUC_UNUSED, GdkEventExpose * event)
#line 708 "lm-line-graph.c"
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->expose_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->expose_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "LM:Line:Graph::expose_event"
{
#line 357 "src/lm-line-graph.gob"
	
    Self *self = SELF(widget);
    int x;
    int y;
    int graph_x;
    int graph_y;
    int graph_area_x;
    int graph_area_y;

    if (! GTK_WIDGET_DRAWABLE(widget))
      return FALSE;

    lm_source_clear(&selfp->update_not_done_timeout_id);

    self_ensure_labels(self);

    lm_widget_get_origin(widget, XALIGN, YALIGN, &x, &y);

    self_draw_labels(self, event, x, y);

    graph_x = x + selfp->graph_x;
    graph_y = y + selfp->graph_y;

    lm_paint_box(widget->window,
		 GTK_WIDGET_STATE(widget),
		 GTK_SHADOW_IN,
		 &event->area,
		 widget,
		 widget->style->base_gc[GTK_WIDGET_STATE(widget)],
		 graph_x,
		 graph_y,
		 LM_LINE_GRAPH_WIDTH,
		 LM_LINE_GRAPH_HEIGHT);

    graph_area_x = graph_x + LM_BOX_BORDER_WIDTH;
    graph_area_y = graph_y + LM_BOX_BORDER_WIDTH;

    self_draw_subdivisions(self, graph_area_x, graph_area_y);

    if (selfp->applet->hosts->len != 0)
      {
	cairo_t *cr;
	LMTimeSpan now;
	LMTimeSpan scale;
	LMTimeSpan span;
	int i;

	cr = gdk_cairo_create(widget->window);

	/*
	 * Setup a Cairo clip rectangle of size width,height at
	 * (1,1). We need this rectangle because the line that
	 * connects the first data point (which lies outside of the
	 * graph) and the second (which lies inside) crosses the graph
	 * edge.
	 *
	 * Another purpose is to make sure that Cairo will not draw on
	 * the widget border (because of line width).
	 */
	cairo_rectangle(cr, graph_area_x, graph_area_y, LM_LINE_GRAPH_AREA_WIDTH, LM_LINE_GRAPH_AREA_HEIGHT);
	cairo_clip(cr);

	/*
	 * Add an offset so that 0,0 is located at the upper-left
	 * corner of our clip rectangle, not at the upper-left corner
	 * of the GdkWindow.
	 */
	cairo_translate(cr, graph_area_x, graph_area_y);

	cairo_set_line_width(cr, LINE_WIDTH);
	cairo_set_line_cap(cr, CAIRO_LINE_CAP_BUTT);
	cairo_set_line_join(cr, CAIRO_LINE_JOIN_MITER);

	now = lm_get_ticks();
	scale = (LMTimeSpan) selfp->applet->scale * 1000;
	span = (LMTimeSpan) selfp->applet->tooltip_graph_span * 1000000;

	/* iterate in reverse order, to plot hosts listed first above */
	LM_ARRAY_REVERSE_FOREACH(i, selfp->applet->hosts)
	  {
	    LMHostFrontend *host = g_ptr_array_index(selfp->applet->hosts, i);

	    self_plot_host(self, host, cr, now, scale, span);
	  }

	cairo_destroy(cr);

	if (! selfp->update_timeout_id)
	  {
	    int timeout;

	    /*
	     * Compute the update interval required for scrolling
	     * pixel by pixel. Note that if we updated more often than
	     * that, lines would wobble, since rasterisation could
	     * cause the number of horizontal pixels between two data
	     * points to vary from one frame to the next.
	     */
	    timeout = selfp->applet->tooltip_graph_span * 1000 / LM_LINE_GRAPH_AREA_WIDTH;

	    selfp->update_timeout_id = gdk_threads_add_timeout(timeout, self_update_cb, self);
	  }
      }
    else
      lm_source_clear(&selfp->update_timeout_id);

    return FALSE;
  }}
#line 825 "lm-line-graph.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 466 "src/lm-line-graph.gob"
static void 
lm_line_graph_draw_labels (LMLineGraph * self, GdkEventExpose * event, int x, int y)
{
#line 833 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::draw_labels"
#line 466 "src/lm-line-graph.gob"
	g_return_if_fail (self != NULL);
#line 466 "src/lm-line-graph.gob"
	g_return_if_fail (LM_IS_LINE_GRAPH (self));
#line 839 "lm-line-graph.c"
{
#line 468 "src/lm-line-graph.gob"
	
    self_draw_labels_real(self, selfp->x_labels, X_LABELS, event, x, y);
    self_draw_labels_real(self, selfp->y_labels, Y_LABELS, event, x, y);
  }}
#line 846 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 473 "src/lm-line-graph.gob"
static void 
lm_line_graph_draw_labels_real (LMLineGraph * self, const LabelInfo * infos, int num_infos, GdkEventExpose * event, int x, int y)
{
#line 853 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::draw_labels_real"
#line 473 "src/lm-line-graph.gob"
	g_return_if_fail (self != NULL);
#line 473 "src/lm-line-graph.gob"
	g_return_if_fail (LM_IS_LINE_GRAPH (self));
#line 473 "src/lm-line-graph.gob"
	g_return_if_fail (event != NULL);
#line 861 "lm-line-graph.c"
{
#line 480 "src/lm-line-graph.gob"
	
    GtkWidget *widget = GTK_WIDGET(self);
    int i;

    for (i = 0; i < num_infos; i++)
      {
	const LabelInfo *info = &infos[i];

	gtk_paint_layout(widget->style,
			 widget->window,
			 GTK_WIDGET_STATE(widget),
			 FALSE,
			 &event->area,
			 widget,
			 NULL,
			 x + info->x,
			 y + info->y,
			 info->layout);
      }
  }}
#line 884 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 501 "src/lm-line-graph.gob"
static void 
lm_line_graph_draw_subdivisions (LMLineGraph * self, int graph_area_x, int graph_area_y)
{
#line 891 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::draw_subdivisions"
#line 501 "src/lm-line-graph.gob"
	g_return_if_fail (self != NULL);
#line 501 "src/lm-line-graph.gob"
	g_return_if_fail (LM_IS_LINE_GRAPH (self));
#line 897 "lm-line-graph.c"
{
#line 503 "src/lm-line-graph.gob"
	
    GtkWidget *widget = GTK_WIDGET(self);
    GdkColor minor_color = { 0, 0xe000, 0xe000, 0xe000 };
    GdkColor major_color = { 0, 0xff00, 0xcc00, 0xcc00 };
    GdkColor *custom_minor_color;
    GdkColor *custom_major_color;
    int minor_subdivision;
    int major_subdivision;
    int line_end;
    int graph_end;
    int line;

    if (! selfp->subdivision_gc)
      selfp->subdivision_gc = gdk_gc_new(widget->window);

    gtk_widget_style_get(widget,
			 "minor-subdivision-color", &custom_minor_color,
			 "major-subdivision-color", &custom_major_color,
			 NULL);

    if (custom_minor_color)
      {
	minor_color = *custom_minor_color;
	gdk_color_free(custom_minor_color);
      }
    if (custom_major_color)
      {
	major_color = *custom_major_color;
	gdk_color_free(custom_major_color);
      }

    /* horizontal */

    minor_subdivision = LM_LINE_GRAPH_AREA_WIDTH / X_MINOR_SUBDIVISIONS;
    major_subdivision = LM_LINE_GRAPH_AREA_WIDTH / X_MAJOR_SUBDIVISIONS;

    line_end = graph_area_y + LM_LINE_GRAPH_AREA_HEIGHT - 1;
    graph_end = graph_area_x + LM_LINE_GRAPH_AREA_WIDTH;

    gdk_gc_set_rgb_fg_color(selfp->subdivision_gc, &minor_color);

    for (line = minor_subdivision; line < LM_LINE_GRAPH_AREA_WIDTH; line += minor_subdivision)
      if (line % major_subdivision != 0)
	{
	  int x = graph_area_x + line;
	  gdk_draw_line(widget->window, selfp->subdivision_gc, x, graph_area_y, x, line_end);
	}

    gdk_gc_set_rgb_fg_color(selfp->subdivision_gc, &major_color);

    for (line = graph_area_x + major_subdivision; line < graph_end; line += major_subdivision)
      gdk_draw_line(widget->window, selfp->subdivision_gc, line, graph_area_y, line, line_end);

    /* vertical */

    minor_subdivision = LM_LINE_GRAPH_AREA_HEIGHT / Y_MINOR_SUBDIVISIONS;
    major_subdivision = LM_LINE_GRAPH_AREA_HEIGHT / Y_MAJOR_SUBDIVISIONS;

    line_end = graph_area_x + LM_LINE_GRAPH_AREA_WIDTH - 1;
    graph_end = graph_area_y + LM_LINE_GRAPH_AREA_HEIGHT;

    gdk_gc_set_rgb_fg_color(selfp->subdivision_gc, &minor_color);

    for (line = minor_subdivision; line < LM_LINE_GRAPH_AREA_HEIGHT; line += minor_subdivision)
      if (line % major_subdivision != 0)
	{
	  int y = graph_area_y + line;
	  gdk_draw_line(widget->window, selfp->subdivision_gc, graph_area_x, y, line_end, y);
	}

    gdk_gc_set_rgb_fg_color(selfp->subdivision_gc, &major_color);

    for (line = graph_area_y + major_subdivision; line < graph_end; line += major_subdivision)
      gdk_draw_line(widget->window, selfp->subdivision_gc, graph_area_x, line, line_end, line);
  }}
#line 975 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 579 "src/lm-line-graph.gob"
static void 
lm_line_graph_plot_host (LMLineGraph * self, LMHostFrontend * host, cairo_t * cr, LMTimeSpan now, LMTimeSpan scale, LMTimeSpan span)
{
#line 982 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::plot_host"
#line 579 "src/lm-line-graph.gob"
	g_return_if_fail (self != NULL);
#line 579 "src/lm-line-graph.gob"
	g_return_if_fail (LM_IS_LINE_GRAPH (self));
#line 579 "src/lm-line-graph.gob"
	g_return_if_fail (host != NULL);
#line 579 "src/lm-line-graph.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (host));
#line 579 "src/lm-line-graph.gob"
	g_return_if_fail (cr != NULL);
#line 994 "lm-line-graph.c"
{
#line 586 "src/lm-line-graph.gob"
	
    GArray *display_data;
    gboolean line_ended = TRUE;
    int i;

    cairo_new_path(cr);
    gdk_cairo_set_source_color(cr, &host->color);

    display_data = lm_data_set_get_display_data(host->data_set, now);

    for (i = 0; i < display_data->len; i++)
      {
	const LMDataPoint *dp = &g_array_index(display_data, LMDataPoint, i);
	LMTimeSpan age;
	double x;
	double y;

	if (dp->roundtrip_time < 0)
	  {
	    if (! line_ended)
	      {
		line_ended = TRUE;
		cairo_stroke(cr);
	      }
	    continue;
	  }

	age = now - dp->timestamp;

	x = (double) (span - age) / span * LM_LINE_GRAPH_AREA_WIDTH;
	y = (double) LM_LINE_GRAPH_AREA_HEIGHT - ((double) dp->roundtrip_time / scale * LM_LINE_GRAPH_AREA_HEIGHT);

	/*
	 * Constrain high pings inside the graph, since no plot means
	 * no reply. Note that we use 1 and not 0 because of the line
	 * width: if we used 0, the point would be centered on the
	 * edge of the clip rectangle, and half of it would be
	 * invisible.
	 */
	if (y < 1)
	  y = 1;

	if (line_ended)
	  {
	    cairo_move_to(cr, x, y);
	    line_ended = FALSE;
	  }
	else
	  cairo_line_to(cr, x, y);
      }

    if (! line_ended)
      cairo_stroke(cr);
  }}
#line 1051 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 641 "src/lm-line-graph.gob"
static gboolean 
lm_line_graph_update_cb (gpointer data)
{
#line 1058 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::update_cb"
{
#line 643 "src/lm-line-graph.gob"
	
    Self *self = data;

    gtk_widget_queue_draw(GTK_WIDGET(self));

    /*
     * If the update did not occur in a couple of seconds, it normally
     * means that the graph is no longer visible (for instance because
     * its parent tooltip was hidden). We can then save some
     * resources.
     */
    if (! selfp->update_not_done_timeout_id)
      selfp->update_not_done_timeout_id = g_timeout_add_seconds(10, self_update_not_done_cb, self);

    return TRUE;		/* continue */
  }}
#line 1078 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 660 "src/lm-line-graph.gob"
static gboolean 
lm_line_graph_update_time_cb (gpointer data)
{
#line 1085 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::update_time_cb"
{
#line 662 "src/lm-line-graph.gob"
	
    Self *self = data;

    self_clear_labels_and_queue_resize(self);

    selfp->update_time_timeout_id = 0;
    return FALSE;		/* remove */
  }}
#line 1097 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 671 "src/lm-line-graph.gob"
static gboolean 
lm_line_graph_update_not_done_cb (gpointer data)
{
#line 1104 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::update_not_done_cb"
{
#line 673 "src/lm-line-graph.gob"
	
    Self *self = data;
    int i;

    lm_source_clear(&selfp->update_timeout_id);
    lm_source_clear(&selfp->update_time_timeout_id);

    LM_ARRAY_FOREACH(i, selfp->applet->hosts)
      {
	LMHostFrontend *host = g_ptr_array_index(selfp->applet->hosts, i);

	lm_data_set_clear_display_data(host->data_set);
      }

    selfp->update_not_done_timeout_id = 0;
    return FALSE;
  }}
#line 1125 "lm-line-graph.c"
#undef __GOB_FUNCTION__

#line 691 "src/lm-line-graph.gob"
GtkWidget * 
lm_line_graph_new (LMApplet * applet)
{
#line 1132 "lm-line-graph.c"
#define __GOB_FUNCTION__ "LM:Line:Graph::new"
#line 691 "src/lm-line-graph.gob"
	g_return_val_if_fail (applet != NULL, (GtkWidget * )0);
#line 691 "src/lm-line-graph.gob"
	g_return_val_if_fail (LM_IS_APPLET (applet), (GtkWidget * )0);
#line 1138 "lm-line-graph.c"
{
#line 693 "src/lm-line-graph.gob"
	
    return GTK_WIDGET(GET_NEW_VARG(LM_LINE_GRAPH_PROP_APPLET(applet), NULL));
  }}
#line 1144 "lm-line-graph.c"
#undef __GOB_FUNCTION__
