// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution

// QT
#include <qfontdialog.h>
#include <qcolordialog.h>
#include <qdatetime.h>
#include <qbutton.h>
#include <qlistview.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qprocess.h>

#include "utils.h"
#include "msgproc.h"
#include "addrbook.h"
//#include "readmsg.h"

// Classess
extern TNewMsg   *NewMsg;
extern TMsgProc  *MsgProc;
extern TAddrBook *AddrBook;
extern TUtils Util;

// Global variables
extern TAttrs FormAttrsTb[10];
extern QString  bbs_wo_ssid;
extern QString  mycall;
extern QString  PrgPath;
extern int   	lastnum;
extern QStringList PersSigLines;
extern QStringList BullSigLines;
extern QString  HTMLV;
extern QString  HTMLE;
extern QString  ExtEd;
extern QString  QuotePref;
extern QString  Email;
extern QString  HierAddr;
extern bool  	WordWrap;
extern int   	WordWrapNr;

QProcess *EditMsgProcess;






void TNewMsg::AddquotesBtnClick()
{
	int p_from;
	int p_to;
	int i_from;
	int i_to;
	int i;
	
	if ( EditMsg->hasSelectedText() )
	{
		EditMsg->getSelection( &p_from, &i_from, &p_to,  &i_to );
		QMessageBox::information( this, "Title", "zm = " + QString::number(p_from) );
		for ( i= p_from; i <= p_to; i++)
		{
			EditMsg->insertAt( QuotePref, i, 0 );
		}
	}
}


void TNewMsg::AddSignBtnClick()
{
	EditMsg->append("[Signature]");

}


void TNewMsg::ColorBtnClick()
{
	QColor colorTmp = QColorDialog::getColor( EditMsg->paletteBackgroundColor () );
	if ( colorTmp.isValid() ) EditMsg->setPaletteBackgroundColor( colorTmp );
  	UpdateFormAttrs();
}


void TNewMsg::ExtEditBtnClick()
{
	QString tmp;
	
	if (EditMsg->lines() > 0)
	{
	
		QFile fl ( PrgPath + "mail/NewMsg.txt" );
		if ( fl.open( IO_WriteOnly ) )
		{
			QTextStream stream( &fl );
			stream << EditMsg->text();
			EditMsg->setModified( FALSE );
			fl.close();
		}
		
		if ( ! ExtEd.isEmpty() )
		{
			EditMsgProcess = new QProcess(this);
			EditMsgProcess->addArgument( ExtEd );
			EditMsgProcess->addArgument( PrgPath + "mail/NewMsg.txt" );
		               
			connect( EditMsgProcess, SIGNAL(processExited ()), this, SLOT(ExtEditExit()) );
		
			if ( !EditMsgProcess->start() ) 
				QMessageBox::critical( this, "Error", "External text editor cannot be executed" );
		
		}
	}

}


void TNewMsg::FontBtnClick()
{
    EditMsg->setFont( QFontDialog::getFont( 0, EditMsg->font() ) );
    UpdateFormAttrs();
}


void TNewMsg::HtmlEditBtnClick()
{
	QString tmp;
	
	if (EditMsg->lines() > 0)
	{
	
		QFile fl ( PrgPath + "mail/NewMsg.html" );
		if ( fl.open( IO_WriteOnly ) )
		{
			QTextStream stream( &fl );
			stream << EditMsg->text();
			EditMsg->setModified( FALSE );
			fl.close();
		}
		
		if ( ! HTMLE.isEmpty() )
		{
			EditMsgProcess = new QProcess(this);
			EditMsgProcess->addArgument( HTMLE );
			EditMsgProcess->addArgument( PrgPath + "mail/NewMsg.html" );
		               
			connect( EditMsgProcess, SIGNAL(processExited ()), this, SLOT(ExtHTMLEditExit()) );
		
			if ( !EditMsgProcess->start() ) 
				QMessageBox::critical( this, "Error", "External text editor cannot be executed" );
		
		}
	}

}


void TNewMsg::HtmlViewBtnClick()
{
	QString tmp;
	
	if (EditMsg->lines() > 0)
	{
	
		QFile fl ( PrgPath + "mail/NewMsg.html" );
		if ( fl.open( IO_WriteOnly ) )
		{
			QTextStream stream( &fl );
			stream << EditMsg->text();
			EditMsg->setModified( FALSE );
			fl.close();
		}
		
		if ( ! HTMLV.isEmpty() )
		{
			EditMsgProcess = new QProcess(this);
			EditMsgProcess->addArgument( HTMLV );
			EditMsgProcess->addArgument( PrgPath + "mail/NewMsg.html" );
		               
			connect( EditMsgProcess, SIGNAL(processExited ()), this, SLOT(ExtHTMLViewExit()) );
		
			if ( !EditMsgProcess->start() ) 
				QMessageBox::critical( this, "Error", "External text editor cannot be executed" );
		
		}
	}

}


void TNewMsg::InsetTextBtnClick()
{
	QString s = QFileDialog::getOpenFileName(
			PrgPath, "Text files (*.txt);; All files (*)",this,"open file dialog", "Choose a file to insert " );
		
	if ( ! s.isEmpty() )
	{
		QFile fl (s);
		if ( fl.open( IO_ReadOnly ) )
		{
			EditMsg->insert( fl.readAll() ); 
			fl.close();
		}
	}
}


void TNewMsg::InsertDntBtnClick()
{
	QDate date = QDate::currentDate();

	EditMsg->insert( date.toString( "d MMMM yy"));
}


void TNewMsg::ToBtnClick()
{
	AddrBook->show();
}


void TNewMsg::MailToBtnClick()
{
	EditMsg->insert( "mailto: " + Email + "\n");
	EditMsg->insert( "        " + mycall + "@" + bbs_wo_ssid + "." + HierAddr );
}


void TNewMsg::NewMsgBtnClick()
{
	NewMsg->show();                // to be rewritten !!!!!!!!!!!!!!!
}


void TNewMsg::PrintBtnClick()
{

}


void TNewMsg::SendBtnClick()
{
  idx_record idx_tmp;
  QString tmp;
  int paraFrom, indexFrom;


  if (! ToEdt->text().isEmpty() && ( MsgTypeP->isChecked() || MsgTypeB->isChecked() ))
  {
    if ( MsgTypeP->isChecked() ) idx_tmp.flag = "P";
    if ( MsgTypeB->isChecked() ) idx_tmp.flag = "B";

    idx_tmp.to_a = user(ToEdt->text() );
    if ( AtEdt->text().isEmpty() ) idx_tmp.at = bbs_wo_ssid; else idx_tmp .at = AtEdt->text();
    idx_tmp.from = mycall;
    QDate date = QDate::currentDate();
    tmp.sprintf("%02d%02d", date.month(), date.day() );
    idx_tmp.date = tmp;
    QTime time = QTime::currentTime();
    tmp.sprintf("%02d%02d",time.hour(), time.minute() );
    idx_tmp.time = tmp;
    idx_tmp.subject = SubjEdt->text();

    if ( ! MsgProc->EditBtn->isEnabled() )
    {
      idx_tmp.number = MsgProc->MsgList->currentItem()->text(0).stripWhiteSpace();
      idx_tmp.size = QString::number(EditMsg->length());
      if (QFile::exists( PrgPath+"queue/"+idx_tmp.number+".idx"))   Util.idx_save('q',idx_tmp);
      MsgProc->EditBtn->setEnabled( TRUE );
    }
    else
    {
      idx_tmp.number = QString::number(lastnum);
      Util.IncLastNum();
      paraFrom  = 0;
      indexFrom = 1;
      if (EditMsg->find("[Signature]", TRUE, FALSE, TRUE, &paraFrom, &indexFrom))
      {
	      EditMsg->setSelection( paraFrom, indexFrom, paraFrom, indexFrom+11,0);
	      EditMsg->removeSelectedText( 0 );
	      if (MsgTypeP->isChecked() )    EditMsg->insertAt( PersSigLines.join("\n") , paraFrom, indexFrom );
	      if (MsgTypeB->isChecked() )    EditMsg->insertAt( BullSigLines.join("\n") , paraFrom, indexFrom );
      }
      idx_tmp.size = QString::number(EditMsg->length());
      Util.idx_save('q',idx_tmp);
    }
    // ## For message processor purpose - assigning status of a message
    QFile fl ( PrgPath + "mail/" + idx_tmp.number );
    if ( fl.open( IO_WriteOnly ) )
    {
	    QTextStream stream( &fl );
	    stream << EditMsg->text();
	    EditMsg->setModified( FALSE );
	    fl.close();
    }
    if ( MsgTypeP->isChecked() ) idx_tmp.flag = "W";
    if ( MsgTypeB->isChecked() ) idx_tmp.flag = "V";
    Util.idx_save('i', idx_tmp );
    
    NewMsg->close();
    Util.Look4Msgs();
    Util.MsgDir( TRUE );
  }
  else
	  QMessageBox::information( this, "Error","You must specify at least fields: To and Type !" ); 
}



void TNewMsg::hideEvent( QHideEvent *e )
{
  if ( ! e->spontaneous ()  )    UpdateFormAttrs();
}


void TNewMsg::UpdateFormAttrs()
{
  QFontInfo fi (EditMsg->font());
  QColor font_color(EditMsg->foregroundColor());
  QColor background(EditMsg->paletteBackgroundColor());
  
  FormAttrsTb[5].FontAttrs.Name      =  fi.family();
  FormAttrsTb[5].FontAttrs.Size      =  fi.pointSize();
  
  FormAttrsTb[5].FontAttrs.Color     =  font_color.name();
  FormAttrsTb[5].FontAttrs.Pitch     =  fi.fixedPitch();
  FormAttrsTb[5].FontAttrs.Bold      =  fi.bold();
  FormAttrsTb[5].FontAttrs.Italic    =  fi.italic();

  FormAttrsTb[5].FormAttrs.Color  =  EditMsg->paletteBackgroundColor().name();
  FormAttrsTb[5].FormAttrs.x      =  NewMsg->x();
  FormAttrsTb[5].FormAttrs.y      =  NewMsg->y();
  FormAttrsTb[5].FormAttrs.height =  NewMsg->height();
  FormAttrsTb[5].FormAttrs.width  =  NewMsg->width();

}


void TNewMsg::showEvent( QShowEvent * e )
{
  if ( ! e->spontaneous ()  )
  {
  QFont fi;
  QColor color; //(MsgList->paletteBackgroundColor());
  
  
  fi.setFamily(FormAttrsTb[5].FontAttrs.Name);
  fi.setPointSize(FormAttrsTb[5].FontAttrs.Size);
  
  fi.setFixedPitch(FormAttrsTb[5].FontAttrs.Pitch);
  fi.setBold(FormAttrsTb[5].FontAttrs.Bold);
  fi.setItalic(FormAttrsTb[5].FontAttrs.Italic);
  EditMsg->setFont( fi );

  color.setNamedColor(FormAttrsTb[5].FormAttrs.Color);
  EditMsg->setPaletteBackgroundColor(color);
  EditMsg->setPaletteForegroundColor (FormAttrsTb[5].FontAttrs.Color); // Font Color
  
  move( FormAttrsTb[5].FormAttrs.x, FormAttrsTb[5].FormAttrs.y );
  resize( FormAttrsTb[5].FormAttrs.width, FormAttrsTb[5].FormAttrs.height );
  
  if ( WordWrap )
  {
	  EditMsg->setWordWrap( QTextEdit::FixedColumnWidth  );
	  EditMsg->setWrapColumnOrWidth( WordWrapNr );
	  EditMsg->setWrapPolicy( QTextEdit::AtWordBoundary );
			 
  }

 }
}


QString TNewMsg::user( QString src )
{
  QString s;

  s = src.section('@',0,1);
//QMessageBox::information( this, "Title", "we=" + src+ " wy=" + s );
  return s.upper();

}


QString TNewMsg::bbs( QString src )
{
  QString s;
  s = src.section('.',0,0);
  return s.upper();
}


void TNewMsg::MsgTypePClick()
{
	if (MsgTypeP->isChecked()) MsgTypeB->setChecked( FALSE );
}


void TNewMsg::MsgTypeBClick()
{
	if (MsgTypeB->isChecked()) MsgTypeP->setChecked( FALSE );
}


void TNewMsg::ExtEditExit()
{
	QFile fl ( PrgPath + "mail/NewMsg.txt" );
	if ( fl.open( IO_ReadOnly ) )
	{
		EditMsg->setText( fl.readAll() );
	}
 fl.close();
 fl.remove();
}


void TNewMsg::ExtHTMLEditExit()
{
  QFile fl ( PrgPath + "mail/NewMsg.html" );
  if ( fl.open( IO_ReadOnly ) )
  {
    EditMsg->setText( fl.readAll() );
  }
  fl.close();
  fl.remove();
}


void TNewMsg::ExtHTMLViewExit()
{
  QFile::remove( PrgPath + "mail/NewMsg.html" );
}


