/* main.h,v 1.6 2009-03-30 23:13:36 lacos Exp */

#ifndef MAIN_H
#  define MAIN_H

#  include <pthread.h> /* pthread_mutex_t */
#  include <stddef.h>  /* size_t */
#  include <limits.h>  /* CHAR_BIT */

#  if 8 != CHAR_BIT
#    error "Environments where 8 != CHAR_BIT are not supported."
#  endif


extern const char *pname;
extern void *(*mallocf)(size_t size);
extern void (*freef)(void *ptr);
extern void *(*lbzallocf)(void *ignored, int n, int m);
extern void (*lbzfreef)(void *ignored, void *ptr);


struct cond
{
  pthread_mutex_t lock; /* Lock this to protect shared resource. */
  pthread_cond_t cond;  /* Trigger this if predicate becomes true. */
  long unsigned ccount, /* Increment this when checking predicate. */
      wcount;           /* Increment this when waiting is necessary. */
};


void
fail(const char *op, int err);

void *
xalloc(size_t size);

void
xinit(struct cond *cond);

void
xdestroy(struct cond *cond);

void
xlock(struct cond *cond);

void
xlock_pred(struct cond *cond);

void
xunlock(struct cond *cond);

void
xwait(struct cond *cond);

void
xsignal(struct cond *cond);

void
xbroadcast(struct cond *cond);

void
xcreate(pthread_t *thread, void *(*routine)(void *), void *arg);

void
xjoin(pthread_t thread);

#endif
