package latexDraw.util;


/**
 * The class define some useful methods to manage numbers.
 * 
 * This file is part of LaTeXDraw.<br>
 * Copyright(c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 12/18/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public abstract class LaTeXDrawNumber
{
	/**
	 * This method allows to set a threshold that if a number is under it, it will be considered as valuing 0; 
	 * for instance, given the numbers 2E-10 and 0.002 and the
	 * threshold 0.00001; then this method will cut the first number and will return 0. The absolute value of
	 * the second number is not lesser than the threshold so it will be returned intact.
	 * @param value The number to check.
	 * @param threshold The minimum threshold of the value.
	 * @return The cut or the intact number.
	 * @since 1.9
	 */
	public static float getCutNumber(float value, double threshold)
	{
		return Math.abs(value) < threshold ? 0f : value;
	}
	
	
	
	/**
	 * This method allows to set a threshold that if a number is under it, it will be considered as valuing 0; 
	 * for instance, given the numbers 2E-10 and 0.002 and the
	 * threshold 0.00001; then this method will cut the first number and will return 0. The absolute value of
	 * the second number is not lesser than the threshold so it will be returned intact.
	 * @param value The number to check.
	 * @param threshold The minimum threshold of the value.
	 * @return The cut or the intact number.
	 * @since 1.9
	 */
	public static double getCutNumber(double value, double threshold)
	{
		return Math.abs(value) < threshold ? 0. : value;
	}
}
