package latexDraw.ui.components.progressbars;

import javax.swing.JOptionPane;

import latexDraw.figures.Draw;
import latexDraw.figures.Figure;
import latexDraw.generators.svg.SVGDocumentGenerator;
import latexDraw.lang.LaTeXDrawLang;
import latexDraw.parsers.svg.MalformedSVGDocument;
import latexDraw.ui.DrawPanel;
import latexDraw.ui.LaTeXDrawFrame;

/** 
 * Defines a progress bar manager of SVG import.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 * <br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 * <br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * <br>
 * 02/04/08<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class SVGProgressBarManager extends AbstractProgressBarManager
{
	public SVGProgressBarManager(LaTeXDrawFrame f)
	{
		super(f);
	}



	public void run()
	{
		try
		{
			Draw figures = SVGDocumentGenerator.toLatexdraw(fileToParse, frame, frame.getProgressBar());
			DrawPanel drawPanel = frame.getDrawPanel();

			if(figures!=null)
			{
				for(Figure f : figures.getFigures())
					drawPanel.getDraw().addFigure(f, null);
				
				if(!figures.isEmpty())
    				frame.setIsModified(true);
				
				drawPanel.updateDraw(true);
			}
			else
				frame.setStatusBarText(LaTeXDrawLang.getOthersString("SVGManager.0")); //$NON-NLS-1$
			
			frame.setTitle();
			frame.getUndoManager().clear();
			frame.updateUndoRedo();
			frame.setSelection(false);
			frame.setIsModified(false);
			frame.getPreferencesFrame().addRecentFile(fileToParse.getAbsolutePath());
			frame.getLMenuBar().updateRecentFilesMenu();
			frame.setStatusBarText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.202")); //$NON-NLS-1$
		}
		catch(MalformedSVGDocument ex)
		{
			frame.setIsModified(false);
			frame.setCurrentFile(null);
			frame.setStatusBarText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.203")); //$NON-NLS-1$
			ex.printStackTrace(); 
			
			JOptionPane.showMessageDialog(frame, 
		 		    LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.204") + ex.toString(), //$NON-NLS-1$
		 		    LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.86"), JOptionPane.WARNING_MESSAGE);   //$NON-NLS-1$
		}
		
		resetProgressBar();
	}
}
