<?php
/**
 * This Class is for language work
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: class-language.php 281 2007-01-28 21:03:07Z lordlamer $
 */
class language {
	var $CLASS = array();
	var $default_lang = "en";
	var $get = array(); // array with languagetokens

	var $sys = array(); // array with syslanguagetokens

	var $lang = ""; // loaded language

	/**
	 * init/start class
	 */
	function start(&$CLASS,$language) {
		$this->CLASS =& $CLASS;

		// load syslangtokens to array
		$this->load_sys_lang($language);

		// set userlanguage if available
		if (isset ($_SESSION['language']) and $_SESSION['language'] != "") {
			$language = $_SESSION['language'];
		}

		$this->load_language($language);

		return 0;
	}

	/**
	 *
	 */
	function load_language($language) {
		$languagetoken = '';

		if(is_file($this->CLASS['vars']['base_path'] . "/system/language/lang_" . $language . ".php")) {
			include($this->CLASS['vars']['base_path'] . "/system/language/lang_" . $language . ".php");
		} elseif(is_file($this->CLASS['vars']['base_path'] . "/system/language/lang_" . $this->default_lang . ".php")) {
			include($this->CLASS['vars']['base_path'] . "/system/language/lang_" . $this->default_lang . ".php");
			$language = $this->default_lang;
		} else {
			exit("LANGUAGE: '" . $language . "' NOT FOUND!");
		}

		$this->get = $languagetoken[$language];
		$this->lang = $language;
		unset($languagetoken);
	}

	/**
	 *
	 */
	function load_sys_lang($language) {
		$languagetoken = '';
;
		if(is_file($this->CLASS['vars']['base_path'] . "/system/language/lang_" . $language . ".php")) {
			include($this->CLASS['vars']['base_path'] . "/system/language/lang_" . $language . ".php");
		} elseif(is_file($this->CLASS['vars']['base_path'] . "/system/language/lang_" . $this->default_lang . ".php")) {
			include($this->CLASS['vars']['base_path'] . "/system/language/lang_" . $this->default_lang . ".php");
			$language = $this->default_lang;
		} else {
			exit("LANGUAGE: '" . $language . "' NOT FOUND!");
		}

		$this->sys = $languagetoken[$language];
		unset($languagetoken);
	}

	/**
	 *
	 */
	function load_ext_lang($extension,$lang) {
		if(isset($lang[$this->lang])) {
			$this->get['ext'][$extension] = $lang[$this->lang];
		} elseif($lang[$this->default_lang]) {
			$this->get['ext'][$extension] = $lang[$this->default_lang];
		}
	}

	/**
	 * dropdown with available languages
	 */
	function lang_dropdown($name = "language",$default = "", $optionparams = "") {
		if(!is_array($this->CLASS['vars']['knowledgeroot']['availablelanguages'])) {
			$this->CLASS['vars']['knowledgeroot']['availablelanguages'] = array($this->CLASS['vars']['knowledgeroot']['language']);
		}

		if($default == "") {
			$default = $this->CLASS['vars']['knowledgeroot']['language'];
		}

		if($this->CLASS['vars']['menu']['ajax'] == "yes") {
			$jsscript = 'onchange="this.form.submit();"';
		} else {
			$jsscript = "";
		}
		$out = '<select name="'.$name.'" '.$jsscript.'>'."\n";
		$selected = '';
		foreach ($this->CLASS['vars']['knowledgeroot']['availablelanguages'] as $key => $value) {
			if ($value == $default) {
				$selected = 'selected="selected"';
			}

			$out .= "\t<option ".$optionparams." value=\"".$value."\" $selected>".$value."</option>\n";
			$selected = "";
		}

		$out .= "</select>\n";
		return $out;
	}
}

?>