/* ========================================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Description : Retrieve previews of photographs in a semi organized way
 *
 * Copyright 2007-2008 by M. Asselstine
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ====================================================================== */
#ifndef PREVIEWMGR_H
#define PREVIEWMGR_H


#include <QPixmap>

#include <KUrl>
#include <KFileItem>

#include <kio/previewjob.h>

namespace KIO { class Job; class PreviewJob; }

/**
 * Manage the fetching of preview images.
 * @author M. Asselstine <asselsm@gmail.com>
 */
class PreviewMgr : public QObject
{
  Q_OBJECT

public:
  static PreviewMgr* instance();

  const QPixmap* defaultPreview() const;
  const QPixmap* preview(int id) const;

  typedef enum
  {
    Landscape,
    Portrait
  } PhotoOrientation;

  PhotoOrientation orientation(int id, int rotation = 0) const;

public slots:
  void previewRequest(int id, const KUrl& url);

private slots:
  void startPreviewJob();
  void jobFailed(const KFileItem& fi);
  void gotPreview(const KFileItem& fi, const QPixmap& pm);

protected:
  PreviewMgr(QObject* parent);
  ~PreviewMgr();

signals:
  void updatedPreview(int id);

private:
  class PrivateData;
  PrivateData& d;
};

#endif
