/*
 * xml2bib.c
 *
 * Copyright (c) Chris Putnam 2003-4
 *
 * Program and source code released under the GPL
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "newstr.h"
#include "lists.h"
#include "strsearch.h"
#include "fields.h"
#include "bibtexout.h"
#include "bibl.h"
#include "bibutils.h"
#include "bibprogs.h"

void
process_args_xml2bib( int *argc, char *argv[], param *p )
{
	char  progname[] = "xml2bib";
	int i, j, subtract;
	i = 1;
	while ( i<*argc ) {
		subtract = 0;
		if ( args_match( argv[i], "-h", "--help" ) ) {
			exit( EXIT_SUCCESS );
		} else if ( args_match( argv[i], "-v", "--version" ) ) {
			exit( EXIT_SUCCESS );
		} else if ( args_match( argv[i], "-fc", "--finalcomma" ) ) {
			p->format_opts |= BIBOUT_FINALCOMMA;
			subtract = 1;
		} else if ( args_match( argv[i], "-s", "--single-refperfile" )){
			p->singlerefperfile = 1;
			subtract = 1;
		} else if ( args_match( argv[i], "-sd", "--singledash" ) ) {
			p->format_opts |= BIBOUT_SINGLEDASH;
			subtract = 1;
		} else if ( args_match( argv[i], "-b", "--brackets" ) ) {
			p->format_opts |= BIBOUT_BRACKETS;
			subtract = 1;
		} else if ( args_match( argv[i], "-w", "--whitespace" ) ) {
			p->format_opts |= BIBOUT_WHITESPACE;
			subtract = 1;
		} else if ( args_match( argv[i], "-U", "--uppercase" ) ) {
			p->format_opts |= BIBOUT_UPPERCASE;
			subtract = 1;
		} else if ( args_match( argv[i], "-i", "--input-encoding" ) ) {
			args_encoding( *argc, argv, i, &(p->charsetin), 
					&(p->utf8in), progname );
			p->charsetin_src = BIBL_SRC_USER;
			subtract = 2;
		} else if ( args_match( argv[i], "-o", "--output-encoding" ) ) {
			args_encoding( *argc, argv, i, &(p->charsetout),
					&(p->utf8out), progname );
			p->charsetout_src = BIBL_SRC_USER;
			subtract = 2;
		}
		if ( subtract ) {
			for ( j=i+subtract; j<*argc; ++j )
				argv[j-subtract] = argv[j];
			*argc -= subtract;
		} else i++;
	}
}


int xml2bib(char *input, char *output)
{
	char  progname[] = "xml2bib";
	FILE *fp;
	param p;
	bibl b;
	int err, i;
	bibl_init( &b );
	bibl_initparams( &p, BIBL_MODSIN, BIBL_BIBTEXOUT );
	
	int argc = 3; 
	char *argv[] = {"xml2bib", "-o", "unicode"};
	
	process_args_xml2bib( &argc, argv, &p );
	fp = fopen(input, "r" );
	if ( fp ) {
		err = bibl_read( &b, fp, input, BIBL_MODSIN, &p );
		if ( err ) bibl_reporterr( err );
		fclose( fp );
	}
	FILE *out_file;
	out_file = fopen(output, "w" );
	if (!err)
		bibl_write( &b, out_file, BIBL_BIBTEXOUT, &p );
	fclose( out_file );
	fprintf( stderr, "%s: Processed %ld references.\n", progname, b.nrefs );
	bibl_free( &b );
	return EXIT_SUCCESS;
}
	
	


